/*
 * Decompiled with CFR 0.152.
 */
package numerics;

import java.util.ArrayList;
import java.util.Random;
import java.util.logging.Logger;
import misc.LoggedException;
import numerics.EigenSystem3D;
import numerics.RealMatrix;
import numerics.Rotations;
import numerics.Vector3D;
import numerics.WatsonDistribution;
import numerics.WatsonFitter;
import optimizers.MarquardtMinimiser;
import optimizers.MarquardtMinimiserException;
import tools.FileInput;

public class TwoFibreFixedPropWatsonFitter
extends MarquardtMinimiser {
    private static final Logger logger = Logger.getLogger("numerics.TwoFibreFixedPropWatsonFitter");
    Vector3D[] samples;
    final double alpha;
    protected final double[] mu1DotX;
    protected final double[] mu2DotX;
    protected final double[] eK1Mu1DotXSq;
    protected final double[] eK2Mu2DotXSq;

    @Override
    protected double fObj(double[] dArray, double[] dArray2, double[][] dArray3) {
        double d = 0.0;
        Vector3D vector3D = Vector3D.vectorFromSPC(1.0, dArray[1], dArray[2]);
        Vector3D vector3D2 = Vector3D.vectorFromSPC(1.0, dArray[4], dArray[5]);
        double[] dArray4 = new double[this.samples.length];
        double[][] dArray5 = new double[this.ma + 1][this.samples.length];
        double d2 = WatsonDistribution.hyper1F1(0.5, 1.5, dArray[3], 1.0E-9);
        double d3 = WatsonDistribution.hyper1F1(0.5, 1.5, dArray[6], 1.0E-9);
        for (int i = 0; i < this.samples.length; ++i) {
            this.mu1DotX[i] = vector3D.x * this.samples[i].x + vector3D.y * this.samples[i].y + vector3D.z * this.samples[i].z;
            this.mu2DotX[i] = vector3D2.x * this.samples[i].x + vector3D2.y * this.samples[i].y + vector3D2.z * this.samples[i].z;
            this.eK1Mu1DotXSq[i] = Math.exp(dArray[3] * this.mu1DotX[i] * this.mu1DotX[i]);
            this.eK2Mu2DotXSq[i] = Math.exp(dArray[6] * this.mu2DotX[i] * this.mu2DotX[i]);
            dArray4[i] = this.alpha * (1.0 / d2) * this.eK1Mu1DotXSq[i] + (1.0 - this.alpha) * (1.0 / d3) * this.eK2Mu2DotXSq[i];
            d -= Math.log(dArray4[i]);
        }
        double d4 = WatsonDistribution.hyper1F1(1.5, 2.5, dArray[3], 1.0E-9);
        double d5 = WatsonDistribution.hyper1F1(1.5, 2.5, dArray[6], 1.0E-9);
        this.firstDeriv(dArray, dArray4, dArray5, dArray2, this.mu1DotX, this.mu2DotX, this.eK1Mu1DotXSq, this.eK2Mu2DotXSq, d2, d3, d4, d5);
        this.secondDeriv(dArray, dArray4, dArray5, dArray3, this.mu1DotX, this.mu2DotX, this.eK1Mu1DotXSq, this.eK2Mu2DotXSq, d2, d3, d4, d5);
        return d;
    }

    protected void firstDeriv(double[] dArray, double[] dArray2, double[][] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, double[] dArray7, double[] dArray8, double d, double d2, double d3, double d4) {
        double d5 = Math.cos(dArray[1]);
        double d6 = Math.sin(dArray[1]);
        double d7 = Math.cos(dArray[2]);
        double d8 = Math.sin(dArray[2]);
        double d9 = Math.cos(dArray[4]);
        double d10 = Math.sin(dArray[4]);
        double d11 = Math.cos(dArray[5]);
        double d12 = Math.sin(dArray[5]);
        for (int i = 0; i < this.samples.length; ++i) {
            double d13 = this.samples[i].x;
            double d14 = this.samples[i].y;
            double d15 = this.samples[i].z;
            dArray3[1][i] = 2.0 * dArray7[i] * dArray[3] * (d13 * d5 * d7 - d15 * d6 + d14 * d5 * d8) * dArray5[i] * this.alpha / d;
            dArray4[1] = dArray4[1] - 1.0 / dArray2[i] * dArray3[1][i];
            dArray3[2][i] = 2.0 * dArray7[i] * dArray[3] * (d14 * d7 * d6 - d13 * d6 * d8) * dArray5[i] * this.alpha / d;
            dArray4[2] = dArray4[2] - 1.0 / dArray2[i] * dArray3[2][i];
            dArray3[3][i] = -0.3333333333333333 * dArray7[i] * d3 * this.alpha / (d * d) + dArray7[i] * dArray5[i] * dArray5[i] * this.alpha / d;
            dArray4[3] = dArray4[3] - 1.0 / dArray2[i] * dArray3[3][i];
            dArray3[4][i] = 2.0 * dArray8[i] * dArray[6] * (d13 * d9 * d11 - d15 * d10 + d14 * d9 * d12) * dArray6[i] * (1.0 - this.alpha) / d2;
            dArray4[4] = dArray4[4] - 1.0 / dArray2[i] * dArray3[4][i];
            dArray3[5][i] = 2.0 * dArray8[i] * dArray[6] * (d14 * d11 * d10 - d13 * d10 * d12) * (d15 * d9 + d13 * d11 * d10 + d14 * d10 * d12) * (1.0 - this.alpha) / d2;
            dArray4[5] = dArray4[5] - 1.0 / dArray2[i] * dArray3[5][i];
            dArray3[6][i] = -0.3333333333333333 * dArray8[i] * d4 * (1.0 - this.alpha) / (d2 * d2) + dArray8[i] * dArray6[i] * dArray6[i] * (1.0 - this.alpha) / d2;
            dArray4[6] = dArray4[6] - 1.0 / dArray2[i] * dArray3[6][i];
        }
    }

    protected void secondDeriv(double[] dArray, double[] dArray2, double[][] dArray3, double[][] dArray4, double[] dArray5, double[] dArray6, double[] dArray7, double[] dArray8, double d, double d2, double d3, double d4) {
        int n;
        double d5 = WatsonDistribution.hyper1F1(2.5, 3.5, dArray[3], 1.0E-9);
        double d6 = WatsonDistribution.hyper1F1(2.5, 3.5, dArray[6], 1.0E-9);
        double d7 = Math.cos(dArray[1]);
        double d8 = Math.sin(dArray[1]);
        double d9 = Math.cos(dArray[2]);
        double d10 = Math.sin(dArray[2]);
        double d11 = Math.cos(dArray[4]);
        double d12 = Math.sin(dArray[4]);
        double d13 = Math.cos(dArray[5]);
        double d14 = Math.sin(dArray[5]);
        double d15 = dArray[3] * dArray[3];
        double d16 = dArray[6] * dArray[6];
        for (n = 0; n < this.samples.length; ++n) {
            double d17 = this.samples[n].x;
            double d18 = this.samples[n].y;
            double d19 = this.samples[n].z;
            double d20 = 1.0 / dArray2[n];
            double d21 = d20 * d20;
            double d22 = d17 * d7 * d9 - d19 * d8 + d18 * d7 * d10;
            double d23 = dArray5[n];
            double d24 = d17 * d11 * d13 - d19 * d12 + d18 * d11 * d14;
            double d25 = dArray6[n];
            double d26 = d18 * d9 * d8 - d17 * d8 * d10;
            double d27 = d18 * d13 * d12 - d17 * d12 * d14;
            double d28 = d23 * d23;
            double d29 = d25 * d25;
            double d30 = 2.0 * dArray7[n] * dArray[3];
            double[] dArray9 = dArray4[1];
            dArray9[1] = dArray9[1] - (d20 * (d30 * d22 * d22 * this.alpha / d + d30 * (-1.0 * d23) * d23 * this.alpha / d + 4.0 * dArray7[n] * d15 * d22 * d22 * d28 * this.alpha / d) - d21 * dArray3[1][n] * dArray3[1][n]);
            double[] dArray10 = dArray4[1];
            dArray10[2] = dArray10[2] - (d20 * (d30 * d22 * d26 * this.alpha / d + d30 * (d18 * d7 * d9 - d17 * d7 * d10) * d23 * this.alpha / d + 4.0 * dArray7[n] * d15 * d22 * d26 * d28 * this.alpha / d) - d21 * dArray3[1][n] * dArray3[2][n]);
            double[] dArray11 = dArray4[1];
            dArray11[3] = dArray11[3] - (d20 * (2.0 * dArray7[n] * d22 * d23 * this.alpha / d - 0.6666666666666666 * dArray7[n] * dArray[3] * d3 * d22 * d23 * this.alpha / (d * d) + d30 * d22 * d28 * d23 * this.alpha / d) - d21 * dArray3[1][n] * dArray3[3][n]);
            double[] dArray12 = dArray4[2];
            dArray12[2] = dArray12[2] - (d20 * (d30 * d26 * d26 * this.alpha / d + d30 * (-(d17 * d9 * d8) - d18 * d8 * d10) * d23 * this.alpha / d + 4.0 * dArray7[n] * d15 * d26 * d26 * d28 * this.alpha / d) - d21 * dArray3[2][n] * dArray3[2][n]);
            double[] dArray13 = dArray4[2];
            dArray13[3] = dArray13[3] - (d20 * (2.0 * dArray7[n] * d26 * d23 * this.alpha / d - 0.6666666666666666 * dArray7[n] * dArray[3] * d3 * d26 * d23 * this.alpha / (d * d) + d30 * d26 * d28 * d23 * this.alpha / d) - d21 * dArray3[2][n] * dArray3[3][n]);
            double[] dArray14 = dArray4[3];
            dArray14[3] = dArray14[3] - (d20 * (0.2222222222222222 * dArray7[n] * (d3 * d3) * this.alpha / (d * d * d) - 0.2 * dArray7[n] * d5 * this.alpha / (d * d) - 0.6666666666666666 * dArray7[n] * d3 * d28 * this.alpha / (d * d) + dArray7[n] * d28 * d28 * this.alpha / d) - d21 * dArray3[3][n] * dArray3[3][n]);
            double[] dArray15 = dArray4[4];
            dArray15[4] = dArray15[4] - (d20 * (2.0 * dArray8[n] * dArray[6] * (d24 * d24) * (1.0 - this.alpha) / d2 + 2.0 * dArray8[n] * dArray[6] * (-(d19 * d11) - d17 * d13 * d12 - d18 * d12 * d14) * d25 * (1.0 - this.alpha) / d2 + 4.0 * dArray8[n] * d16 * (d24 * d24) * d29 * (1.0 - this.alpha) / d2) - d21 * dArray3[4][n] * dArray3[4][n]);
            double[] dArray16 = dArray4[4];
            dArray16[5] = dArray16[5] - (d20 * (2.0 * dArray8[n] * dArray[6] * d24 * d27 * (1.0 - this.alpha) / d2 + 2.0 * dArray8[n] * dArray[6] * (d18 * d11 * d13 - d17 * d11 * d14) * d25 * (1.0 - this.alpha) / d2 + 4.0 * dArray8[n] * d16 * d24 * d27 * d29 * (1.0 - this.alpha) / d2) - d21 * dArray3[4][n] * dArray3[5][n]);
            double[] dArray17 = dArray4[4];
            dArray17[6] = dArray17[6] - (d20 * (2.0 * dArray8[n] * d24 * d25 * (1.0 - this.alpha) / d2 - 0.6666666666666666 * dArray8[n] * dArray[6] * d4 * d24 * d25 * (1.0 - this.alpha) / (d2 * d2) + 2.0 * dArray8[n] * dArray[6] * d24 * d29 * d25 * (1.0 - this.alpha) / d2) - d21 * dArray3[4][n] * dArray3[6][n]);
            double[] dArray18 = dArray4[5];
            dArray18[5] = dArray18[5] - (d20 * (2.0 * dArray8[n] * dArray[6] * d27 * d27 * (1.0 - this.alpha) / d2 + 2.0 * dArray8[n] * dArray[6] * (-(d17 * d13 * d12) - d18 * d12 * d14) * d25 * (1.0 - this.alpha) / d2 + 4.0 * dArray8[n] * d16 * d27 * d27 * d29 * (1.0 - this.alpha) / d2) - d21 * dArray3[5][n] * dArray3[5][n]);
            double[] dArray19 = dArray4[5];
            dArray19[6] = dArray19[6] - (d20 * (2.0 * dArray8[n] * d27 * d25 * (1.0 - this.alpha) / d2 - 0.6666666666666666 * dArray8[n] * dArray[6] * d4 * d27 * d25 * (1.0 - this.alpha) / (d2 * d2) + 2.0 * dArray8[n] * dArray[6] * d27 * d29 * d25 * (1.0 - this.alpha) / d2) - d21 * dArray3[5][n] * dArray3[6][n]);
            double[] dArray20 = dArray4[6];
            dArray20[6] = dArray20[6] - (d20 * (0.2222222222222222 * dArray8[n] * (d4 * d4) * (1.0 - this.alpha) / (d2 * d2 * d2) - 0.2 * dArray8[n] * d6 * (1.0 - this.alpha) / (d2 * d2) - 0.6666666666666666 * dArray8[n] * d4 * d29 * (1.0 - this.alpha) / (d2 * d2) + dArray8[n] * d29 * d29 * (1.0 - this.alpha) / d2) - d21 * dArray3[6][n] * dArray3[6][n]);
        }
        for (n = 1; n <= this.ma; ++n) {
            for (int i = 1; i <= n; ++i) {
                dArray4[n][i] = dArray4[i][n];
            }
        }
    }

    public WatsonDistribution[] getDistributions() {
        Random random = new Random();
        return this.getDistributions(random);
    }

    public WatsonDistribution[] getDistributions(Random random) {
        Vector3D vector3D = Vector3D.vectorFromSPC(1.0, this.a[1], this.a[2]);
        Vector3D vector3D2 = Vector3D.vectorFromSPC(1.0, this.a[4], this.a[5]);
        return new WatsonDistribution[]{new WatsonDistribution(vector3D, this.a[3], random), new WatsonDistribution(vector3D2, this.a[6], random)};
    }

    public Vector3D[] getMus() {
        Vector3D vector3D = Vector3D.vectorFromSPC(1.0, this.a[1], this.a[2]);
        Vector3D vector3D2 = Vector3D.vectorFromSPC(1.0, this.a[4], this.a[5]);
        return new Vector3D[]{vector3D, vector3D2};
    }

    public double getMixingParameter() {
        return this.alpha;
    }

    public double[] getKappas() {
        return new double[]{this.a[3], this.a[6]};
    }

    @Override
    public void setInitParams(double[] dArray) throws MarquardtMinimiserException {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = dArray[i];
        }
        super.setInitParams(dArray2);
    }

    public void setInitParams(Vector3D vector3D, Vector3D vector3D2, double d, double d2) throws MarquardtMinimiserException {
        double[] dArray = Vector3D.thetaPhi(vector3D);
        double[] dArray2 = new double[6];
        dArray2[0] = dArray[0];
        dArray2[1] = dArray[1];
        dArray2[2] = d;
        dArray = Vector3D.thetaPhi(vector3D2);
        dArray2[3] = dArray[0];
        dArray2[4] = dArray[1];
        dArray2[5] = d2;
        this.setInitParams(dArray2);
    }

    public void fitEstimatedParams(Vector3D vector3D, Vector3D vector3D2, double d, double d2, double d3, double d4, double d5, double d6, int n) throws MarquardtMinimiserException {
        int n2;
        double[] dArray = new double[6];
        dArray[2] = d5;
        dArray[5] = d6;
        double d7 = Double.MAX_VALUE;
        double[] dArray2 = new double[6];
        boolean bl = false;
        double[] dArray3 = Vector3D.thetaPhi(vector3D);
        double[] dArray4 = Vector3D.thetaPhi(vector3D2);
        RealMatrix realMatrix = Rotations.getRotMat(vector3D, Math.PI * 2 / (double)n);
        RealMatrix realMatrix2 = Rotations.getRotMat(vector3D2, Math.PI * 2 / (double)n);
        dArray[0] = dArray3[0];
        dArray[1] = dArray3[1];
        dArray[3] = dArray4[0];
        dArray[4] = dArray4[1];
        for (int i = 0; i < 6; ++i) {
            dArray2[i] = dArray[i];
        }
        try {
            this.setInitParams(dArray);
            this.minimise();
            bl = true;
        }
        catch (MarquardtMinimiserException marquardtMinimiserException) {
            // empty catch block
        }
        if (this.fObjVal < d7) {
            d7 = this.fObjVal;
            dArray2 = this.getParameters();
        }
        double[] dArray5 = new double[2];
        double[] dArray6 = new double[2];
        dArray5[0] = dArray3[0] + d;
        dArray5[1] = dArray3[1];
        if (dArray5[0] > Math.PI) {
            dArray5[0] = dArray5[0] - Math.PI;
        }
        Vector3D vector3D3 = Vector3D.vectorFromSPC(1.0, dArray5[0], dArray5[1]);
        dArray6[0] = dArray4[0] + d3;
        dArray6[1] = dArray4[1];
        if (dArray6[0] > Math.PI) {
            dArray6[0] = dArray6[0] - Math.PI;
        }
        Vector3D vector3D4 = Vector3D.vectorFromSPC(1.0, dArray6[0], dArray6[1]);
        for (n2 = 0; n2 < n; ++n2) {
            if (n2 > 0) {
                vector3D3 = Vector3D.vectorFromSPC(1.0, dArray5[0], dArray5[1]);
                vector3D3 = Rotations.rotateVector(vector3D3, realMatrix);
                dArray5 = Vector3D.thetaPhi(vector3D3);
                vector3D4 = Vector3D.vectorFromSPC(1.0, dArray6[0], dArray6[1]);
                vector3D4 = Rotations.rotateVector(vector3D4, realMatrix2);
                dArray6 = Vector3D.thetaPhi(vector3D4);
            }
            dArray[0] = dArray5[0];
            dArray[1] = dArray5[1];
            dArray[3] = dArray6[0];
            dArray[4] = dArray6[1];
            try {
                this.setInitParams(dArray);
                this.minimise();
                bl = true;
            }
            catch (MarquardtMinimiserException marquardtMinimiserException) {
                // empty catch block
            }
            if (!(this.fObjVal < d7)) continue;
            d7 = this.fObjVal;
            dArray2 = this.getParameters();
        }
        dArray5[0] = dArray3[0] + d2;
        dArray5[1] = dArray3[1];
        if (dArray5[0] > Math.PI) {
            dArray5[0] = dArray5[0] - Math.PI;
        }
        vector3D3 = Vector3D.vectorFromSPC(1.0, dArray5[0], dArray5[1]);
        vector3D3 = Rotations.rotateVector(vector3D3, vector3D, Math.PI / (double)n);
        dArray6[0] = dArray4[0] + d4;
        dArray6[1] = dArray4[1];
        if (dArray6[0] > Math.PI) {
            dArray6[0] = dArray6[0] - Math.PI;
        }
        vector3D4 = Vector3D.vectorFromSPC(1.0, dArray6[0], dArray6[1]);
        vector3D4 = Rotations.rotateVector(vector3D4, vector3D2, Math.PI / (double)n);
        for (n2 = 0; n2 < n; ++n2) {
            if (n2 > 0) {
                vector3D3 = Vector3D.vectorFromSPC(1.0, dArray5[0], dArray5[1]);
                vector3D3 = Rotations.rotateVector(vector3D3, realMatrix);
                dArray5 = Vector3D.thetaPhi(vector3D3);
                vector3D4 = Vector3D.vectorFromSPC(1.0, dArray6[0], dArray6[1]);
                vector3D4 = Rotations.rotateVector(vector3D4, realMatrix2);
                dArray6 = Vector3D.thetaPhi(vector3D4);
            }
            dArray[0] = dArray5[0];
            dArray[1] = dArray5[1];
            dArray[3] = dArray6[0];
            dArray[4] = dArray6[1];
            try {
                this.setInitParams(dArray);
                this.minimise();
                bl = true;
            }
            catch (MarquardtMinimiserException marquardtMinimiserException) {
                // empty catch block
            }
            if (!(this.fObjVal < d7)) continue;
            d7 = this.fObjVal;
            dArray2 = this.getParameters();
        }
        this.setInitParams(dArray2);
        if (!bl) {
            throw new MarquardtMinimiserException("None of the parameters could converge");
        }
    }

    public void fitEstimatedParams(Vector3D vector3D, Vector3D vector3D2, int n) throws MarquardtMinimiserException {
        double d;
        int n2;
        Vector3D[] vector3DArray;
        Vector3D[] vector3DArray2 = new Vector3D[this.samples.length];
        Vector3D[] vector3DArray3 = new Vector3D[this.samples.length];
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < this.samples.length; ++i) {
            vector3DArray = this.samples[i];
            if (Math.abs(vector3D.dot((Vector3D)vector3DArray)) > Math.abs(vector3D2.dot((Vector3D)vector3DArray))) {
                vector3DArray2[n3++] = vector3DArray;
                continue;
            }
            vector3DArray3[n4++] = vector3DArray;
        }
        Vector3D[] vector3DArray4 = new Vector3D[n3];
        vector3DArray = new Vector3D[n4];
        for (n2 = 0; n2 < n3; ++n2) {
            vector3DArray4[n2] = vector3DArray2[n2];
        }
        for (n2 = 0; n2 < n4; ++n2) {
            vector3DArray[n2] = vector3DArray3[n2];
        }
        vector3DArray2 = vector3DArray4;
        vector3DArray3 = vector3DArray;
        EigenSystem3D eigenSystem3D = WatsonFitter.tBarEigenSystem(vector3DArray2);
        EigenSystem3D eigenSystem3D2 = WatsonFitter.tBarEigenSystem(vector3DArray3);
        double d2 = WatsonFitter.getBipolarConfidenceCone(eigenSystem3D, vector3DArray2, 0.25) * 180.0 / Math.PI;
        double d3 = WatsonFitter.getBipolarConfidenceCone(eigenSystem3D, vector3DArray2, 0.05) * 180.0 / Math.PI;
        double d4 = WatsonFitter.getBipolarConfidenceCone(eigenSystem3D2, vector3DArray3, 0.25) * 180.0 / Math.PI;
        double d5 = WatsonFitter.getBipolarConfidenceCone(eigenSystem3D2, vector3DArray3, 0.05) * 180.0 / Math.PI;
        double d6 = d = 20.0;
        try {
            this.fitEstimatedParams(eigenSystem3D.eigenvectors[0], eigenSystem3D2.eigenvectors[0], d2, d3, d4, d5, d, d6, n);
        }
        catch (MarquardtMinimiserException marquardtMinimiserException) {
            double d7 = WatsonFitter.fitKappa(eigenSystem3D, vector3DArray2);
            double d8 = WatsonFitter.fitKappa(eigenSystem3D2, vector3DArray3);
            if (d7 < 0.0) {
                d7 = 0.0;
            }
            if (d8 < 0.0) {
                d8 = 0.0;
            }
            this.setInitParams(eigenSystem3D.eigenvectors[0], eigenSystem3D2.eigenvectors[0], d7, d8);
            throw marquardtMinimiserException;
        }
        double[] dArray = this.getKappas();
        if (Double.isInfinite(dArray[0]) || Double.isInfinite(dArray[1])) {
            double d9 = WatsonFitter.fitKappa(eigenSystem3D, vector3DArray2);
            double d10 = WatsonFitter.fitKappa(eigenSystem3D2, vector3DArray3);
            if (d9 < 0.0) {
                d9 = 0.0;
            }
            if (d10 < 0.0) {
                d10 = 0.0;
            }
            this.setInitParams(eigenSystem3D.eigenvectors[0], eigenSystem3D2.eigenvectors[0], d9, d10);
            throw new MarquardtMinimiserException("Converged but concentration was infinite");
        }
    }

    @Override
    public double[] getParameters() {
        double[] dArray = new double[this.ma];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.a[i + 1];
        }
        return dArray;
    }

    public void setFixedParams(boolean[] blArray) {
        this.ia = new boolean[blArray.length + 1];
        this.ia[0] = true;
        for (int i = 0; i < blArray.length; ++i) {
            this.ia[i + 1] = blArray[i];
        }
    }

    public void setMu1Variable(boolean bl) {
        this.ia[1] = bl;
        this.ia[2] = bl;
    }

    public void setMu2Variable(boolean bl) {
        this.ia[4] = bl;
        this.ia[5] = bl;
    }

    public void setKappa1Variable(boolean bl) {
        this.ia[3] = bl;
    }

    public void setKappa2Variable(boolean bl) {
        this.ia[6] = bl;
    }

    public TwoFibreFixedPropWatsonFitter(Vector3D[] vector3DArray, double d) {
        this.alpha = d;
        this.init(6);
        this.samples = vector3DArray;
        this.mu1DotX = new double[this.samples.length];
        this.mu2DotX = new double[this.samples.length];
        this.eK1Mu1DotXSq = new double[this.samples.length];
        this.eK2Mu2DotXSq = new double[this.samples.length];
    }

    public static void main(String[] stringArray) {
        Object object;
        Vector3D[] vector3DArray;
        if (stringArray.length == 0) {
            System.out.println("Usage: TwoFibreFixedPropWatsonFitter -sampleAxes [filename] -initMu1 [theta phi] -initMu2 [theta phi] -initK1 [value] -initK2 [value] -initAlpha [value]\n\nThe axes file should contain a list of unit vectors with x y z delimited by spaces and each vector on a separate line. Parameters default to zero if arguments are missing.");
            System.exit(0);
        }
        Vector3D[] vector3DArray2 = null;
        double[] dArray = new double[6];
        double d = 0.5;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].toLowerCase().equals("-sampleaxes")) {
                vector3DArray = new FileInput(stringArray[i + 1]);
                object = new ArrayList();
                while (!vector3DArray.eof()) {
                    String[] stringArray2 = vector3DArray.readString().split(" ");
                    double d2 = Double.parseDouble(stringArray2[0]);
                    double d3 = Double.parseDouble(stringArray2[1]);
                    double d4 = Double.parseDouble(stringArray2[2]);
                    ((ArrayList)object).add(new Vector3D(d2, d3, d4));
                }
                continue;
            }
            if (stringArray[i].toLowerCase().equals("-initmu1")) {
                dArray[0] = Double.parseDouble(stringArray[i + 1]);
                dArray[1] = Double.parseDouble(stringArray[i + 2]);
                continue;
            }
            if (stringArray[i].toLowerCase().equals("-initk1")) {
                dArray[2] = Double.parseDouble(stringArray[i + 1]);
                continue;
            }
            if (stringArray[i].toLowerCase().equals("-initmu2")) {
                dArray[3] = Double.parseDouble(stringArray[i + 1]);
                dArray[4] = Double.parseDouble(stringArray[i + 2]);
                continue;
            }
            if (stringArray[i].toLowerCase().equals("-initk2")) {
                dArray[5] = Double.parseDouble(stringArray[i + 1]);
                continue;
            }
            if (!stringArray[i].toLowerCase().equals("-alpha")) continue;
            d = Double.parseDouble(stringArray[i + 1]);
        }
        TwoFibreFixedPropWatsonFitter twoFibreFixedPropWatsonFitter = new TwoFibreFixedPropWatsonFitter(vector3DArray2, d);
        try {
            twoFibreFixedPropWatsonFitter.setInitParams(dArray);
            twoFibreFixedPropWatsonFitter.minimise();
        }
        catch (MarquardtMinimiserException marquardtMinimiserException) {
            logger.severe("Minimization failed with exception: ");
            LoggedException.logExceptionSevere(marquardtMinimiserException, Thread.currentThread().getName());
            System.exit(1);
        }
        System.out.println("Fitted parameters");
        vector3DArray = twoFibreFixedPropWatsonFitter.getMus();
        object = twoFibreFixedPropWatsonFitter.getKappas();
        double d5 = twoFibreFixedPropWatsonFitter.getMixingParameter();
        System.out.println("mu1 " + vector3DArray[0]);
        System.out.println("kappa1 " + (double)object[0]);
        System.out.println("\nmu2 " + vector3DArray[1]);
        System.out.println("kappa2 " + (double)object[1]);
        System.out.println("alpha " + d5);
    }
}

