/*
 * Decompiled with CFR 0.152.
 */
package numerics;

import java.util.ArrayList;
import java.util.Random;
import numerics.TwoFibreFixedPropWatsonFitter;
import numerics.Vector3D;
import numerics.WatsonDistribution;
import optimizers.MarquardtMinimiserException;
import tools.FileInput;

public class TwoFibreBipolarWatsonFitter
extends TwoFibreFixedPropWatsonFitter {
    double[] k1Mu1DotXSq;
    double[] k2Mu2DotXSq;

    @Override
    protected double fObj(double[] dArray, double[] dArray2, double[][] dArray3) {
        double d = 0.0;
        Vector3D vector3D = Vector3D.vectorFromSPC(1.0, dArray[1], dArray[2]);
        Vector3D vector3D2 = Vector3D.vectorFromSPC(1.0, dArray[4], dArray[5]);
        double[] dArray4 = new double[this.samples.length];
        double[][] dArray5 = new double[this.ma + 1][this.samples.length];
        if (dArray[3] > 15.0 || dArray[6] > 15.0) {
            double d2 = WatsonDistribution.logHyper1F1(0.5, 1.5, dArray[3] * dArray[3], 1.0E-9);
            double d3 = WatsonDistribution.logHyper1F1(0.5, 1.5, dArray[6] * dArray[6], 1.0E-9);
            for (int i = 0; i < this.samples.length; ++i) {
                this.mu1DotX[i] = vector3D.x * this.samples[i].x + vector3D.y * this.samples[i].y + vector3D.z * this.samples[i].z;
                this.mu2DotX[i] = vector3D2.x * this.samples[i].x + vector3D2.y * this.samples[i].y + vector3D2.z * this.samples[i].z;
                this.k1Mu1DotXSq[i] = dArray[3] * dArray[3] * this.mu1DotX[i] * this.mu1DotX[i];
                this.k2Mu2DotXSq[i] = dArray[6] * dArray[6] * this.mu2DotX[i] * this.mu2DotX[i];
                dArray4[i] = Math.exp(this.k1Mu1DotXSq[i] - d2) / 2.0 + Math.exp(this.k2Mu2DotXSq[i] - d3) / 2.0;
                d -= Math.log(dArray4[i]);
            }
            double d4 = WatsonDistribution.logHyper1F1(1.5, 2.5, dArray[3] * dArray[3], 1.0E-9);
            double d5 = WatsonDistribution.logHyper1F1(1.5, 2.5, dArray[6] * dArray[6], 1.0E-9);
            this.firstDerivLog(dArray, dArray4, dArray5, dArray2, this.mu1DotX, this.mu2DotX, this.k1Mu1DotXSq, this.k2Mu2DotXSq, d2, d3, d4, d5);
            this.secondDerivLog(dArray, dArray4, dArray5, dArray3, this.mu1DotX, this.mu2DotX, this.k1Mu1DotXSq, this.k2Mu2DotXSq, d2, d3, d4, d5);
        } else {
            double d6 = WatsonDistribution.hyper1F1(0.5, 1.5, dArray[3] * dArray[3], 1.0E-9);
            double d7 = WatsonDistribution.hyper1F1(0.5, 1.5, dArray[6] * dArray[6], 1.0E-9);
            for (int i = 0; i < this.samples.length; ++i) {
                this.mu1DotX[i] = vector3D.x * this.samples[i].x + vector3D.y * this.samples[i].y + vector3D.z * this.samples[i].z;
                this.mu2DotX[i] = vector3D2.x * this.samples[i].x + vector3D2.y * this.samples[i].y + vector3D2.z * this.samples[i].z;
                this.eK1Mu1DotXSq[i] = Math.exp(dArray[3] * dArray[3] * this.mu1DotX[i] * this.mu1DotX[i]);
                this.eK2Mu2DotXSq[i] = Math.exp(dArray[6] * dArray[6] * this.mu2DotX[i] * this.mu2DotX[i]);
                dArray4[i] = (1.0 / d6 * this.eK1Mu1DotXSq[i] + 1.0 / d7 * this.eK2Mu2DotXSq[i]) / 2.0;
                d -= Math.log(dArray4[i]);
            }
            double d8 = WatsonDistribution.hyper1F1(1.5, 2.5, dArray[3] * dArray[3], 1.0E-9);
            double d9 = WatsonDistribution.hyper1F1(1.5, 2.5, dArray[6] * dArray[6], 1.0E-9);
            this.firstDeriv(dArray, dArray4, dArray5, dArray2, this.mu1DotX, this.mu2DotX, this.eK1Mu1DotXSq, this.eK2Mu2DotXSq, d6, d7, d8, d9);
            this.secondDeriv(dArray, dArray4, dArray5, dArray3, this.mu1DotX, this.mu2DotX, this.eK1Mu1DotXSq, this.eK2Mu2DotXSq, d6, d7, d8, d9);
        }
        return d;
    }

    @Override
    protected void firstDeriv(double[] dArray, double[] dArray2, double[][] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, double[] dArray7, double[] dArray8, double d, double d2, double d3, double d4) {
        double d5 = Math.cos(dArray[1]);
        double d6 = Math.sin(dArray[1]);
        double d7 = Math.cos(dArray[2]);
        double d8 = Math.sin(dArray[2]);
        double d9 = Math.cos(dArray[4]);
        double d10 = Math.sin(dArray[4]);
        double d11 = Math.cos(dArray[5]);
        double d12 = Math.sin(dArray[5]);
        for (int i = 0; i < this.samples.length; ++i) {
            double d13 = this.samples[i].x;
            double d14 = this.samples[i].y;
            double d15 = this.samples[i].z;
            double d16 = dArray5[i] * dArray5[i];
            double d17 = dArray6[i] * dArray6[i];
            dArray3[1][i] = dArray7[i] * (dArray[3] * dArray[3]) * (d13 * d5 * d7 - d15 * d6 + d14 * d5 * d8) * dArray5[i] / d;
            dArray4[1] = dArray4[1] - 1.0 / dArray2[i] * dArray3[1][i];
            dArray3[2][i] = dArray7[i] * (dArray[3] * dArray[3]) * (d14 * d7 * d6 - d13 * d6 * d8) * dArray5[i] / d;
            dArray4[2] = dArray4[2] - 1.0 / dArray2[i] * dArray3[2][i];
            dArray3[3][i] = -0.3333333333333333 * dArray7[i] * dArray[3] * d3 / (d * d) + dArray7[i] * dArray[3] * d16 / d;
            dArray4[3] = dArray4[3] - 1.0 / dArray2[i] * dArray3[3][i];
            dArray3[4][i] = dArray8[i] * (dArray[6] * dArray[6]) * (d13 * d9 * d11 - d15 * d10 + d14 * d9 * d12) * dArray6[i] / d2;
            dArray4[4] = dArray4[4] - 1.0 / dArray2[i] * dArray3[4][i];
            dArray3[5][i] = dArray8[i] * (dArray[6] * dArray[6]) * (d14 * d11 * d10 - d13 * d10 * d12) * dArray6[i] / d2;
            dArray4[5] = dArray4[5] - 1.0 / dArray2[i] * dArray3[5][i];
            dArray3[6][i] = -0.3333333333333333 * dArray8[i] * dArray[6] * d4 / (d2 * d2) + dArray8[i] * dArray[6] * d17 / d2;
            dArray4[6] = dArray4[6] - 1.0 / dArray2[i] * dArray3[6][i];
        }
    }

    protected void firstDerivLog(double[] dArray, double[] dArray2, double[][] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, double[] dArray7, double[] dArray8, double d, double d2, double d3, double d4) {
        double d5 = Math.cos(dArray[1]);
        double d6 = Math.sin(dArray[1]);
        double d7 = Math.cos(dArray[2]);
        double d8 = Math.sin(dArray[2]);
        double d9 = Math.cos(dArray[4]);
        double d10 = Math.sin(dArray[4]);
        double d11 = Math.cos(dArray[5]);
        double d12 = Math.sin(dArray[5]);
        for (int i = 0; i < this.samples.length; ++i) {
            double d13 = this.samples[i].x;
            double d14 = this.samples[i].y;
            double d15 = this.samples[i].z;
            double d16 = dArray5[i] * dArray5[i];
            double d17 = dArray6[i] * dArray6[i];
            dArray3[1][i] = dArray[3] * dArray[3] * (d13 * d5 * d7 - d15 * d6 + d14 * d5 * d8) * dArray5[i] * Math.exp(dArray7[i] - d);
            dArray4[1] = dArray4[1] - 1.0 / dArray2[i] * dArray3[1][i];
            dArray3[2][i] = dArray[3] * dArray[3] * (d14 * d7 * d6 - d13 * d6 * d8) * dArray5[i] * Math.exp(dArray7[i] - d);
            dArray4[2] = dArray4[2] - 1.0 / dArray2[i] * dArray3[2][i];
            dArray3[3][i] = -0.3333333333333333 * dArray[3] * Math.exp(dArray7[i] + d3 - (d + d)) + dArray[3] * d16 * Math.exp(dArray7[i] - d);
            dArray4[3] = dArray4[3] - 1.0 / dArray2[i] * dArray3[3][i];
            dArray3[4][i] = dArray[6] * dArray[6] * (d13 * d9 * d11 - d15 * d10 + d14 * d9 * d12) * dArray6[i] * Math.exp(dArray8[i] - d2);
            dArray4[4] = dArray4[4] - 1.0 / dArray2[i] * dArray3[4][i];
            dArray3[5][i] = dArray[6] * dArray[6] * (d14 * d11 * d10 - d13 * d10 * d12) * dArray6[i] * Math.exp(dArray8[i] + -d2);
            dArray4[5] = dArray4[5] - 1.0 / dArray2[i] * dArray3[5][i];
            dArray3[6][i] = -0.3333333333333333 * dArray[6] * Math.exp(dArray8[i] + d4 - (d2 + d2)) + dArray[6] * d17 * Math.exp(dArray8[i] - d2);
            dArray4[6] = dArray4[6] - 1.0 / dArray2[i] * dArray3[6][i];
        }
    }

    @Override
    protected void secondDeriv(double[] dArray, double[] dArray2, double[][] dArray3, double[][] dArray4, double[] dArray5, double[] dArray6, double[] dArray7, double[] dArray8, double d, double d2, double d3, double d4) {
        int n;
        double d5 = WatsonDistribution.hyper1F1(2.5, 3.5, dArray[3] * dArray[3], 1.0E-9);
        double d6 = WatsonDistribution.hyper1F1(2.5, 3.5, dArray[6] * dArray[6], 1.0E-9);
        double d7 = Math.cos(dArray[1]);
        double d8 = Math.sin(dArray[1]);
        double d9 = Math.cos(dArray[2]);
        double d10 = Math.sin(dArray[2]);
        double d11 = Math.cos(dArray[4]);
        double d12 = Math.sin(dArray[4]);
        double d13 = Math.cos(dArray[5]);
        double d14 = Math.sin(dArray[5]);
        for (n = 0; n < this.samples.length; ++n) {
            double d15 = this.samples[n].x;
            double d16 = this.samples[n].y;
            double d17 = this.samples[n].z;
            double d18 = 1.0 / dArray2[n];
            double d19 = d18 * d18;
            double d20 = dArray5[n] * dArray5[n];
            double d21 = dArray6[n] * dArray6[n];
            double d22 = d15 * d7 * d9 - d17 * d8 + d16 * d7 * d10;
            double d23 = d16 * d9 * d8 - d15 * d8 * d10;
            double d24 = d15 * d11 * d13 - d17 * d12 + d16 * d11 * d14;
            double d25 = d16 * d13 * d12 - d15 * d12 * d14;
            double[] dArray9 = dArray4[1];
            dArray9[1] = dArray9[1] - (d18 * (dArray7[n] * (dArray[3] * dArray[3]) * (d22 * d22) / d + dArray7[n] * (dArray[3] * dArray[3]) * (-(d17 * d7) - d15 * d9 * d8 - d16 * d8 * d10) * dArray5[n] / d + 2.0 * dArray7[n] * (dArray[3] * dArray[3] * dArray[3] * dArray[3]) * (d22 * d22) * d20 / d) - d19 * dArray3[1][n] * dArray3[1][n]);
            double[] dArray10 = dArray4[1];
            dArray10[2] = dArray10[2] - (d18 * (dArray7[n] * (dArray[3] * dArray[3]) * d22 * d23 / d + dArray7[n] * (dArray[3] * dArray[3]) * (d16 * d7 * d9 - d15 * d7 * d10) * dArray5[n] / d + 2.0 * dArray7[n] * (dArray[3] * dArray[3] * dArray[3] * dArray[3]) * d22 * d23 * d20 / d) - d19 * dArray3[1][n] * dArray3[2][n]);
            double[] dArray11 = dArray4[1];
            dArray11[3] = dArray11[3] - (d18 * (2.0 * dArray7[n] * dArray[3] * d22 * dArray5[n] / d - 0.6666666666666666 * dArray7[n] * (dArray[3] * dArray[3] * dArray[3]) * d3 * d22 * dArray5[n] / (d * d) + 2.0 * dArray7[n] * (dArray[3] * dArray[3] * dArray[3]) * d22 * (d20 * dArray5[n]) / d) - d19 * dArray3[1][n] * dArray3[3][n]);
            double[] dArray12 = dArray4[2];
            dArray12[2] = dArray12[2] - (d18 * (dArray7[n] * (dArray[3] * dArray[3]) * (d23 * d23) / d + dArray7[n] * (dArray[3] * dArray[3]) * (-(d15 * d9 * d8) - d16 * d8 * d10) * dArray5[n] / d + 2.0 * dArray7[n] * (dArray[3] * dArray[3] * dArray[3] * dArray[3]) * (d23 * d23) * d20 / d) - d19 * dArray3[2][n] * dArray3[2][n]);
            double[] dArray13 = dArray4[2];
            dArray13[3] = dArray13[3] - (d18 * (2.0 * dArray7[n] * dArray[3] * d23 * dArray5[n] / d - 0.6666666666666666 * dArray7[n] * (dArray[3] * dArray[3] * dArray[3]) * d3 * d23 * dArray5[n] / (d * d) + 2.0 * dArray7[n] * (dArray[3] * dArray[3] * dArray[3]) * d23 * (d20 * dArray5[n]) / d) - d19 * dArray3[2][n] * dArray3[3][n]);
            double[] dArray14 = dArray4[3];
            dArray14[3] = dArray14[3] - (d18 * (-0.3333333333333333 * dArray7[n] * d3 / (d * d) + 0.4444444444444444 * dArray7[n] * (dArray[3] * dArray[3]) * (d3 * d3) / (d * d * d) - 0.4 * dArray7[n] * (dArray[3] * dArray[3]) * d5 / (d * d) + dArray7[n] * d20 / d - 1.3333333333333333 * dArray7[n] * (dArray[3] * dArray[3]) * d3 * d20 / (d * d) + 2.0 * dArray7[n] * (dArray[3] * dArray[3]) * (d20 * d20) / d) - d19 * dArray3[3][n] * dArray3[3][n]);
            double[] dArray15 = dArray4[4];
            dArray15[4] = dArray15[4] - (d18 * (dArray8[n] * (dArray[6] * dArray[6]) * (d24 * d24) / d2 + dArray8[n] * (dArray[6] * dArray[6]) * (-(d17 * d11) - d15 * d13 * d12 - d16 * d12 * d14) * dArray6[n] / d2 + 2.0 * dArray8[n] * (dArray[6] * dArray[6] * dArray[6] * dArray[6]) * (d24 * d24) * d21 / d2) - d19 * dArray3[4][n] * dArray3[4][n]);
            double[] dArray16 = dArray4[4];
            dArray16[5] = dArray16[5] - (d18 * (dArray8[n] * (dArray[6] * dArray[6]) * d24 * d25 / d2 + dArray8[n] * (dArray[6] * dArray[6]) * (d16 * d11 * d13 - d15 * d11 * d14) * dArray6[n] / d2 + 2.0 * dArray8[n] * (dArray[6] * dArray[6] * dArray[6] * dArray[6]) * d24 * d25 * d21 / d2) - d19 * dArray3[4][n] * dArray3[5][n]);
            double[] dArray17 = dArray4[4];
            dArray17[6] = dArray17[6] - (d18 * (2.0 * dArray8[n] * dArray[6] * d24 * dArray6[n] / d2 - 0.6666666666666666 * dArray8[n] * (dArray[6] * dArray[6] * dArray[6]) * d4 * d24 * dArray6[n] / (d2 * d2) + 2.0 * dArray8[n] * (dArray[6] * dArray[6] * dArray[6]) * d24 * (d21 * dArray6[n]) / d2) - d19 * dArray3[4][n] * dArray3[6][n]);
            double[] dArray18 = dArray4[5];
            dArray18[5] = dArray18[5] - (d18 * (dArray8[n] * (dArray[6] * dArray[6]) * (d25 * d25) / d2 + dArray8[n] * (dArray[6] * dArray[6]) * (-(d15 * d13 * d12) - d16 * d12 * d14) * dArray6[n] / d2 + 2.0 * dArray8[n] * (dArray[6] * dArray[6] * dArray[6] * dArray[6]) * (d25 * d25) * d21 / d2) - d19 * dArray3[5][n] * dArray3[5][n]);
            double[] dArray19 = dArray4[5];
            dArray19[6] = dArray19[6] - (d18 * (2.0 * dArray8[n] * dArray[6] * d25 * dArray6[n] / d2 - 0.6666666666666666 * dArray8[n] * (dArray[6] * dArray[6] * dArray[6]) * d4 * d25 * dArray6[n] / (d2 * d2) + 2.0 * dArray8[n] * (dArray[6] * dArray[6] * dArray[6]) * d25 * (d21 * dArray6[n]) / d2) - d19 * dArray3[5][n] * dArray3[6][n]);
            double[] dArray20 = dArray4[6];
            dArray20[6] = dArray20[6] - (d18 * (-0.3333333333333333 * dArray8[n] * d4 / (d2 * d2) + 0.4444444444444444 * dArray8[n] * (dArray[6] * dArray[6]) * (d4 * d4) / (d2 * d2 * d2) - 0.4 * dArray8[n] * (dArray[6] * dArray[6]) * d6 / (d2 * d2) + dArray8[n] * d21 / d2 - 1.3333333333333333 * dArray8[n] * (dArray[6] * dArray[6]) * d4 * d21 / (d2 * d2) + 2.0 * dArray8[n] * (dArray[6] * dArray[6]) * (d21 * d21) / d2) - d19 * dArray3[6][n] * dArray3[6][n]);
        }
        for (n = 1; n <= this.ma; ++n) {
            for (int i = 1; i <= n; ++i) {
                dArray4[n][i] = dArray4[i][n];
            }
        }
    }

    protected void secondDerivLog(double[] dArray, double[] dArray2, double[][] dArray3, double[][] dArray4, double[] dArray5, double[] dArray6, double[] dArray7, double[] dArray8, double d, double d2, double d3, double d4) {
        int n;
        double d5 = WatsonDistribution.logHyper1F1(2.5, 3.5, dArray[3] * dArray[3], 1.0E-9);
        double d6 = WatsonDistribution.logHyper1F1(2.5, 3.5, dArray[6] * dArray[6], 1.0E-9);
        double d7 = Math.cos(dArray[1]);
        double d8 = Math.sin(dArray[1]);
        double d9 = Math.cos(dArray[2]);
        double d10 = Math.sin(dArray[2]);
        double d11 = Math.cos(dArray[4]);
        double d12 = Math.sin(dArray[4]);
        double d13 = Math.cos(dArray[5]);
        double d14 = Math.sin(dArray[5]);
        for (n = 0; n < this.samples.length; ++n) {
            double d15 = this.samples[n].x;
            double d16 = this.samples[n].y;
            double d17 = this.samples[n].z;
            double d18 = 1.0 / dArray2[n];
            double d19 = d18 * d18;
            double d20 = dArray5[n] * dArray5[n];
            double d21 = dArray6[n] * dArray6[n];
            double d22 = d15 * d7 * d9 - d17 * d8 + d16 * d7 * d10;
            double d23 = d16 * d9 * d8 - d15 * d8 * d10;
            double d24 = d15 * d11 * d13 - d17 * d12 + d16 * d11 * d14;
            double d25 = d16 * d13 * d12 - d15 * d12 * d14;
            double[] dArray9 = dArray4[1];
            dArray9[1] = dArray9[1] - (d18 * (dArray[3] * dArray[3] * (d22 * d22) * Math.exp(dArray7[n] - d) + dArray[3] * dArray[3] * (-(d17 * d7) - d15 * d9 * d8 - d16 * d8 * d10) * dArray5[n] * Math.exp(dArray7[n] - d) + 2.0 * (dArray[3] * dArray[3] * dArray[3] * dArray[3]) * (d22 * d22) * d20 * Math.exp(dArray7[n] - d)) - d19 * dArray3[1][n] * dArray3[1][n]);
            double[] dArray10 = dArray4[1];
            dArray10[2] = dArray10[2] - (d18 * (dArray[3] * dArray[3] * d22 * d23 * Math.exp(dArray7[n] - d) + dArray[3] * dArray[3] * (d16 * d7 * d9 - d15 * d7 * d10) * dArray5[n] * Math.exp(dArray7[n] - d) + 2.0 * (dArray[3] * dArray[3] * dArray[3] * dArray[3]) * d22 * d23 * d20 * Math.exp(dArray7[n] - d)) - d19 * dArray3[1][n] * dArray3[2][n]);
            double[] dArray11 = dArray4[1];
            dArray11[3] = dArray11[3] - (d18 * (2.0 * dArray[3] * d22 * dArray5[n] * Math.exp(dArray7[n] - d) - 0.6666666666666666 * (dArray[3] * dArray[3] * dArray[3]) * d22 * dArray5[n] * Math.exp(dArray7[n] + d3 - (d + d)) + 2.0 * (dArray[3] * dArray[3] * dArray[3]) * d22 * (d20 * dArray5[n]) * Math.exp(dArray7[n] - d)) - d19 * dArray3[1][n] * dArray3[3][n]);
            double[] dArray12 = dArray4[2];
            dArray12[2] = dArray12[2] - (d18 * (dArray[3] * dArray[3] * (d23 * d23) * Math.exp(dArray7[n] - d) + dArray[3] * dArray[3] * (-(d15 * d9 * d8) - d16 * d8 * d10) * dArray5[n] * Math.exp(dArray7[n] - d) + 2.0 * (dArray[3] * dArray[3] * dArray[3] * dArray[3]) * (d23 * d23) * d20 * Math.exp(dArray7[n] - d)) - d19 * dArray3[2][n] * dArray3[2][n]);
            double[] dArray13 = dArray4[2];
            dArray13[3] = dArray13[3] - (d18 * (2.0 * dArray[3] * d23 * dArray5[n] * Math.exp(dArray7[n] - d) - 0.6666666666666666 * (dArray[3] * dArray[3] * dArray[3]) * d23 * dArray5[n] * Math.exp(dArray7[n] + d3 - (d + d)) + 2.0 * (dArray[3] * dArray[3] * dArray[3]) * d23 * (d20 * dArray5[n]) * Math.exp(dArray7[n] - d)) - d19 * dArray3[2][n] * dArray3[3][n]);
            double[] dArray14 = dArray4[3];
            dArray14[3] = dArray14[3] - (d18 * (-0.3333333333333333 * Math.exp(dArray7[n] + d3 - (d + d)) + 0.4444444444444444 * (dArray[3] * dArray[3]) * Math.exp(dArray7[n] + d3 + d3 - (d + d + d)) - 0.4 * (dArray[3] * dArray[3]) * Math.exp(dArray7[n] + d5 - (d + d)) + d20 * Math.exp(dArray7[n] - d) - 1.3333333333333333 * (dArray[3] * dArray[3]) * d20 * Math.exp(dArray7[n] + d3 - (d + d)) + 2.0 * (dArray[3] * dArray[3]) * (d20 * d20) * Math.exp(dArray7[n] - d)) - d19 * dArray3[3][n] * dArray3[3][n]);
            double[] dArray15 = dArray4[4];
            dArray15[4] = dArray15[4] - (d18 * (dArray[6] * dArray[6] * (d24 * d24) * Math.exp(dArray8[n] - d2) + dArray[6] * dArray[6] * (-(d17 * d11) - d15 * d13 * d12 - d16 * d12 * d14) * dArray6[n] * Math.exp(dArray8[n] - d2) + 2.0 * (dArray[6] * dArray[6] * dArray[6] * dArray[6]) * (d24 * d24) * d21 * Math.exp(dArray8[n] - d2)) - d19 * dArray3[4][n] * dArray3[4][n]);
            double[] dArray16 = dArray4[4];
            dArray16[5] = dArray16[5] - (d18 * (dArray[6] * dArray[6] * d24 * d25 * Math.exp(dArray8[n] - d2) + dArray[6] * dArray[6] * (d16 * d11 * d13 - d15 * d11 * d14) * dArray6[n] * Math.exp(dArray8[n] - d2) + 2.0 * (dArray[6] * dArray[6] * dArray[6] * dArray[6]) * d24 * d25 * d21 * Math.exp(dArray8[n] - d2)) - d19 * dArray3[4][n] * dArray3[5][n]);
            double[] dArray17 = dArray4[4];
            dArray17[6] = dArray17[6] - (d18 * (2.0 * dArray[6] * d24 * dArray6[n] * Math.exp(dArray8[n] - d2) - 0.6666666666666666 * (dArray[6] * dArray[6] * dArray[6]) * d24 * dArray6[n] * Math.exp(dArray8[n] + d4 - (d2 + d2)) + 2.0 * (dArray[6] * dArray[6] * dArray[6]) * d24 * (d21 * dArray6[n]) * Math.exp(dArray8[n] - d2)) - d19 * dArray3[4][n] * dArray3[6][n]);
            double[] dArray18 = dArray4[5];
            dArray18[5] = dArray18[5] - (d18 * (dArray[6] * dArray[6] * (d25 * d25) * Math.exp(dArray8[n] - d2) + dArray[6] * dArray[6] * (-(d15 * d13 * d12) - d16 * d12 * d14) * dArray6[n] * Math.exp(dArray8[n] - d2) + 2.0 * (dArray[6] * dArray[6] * dArray[6] * dArray[6]) * (d25 * d25) * d21 * Math.exp(dArray8[n] - d2)) - d19 * dArray3[5][n] * dArray3[5][n]);
            double[] dArray19 = dArray4[5];
            dArray19[6] = dArray19[6] - (d18 * (2.0 * dArray[6] * d25 * dArray6[n] * Math.exp(dArray8[n] - d2) - 0.6666666666666666 * (dArray[6] * dArray[6] * dArray[6]) * d25 * dArray6[n] * Math.exp(dArray8[n] + d4 - (d2 + d2)) + 2.0 * (dArray[6] * dArray[6] * dArray[6]) * d25 * (d21 * dArray6[n]) * Math.exp(dArray8[n] - d2)) - d19 * dArray3[5][n] * dArray3[6][n]);
            double[] dArray20 = dArray4[6];
            dArray20[6] = dArray20[6] - (d18 * (-0.3333333333333333 * Math.exp(dArray8[n] + d4 - (d2 + d2)) + 0.4444444444444444 * (dArray[6] * dArray[6]) * Math.exp(dArray8[n] + (d4 + d4) - (d2 + d2 + d2)) - 0.4 * (dArray[6] * dArray[6]) * Math.exp(dArray8[n] + d6 - (d2 + d2)) + d21 * Math.exp(dArray8[n] - d2) - 1.3333333333333333 * d21 * (dArray[6] * dArray[6]) * Math.exp(dArray8[n] + d4 - (d2 + d2)) + 2.0 * (dArray[6] * dArray[6]) * (d21 * d21) * Math.exp(dArray8[n] - d2)) - d19 * dArray3[6][n] * dArray3[6][n]);
        }
        for (n = 1; n <= this.ma; ++n) {
            for (int i = 1; i <= n; ++i) {
                dArray4[n][i] = dArray4[i][n];
            }
        }
    }

    public TwoFibreBipolarWatsonFitter(Vector3D[] vector3DArray) {
        super(vector3DArray, 0.5);
        this.k1Mu1DotXSq = new double[vector3DArray.length];
        this.k2Mu2DotXSq = new double[vector3DArray.length];
    }

    @Override
    public void setInitParams(double[] dArray) throws MarquardtMinimiserException {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = dArray[i];
        }
        dArray2[2] = Math.sqrt(dArray2[2]);
        dArray2[5] = Math.sqrt(dArray2[5]);
        super.setInitParams(dArray2);
    }

    @Override
    public void setInitParams(Vector3D vector3D, Vector3D vector3D2, double d, double d2) throws MarquardtMinimiserException {
        double[] dArray = Vector3D.thetaPhi(vector3D);
        double[] dArray2 = new double[6];
        dArray2[0] = dArray[0];
        dArray2[1] = dArray[1];
        dArray2[2] = Math.sqrt(d);
        dArray = Vector3D.thetaPhi(vector3D2);
        dArray2[3] = dArray[0];
        dArray2[4] = dArray[1];
        dArray2[5] = Math.sqrt(d2);
        this.setInitParams(dArray2);
    }

    @Override
    public double[] getParameters() {
        double[] dArray = new double[this.ma];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.a[i + 1];
        }
        dArray[2] = dArray[2] * dArray[2];
        dArray[5] = dArray[5] * dArray[5];
        return dArray;
    }

    @Override
    public WatsonDistribution[] getDistributions(Random random) {
        Vector3D vector3D = Vector3D.vectorFromSPC(1.0, this.a[1], this.a[2]);
        Vector3D vector3D2 = Vector3D.vectorFromSPC(1.0, this.a[4], this.a[5]);
        return new WatsonDistribution[]{new WatsonDistribution(vector3D, this.a[3] * this.a[3], random), new WatsonDistribution(vector3D2, this.a[6] * this.a[6], random)};
    }

    @Override
    public double[] getKappas() {
        return new double[]{this.a[3] * this.a[3], this.a[6] * this.a[6]};
    }

    public static void main(String[] stringArray) {
        Object object;
        Vector3D[] vector3DArray;
        if (stringArray.length == 0) {
            System.out.println("Usage: TwoFibreBipolarWatsonFitter -sampleAxes [filename] -initMu1 [theta phi] -initMu2 [theta phi] -initK1 [value] -initK2 [value]\n\nThe axes file should contain a list of unit vectors with x y z delimited by spaces and each vector on a separate line. Parameters default to zero if arguments are missing.");
            System.exit(0);
        }
        Vector3D[] vector3DArray2 = null;
        double[] dArray = new double[6];
        double d = 0.5;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].toLowerCase().equals("-sampleaxes")) {
                vector3DArray = new FileInput(stringArray[i + 1]);
                object = new ArrayList();
                while (!vector3DArray.eof()) {
                    String[] stringArray2 = vector3DArray.readString().split(" ");
                    double d2 = Double.parseDouble(stringArray2[0]);
                    double d3 = Double.parseDouble(stringArray2[1]);
                    double d4 = Double.parseDouble(stringArray2[2]);
                    ((ArrayList)object).add(new Vector3D(d2, d3, d4));
                }
                continue;
            }
            if (stringArray[i].toLowerCase().equals("-initmu1")) {
                dArray[0] = Double.parseDouble(stringArray[i + 1]);
                dArray[1] = Double.parseDouble(stringArray[i + 2]);
                continue;
            }
            if (stringArray[i].toLowerCase().equals("-initk1")) {
                dArray[2] = Double.parseDouble(stringArray[i + 1]);
                continue;
            }
            if (stringArray[i].toLowerCase().equals("-initmu2")) {
                dArray[3] = Double.parseDouble(stringArray[i + 1]);
                dArray[4] = Double.parseDouble(stringArray[i + 2]);
                continue;
            }
            if (stringArray[i].toLowerCase().equals("-initk2")) {
                dArray[5] = Double.parseDouble(stringArray[i + 1]);
                continue;
            }
            if (!stringArray[i].toLowerCase().equals("-alpha")) continue;
            d = Double.parseDouble(stringArray[i + 1]);
        }
        TwoFibreBipolarWatsonFitter twoFibreBipolarWatsonFitter = new TwoFibreBipolarWatsonFitter(vector3DArray2);
        try {
            twoFibreBipolarWatsonFitter.setInitParams(dArray);
            twoFibreBipolarWatsonFitter.minimise();
        }
        catch (MarquardtMinimiserException marquardtMinimiserException) {
            System.out.println("Minimization failed with exception: " + marquardtMinimiserException);
            System.exit(1);
        }
        System.out.println("Fitted parameters");
        vector3DArray = twoFibreBipolarWatsonFitter.getMus();
        object = twoFibreBipolarWatsonFitter.getKappas();
        double d5 = twoFibreBipolarWatsonFitter.getMixingParameter();
        System.out.println("mu1 " + vector3DArray[0]);
        System.out.println("kappa1 " + (double)object[0]);
        System.out.println("\nmu2 " + vector3DArray[1]);
        System.out.println("kappa2 " + (double)object[1]);
        System.out.println("alpha " + d5);
    }
}

