/*
 * Decompiled with CFR 0.152.
 */
package numerics;

import java.util.Random;
import numerics.ACG_Distribution;
import numerics.ACG_Fitter;
import numerics.RealMatrix;
import numerics.Vector3D;
import optimizers.ConjGradMinimizer;
import optimizers.ConjGradMinimizerException;

public class TwoFibreACGFitter
extends ConjGradMinimizer {
    protected Vector3D[] samples;
    protected double[] gi;

    public TwoFibreACGFitter(Vector3D[] vector3DArray) {
        this.samples = vector3DArray;
        this.init(12);
    }

    protected static double[] getParams_Chol(double[] dArray) {
        double[] dArray2 = new double[]{dArray[1] * dArray[1], dArray[1] * dArray[2], dArray[1] * dArray[3], dArray[2] * dArray[2] + dArray[4] * dArray[4], dArray[2] * dArray[3] + dArray[4] * dArray[5], dArray[3] * dArray[3] + dArray[5] * dArray[5] + dArray[6] * dArray[6], dArray[7] * dArray[7], dArray[7] * dArray[8], dArray[7] * dArray[9], dArray[8] * dArray[8] + dArray[10] * dArray[10], dArray[8] * dArray[9] + dArray[10] * dArray[11], dArray[9] * dArray[9] + dArray[11] * dArray[11] + dArray[12] * dArray[12]};
        return dArray2;
    }

    public static double[] getCholParams(double[] dArray) {
        double d = dArray[1];
        double d2 = dArray[2];
        double d3 = dArray[3];
        double d4 = dArray[4];
        double d5 = dArray[5];
        double d6 = dArray[6];
        double d7 = dArray[7];
        double d8 = dArray[8];
        double d9 = dArray[9];
        double d10 = dArray[10];
        double d11 = dArray[11];
        double d12 = dArray[12];
        double[] dArray2 = new double[13];
        dArray2[1] = d > 0.0 ? Math.sqrt(d) : 0.0;
        dArray2[2] = dArray2[1] > 0.0 ? d2 / dArray2[1] : 0.0;
        dArray2[3] = dArray2[1] > 0.0 ? d3 / dArray2[1] : 0.0;
        double d13 = d4 - dArray2[2] * dArray2[2];
        dArray2[4] = d13 > 0.0 ? Math.sqrt(d13) : 0.0;
        dArray2[5] = dArray2[4] > 0.0 ? (d5 - dArray2[2] * dArray2[3]) / dArray2[4] : 0.0;
        double d14 = d6 - dArray2[3] * dArray2[3] - dArray2[5] * dArray2[5];
        dArray2[6] = d14 > 0.0 ? Math.sqrt(d14) : 0.0;
        dArray2[7] = d7 > 0.0 ? Math.sqrt(d7) : 0.0;
        dArray2[8] = dArray2[7] > 0.0 ? d8 / dArray2[7] : 0.0;
        dArray2[9] = dArray2[7] > 0.0 ? d9 / dArray2[7] : 0.0;
        d13 = d10 - dArray2[8] * dArray2[8];
        dArray2[10] = d13 > 0.0 ? Math.sqrt(d13) : 0.0;
        dArray2[11] = dArray2[10] > 0.0 ? (d11 - dArray2[8] * dArray2[9]) / dArray2[10] : 0.0;
        d14 = d12 - dArray2[9] * dArray2[9] - dArray2[11] * dArray2[11];
        dArray2[12] = d14 > 0.0 ? Math.sqrt(d14) : 0.0;
        return dArray2;
    }

    public double[] fitEstimatedParams(Vector3D vector3D, Vector3D vector3D2, double d) {
        int n;
        Vector3D[] vector3DArray;
        Vector3D[] vector3DArray2 = new Vector3D[this.samples.length];
        Vector3D[] vector3DArray3 = new Vector3D[this.samples.length];
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.samples.length; ++i) {
            vector3DArray = this.samples[i];
            if (Math.abs(vector3D.dot((Vector3D)vector3DArray)) > Math.abs(vector3D2.dot((Vector3D)vector3DArray))) {
                vector3DArray2[n2++] = vector3DArray;
                continue;
            }
            vector3DArray3[n3++] = vector3DArray;
        }
        Vector3D[] vector3DArray4 = new Vector3D[n2];
        vector3DArray = new Vector3D[n3];
        for (n = 0; n < n2; ++n) {
            vector3DArray4[n] = vector3DArray2[n];
        }
        for (n = 0; n < n3; ++n) {
            vector3DArray[n] = vector3DArray3[n];
        }
        vector3DArray2 = vector3DArray4;
        vector3DArray3 = vector3DArray;
        RealMatrix realMatrix = ACG_Fitter.findA(vector3DArray2);
        RealMatrix realMatrix2 = ACG_Fitter.findA(vector3DArray3);
        double[] dArray = new double[]{realMatrix.entries[0][0], realMatrix.entries[0][1], realMatrix.entries[0][2], realMatrix.entries[1][1], realMatrix.entries[1][2], realMatrix.entries[2][2]};
        double[] dArray2 = new double[]{realMatrix2.entries[0][0], realMatrix2.entries[0][1], realMatrix2.entries[0][2], realMatrix2.entries[1][1], realMatrix2.entries[1][2], realMatrix2.entries[2][2]};
        try {
            return this.fitEstimatedParams(dArray, dArray2, d);
        }
        catch (ConjGradMinimizerException conjGradMinimizerException) {
            double[] dArray3 = new double[12];
            for (int i = 0; i < 6; ++i) {
                dArray3[i] = dArray[i];
                dArray3[i + 6] = dArray2[i];
            }
            return dArray3;
        }
    }

    public double[] fitEstimatedParams(double[] dArray, double[] dArray2, double d) throws ConjGradMinimizerException {
        double[] dArray3 = new double[13];
        for (int i = 0; i < 6; ++i) {
            dArray3[i + 1] = dArray[i];
            dArray3[i + 7] = dArray2[i];
        }
        double[] dArray4 = TwoFibreACGFitter.getCholParams(dArray3);
        this.minimise(dArray4, d);
        double[] dArray5 = TwoFibreACGFitter.getParams_Chol(dArray4);
        return dArray5;
    }

    public static ACG_Distribution[] getDistributions(double[] dArray, Random random) {
        RealMatrix realMatrix = new RealMatrix(3, 3);
        RealMatrix realMatrix2 = new RealMatrix(3, 3);
        realMatrix.entries[0][0] = dArray[0];
        realMatrix.entries[0][1] = dArray[1];
        realMatrix.entries[0][2] = dArray[2];
        realMatrix.entries[1][0] = dArray[1];
        realMatrix.entries[1][1] = dArray[3];
        realMatrix.entries[1][2] = dArray[4];
        realMatrix.entries[2][0] = dArray[2];
        realMatrix.entries[2][1] = dArray[4];
        realMatrix.entries[2][2] = dArray[5];
        realMatrix2.entries[0][0] = dArray[6];
        realMatrix2.entries[0][1] = dArray[7];
        realMatrix2.entries[0][2] = dArray[8];
        realMatrix2.entries[1][0] = dArray[7];
        realMatrix2.entries[1][1] = dArray[9];
        realMatrix2.entries[1][2] = dArray[10];
        realMatrix2.entries[2][0] = dArray[8];
        realMatrix2.entries[2][1] = dArray[10];
        realMatrix2.entries[2][2] = dArray[11];
        ACG_Distribution[] aCG_DistributionArray = new ACG_Distribution[]{new ACG_Distribution(realMatrix, random), new ACG_Distribution(realMatrix2, random)};
        return aCG_DistributionArray;
    }

    @Override
    protected void init(int n) {
        super.init(n);
        this.gi = new double[this.samples.length];
    }

    @Override
    protected double fObj(double[] dArray) {
        double d = 0.0;
        double d2 = dArray[1];
        double d3 = dArray[2];
        double d4 = dArray[3];
        double d5 = dArray[4];
        double d6 = dArray[5];
        double d7 = dArray[6];
        double d8 = dArray[7];
        double d9 = dArray[8];
        double d10 = dArray[9];
        double d11 = dArray[10];
        double d12 = dArray[11];
        double d13 = dArray[12];
        for (int i = 0; i < this.samples.length; ++i) {
            this.gi[i] = 0.5 / (Math.sqrt(d2 * d2 * d5 * d5 * d7 * d7) * Math.pow((d4 * d4 * d5 * d5 * this.samples[i].x * this.samples[i].x + d5 * d5 * d7 * d7 * this.samples[i].x * this.samples[i].x + d3 * d3 * (d6 * d6 + d7 * d7) * this.samples[i].x * this.samples[i].x + d2 * d2 * d6 * d6 * this.samples[i].y * this.samples[i].y + d2 * d2 * d7 * d7 * this.samples[i].y * this.samples[i].y - 2.0 * d2 * d2 * d5 * d6 * this.samples[i].y * this.samples[i].z + d2 * d2 * d5 * d5 * this.samples[i].z * this.samples[i].z - 2.0 * d4 * d5 * this.samples[i].x * (d3 * d6 * this.samples[i].x - d2 * d6 * this.samples[i].y + d2 * d5 * this.samples[i].z) - 2.0 * d2 * d3 * this.samples[i].x * (d6 * d6 * this.samples[i].y + d7 * d7 * this.samples[i].y - d5 * d6 * this.samples[i].z)) / (d2 * d2 * d5 * d5 * d7 * d7), 1.5)) + 0.5 / (Math.sqrt(d8 * d8 * d11 * d11 * d13 * d13) * Math.pow((d10 * d10 * d11 * d11 * this.samples[i].x * this.samples[i].x + d11 * d11 * d13 * d13 * this.samples[i].x * this.samples[i].x + d9 * d9 * (d12 * d12 + d13 * d13) * this.samples[i].x * this.samples[i].x + d8 * d8 * d12 * d12 * this.samples[i].y * this.samples[i].y + d8 * d8 * d13 * d13 * this.samples[i].y * this.samples[i].y - 2.0 * d8 * d8 * d11 * d12 * this.samples[i].y * this.samples[i].z + d8 * d8 * d11 * d11 * this.samples[i].z * this.samples[i].z - 2.0 * d10 * d11 * this.samples[i].x * (d9 * d12 * this.samples[i].x - d8 * d12 * this.samples[i].y + d8 * d11 * this.samples[i].z) - 2.0 * d8 * d9 * this.samples[i].x * (d12 * d12 * this.samples[i].y + d13 * d13 * this.samples[i].y - d11 * d12 * this.samples[i].z)) / (d8 * d8 * d11 * d11 * d13 * d13), 1.5));
            d -= Math.log(this.gi[i]);
        }
        return d;
    }

    @Override
    protected double[] dfObj(double[] dArray) {
        double[] dArray2 = new double[13];
        double d = dArray[1];
        double d2 = dArray[2];
        double d3 = dArray[3];
        double d4 = dArray[4];
        double d5 = dArray[5];
        double d6 = dArray[6];
        double d7 = dArray[7];
        double d8 = dArray[8];
        double d9 = dArray[9];
        double d10 = dArray[10];
        double d11 = dArray[11];
        double d12 = dArray[12];
        for (int i = 0; i < this.samples.length; ++i) {
            double d13 = d3 * d3 * d4 * d4 * this.samples[i].x * this.samples[i].x + d4 * d4 * d6 * d6 * this.samples[i].x * this.samples[i].x;
            double d14 = d2 * d2 * (d5 * d5 + d6 * d6) * this.samples[i].x * this.samples[i].x;
            double d15 = Math.pow((d13 + d14 + d * d * d5 * d5 * this.samples[i].y * this.samples[i].y + d * d * d6 * d6 * this.samples[i].y * this.samples[i].y - 2.0 * d * d * d4 * d5 * this.samples[i].y * this.samples[i].z + d * d * d4 * d4 * this.samples[i].z * this.samples[i].z - 2.0 * d3 * d4 * this.samples[i].x * (d2 * d5 * this.samples[i].x - d * d5 * this.samples[i].y + d * d4 * this.samples[i].z) - 2.0 * d * d2 * this.samples[i].x * (d5 * d5 * this.samples[i].y + d6 * d6 * this.samples[i].y - d4 * d5 * this.samples[i].z)) / (d * d * d4 * d4 * d6 * d6), 2.5);
            double d16 = Math.pow(d13 + d14 + d * d * d5 * d5 * this.samples[i].y * this.samples[i].y + d * d * d6 * d6 * this.samples[i].y * this.samples[i].y - 2.0 * d * d * d4 * d5 * this.samples[i].y * this.samples[i].z + d * d * d4 * d4 * this.samples[i].z * this.samples[i].z + d3 * d4 * this.samples[i].x * (-2.0 * d2 * d5 * this.samples[i].x + 2.0 * d * d5 * this.samples[i].y - 2.0 * d * d4 * this.samples[i].z) + d * d2 * this.samples[i].x * (-2.0 * d5 * d5 * this.samples[i].y - 2.0 * d6 * d6 * this.samples[i].y + 2.0 * d4 * d5 * this.samples[i].z), 2.0);
            double d17 = Math.pow(d9 * d9 * d10 * d10 * this.samples[i].x * this.samples[i].x + d10 * d10 * d12 * d12 * this.samples[i].x * this.samples[i].x + d8 * d8 * (d11 * d11 + d12 * d12) * this.samples[i].x * this.samples[i].x + d7 * d7 * d11 * d11 * this.samples[i].y * this.samples[i].y + d7 * d7 * d12 * d12 * this.samples[i].y * this.samples[i].y - 2.0 * d7 * d7 * d10 * d11 * this.samples[i].y * this.samples[i].z + d7 * d7 * d10 * d10 * this.samples[i].z * this.samples[i].z + d9 * d10 * this.samples[i].x * (-2.0 * d8 * d11 * this.samples[i].x + 2.0 * d7 * d11 * this.samples[i].y - 2.0 * d7 * d10 * this.samples[i].z) + d7 * d8 * this.samples[i].x * (-2.0 * d11 * d11 * this.samples[i].y - 2.0 * d12 * d12 * this.samples[i].y + 2.0 * d10 * d11 * this.samples[i].z), 2.0);
            double[] dArray3 = new double[13];
            dArray3[1] = Math.sqrt(d * d * d4 * d4 * d6 * d6) * (d13 + d14 - 0.5 * d * d * d5 * d5 * this.samples[i].y * this.samples[i].y - 0.5 * d * d * d6 * d6 * this.samples[i].y * this.samples[i].y + d * d * d4 * d5 * this.samples[i].y * this.samples[i].z - 0.5 * d * d * d4 * d4 * this.samples[i].z * this.samples[i].z + d3 * d4 * this.samples[i].x * (-2.0 * d2 * d5 * this.samples[i].x + 0.5 * d * d5 * this.samples[i].y - 0.5 * d * d4 * this.samples[i].z) + d * d2 * this.samples[i].x * (-0.5 * d5 * d5 * this.samples[i].y - 0.5 * d6 * d6 * this.samples[i].y + 0.5 * d4 * d5 * this.samples[i].z)) / (d * Math.sqrt((d13 + d14 + d * d * d5 * d5 * this.samples[i].y * this.samples[i].y + d * d * d6 * d6 * this.samples[i].y * this.samples[i].y - 2.0 * d * d * d4 * d5 * this.samples[i].y * this.samples[i].z + d * d * d4 * d4 * this.samples[i].z * this.samples[i].z - 2.0 * d3 * d4 * this.samples[i].x * (d2 * d5 * this.samples[i].x - d * d5 * this.samples[i].y + d * d4 * this.samples[i].z) - 2.0 * d * d2 * this.samples[i].x * (d5 * d5 * this.samples[i].y + d6 * d6 * this.samples[i].y - d4 * d5 * this.samples[i].z)) / (d * d * d4 * d4 * d6 * d6)) * d16);
            dArray2[1] = dArray2[1] - dArray3[1] / this.gi[i];
            dArray3[2] = -1.5 * this.samples[i].x * (-(d3 * d4 * d5 * this.samples[i].x) + d2 * (d5 * d5 + d6 * d6) * this.samples[i].x - d * (d5 * d5 * this.samples[i].y + d6 * d6 * this.samples[i].y - d4 * d5 * this.samples[i].z)) / (Math.pow(d * d * d4 * d4 * d6 * d6, 1.5) * d15);
            dArray2[2] = dArray2[2] - dArray3[2] / this.gi[i];
            dArray3[3] = -1.5 * d4 * this.samples[i].x * (d3 * d4 * this.samples[i].x - d2 * d5 * this.samples[i].x + d * d5 * this.samples[i].y - d * d4 * this.samples[i].z) / (Math.pow(d * d * d4 * d4 * d6 * d6, 1.5) * d15);
            dArray2[3] = dArray2[3] - dArray3[3] / this.gi[i];
            dArray3[4] = Math.sqrt(d * d * d4 * d4 * d6 * d6) * (-0.5 * d3 * d3 * d4 * d4 * this.samples[i].x * this.samples[i].x - 0.5 * d4 * d4 * d6 * d6 * this.samples[i].x * this.samples[i].x + d14 + d * d * d5 * d5 * this.samples[i].y * this.samples[i].y + d * d * d6 * d6 * this.samples[i].y * this.samples[i].y - 0.5 * d * d * d4 * d5 * this.samples[i].y * this.samples[i].z - 0.5 * d * d * d4 * d4 * this.samples[i].z * this.samples[i].z + d3 * d4 * this.samples[i].x * (-0.5 * d2 * d5 * this.samples[i].x + 0.5 * d * d5 * this.samples[i].y + d * d4 * this.samples[i].z) + d * d2 * this.samples[i].x * (-2.0 * d5 * d5 * this.samples[i].y - 2.0 * d6 * d6 * this.samples[i].y + 0.5 * d4 * d5 * this.samples[i].z)) / (d4 * Math.sqrt((d13 + d14 + d * d * d5 * d5 * this.samples[i].y * this.samples[i].y + d * d * d6 * d6 * this.samples[i].y * this.samples[i].y - 2.0 * d * d * d4 * d5 * this.samples[i].y * this.samples[i].z + d * d * d4 * d4 * this.samples[i].z * this.samples[i].z - 2.0 * d3 * d4 * this.samples[i].x * (d2 * d5 * this.samples[i].x - d * d5 * this.samples[i].y + d * d4 * this.samples[i].z) - 2.0 * d * d2 * this.samples[i].x * (d5 * d5 * this.samples[i].y + d6 * d6 * this.samples[i].y - d4 * d5 * this.samples[i].z)) / (d * d * d4 * d4 * d6 * d6)) * d16);
            dArray2[4] = dArray2[4] - dArray3[4] / this.gi[i];
            dArray3[5] = -1.5 * (d2 * this.samples[i].x - d * this.samples[i].y) * (-(d3 * d4 * this.samples[i].x) + d2 * d5 * this.samples[i].x - d * d5 * this.samples[i].y + d * d4 * this.samples[i].z) / (Math.pow(d * d * d4 * d4 * d6 * d6, 1.5) * d15);
            dArray2[5] = dArray2[5] - dArray3[5] / this.gi[i];
            dArray3[6] = Math.sqrt(d * d * d4 * d4 * d6 * d6) * (d3 * d3 * d4 * d4 * this.samples[i].x * this.samples[i].x - 0.5 * d4 * d4 * d6 * d6 * this.samples[i].x * this.samples[i].x + d2 * d2 * (d5 * d5 - 0.5 * d6 * d6) * this.samples[i].x * this.samples[i].x + d * d * d5 * d5 * this.samples[i].y * this.samples[i].y - 0.5 * d * d * d6 * d6 * this.samples[i].y * this.samples[i].y - 2.0 * d * d * d4 * d5 * this.samples[i].y * this.samples[i].z + d * d * d4 * d4 * this.samples[i].z * this.samples[i].z + d3 * d4 * this.samples[i].x * (-2.0 * d2 * d5 * this.samples[i].x + 2.0 * d * d5 * this.samples[i].y - 2.0 * d * d4 * this.samples[i].z) + d * d2 * this.samples[i].x * (-2.0 * d5 * d5 * this.samples[i].y + d6 * d6 * this.samples[i].y + 2.0 * d4 * d5 * this.samples[i].z)) / (d6 * Math.sqrt((d13 + d14 + d * d * d5 * d5 * this.samples[i].y * this.samples[i].y + d * d * d6 * d6 * this.samples[i].y * this.samples[i].y - 2.0 * d * d * d4 * d5 * this.samples[i].y * this.samples[i].z + d * d * d4 * d4 * this.samples[i].z * this.samples[i].z - 2.0 * d3 * d4 * this.samples[i].x * (d2 * d5 * this.samples[i].x - d * d5 * this.samples[i].y + d * d4 * this.samples[i].z) - 2.0 * d * d2 * this.samples[i].x * (d5 * d5 * this.samples[i].y + d6 * d6 * this.samples[i].y - d4 * d5 * this.samples[i].z)) / (d * d * d4 * d4 * d6 * d6)) * d16);
            dArray2[6] = dArray2[6] - dArray3[6] / this.gi[i];
            dArray3[7] = Math.sqrt(d7 * d7 * d10 * d10 * d12 * d12) * (d9 * d9 * d10 * d10 * this.samples[i].x * this.samples[i].x + d10 * d10 * d12 * d12 * this.samples[i].x * this.samples[i].x + d8 * d8 * (d11 * d11 + d12 * d12) * this.samples[i].x * this.samples[i].x - 0.5 * d7 * d7 * d11 * d11 * this.samples[i].y * this.samples[i].y - 0.5 * d7 * d7 * d12 * d12 * this.samples[i].y * this.samples[i].y + d7 * d7 * d10 * d11 * this.samples[i].y * this.samples[i].z - 0.5 * d7 * d7 * d10 * d10 * this.samples[i].z * this.samples[i].z + d9 * d10 * this.samples[i].x * (-2.0 * d8 * d11 * this.samples[i].x + 0.5 * d7 * d11 * this.samples[i].y - 0.5 * d7 * d10 * this.samples[i].z) + d7 * d8 * this.samples[i].x * (-0.5 * d11 * d11 * this.samples[i].y - 0.5 * d12 * d12 * this.samples[i].y + 0.5 * d10 * d11 * this.samples[i].z)) / (d7 * Math.sqrt((d9 * d9 * d10 * d10 * this.samples[i].x * this.samples[i].x + d10 * d10 * d12 * d12 * this.samples[i].x * this.samples[i].x + d8 * d8 * (d11 * d11 + d12 * d12) * this.samples[i].x * this.samples[i].x + d7 * d7 * d11 * d11 * this.samples[i].y * this.samples[i].y + d7 * d7 * d12 * d12 * this.samples[i].y * this.samples[i].y - 2.0 * d7 * d7 * d10 * d11 * this.samples[i].y * this.samples[i].z + d7 * d7 * d10 * d10 * this.samples[i].z * this.samples[i].z - 2.0 * d9 * d10 * this.samples[i].x * (d8 * d11 * this.samples[i].x - d7 * d11 * this.samples[i].y + d7 * d10 * this.samples[i].z) - 2.0 * d7 * d8 * this.samples[i].x * (d11 * d11 * this.samples[i].y + d12 * d12 * this.samples[i].y - d10 * d11 * this.samples[i].z)) / (d7 * d7 * d10 * d10 * d12 * d12)) * d17);
            dArray2[7] = dArray2[7] - dArray3[7] / this.gi[i];
            dArray3[8] = -1.5 * this.samples[i].x * (-(d9 * d10 * d11 * this.samples[i].x) + d8 * (d11 * d11 + d12 * d12) * this.samples[i].x - d7 * (d11 * d11 * this.samples[i].y + d12 * d12 * this.samples[i].y - d10 * d11 * this.samples[i].z)) / (Math.pow(d7 * d7 * d10 * d10 * d12 * d12, 1.5) * Math.pow((d9 * d9 * d10 * d10 * this.samples[i].x * this.samples[i].x + d10 * d10 * d12 * d12 * this.samples[i].x * this.samples[i].x + d8 * d8 * (d11 * d11 + d12 * d12) * this.samples[i].x * this.samples[i].x + d7 * d7 * d11 * d11 * this.samples[i].y * this.samples[i].y + d7 * d7 * d12 * d12 * this.samples[i].y * this.samples[i].y - 2.0 * d7 * d7 * d10 * d11 * this.samples[i].y * this.samples[i].z + d7 * d7 * d10 * d10 * this.samples[i].z * this.samples[i].z - 2.0 * d9 * d10 * this.samples[i].x * (d8 * d11 * this.samples[i].x - d7 * d11 * this.samples[i].y + d7 * d10 * this.samples[i].z) - 2.0 * d7 * d8 * this.samples[i].x * (d11 * d11 * this.samples[i].y + d12 * d12 * this.samples[i].y - d10 * d11 * this.samples[i].z)) / (d7 * d7 * d10 * d10 * d12 * d12), 2.5));
            dArray2[8] = dArray2[8] - dArray3[8] / this.gi[i];
            dArray3[9] = -1.5 * d10 * this.samples[i].x * (d9 * d10 * this.samples[i].x - d8 * d11 * this.samples[i].x + d7 * d11 * this.samples[i].y - d7 * d10 * this.samples[i].z) / (Math.pow(d7 * d7 * d10 * d10 * d12 * d12, 1.5) * Math.pow((d9 * d9 * d10 * d10 * this.samples[i].x * this.samples[i].x + d10 * d10 * d12 * d12 * this.samples[i].x * this.samples[i].x + d8 * d8 * (d11 * d11 + d12 * d12) * this.samples[i].x * this.samples[i].x + d7 * d7 * d11 * d11 * this.samples[i].y * this.samples[i].y + d7 * d7 * d12 * d12 * this.samples[i].y * this.samples[i].y - 2.0 * d7 * d7 * d10 * d11 * this.samples[i].y * this.samples[i].z + d7 * d7 * d10 * d10 * this.samples[i].z * this.samples[i].z - 2.0 * d9 * d10 * this.samples[i].x * (d8 * d11 * this.samples[i].x - d7 * d11 * this.samples[i].y + d7 * d10 * this.samples[i].z) - 2.0 * d7 * d8 * this.samples[i].x * (d11 * d11 * this.samples[i].y + d12 * d12 * this.samples[i].y - d10 * d11 * this.samples[i].z)) / (d7 * d7 * d10 * d10 * d12 * d12), 2.5));
            dArray2[9] = dArray2[9] - dArray3[9] / this.gi[i];
            dArray3[10] = Math.sqrt(d7 * d7 * d10 * d10 * d12 * d12) * (-0.5 * d9 * d9 * d10 * d10 * this.samples[i].x * this.samples[i].x - 0.5 * d10 * d10 * d12 * d12 * this.samples[i].x * this.samples[i].x + d8 * d8 * (d11 * d11 + d12 * d12) * this.samples[i].x * this.samples[i].x + d7 * d7 * d11 * d11 * this.samples[i].y * this.samples[i].y + d7 * d7 * d12 * d12 * this.samples[i].y * this.samples[i].y - 0.5 * d7 * d7 * d10 * d11 * this.samples[i].y * this.samples[i].z - 0.5 * d7 * d7 * d10 * d10 * this.samples[i].z * this.samples[i].z + d9 * d10 * this.samples[i].x * (-0.5 * d8 * d11 * this.samples[i].x + 0.5 * d7 * d11 * this.samples[i].y + d7 * d10 * this.samples[i].z) + d7 * d8 * this.samples[i].x * (-2.0 * d11 * d11 * this.samples[i].y - 2.0 * d12 * d12 * this.samples[i].y + 0.5 * d10 * d11 * this.samples[i].z)) / (d10 * Math.sqrt((d9 * d9 * d10 * d10 * this.samples[i].x * this.samples[i].x + d10 * d10 * d12 * d12 * this.samples[i].x * this.samples[i].x + d8 * d8 * (d11 * d11 + d12 * d12) * this.samples[i].x * this.samples[i].x + d7 * d7 * d11 * d11 * this.samples[i].y * this.samples[i].y + d7 * d7 * d12 * d12 * this.samples[i].y * this.samples[i].y - 2.0 * d7 * d7 * d10 * d11 * this.samples[i].y * this.samples[i].z + d7 * d7 * d10 * d10 * this.samples[i].z * this.samples[i].z - 2.0 * d9 * d10 * this.samples[i].x * (d8 * d11 * this.samples[i].x - d7 * d11 * this.samples[i].y + d7 * d10 * this.samples[i].z) - 2.0 * d7 * d8 * this.samples[i].x * (d11 * d11 * this.samples[i].y + d12 * d12 * this.samples[i].y - d10 * d11 * this.samples[i].z)) / (d7 * d7 * d10 * d10 * d12 * d12)) * d17);
            dArray2[10] = dArray2[10] - dArray3[10] / this.gi[i];
            dArray3[11] = -1.5 * (d8 * this.samples[i].x - d7 * this.samples[i].y) * (-(d9 * d10 * this.samples[i].x) + d8 * d11 * this.samples[i].x - d7 * d11 * this.samples[i].y + d7 * d10 * this.samples[i].z) / (Math.pow(d7 * d7 * d10 * d10 * d12 * d12, 1.5) * Math.pow((d9 * d9 * d10 * d10 * this.samples[i].x * this.samples[i].x + d10 * d10 * d12 * d12 * this.samples[i].x * this.samples[i].x + d8 * d8 * (d11 * d11 + d12 * d12) * this.samples[i].x * this.samples[i].x + d7 * d7 * d11 * d11 * this.samples[i].y * this.samples[i].y + d7 * d7 * d12 * d12 * this.samples[i].y * this.samples[i].y - 2.0 * d7 * d7 * d10 * d11 * this.samples[i].y * this.samples[i].z + d7 * d7 * d10 * d10 * this.samples[i].z * this.samples[i].z - 2.0 * d9 * d10 * this.samples[i].x * (d8 * d11 * this.samples[i].x - d7 * d11 * this.samples[i].y + d7 * d10 * this.samples[i].z) - 2.0 * d7 * d8 * this.samples[i].x * (d11 * d11 * this.samples[i].y + d12 * d12 * this.samples[i].y - d10 * d11 * this.samples[i].z)) / (d7 * d7 * d10 * d10 * d12 * d12), 2.5));
            dArray2[11] = dArray2[11] - dArray3[11] / this.gi[i];
            dArray3[12] = Math.sqrt(d7 * d7 * d10 * d10 * d12 * d12) * (d9 * d9 * d10 * d10 * this.samples[i].x * this.samples[i].x - 0.5 * d10 * d10 * d12 * d12 * this.samples[i].x * this.samples[i].x + d8 * d8 * (d11 * d11 - 0.5 * d12 * d12) * this.samples[i].x * this.samples[i].x + d7 * d7 * d11 * d11 * this.samples[i].y * this.samples[i].y - 0.5 * d7 * d7 * d12 * d12 * this.samples[i].y * this.samples[i].y - 2.0 * d7 * d7 * d10 * d11 * this.samples[i].y * this.samples[i].z + d7 * d7 * d10 * d10 * this.samples[i].z * this.samples[i].z + d9 * d10 * this.samples[i].x * (-2.0 * d8 * d11 * this.samples[i].x + 2.0 * d7 * d11 * this.samples[i].y - 2.0 * d7 * d10 * this.samples[i].z) + d7 * d8 * this.samples[i].x * (-2.0 * d11 * d11 * this.samples[i].y + d12 * d12 * this.samples[i].y + 2.0 * d10 * d11 * this.samples[i].z)) / (d12 * Math.sqrt((d9 * d9 * d10 * d10 * this.samples[i].x * this.samples[i].x + d10 * d10 * d12 * d12 * this.samples[i].x * this.samples[i].x + d8 * d8 * (d11 * d11 + d12 * d12) * this.samples[i].x * this.samples[i].x + d7 * d7 * d11 * d11 * this.samples[i].y * this.samples[i].y + d7 * d7 * d12 * d12 * this.samples[i].y * this.samples[i].y - 2.0 * d7 * d7 * d10 * d11 * this.samples[i].y * this.samples[i].z + d7 * d7 * d10 * d10 * this.samples[i].z * this.samples[i].z - 2.0 * d9 * d10 * this.samples[i].x * (d8 * d11 * this.samples[i].x - d7 * d11 * this.samples[i].y + d7 * d10 * this.samples[i].z) - 2.0 * d7 * d8 * this.samples[i].x * (d11 * d11 * this.samples[i].y + d12 * d12 * this.samples[i].y - d10 * d11 * this.samples[i].z)) / (d7 * d7 * d10 * d10 * d12 * d12)) * d17);
            dArray2[12] = dArray2[12] - dArray3[12] / this.gi[i];
        }
        return dArray2;
    }
}

