/*
 * Decompiled with CFR 0.152.
 */
package numerics;

import numerics.GammaFunctions;
import numerics.IncompleteBetaException;

public class IncompleteBeta {
    public static double betai(double d, double d2, double d3) throws IncompleteBetaException {
        if (d3 < 0.0 || d3 > 1.0) {
            throw new IncompleteBetaException("Invalid x in IncompleteBeta.betai." + d3 + " " + d + " " + d2);
        }
        double d4 = d3 == 0.0 || d3 == 1.0 ? 0.0 : Math.exp(GammaFunctions.gammln(d + d2) - GammaFunctions.gammln(d) - GammaFunctions.gammln(d2) + d * Math.log(d3) + d2 * Math.log(1.0 - d3));
        if (d3 < (d + 1.0) / (d + d2 + 2.0)) {
            return d4 * IncompleteBeta.betacf(d, d2, d3) / d;
        }
        return 1.0 - d4 * IncompleteBeta.betacf(d2, d, 1.0 - d3) / d2;
    }

    public static double betacf(double d, double d2, double d3) throws IncompleteBetaException {
        int n;
        int n2 = 100;
        double d4 = 3.0E-7;
        double d5 = 1.0E-30;
        double d6 = d + d2;
        double d7 = d + 1.0;
        double d8 = d - 1.0;
        double d9 = 1.0;
        double d10 = 1.0 - d6 * d3 / d7;
        if (Math.abs(d10) < d5) {
            d10 = d5;
        }
        double d11 = d10 = 1.0 / d10;
        for (n = 1; n <= n2; ++n) {
            int n3 = 2 * n;
            double d12 = (double)n * (d2 - (double)n) * d3 / ((d8 + (double)n3) * (d + (double)n3));
            if (Math.abs(d10 = 1.0 + d12 * d10) < d5) {
                d10 = d5;
            }
            if (Math.abs(d9 = 1.0 + d12 / d9) < d5) {
                d9 = d5;
            }
            d10 = 1.0 / d10;
            d11 *= d10 * d9;
            d12 = -(d + (double)n) * (d6 + (double)n) * d3 / ((d + (double)n3) * (d7 + (double)n3));
            if (Math.abs(d10 = 1.0 + d12 * d10) < d5) {
                d10 = d5;
            }
            if (Math.abs(d9 = 1.0 + d12 / d9) < d5) {
                d9 = d5;
            }
            d10 = 1.0 / d10;
            double d13 = d10 * d9;
            d11 *= d13;
            if (Math.abs(d13 - 1.0) < d4) break;
        }
        if (n > n2) {
            throw new IncompleteBetaException("a or b too big, or MAXIT too small in betacf");
        }
        return d11;
    }
}

