/*
 * Decompiled with CFR 0.152.
 */
package numerics;

import Jama.EigenvalueDecomposition;
import java.text.DecimalFormat;
import numerics.RealMatrix;
import numerics.Vector3D;

public class EigenSystem3D {
    private static DecimalFormat df = new DecimalFormat("0.00000E00");
    public final Vector3D[] eigenvectors;
    public final double[] eigenvalues;

    public EigenSystem3D(Vector3D[] vector3DArray, double[] dArray) {
        if (vector3DArray.length != 3 || vector3DArray.length != dArray.length) {
            throw new IllegalArgumentException("Number of eigenvalues must match number of eigenvectors");
        }
        this.eigenvectors = vector3DArray;
        this.eigenvalues = dArray;
    }

    public EigenSystem3D(double[][] dArray) {
        this.eigenvectors = new Vector3D[3];
        this.eigenvalues = new double[3];
        this.eigenvectors[0] = new Vector3D(dArray[1][0], dArray[2][0], dArray[3][0]);
        this.eigenvectors[1] = new Vector3D(dArray[1][1], dArray[2][1], dArray[3][1]);
        this.eigenvectors[2] = new Vector3D(dArray[1][2], dArray[2][2], dArray[3][2]);
        this.eigenvalues[0] = dArray[0][0];
        this.eigenvalues[1] = dArray[0][1];
        this.eigenvalues[2] = dArray[0][2];
    }

    public static EigenSystem3D sort(EigenvalueDecomposition eigenvalueDecomposition) {
        int n;
        double[][] dArray = eigenvalueDecomposition.getV().getArray();
        double[] dArray2 = eigenvalueDecomposition.getRealEigenvalues();
        if (dArray2.length != 3) {
            throw new IllegalArgumentException("eig is not from a 3x3 matrix");
        }
        int n2 = 0;
        int n3 = 0;
        for (n = 1; n < 3; ++n) {
            if (dArray2[n] >= dArray2[n3]) {
                n3 = n;
            }
            if (!(dArray2[n] < dArray2[n2])) continue;
            n2 = n;
        }
        n = 3 - n2 - n3;
        Vector3D[] vector3DArray = new Vector3D[3];
        double[] dArray3 = new double[]{dArray2[n3], dArray2[n], dArray2[n2]};
        vector3DArray[0] = new Vector3D(dArray[0][n3], dArray[1][n3], dArray[2][n3]);
        vector3DArray[1] = new Vector3D(dArray[0][n], dArray[1][n], dArray[2][n]);
        vector3DArray[2] = new Vector3D(dArray[0][n2], dArray[1][n2], dArray[2][n2]);
        return new EigenSystem3D(vector3DArray, dArray3);
    }

    public static EigenSystem3D sort(RealMatrix realMatrix) {
        int n;
        if (realMatrix.rows() != 3 || realMatrix.columns() != 3) {
            throw new IllegalArgumentException("Method requires 3x3 matrix");
        }
        RealMatrix[] realMatrixArray = realMatrix.jacobi();
        int n2 = 0;
        int n3 = 0;
        for (n = 1; n < 3; ++n) {
            if (realMatrixArray[0].entries[n][n] >= realMatrixArray[0].entries[n3][n3]) {
                n3 = n;
            }
            if (!(realMatrixArray[0].entries[n][n] < realMatrixArray[0].entries[n2][n2])) continue;
            n2 = n;
        }
        n = 3 - n2 - n3;
        Vector3D[] vector3DArray = new Vector3D[3];
        double[] dArray = new double[3];
        vector3DArray[0] = new Vector3D(realMatrixArray[1].entries[0][n3], realMatrixArray[1].entries[1][n3], realMatrixArray[1].entries[2][n3]);
        vector3DArray[1] = new Vector3D(realMatrixArray[1].entries[0][n], realMatrixArray[1].entries[1][n], realMatrixArray[1].entries[2][n]);
        vector3DArray[2] = new Vector3D(realMatrixArray[1].entries[0][n2], realMatrixArray[1].entries[1][n2], realMatrixArray[1].entries[2][n2]);
        dArray[0] = realMatrixArray[0].entries[n3][n3];
        dArray[1] = realMatrixArray[0].entries[n][n];
        dArray[2] = realMatrixArray[0].entries[n2][n2];
        return new EigenSystem3D(vector3DArray, dArray);
    }

    public String toString() {
        String string = "";
        for (int i = 0; i < 3; ++i) {
            string = string + df.format(this.eigenvalues[i]) + " " + df.format(this.eigenvectors[i].x) + " " + df.format(this.eigenvectors[i].y) + " " + df.format(this.eigenvectors[i].z);
            string = string + "\n";
        }
        return string;
    }
}

