/*
 * Decompiled with CFR 0.152.
 */
package numerics;

import java.text.DecimalFormat;
import java.util.Random;
import misc.LoggedException;
import numerics.BinghamDistribution;
import numerics.ConvergenceException;
import numerics.EigenSystem3D;
import numerics.SphericalDistributionFitter;

public class BinghamFitter
extends SphericalDistributionFitter {
    private static final int c__9 = 9;
    private static final int c__1 = 1;
    private static final int c__3 = 3;
    private static final int c__5 = 5;
    private static final double c_b28 = 8.0;

    private BinghamFitter() {
    }

    public static BinghamDistribution getBinghamDistribution(EigenSystem3D eigenSystem3D) throws ConvergenceException {
        return BinghamFitter.getBinghamDistribution(eigenSystem3D, new Random());
    }

    public static BinghamDistribution getBinghamDistribution(EigenSystem3D eigenSystem3D, Random random) throws ConvergenceException {
        double d = eigenSystem3D.eigenvalues[1];
        double d2 = eigenSystem3D.eigenvalues[2];
        double[] dArray = BinghamFitter.bngpar(d, d2);
        return new BinghamDistribution(eigenSystem3D.eigenvectors, dArray[0], dArray[1], dArray[2], random);
    }

    public static double[] bngpar(double d, double d2) throws ConvergenceException {
        double[] dArray = new double[4];
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n = 0;
        double d6 = 0.0;
        int n2 = 0;
        int[] nArray = new int[1];
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[4];
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 1.0E-15;
        if (d2 < 0.0 && d2 > -d9 && d < (d2 = d9)) {
            d = d2;
        }
        if (!(d2 <= d && d2 > 0.0 && d2 + d * 2.0 <= 1.0)) {
            throw new LoggedException("Can't use t1 == " + d2 + " and t2 == " + d + " to calculate A");
        }
        if (d <= 0.04) {
            n = 3;
            d7 = -1.0 / (d2 * 2.0);
            d8 = -1.0 / (d * 2.0);
        } else if (d2 <= 0.04 && d / d2 >= 3.0) {
            n = 2;
            d8 = 0.5 - d <= 0.35 ? (1.0 - d * 2.0) * -2.0 : -1.0 / (0.5 - d);
            d7 = -1.0 / (d2 * 2.0);
        } else {
            n = 1;
            d7 = 0.0;
            d8 = 0.0;
        }
        for (n2 = 1; n2 <= 20; ++n2) {
            double d10 = d7;
            double d11 = d8;
            nArray[0] = 8;
            d5 = BinghamFitter.bingc(d7, d8, dArray2, dArray3, n, nArray);
            double d12 = dArray2[0] - d2;
            double d13 = dArray2[1] - d;
            BinghamFitter.inv(dArray3, dArray);
            d7 = d10 - dArray[0] * d12 - dArray[2] * d13;
            d8 = d11 - dArray[1] * d12 - dArray[3] * d13;
            if (d8 > 0.0) {
                d8 = 0.0;
            }
            if (d7 > d8) {
                d7 = d8;
            }
            d3 = d7 - d10;
            d4 = d8 - d11;
            d6 = Math.abs(d3) / (1.0 - d7) + Math.abs(d4) / (1.0 - d8);
            if (!(d6 < 1.0E-7)) continue;
            return new double[]{d7, d8, d5 / (Math.PI * 4)};
        }
        throw new ConvergenceException("bngpar couldn't converge");
    }

    public static double bingc(double d, double d2) throws ConvergenceException {
        if (d2 > 0.0 || d > d2) {
            throw new IllegalArgumentException("Illegal concentration parameters {ak1, ak2} = {" + d + ", " + d2 + "}");
        }
        double[] dArray = new double[2];
        double[] dArray2 = new double[4];
        int[] nArray = new int[]{8};
        int n = 0;
        if (d2 < -8.5) {
            n = 3;
        } else {
            n = 1;
            if (d <= -10.0 && d / d2 >= 2.0) {
                n = 2;
            }
        }
        return BinghamFitter.bingc(d, d2, dArray, dArray2, n, nArray) / (Math.PI * 4);
    }

    public static double bingc(double d, double d2, double[] dArray, double[] dArray2) throws ConvergenceException {
        int[] nArray = new int[]{8};
        int n = 0;
        if (d2 < -8.5) {
            n = 3;
        } else {
            n = 1;
            if (d <= -10.0 && d / d2 >= 2.0) {
                n = 2;
            }
        }
        double d3 = BinghamFitter.bingc(d, d2, dArray, dArray2, n, nArray);
        dArray[0] = dArray[0] / (Math.PI * 4);
        dArray[1] = dArray[1] / (Math.PI * 4);
        dArray2[0] = dArray2[0] / (Math.PI * 4);
        dArray2[1] = dArray2[1] / (Math.PI * 4);
        dArray2[2] = dArray2[2] / (Math.PI * 4);
        dArray2[3] = dArray2[3] / (Math.PI * 4);
        return d3 / (Math.PI * 4);
    }

    private static double bingc(double d, double d2, double[] dArray, double[] dArray2, int n, int[] nArray) throws ConvergenceException {
        int n2;
        boolean bl = false;
        double d3 = 0.0;
        double[] dArray3 = new double[10];
        double[] dArray4 = new double[8];
        double[] dArray5 = new double[8];
        double[] dArray6 = new double[9];
        double[] dArray7 = new double[9];
        double[] dArray8 = new double[9];
        double[] dArray9 = new double[9];
        double[] dArray10 = new double[9];
        int n3 = 0;
        int n4 = 0;
        double d4 = 1.0E-6;
        if (d > d2 || d2 > 0.0) {
            boolean bl2 = true;
            return d3;
        }
        if (!bl) {
            bl = true;
            dArray6[0] = 1.0;
            for (n2 = 1; n2 <= 8; ++n2) {
                dArray6[n2] = dArray6[n2 - 1] * ((double)n2 * 2.0 - 1.0);
            }
        }
        if (n == 1) {
            double d5 = -d;
            double d6 = -d + d2;
            double d7 = Math.exp(d5);
            double d8 = d5;
            for (n2 = 2; n2 <= 100; ++n2) {
                d8 = d8 * d5 / (double)n2;
                if (!((double)n2 > d5) || !(d8 / d7 < d4)) continue;
                n3 = n2;
                break;
            }
            if (n2 == 101) {
                throw new ConvergenceException("L61: Normalization constant couldn't converge");
            }
            double d9 = Math.exp(d6);
            double d10 = d6;
            for (n2 = 2; n2 <= 100; ++n2) {
                d10 = d10 * d6 / (double)n2;
                if (!((double)n2 > d6) || !(d10 / d9 < d4)) continue;
                n4 = n2;
                break;
            }
            if (n2 == 101) {
                throw new ConvergenceException("L63: Normalization constant couldn't converge");
            }
            double d11 = 12.566370616;
            d3 = 0.0;
            double d12 = 0.0;
            double d13 = 0.0;
            double d14 = 0.0;
            double d15 = 0.0;
            double d16 = 0.0;
            if (Math.abs(d5) < 1.0E-15) {
                d5 = 1.0E-15;
            }
            if (Math.abs(d6) < 1.0E-15) {
                d6 = 1.0E-15;
            }
            int n5 = n3;
            for (n2 = 0; n2 <= n5; ++n2) {
                double d17;
                if (n2 >= 1) {
                    d11 = d11 * ((double)n2 - 0.5) / ((double)n2 + 0.5) / (double)n2 * d5;
                }
                double d18 = d17 = d11;
                d12 += d17 * (double)n2 / d5;
                d14 += d17 * (double)n2 * (double)(n2 - 1) / d5 / d5;
                int n6 = n4;
                for (int i = 1; i <= n6; ++i) {
                    d17 = d17 * ((double)i - 0.5) / (((double)(n2 + i) + 0.5) * (double)i) * d6;
                    d12 += d17 * (double)n2 / d5;
                    d13 += d17 * (double)i / d6;
                    d14 += d17 * (double)n2 * (double)(n2 - 1) / d5 / d5;
                    d15 += d17 * (double)n2 * (double)i / d5 / d6;
                    d16 += d17 * (double)i * (double)(i - 1) / d6 / d6;
                    d18 += d17;
                    if (d17 < 1.0E-16 && i >= 2) break;
                }
                d3 += d18;
                if (d18 < 1.0E-16 && n2 >= 2) break;
            }
            nArray[0] = n3 > n4 ? n3 : n4;
            dArray[0] = 1.0 - (d12 + d13) / d3;
            dArray[1] = d13 / d3;
            double d19 = d3 * d3;
            d14 = d14 / d3 - d12 * d12 / d19;
            d15 = d15 / d3 - d12 * d13 / d19;
            d16 = d16 / d3 - d13 * d13 / d19;
            dArray2[0] = d14 + d15 * 2.0 + d16;
            dArray2[2] = -d15 - d16;
            dArray2[1] = dArray2[2];
            dArray2[3] = d16;
            return d3 *= Math.exp(d);
        }
        if (n == 2) {
            double d20 = d2 - d * 2.0;
            double d21 = -d2 / 2.0;
            if (d20 <= 0.001) {
                d3 = 15.74960995;
                dArray[0] = 3.0;
                dArray[1] = 1.0;
                dArray2[0] = 1.0;
                dArray2[2] = 0.0;
                dArray2[1] = 0.0;
                dArray2[3] = 1.0;
                return d3;
            }
            double d22 = d21 * d21 / 4.0;
            double d23 = BinghamFitter.bstrs0(d22);
            dArray3[9] = BinghamFitter.besrat(8.0, d21, d4);
            for (n2 = 8; n2 >= 1; --n2) {
                dArray3[n2] = d21 / (d21 * dArray3[n2 + 1] + (double)(n2 << 1));
            }
            for (n2 = 2; n2 <= 9; ++n2) {
                if (dArray3[n2 - 1] < 1.0E-15) {
                    dArray3[n2 - 1] = 0.0;
                }
                dArray3[n2] = dArray3[n2 - 1] * dArray3[n2];
            }
            dArray3[0] = 1.0;
            dArray8[0] = dArray3[1];
            for (n2 = 0; n2 <= 8; ++n2) {
                dArray7[n2] = 0.0;
                dArray10[n2] = 0.0;
            }
            dArray10[0] = 1.0;
            double d24 = 1.0;
            double d25 = 1.0;
            double d26 = dArray8[0];
            double d27 = 0.0;
            if (nArray[0] != 0) {
                int n7 = nArray[0];
                for (int i = 1; i <= n7; ++i) {
                    int n8 = i;
                    int n9 = n8 - 1;
                    for (n2 = 0; n2 <= n9; ++n2) {
                        dArray7[n2] = dArray10[n2];
                    }
                    if (n8 == 1) {
                        dArray10[0] = 0.0;
                        dArray10[1] = 1.0;
                    }
                    if (n8 == 2) {
                        dArray10[0] = 0.5;
                        dArray10[1] = 0.0;
                        dArray10[2] = 0.5;
                    }
                    if (n8 > 2) {
                        dArray10[0] = dArray7[1] / 2.0;
                        dArray10[1] = dArray7[0] + dArray7[2] / 2.0;
                        dArray10[n8 - 1] = dArray7[n8 - 2] / 2.0;
                        dArray10[n8] = dArray7[n8 - 1] / 2.0;
                    }
                    if (n8 > 3) {
                        n9 = n8 - 2;
                        for (n2 = 2; n2 <= n9; ++n2) {
                            dArray10[n2] = (dArray7[n2 - 1] + dArray7[n2 + 1]) / 2.0;
                        }
                    }
                    dArray4[n8 - 1] = 0.0;
                    dArray8[n8] = 0.0;
                    n9 = n8;
                    for (n2 = 0; n2 <= n9; ++n2) {
                        if (n2 == 0) {
                            int n10 = n8;
                            dArray8[n10] = dArray8[n10] + dArray10[0] * dArray3[1];
                        } else {
                            int n11 = n8;
                            dArray8[n11] = dArray8[n11] + dArray10[n2] * (dArray3[n2 - 1] + dArray3[n2 + 1]) / 2.0;
                        }
                        int n12 = n8 - 1;
                        dArray4[n12] = dArray4[n12] + dArray10[n2] * dArray3[n2];
                    }
                    d25 = i == 1 ? d25 * (-1.0 / d20) / (double)i : d25 * (-d21 / d20) / (double)i;
                    double d28 = d25 * d21;
                    d26 += dArray6[i] * (dArray4[i - 1] * d25 * (double)i + dArray8[i] * d28);
                    d27 -= (double)i * dArray6[i] * dArray4[i - 1] * d28 / d20;
                    double d29 = dArray6[i] * dArray4[i - 1] * d28;
                    if (Math.abs(d29) / (d24 += d29) < 1.0E-15) break;
                }
            }
            d3 = 15.74960995 / Math.sqrt(d20) * d23 * d24;
            double d30 = -0.5 / d20 + d27 / d24;
            double d31 = d26 / d24 - 1.0;
            dArray[0] = d30 * -2.0;
            dArray[1] = d30 - d31 * 0.5;
            dArray2[0] = 1.0 / (d * 2.0 * d);
            dArray2[2] = 0.0;
            dArray2[1] = dArray2[2];
            dArray2[3] = (dArray3[2] * 0.5 + 0.5 - dArray3[1] * dArray3[1]) / 4.0;
            return d3;
        }
        if (n == 3) {
            double d32 = d2 * -2.0;
            if (d32 == 0.0) {
                d3 = 1.0;
                dArray[0] = 1.0;
                dArray[1] = 1.0;
                dArray2[0] = 1.0;
                dArray2[2] = 0.0;
                dArray2[1] = 0.0;
                dArray2[3] = 1.0;
                return d3;
            }
            double d33 = d2 / d;
            for (n2 = 0; n2 <= 8; ++n2) {
                dArray10[n2] = 0.0;
                dArray7[n2] = 0.0;
            }
            dArray10[0] = 1.0;
            double d34 = 1.0;
            double d35 = 1.0;
            double d36 = 1.0;
            double d37 = 0.0;
            double d38 = 0.0;
            if (nArray[0] != 0) {
                int n13 = nArray[0];
                for (int i = 1; i <= n13; ++i) {
                    int n14 = i;
                    int n15 = n14 - 1;
                    for (n2 = 0; n2 <= n15; ++n2) {
                        dArray7[n2] = dArray10[n2];
                    }
                    dArray10[0] = dArray7[0];
                    dArray10[n14] = dArray7[n14 - 1];
                    if (n14 >= 2) {
                        n15 = n14 - 1;
                        for (n2 = 1; n2 <= n15; ++n2) {
                            dArray10[n2] = dArray7[n2 - 1] + dArray7[n2];
                        }
                    }
                    dArray5[n14 - 1] = 0.0;
                    dArray9[n14] = 0.0;
                    n15 = n14;
                    for (n2 = 0; n2 <= n15; ++n2) {
                        if (n2 > 0) {
                            int n16 = n2 - 1;
                            int n17 = n14;
                            dArray9[n17] = dArray9[n17] + (double)n2 * dArray10[n2] * dArray6[n2] * dArray6[n14 - n2] * Math.pow(d33, n16);
                        }
                        int n18 = n14 - 1;
                        dArray5[n18] = dArray5[n18] + dArray10[n2] * dArray6[n2] * dArray6[n14 - n2] * Math.pow(d33, n2);
                    }
                    d35 = -d35 * (-0.5 - (double)i + 1.0) / (double)i / d32;
                    d37 += d35 * dArray9[i];
                    d38 -= d35 * dArray5[i - 1] * (double)i / d32;
                    double d39 = d36;
                    d36 = d35 * dArray5[i - 1];
                    if (Math.abs(d36) / (d34 += d36) < 1.0E-10) break;
                }
            }
            d3 = 2.0 / d32 * Math.sqrt(d33) * 6.283185308 * d34;
            double d40 = -1.0 / d32 + d38 / d34;
            double d41 = 0.5 / d33 + d37 / d34;
            dArray[0] = d41 * -d2 / (d * d);
            dArray[1] = d40 * -2.0 + d41 / d;
            dArray2[0] = 1.0 / (d * 2.0 * d);
            dArray2[2] = 0.0;
            dArray2[1] = 0.0;
            dArray2[3] = 1.0 / (d2 * 2.0 * d2);
            return d3;
        }
        System.out.println("INVALID MODE IN BINGC");
        return d3;
    }

    private static double besrat(double d, double d2, double d3) {
        double[] dArray = new double[20];
        double d4 = 0.0;
        double d5 = d2 * d2;
        double d6 = (d + 1.0) * 2.0;
        double d7 = d + 1.5;
        double d8 = d7 * d7;
        dArray[0] = d2 / (d7 - 1.0 + Math.sqrt(d8 + d5));
        for (int i = 1; i <= 19; ++i) {
            d7 = d + (double)i + 1.5;
            d8 = d7 * d7;
            double d9 = d2 / (d7 - 1.0 + Math.sqrt(d8 + d5));
            int n = i;
            for (int j = 1; j <= n; ++j) {
                double d10 = d9 / dArray[j - 1];
                dArray[j - 1] = d9;
                double d11 = d + (double)i - (double)j + 1.0;
                double d12 = d11 * d11;
                d9 = d2 / (d11 + Math.sqrt(d12 + d5 * d10));
            }
            dArray[i] = d9;
            d4 = d9;
            double d13 = d2 / (d6 + d2 * dArray[i - 1]);
            d13 -= d9;
            if (!((d13 = Math.abs(d13) / d9) < d3)) continue;
            return d4;
        }
        return d4;
    }

    private static double bstrs0(double d) {
        double d2;
        double d3 = Math.atan(1.0) * 8.0;
        double d4 = Math.sqrt(d * 4.0);
        if (d < 100.0) {
            double d5;
            double d6 = d5 = Math.exp(-d4);
            for (int i = 1; i <= 200; ++i) {
                double d7 = d5;
                if (d7 != (d5 += (d6 = d6 * d / (double)(i * i)))) continue;
                return d5;
            }
            return d5;
        }
        double d8 = d2 = 1.0 / Math.sqrt(d3 * d4);
        double d9 = 0.0;
        double d10 = d4 * 8.0;
        for (int i = 1; i <= 40; ++i) {
            double d11 = d2;
            double d12 = (double)i * 2.0 - 1.0;
            if (d11 != (d2 += (d8 = -d8 * (d9 - d12 * d12) / (double)i / d10))) continue;
            return d2;
        }
        return d2;
    }

    private static int inv(double[] dArray, double[] dArray2) {
        double d = dArray[0] * dArray[3] - dArray[2] * dArray[1];
        dArray2[0] = dArray[3] / d;
        dArray2[2] = -dArray[1] / d;
        dArray2[1] = -dArray[2] / d;
        dArray2[3] = dArray[0] / d;
        return 0;
    }

    public static void main(String[] stringArray) {
        double[] dArray;
        System.out.println("Testing Bingham distribution\n");
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n = 0;
        int n2 = 0;
        System.out.print("t2\t\tt3\t\tak1\t\tak2\n");
        d = 0.0;
        d2 = 0.0;
        DecimalFormat decimalFormat = new DecimalFormat("0.000000");
        for (n = 10; n > 0; --n) {
            for (n2 = 10; n2 >= n; --n2) {
                d2 = 0.33333332 / (double)n2;
                d = 0.33333332 / (double)n;
                if (!(d2 <= d)) continue;
                System.out.print(decimalFormat.format(d) + "\t" + decimalFormat.format(d2));
                try {
                    dArray = BinghamFitter.bngpar(d, d2);
                    System.out.print("\t" + decimalFormat.format(dArray[0]) + "\t" + decimalFormat.format(dArray[1]) + "\t" + decimalFormat.format(dArray[2] * 4.0 * Math.PI) + "\n");
                    continue;
                }
                catch (ConvergenceException convergenceException) {
                    // empty catch block
                }
            }
        }
        System.out.println("\n");
        for (n = 10; n > 0; --n) {
            for (n2 = 10; n2 >= n; --n2) {
                d2 = 0.33333332 / (double)(2 * n2);
                d = 0.33333332 / (double)(2 * n);
                if (!(d2 <= d)) continue;
                dArray = new double[2];
                try {
                    double[] dArray2 = BinghamFitter.bngpar(d, d2);
                    double d6 = BinghamFitter.bingc(dArray2[0], dArray2[1], dArray, new double[4]);
                    System.out.print(decimalFormat.format(dArray2[0]) + "\t" + decimalFormat.format(dArray2[1]) + "\t" + decimalFormat.format(dArray[0] * 4.0 * Math.PI) + "\t" + decimalFormat.format(dArray[1] * 4.0 * Math.PI) + "\n");
                    continue;
                }
                catch (ConvergenceException convergenceException) {
                    // empty catch block
                }
            }
        }
    }
}

