/*
 * Decompiled with CFR 0.152.
 */
package numerics;

import java.util.Random;
import numerics.AxialDistribution;
import numerics.RealMatrix;
import numerics.Vector3D;

public final class ACG_Distribution
implements AxialDistribution {
    private final double sigma1;
    private final double sigma2;
    private final double sigma3;
    private final RealMatrix T;
    private final RealMatrix invA;
    private final double normC;
    private final Random ran;

    private ACG_Distribution() {
        this.T = null;
        this.invA = null;
        this.sigma1 = 0.0;
        this.sigma2 = 0.0;
        this.sigma3 = 0.0;
        this.normC = 1.0;
        this.ran = null;
    }

    public ACG_Distribution(RealMatrix realMatrix, Random random) {
        int n;
        this.invA = realMatrix.inverse();
        this.normC = 1.0 / Math.sqrt(realMatrix.det());
        RealMatrix[] realMatrixArray = realMatrix.jacobi();
        int n2 = 0;
        int n3 = 0;
        for (n = 1; n < 3; ++n) {
            if (realMatrixArray[0].entries[n][n] >= realMatrixArray[0].entries[n3][n3]) {
                n3 = n;
            }
            if (!(realMatrixArray[0].entries[n][n] < realMatrixArray[0].entries[n2][n2])) continue;
            n2 = n;
        }
        n = 3 - n2 - n3;
        this.sigma1 = Math.sqrt(realMatrixArray[0].entries[n3][n3]);
        this.sigma2 = Math.sqrt(realMatrixArray[0].entries[n][n]);
        this.sigma3 = Math.sqrt(realMatrixArray[0].entries[n2][n2]);
        RealMatrix realMatrix2 = new RealMatrix(3, 3);
        realMatrix2.entries[0][0] = realMatrixArray[1].entries[0][n3];
        realMatrix2.entries[1][0] = realMatrixArray[1].entries[1][n3];
        realMatrix2.entries[2][0] = realMatrixArray[1].entries[2][n3];
        realMatrix2.entries[0][1] = realMatrixArray[1].entries[0][n];
        realMatrix2.entries[1][1] = realMatrixArray[1].entries[1][n];
        realMatrix2.entries[2][1] = realMatrixArray[1].entries[2][n];
        realMatrix2.entries[0][2] = realMatrixArray[1].entries[0][n2];
        realMatrix2.entries[1][2] = realMatrixArray[1].entries[1][n2];
        realMatrix2.entries[2][2] = realMatrixArray[1].entries[2][n2];
        this.T = realMatrix2;
        this.ran = random;
    }

    public ACG_Distribution(Vector3D[] vector3DArray, double[] dArray, Random random) {
        RealMatrix[] realMatrixArray = new RealMatrix[3];
        for (int i = 0; i < 3; ++i) {
            realMatrixArray[i] = new RealMatrix(3, 3);
            realMatrixArray[i].entries[0][0] = vector3DArray[i].x * vector3DArray[i].x;
            realMatrixArray[i].entries[0][1] = vector3DArray[i].x * vector3DArray[i].y;
            realMatrixArray[i].entries[0][2] = vector3DArray[i].x * vector3DArray[i].z;
            realMatrixArray[i].entries[1][0] = realMatrixArray[i].entries[0][1];
            realMatrixArray[i].entries[1][1] = vector3DArray[i].y * vector3DArray[i].y;
            realMatrixArray[i].entries[1][2] = vector3DArray[i].y * vector3DArray[i].z;
            realMatrixArray[i].entries[2][0] = realMatrixArray[i].entries[0][2];
            realMatrixArray[i].entries[2][1] = realMatrixArray[i].entries[1][2];
            realMatrixArray[i].entries[2][2] = vector3DArray[i].z * vector3DArray[i].z;
            realMatrixArray[i].scale(dArray[i]);
        }
        RealMatrix realMatrix = realMatrixArray[0].add(realMatrixArray[1].add(realMatrixArray[2]));
        this.invA = realMatrix.inverse();
        this.normC = 1.0 / Math.sqrt(realMatrix.det());
        this.sigma1 = Math.sqrt(dArray[0]);
        this.sigma2 = Math.sqrt(dArray[1]);
        this.sigma3 = Math.sqrt(dArray[2]);
        RealMatrix realMatrix2 = new RealMatrix(3, 3);
        realMatrix2.entries[0][0] = vector3DArray[0].x;
        realMatrix2.entries[1][0] = vector3DArray[0].y;
        realMatrix2.entries[2][0] = vector3DArray[0].z;
        realMatrix2.entries[0][1] = vector3DArray[1].x;
        realMatrix2.entries[1][1] = vector3DArray[1].y;
        realMatrix2.entries[2][1] = vector3DArray[1].z;
        realMatrix2.entries[0][2] = vector3DArray[2].x;
        realMatrix2.entries[1][2] = vector3DArray[2].y;
        realMatrix2.entries[2][2] = vector3DArray[2].z;
        this.T = realMatrix2;
        this.ran = random;
    }

    @Override
    public double pdf(Vector3D vector3D) {
        double d = vector3D.x * (vector3D.x * this.invA.entries[0][0] + vector3D.y * this.invA.entries[1][0] + vector3D.z * this.invA.entries[2][0]) + vector3D.y * (vector3D.x * this.invA.entries[0][1] + vector3D.y * this.invA.entries[1][1] + vector3D.z * this.invA.entries[2][1]) + vector3D.z * (vector3D.x * this.invA.entries[0][2] + vector3D.y * this.invA.entries[1][2] + vector3D.z * this.invA.entries[2][2]);
        return this.normC * Math.pow(d, -1.5);
    }

    public double logPDF(Vector3D vector3D) {
        double d = vector3D.x * (vector3D.x * this.invA.entries[0][0] + vector3D.y * this.invA.entries[1][0] + vector3D.z * this.invA.entries[2][0]) + vector3D.y * (vector3D.x * this.invA.entries[0][1] + vector3D.y * this.invA.entries[1][1] + vector3D.z * this.invA.entries[2][1]) + vector3D.z * (vector3D.x * this.invA.entries[0][2] + vector3D.y * this.invA.entries[1][2] + vector3D.z * this.invA.entries[2][2]);
        return Math.log(this.normC) + -1.5 * Math.log(d);
    }

    @Override
    public Vector3D nextVector() {
        double d = this.ran.nextGaussian() * this.sigma1;
        double d2 = this.ran.nextGaussian() * this.sigma2;
        double d3 = this.ran.nextGaussian() * this.sigma3;
        double d4 = this.T.entries[0][0] * d + this.T.entries[0][1] * d2 + this.T.entries[0][2] * d3;
        double d5 = this.T.entries[1][0] * d + this.T.entries[1][1] * d2 + this.T.entries[1][2] * d3;
        double d6 = this.T.entries[2][0] * d + this.T.entries[2][1] * d2 + this.T.entries[2][2] * d3;
        return new Vector3D(d4, d5, d6).normalized();
    }

    public String toString() {
        return new String("ACG_Distribution, sigma1 == " + this.sigma1 + ", sigma2 == " + this.sigma2 + ", sigma3 == " + this.sigma3);
    }

    public Vector3D[] eigenvectors() {
        return new Vector3D[]{new Vector3D(this.T.entries[0][0], this.T.entries[1][0], this.T.entries[2][0]), new Vector3D(this.T.entries[0][1], this.T.entries[1][1], this.T.entries[2][1]), new Vector3D(this.T.entries[0][2], this.T.entries[1][2], this.T.entries[2][2])};
    }

    public double[] sigmas() {
        return new double[]{this.sigma1, this.sigma2, this.sigma3};
    }
}

