/*
 * Decompiled with CFR 0.152.
 */
package misc;

import imaging.AnalyzeHeader;
import imaging.ImageHeader;
import java.io.IOException;
import misc.LoggedException;
import numerics.Point3D;
import tractography.EightNeighbourInterpolator;
import tractography.Voxel;

public class ScalarImage {
    private boolean interpNN = true;
    private boolean interpLinear = false;
    public double[][][] data;
    private int[] dataDims;
    private double[] voxelDims;
    private EightNeighbourInterpolator linearInterpolator;

    public ScalarImage(double[][][] dArray, double[] dArray2) {
        this.data = dArray;
        this.dataDims = new int[3];
        this.dataDims[0] = dArray.length;
        this.dataDims[1] = dArray[0].length;
        this.dataDims[2] = dArray[0][0].length;
        this.voxelDims = dArray2;
        this.linearInterpolator = new EightNeighbourInterpolator(this.dataDims, dArray2);
    }

    public ScalarImage(String string) throws IOException {
        this.loadData(string, 0);
    }

    public ScalarImage(String string, int n) throws IOException {
        this.loadData(string, n);
    }

    private void loadData(String string, int n) throws IOException {
        ImageHeader imageHeader = ImageHeader.readHeader(string);
        this.data = this.data = imageHeader.readVolume(n);
        this.dataDims = new int[3];
        this.dataDims[0] = imageHeader.xDataDim();
        this.dataDims[1] = imageHeader.yDataDim();
        this.dataDims[2] = imageHeader.zDataDim();
        this.voxelDims = new double[3];
        this.voxelDims[0] = Math.abs(imageHeader.xVoxelDim());
        this.voxelDims[1] = Math.abs(imageHeader.yVoxelDim());
        this.voxelDims[2] = Math.abs(imageHeader.zVoxelDim());
        this.linearInterpolator = new EightNeighbourInterpolator(this.dataDims, this.voxelDims);
    }

    public double valueAt(Point3D point3D) {
        double d = 0.0;
        if (point3D.x < 0.0 || point3D.y < 0.0 || point3D.z < 0.0 || point3D.x > (double)this.dataDims[0] * this.voxelDims[0] || point3D.y > (double)this.dataDims[1] * this.voxelDims[1] || point3D.z > (double)this.dataDims[2] * this.voxelDims[2]) {
            return 0.0;
        }
        if (this.interpNN) {
            int n = (int)(point3D.x / this.voxelDims[0]);
            int n2 = (int)(point3D.y / this.voxelDims[1]);
            int n3 = (int)(point3D.z / this.voxelDims[2]);
            n = n < 0 ? 0 : n;
            n2 = n2 < 0 ? 0 : n2;
            n3 = n3 < 0 ? 0 : n3;
            n = n >= this.dataDims[0] ? this.dataDims[0] - 1 : n;
            n2 = n2 >= this.dataDims[1] ? this.dataDims[1] - 1 : n2;
            n3 = n3 >= this.dataDims[2] ? this.dataDims[2] - 1 : n3;
            d = this.data[n][n2][n3];
        } else if (this.interpLinear) {
            double[] dArray = new double[8];
            int[] nArray = new int[6];
            int n = this.linearInterpolator.setInterpolationVoxels(point3D, dArray, nArray);
            for (int i = 0; i < 8; ++i) {
                int n4 = nArray[i / 4];
                int n5 = nArray[2 + i / 2 % 2];
                int n6 = nArray[4 + i % 2];
                d += dArray[i] * this.data[n4][n5][n6];
            }
        } else {
            throw new LoggedException("Internal error: unknown interpolation method");
        }
        return d;
    }

    public double[] valuesAt(Point3D[] point3DArray) {
        int n = point3DArray.length;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.valueAt(point3DArray[i]);
        }
        return dArray;
    }

    public double[] valuesAt(Voxel[] voxelArray) {
        int n = voxelArray.length;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.data[voxelArray[i].x][voxelArray[i].y][voxelArray[i].z];
        }
        return dArray;
    }

    public double[] derivAt(Point3D point3D) {
        double[] dArray = new double[]{0.0, 0.0, 0.0};
        if (point3D.x < 0.0 || point3D.y < 0.0 || point3D.z < 0.0 || point3D.x > (double)this.dataDims[0] * this.voxelDims[0] || point3D.y > (double)this.dataDims[1] * this.voxelDims[1] || point3D.z > (double)this.dataDims[2] * this.voxelDims[2]) {
            return dArray;
        }
        if (this.interpNN) {
            int n = (int)(point3D.x / this.voxelDims[0]);
            int n2 = (int)(point3D.y / this.voxelDims[1]);
            int n3 = (int)(point3D.z / this.voxelDims[2]);
            n = n >= 0 ? n : 0;
            n = n < this.dataDims[0] ? n : this.dataDims[0] - 1;
            n2 = n2 >= 0 ? n2 : 0;
            n2 = n2 < this.dataDims[1] ? n2 : this.dataDims[1] - 1;
            n3 = n3 >= 0 ? n3 : 0;
            n3 = n3 < this.dataDims[2] ? n3 : this.dataDims[2] - 1;
            int n4 = n + 1;
            n4 = n4 < this.dataDims[0] ? n4 : this.dataDims[0] - 1;
            int n5 = n2 + 1;
            n5 = n5 < this.dataDims[1] ? n5 : this.dataDims[1] - 1;
            int n6 = n3 + 1;
            n6 = n6 < this.dataDims[2] ? n6 : this.dataDims[2] - 1;
            dArray[0] = (this.data[n4][n2][n3] - this.data[n][n2][n3]) / this.voxelDims[0];
            dArray[1] = (this.data[n][n5][n3] - this.data[n][n2][n3]) / this.voxelDims[1];
            dArray[2] = (this.data[n][n2][n6] - this.data[n][n2][n3]) / this.voxelDims[2];
        } else if (this.interpLinear) {
            int[] nArray = new int[6];
            double[] dArray2 = new double[8];
            int n = this.linearInterpolator.setInterpolationVoxelsDX(point3D, dArray2, nArray);
            double[] dArray3 = new double[8];
            int n7 = this.linearInterpolator.setInterpolationVoxelsDY(point3D, dArray3, nArray);
            double[] dArray4 = new double[8];
            int n8 = this.linearInterpolator.setInterpolationVoxelsDZ(point3D, dArray4, nArray);
            for (int i = 0; i < 8; ++i) {
                int n9 = nArray[i / 4];
                int n10 = nArray[2 + i / 2 % 2];
                int n11 = nArray[4 + i % 2];
                dArray[0] = dArray[0] + dArray2[i] * this.data[n9][n10][n11];
                dArray[1] = dArray[1] + dArray3[i] * this.data[n9][n10][n11];
                dArray[2] = dArray[2] + dArray4[i] * this.data[n9][n10][n11];
            }
        } else {
            throw new LoggedException("Internal error: unknown interpolation method");
        }
        return dArray;
    }

    public void setInterpolation(String string) {
        if (string.equals("linear")) {
            this.interpLinear = true;
            this.interpNN = false;
        } else if (string.equals("nearestneighbour")) {
            this.interpNN = true;
            this.interpLinear = false;
        } else {
            throw new LoggedException("Unknown interpolation method: " + string);
        }
    }

    public int[] getDataDims() {
        return new int[]{this.dataDims[0], this.dataDims[1], this.dataDims[2]};
    }

    public double[] getVoxelDims() {
        return new double[]{this.voxelDims[0], this.voxelDims[1], this.voxelDims[2]};
    }

    public void writeAnalyze(String string) throws IOException {
        AnalyzeHeader analyzeHeader = new AnalyzeHeader();
        analyzeHeader.width = (short)this.dataDims[0];
        analyzeHeader.height = (short)this.dataDims[1];
        analyzeHeader.depth = (short)this.dataDims[2];
        analyzeHeader.pixelWidth = (float)this.voxelDims[0];
        analyzeHeader.pixelHeight = (float)this.voxelDims[1];
        analyzeHeader.pixelDepth = (float)this.voxelDims[2];
        analyzeHeader.datatype = (short)16;
        AnalyzeHeader.writeImage(this.data, analyzeHeader, string, false);
    }
}

