/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.util.Random;
import java.util.logging.Logger;
import misc.LoggedException;
import misc.OrderedAcqMinimizer;

public class OrderedAcqSubsetMinimizer
extends OrderedAcqMinimizer {
    private int noSubsets;
    private double[] subsetEnergy;
    private int[] pairsPerSubset;
    private int[] subsets;
    private int[] candidateSubsets = null;
    private double[] candidateSubsetEnergy = null;
    private int i = 0;
    private int j = 0;
    private int[] bestEverSubsets = null;
    private double[] bestEverSubsetEnergy = null;
    private static Logger logger = Logger.getLogger("camino.misc.OrderedAcqSubsetMinimizer");

    public OrderedAcqSubsetMinimizer(int n, int[] nArray, double d, int n2, String string, Random random) {
        super(n, d, n2, string, random);
        this.bestEverSubsets = new int[this.noPairs];
        this.pairsPerSubset = nArray;
        this.noSubsets = this.pairsPerSubset.length;
        this.init();
    }

    public OrderedAcqSubsetMinimizer(double[][] dArray, int[] nArray, double d, int n, String string, Random random) {
        super(dArray, d, n, string, random);
        this.pairsPerSubset = nArray;
        this.noSubsets = this.pairsPerSubset.length;
        this.init();
    }

    private void init() {
        String string = "Optimizing for " + this.noPairs + " pairs and " + this.noSubsets + " subsets.\nPairs per subset: ";
        for (int i = 0; i < this.noSubsets; ++i) {
            string = string + this.pairsPerSubset[i] + " ";
        }
        logger.info(string);
        this.initializeSubsets();
        this.stateEnergy();
        this.saveStateAsLowestEnergy();
    }

    private void initializeSubsets() {
        int n;
        this.subsets = new int[this.noPairs];
        int[] nArray = new int[this.noPairs];
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < this.pairsPerSubset.length; ++n) {
            for (int i = 0; i < this.pairsPerSubset[n]; ++i) {
                nArray[n2++] = n3;
            }
            ++n3;
        }
        for (n = 0; n < this.noPairs; ++n) {
            this.subsets[n] = nArray[n];
        }
    }

    private void calculateCandidateSwapPositions() {
        this.i = (int)(this.ran.nextDouble() * (double)this.noPairs);
        this.j = (int)(this.ran.nextDouble() * (double)this.noPairs);
        while (this.i == this.j || this.subsets[this.i] == this.subsets[this.j]) {
            this.j = (int)(this.ran.nextDouble() * (double)this.noPairs);
        }
    }

    @Override
    protected double stateEnergy() {
        int n;
        double d = 0.0;
        this.subsetEnergy = new double[this.noSubsets];
        for (n = 0; n < this.noPairs; ++n) {
            for (int i = 0; i < n; ++i) {
                if (this.subsets[n] != this.subsets[i]) continue;
                int n2 = this.subsets[n];
                this.subsetEnergy[n2] = this.subsetEnergy[n2] + this.energy[n][i];
            }
        }
        for (n = 0; n < this.noSubsets; ++n) {
            d += this.subsetEnergy[n];
        }
        return d;
    }

    @Override
    protected double generateCandidateState() {
        this.calculateCandidateSwapPositions();
        return this.swappedStateEnergy();
    }

    private double swappedStateEnergy() {
        int n;
        int n2 = this.subsets[this.j];
        int n3 = this.subsets[this.i];
        this.candidateSubsetEnergy = new double[this.noSubsets];
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (n = 0; n < this.noSubsets; ++n) {
            this.candidateSubsetEnergy[n] = this.subsetEnergy[n];
        }
        for (n = 0; n < this.noPairs; ++n) {
            if (n == this.i || n == this.j) continue;
            if (this.subsets[n] == n2) {
                int n4 = this.subsets[n];
                this.candidateSubsetEnergy[n4] = this.candidateSubsetEnergy[n4] + (this.energy[n][this.i] - this.energy[n][this.j]);
                continue;
            }
            if (this.subsets[n] != n3) continue;
            int n5 = this.subsets[n];
            this.candidateSubsetEnergy[n5] = this.candidateSubsetEnergy[n5] + (this.energy[n][this.j] - this.energy[n][this.i]);
        }
        double d4 = 0.0;
        for (int i = 0; i < this.noSubsets; ++i) {
            d4 += this.candidateSubsetEnergy[i];
        }
        return d4;
    }

    @Override
    protected void acceptCandidateState() {
        if (this.candidateSubsetEnergy == null) {
            throw new LoggedException("Attempting to set an invalid state.Please report this error to the Camino team");
        }
        int n = this.subsets[this.i];
        this.subsets[this.i] = this.subsets[this.j];
        this.subsets[this.j] = n;
        this.subsetEnergy = this.candidateSubsetEnergy;
        this.candidateSubsetEnergy = null;
        this.i = 0;
        this.j = 0;
    }

    @Override
    protected void saveStateAsLowestEnergy() {
        this.bestEverSubsets = new int[this.noPairs];
        System.arraycopy(this.subsets, 0, this.bestEverSubsets, 0, this.noPairs);
        this.bestEverSubsetEnergy = new double[this.noSubsets];
        System.arraycopy(this.subsetEnergy, 0, this.bestEverSubsetEnergy, 0, this.noSubsets);
    }

    @Override
    protected void setStateToLowestEnergy() {
        System.arraycopy(this.bestEverSubsets, 0, this.subsets, 0, this.noPairs);
        System.arraycopy(this.bestEverSubsetEnergy, 0, this.subsetEnergy, 0, this.noSubsets);
    }

    @Override
    public String state() {
        return this.state(this.points, this.pairsPerSubset, this.subsets, this.temperature, this.subsetEnergy);
    }

    @Override
    public String lowestEnergyState() {
        return this.state(this.points, this.pairsPerSubset, this.bestEverSubsets, this.temperature, this.bestEverSubsetEnergy);
    }

    private String state(double[][] dArray, int[] nArray, int[] nArray2, double d, double[] dArray2) {
        int n;
        String string = this.noPairs + " " + this.noSubsets + " ";
        double d2 = 0.0;
        for (n = 0; n < this.noSubsets; ++n) {
            string = string + nArray[n] + " ";
            d2 += dArray2[n];
        }
        string = string + this.temperature + " " + d2 + " ";
        for (n = 0; n < this.noSubsets; ++n) {
            string = string + dArray2[n] + " ";
        }
        string = string + "\n";
        for (n = 0; n < this.noSubsets; ++n) {
            for (int i = 0; i < this.noPairs; ++i) {
                if (nArray2[i] != n) continue;
                string = string + dArray[i][0] + " " + dArray[i][1] + " " + dArray[i][2] + "\n";
            }
        }
        return string;
    }
}

