/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.util.Random;
import misc.LoggedException;
import misc.SphericalPoints;
import numerics.Vector3D;
import optimizers.SimulatedAnnealingOptimizer;

public abstract class OrderedAcqMinimizer
extends SimulatedAnnealingOptimizer {
    protected final int noPairs;
    protected double[][] points;
    protected double[][] energy;
    protected static final double root2Times2 = Math.sqrt(2.0) * 2.0;

    public OrderedAcqMinimizer(int n, double d, int n2, String string, Random random) {
        super(d, n2, 100000000000L, string, random);
        this.noPairs = n;
        if (this.noPairs < 7) {
            throw new LoggedException("Can't optimize less than 7 pairs");
        }
        this.points = SphericalPoints.getElecPointSet(this.noPairs);
        this.initializeRandom();
    }

    public OrderedAcqMinimizer(double[][] dArray, double d, int n, String string, Random random) {
        super(d, n, 100000000000L, string, random);
        this.noPairs = dArray.length;
        this.points = dArray;
        this.buildEnergyMatrix();
    }

    public final void buildEnergyMatrix() {
        this.energy = OrderedAcqMinimizer.pairEnergyMatrix(this.points);
    }

    public static final double[][] pairEnergyMatrix(double[][] dArray) {
        int n = dArray.length;
        double[][] dArray2 = new double[n][n];
        for (int i = 0; i < n; ++i) {
            double[] dArray3 = Vector3D.thetaPhi(new Vector3D(dArray[i][0], dArray[i][1], dArray[i][2]));
            double d = dArray3[0];
            double d2 = dArray3[1];
            double d3 = Math.sin(d);
            double d4 = Math.cos(d);
            for (int j = i + 1; j < n; ++j) {
                double[] dArray4 = Vector3D.thetaPhi(new Vector3D(dArray[j][0], dArray[j][1], dArray[j][2]));
                double d5 = dArray4[0];
                double d6 = dArray4[1];
                double d7 = Math.sin(d5);
                double d8 = Math.cos(d5);
                double d9 = Math.cos(d2 - d6);
                dArray2[i][j] = root2Times2 * (1.0 / Math.sqrt(1.0 - d4 * d8 - d9 * d3 * d7) + 1.0 / Math.sqrt(1.0 + d4 * d8 + d9 * d3 * d7));
                dArray2[j][i] = dArray2[i][j];
            }
        }
        return dArray2;
    }

    public final void initializeRandom() {
        double[][] dArrayArray = new double[this.noPairs][];
        boolean[] blArray = new boolean[this.noPairs];
        for (int i = 0; i < this.noPairs; ++i) {
            int n = this.ran.nextInt(this.noPairs);
            while (blArray[n]) {
                n = this.ran.nextInt(this.noPairs);
            }
            dArrayArray[i] = this.points[n];
            blArray[n] = true;
        }
        this.points = dArrayArray;
        this.buildEnergyMatrix();
    }

    protected void swapPoints(int n, int n2) {
        double d;
        int n3;
        double[] dArray = this.points[n];
        this.points[n] = this.points[n2];
        this.points[n2] = dArray;
        for (n3 = 0; n3 < this.noPairs; ++n3) {
            if (n3 == n || n3 == n2) continue;
            d = this.energy[n3][n];
            this.energy[n3][n] = this.energy[n3][n2];
            this.energy[n3][n2] = d;
        }
        for (n3 = 0; n3 < this.noPairs; ++n3) {
            if (n3 == n || n3 == n2) continue;
            d = this.energy[n][n3];
            this.energy[n][n3] = this.energy[n2][n3];
            this.energy[n2][n3] = d;
        }
    }

    public double[][] getPoints() {
        double[][] dArray = new double[this.noPairs][3];
        for (int i = 0; i < this.noPairs; ++i) {
            dArray[i][0] = this.points[i][0];
            dArray[i][1] = this.points[i][1];
            dArray[i][2] = this.points[i][2];
        }
        return dArray;
    }
}

