/*
 * Decompiled with CFR 0.152.
 */
package mesd;

import java.util.logging.Logger;

public class SphDeconvKernels {
    private static Logger logger = Logger.getLogger("mesd.SphDeconvKernels");

    public static double kernel(double[] dArray, double[] dArray2, double[] dArray3) {
        double d = dArray3[0] == 1.0 ? SphDeconvKernels.pasKernel(dArray, dArray2, dArray3[1]) : (dArray3[0] == 2.0 ? SphDeconvKernels.tensorKernel(dArray, dArray2, dArray3[1]) : SphDeconvKernels.spikeKernel(dArray, dArray2, dArray3[1]));
        if (Double.isNaN(d)) {
            logger.warning("kernel return value with q=(" + dArray[0] + "," + dArray[1] + "," + dArray[2] + ") x=" + dArray2[0] + "," + dArray2[1] + "," + dArray2[2] + ") is " + d);
        }
        return d;
    }

    protected static double pasKernel(double[] dArray, double[] dArray2, double d) {
        double d2 = dArray[0] * dArray2[0] + dArray[1] * dArray2[1] + dArray[2] * dArray2[2];
        return Math.cos(d * d2);
    }

    protected static double spikeKernel(double[] dArray, double[] dArray2, double d) {
        double d2 = dArray[0] * dArray2[0] + dArray[1] * dArray2[1] + dArray[2] * dArray2[2];
        return Math.exp(-d * d2 * d2);
    }

    protected static double tensorKernel(double[] dArray, double[] dArray2, double d) {
        double[][] dArray3 = SphDeconvKernels.getDmatrix(dArray2);
        double[] dArray4 = new double[3];
        for (int i = 0; i < 3; ++i) {
            dArray4[i] = dArray3[i][0] * dArray[0] + dArray3[i][1] * dArray[1] + dArray3[i][2] * dArray[2];
        }
        double d2 = dArray[0] * dArray4[0] + dArray[1] * dArray4[1] + dArray[2] * dArray4[2];
        return Math.exp(-d * d2);
    }

    private static double[][] getDmatrix(double[] dArray) {
        int n;
        int n2;
        double[][] dArray2 = SphDeconvKernels.getRmatrix(dArray);
        double[][] dArray3 = new double[3][3];
        double[] dArray4 = new double[]{0.9, 0.9, 0.1};
        double[][] dArray5 = new double[3][3];
        for (n2 = 0; n2 < 3; ++n2) {
            for (n = 0; n < 3; ++n) {
                dArray5[n2][n] = dArray4[n2] * dArray2[n2][n];
            }
        }
        for (n2 = 0; n2 < 3; ++n2) {
            for (n = 0; n < 3; ++n) {
                dArray3[n2][n] = 0.0;
                for (int i = 0; i < 3; ++i) {
                    double[] dArray6 = dArray3[n2];
                    int n3 = n;
                    dArray6[n3] = dArray6[n3] + dArray5[n2][i] * dArray2[n][i];
                }
            }
        }
        return dArray3;
    }

    private static double[][] getRmatrix(double[] dArray) {
        double d = Math.atan2(dArray[1], dArray[0]);
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = dArray[2];
        double d5 = Math.sqrt(1.0 - d4 * d4);
        double[][] dArray2 = new double[3][3];
        dArray2[0][0] = d2;
        dArray2[0][1] = d4 * d3;
        dArray2[0][2] = d5 * d3;
        dArray2[1][0] = -d3;
        dArray2[1][1] = d4 * d2;
        dArray2[1][2] = d5 * d2;
        dArray2[2][0] = 0.0;
        dArray2[2][1] = 0.0;
        dArray2[2][2] = d4;
        return dArray2;
    }

    public static void main(String[] stringArray) {
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        dArray[0] = 1.0 / Math.sqrt(2.0);
        dArray2[0] = 0.0;
        dArray[1] = 1.0 / Math.sqrt(2.0);
        dArray2[1] = 0.0;
        dArray[2] = 0.0;
        dArray2[2] = 1.0;
        double[][] dArray3 = SphDeconvKernels.getRmatrix(dArray);
        double[] dArray4 = new double[3];
        for (int i = 0; i < 3; ++i) {
            dArray4[i] = dArray3[i][0] * dArray2[0] + dArray3[i][1] * dArray2[1] + dArray3[i][2] * dArray2[2];
        }
        System.err.println("y=(" + dArray4[0] + "," + dArray4[1] + "," + dArray4[2] + ")");
    }
}

