/*
 * Decompiled with CFR 0.152.
 */
package inverters;

import inverters.DiffTensorFitter;
import misc.DT;
import optimizers.MarquardtMinimiserException;

public class DiffTensorUnConFitter
extends DiffTensorFitter {
    public DiffTensorUnConFitter() {
    }

    public DiffTensorUnConFitter(double[][] dArray, double[] dArray2, double[] dArray3, int n) throws MarquardtMinimiserException {
        this.noParams = 6;
        this.initialize(dArray, dArray2, dArray3, n);
    }

    @Override
    protected void initAs() {
        this.a[5] = 0.0;
        this.a[3] = 0.0;
        this.a[2] = 0.0;
        double d = 2.1E-9;
        this.a[1] = d / 3.0;
        this.a[4] = d / 3.0;
        this.a[6] = d / 3.0;
    }

    @Override
    public void setStartPoint(double[] dArray) {
        for (int i = 0; i < 6; ++i) {
            this.a[i + 1] = dArray[i + 2];
        }
    }

    @Override
    protected double yfit(double[] dArray, int n) {
        DT dT = new DT(dArray[1], dArray[2], dArray[3], dArray[4], dArray[5], dArray[6]);
        double[] dArray2 = DiffTensorUnConFitter.getQ(this.x, n);
        double d = Math.exp(-this.taus[n] * dT.contractBy(dArray2));
        return d;
    }

    @Override
    protected double[] dydas(double[] dArray, int n) {
        double[] dArray2 = new double[this.ma + 1];
        DT dT = new DT(dArray[1], dArray[2], dArray[3], dArray[4], dArray[5], dArray[6]);
        double[] dArray3 = DiffTensorUnConFitter.getQ(this.x, n);
        double d = Math.exp(-this.taus[n] * dT.contractBy(dArray3));
        dArray2[1] = -this.taus[n] * dArray3[0] * dArray3[0] * d;
        dArray2[2] = -2.0 * this.taus[n] * dArray3[0] * dArray3[1] * d;
        dArray2[3] = -2.0 * this.taus[n] * dArray3[0] * dArray3[2] * d;
        dArray2[4] = -this.taus[n] * dArray3[1] * dArray3[1] * d;
        dArray2[5] = -2.0 * this.taus[n] * dArray3[1] * dArray3[2] * d;
        dArray2[6] = -this.taus[n] * dArray3[2] * dArray3[2] * d;
        return dArray2;
    }

    @Override
    public DT getDiffTensor() {
        return new DT(this.a[1], this.a[2], this.a[3], this.a[4], this.a[5], this.a[6]);
    }
}

