/*
 * Decompiled with CFR 0.152.
 */
package imaging;

import data.DataSource;
import data.DataSourceException;
import data.OutputManager;
import data.ScannerOrderDataSource;
import data.VoxelOrderDataSource;
import data.VoxelOrderScaledDataSource;
import imaging.ImageHeader;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import misc.LoggedException;
import tools.CL_Initializer;
import tools.LEFilterOutputStream;

public class AnalyzeHeader
extends ImageHeader {
    private static int BUFFERSIZE = 0x1000000;
    private static Logger logger = Logger.getLogger("camino.imaging.AnalyzeHeader");
    public static final short DT_NONE = 0;
    public static final short DT_UNKNOWN = 0;
    public static final short DT_BINARY = 1;
    public static final short DT_UNSIGNED_CHAR = 2;
    public static final short DT_SIGNED_SHORT = 4;
    public static final short DT_SIGNED_INT = 8;
    public static final short DT_FLOAT = 16;
    public static final short DT_COMPLEX = 32;
    public static final short DT_DOUBLE = 64;
    public static final short DT_RGB = 128;
    public static final short DT_SIGNED_CHAR = 130;
    public static final short DT_UNSIGNED_SHORT = 132;
    public static final short DT_UNSIGNED_INT = 136;
    public static final short DT_ALL = 255;
    public short datatype = 0;
    public short width = 0;
    public short height = 0;
    public short depth = 0;
    public float vox_offset = 0.0f;
    public short nImages = 1;
    public boolean intelByteOrder = false;
    public int glmin = 0;
    public int glmax = 0;
    public float pixelWidth = 1.0f;
    public float pixelHeight = 1.0f;
    public float pixelDepth = 1.0f;
    public float scaleSlope = 1.0f;
    public float scaleInter = 0.0f;
    public short bitpix = 1;
    public String description = "";
    public short[] centre = new short[3];
    public short[] picoSeed = new short[3];
    private String hdrFile = null;
    private String dataFile = null;

    public AnalyzeHeader() {
    }

    public AnalyzeHeader(AnalyzeHeader analyzeHeader) {
        this.intelByteOrder = analyzeHeader.intelByteOrder;
        this.width = analyzeHeader.width;
        this.height = analyzeHeader.height;
        this.depth = analyzeHeader.depth;
        this.nImages = analyzeHeader.nImages;
        this.datatype = analyzeHeader.datatype;
        this.bitpix = analyzeHeader.bitpix;
        this.pixelWidth = analyzeHeader.pixelWidth;
        this.pixelHeight = analyzeHeader.pixelHeight;
        this.pixelDepth = analyzeHeader.pixelDepth;
        this.vox_offset = analyzeHeader.vox_offset;
        this.scaleSlope = analyzeHeader.scaleSlope;
        this.scaleInter = analyzeHeader.scaleInter;
        this.glmax = analyzeHeader.glmax;
        this.glmin = analyzeHeader.glmin;
        this.description = analyzeHeader.description;
        this.centre[0] = analyzeHeader.centre[0];
        this.centre[1] = analyzeHeader.centre[1];
        this.centre[2] = analyzeHeader.centre[2];
        this.picoSeed[0] = analyzeHeader.picoSeed[0];
        this.picoSeed[1] = analyzeHeader.picoSeed[1];
        this.picoSeed[2] = analyzeHeader.picoSeed[2];
        this.hdrFile = analyzeHeader.hdrFile;
        this.dataFile = analyzeHeader.dataFile;
    }

    public static AnalyzeHeader readHeader(String string) throws IOException {
        int n;
        int n2;
        if (!string.endsWith(".hdr")) {
            string = string + ".hdr";
        }
        FileInputStream fileInputStream = new FileInputStream(string);
        DataInputStream dataInputStream = new DataInputStream(fileInputStream);
        AnalyzeHeader analyzeHeader = new AnalyzeHeader();
        int n3 = 0;
        analyzeHeader.readInt(dataInputStream);
        n3 += 4;
        for (n2 = 0; n2 < 10; ++n2) {
            dataInputStream.read();
        }
        for (n2 = 0; n2 < 18; ++n2) {
            dataInputStream.read();
        }
        n3 += 28;
        analyzeHeader.readInt(dataInputStream);
        analyzeHeader.readShort(dataInputStream);
        dataInputStream.readByte();
        dataInputStream.readByte();
        n3 += 8;
        short s = analyzeHeader.readShort(dataInputStream);
        if (s < 0 || s > 15) {
            analyzeHeader.intelByteOrder = true;
        }
        n3 += 2;
        analyzeHeader.width = analyzeHeader.readShort(dataInputStream);
        n3 += 2;
        analyzeHeader.height = analyzeHeader.readShort(dataInputStream);
        n3 += 2;
        analyzeHeader.depth = analyzeHeader.readShort(dataInputStream);
        n3 += 2;
        analyzeHeader.nImages = analyzeHeader.readShort(dataInputStream);
        n3 += 2;
        for (n2 = 0; n2 < 3; ++n2) {
            analyzeHeader.readShort(dataInputStream);
        }
        n3 += 6;
        analyzeHeader.picoSeed[0] = analyzeHeader.readShort(dataInputStream);
        n3 += 2;
        analyzeHeader.picoSeed[1] = analyzeHeader.readShort(dataInputStream);
        n3 += 2;
        analyzeHeader.picoSeed[2] = analyzeHeader.readShort(dataInputStream);
        n3 += 2;
        analyzeHeader.readShort(dataInputStream);
        n3 += 2;
        analyzeHeader.readShort(dataInputStream);
        n3 += 2;
        analyzeHeader.readShort(dataInputStream);
        n3 += 2;
        analyzeHeader.readShort(dataInputStream);
        n3 += 2;
        analyzeHeader.datatype = analyzeHeader.readShort(dataInputStream);
        n3 += 2;
        analyzeHeader.bitpix = analyzeHeader.readShort(dataInputStream);
        n3 += 2;
        analyzeHeader.readShort(dataInputStream);
        n3 += 2;
        analyzeHeader.readFloat(dataInputStream);
        n3 += 4;
        analyzeHeader.pixelWidth = analyzeHeader.readFloat(dataInputStream);
        n3 += 4;
        analyzeHeader.pixelHeight = analyzeHeader.readFloat(dataInputStream);
        n3 += 4;
        analyzeHeader.pixelDepth = analyzeHeader.readFloat(dataInputStream);
        n3 += 4;
        for (n2 = 0; n2 < 4; ++n2) {
            analyzeHeader.readFloat(dataInputStream);
        }
        n3 += 16;
        analyzeHeader.vox_offset = analyzeHeader.readFloat(dataInputStream);
        n3 += 4;
        analyzeHeader.scaleSlope = analyzeHeader.readFloat(dataInputStream);
        n3 += 4;
        analyzeHeader.scaleInter = analyzeHeader.readFloat(dataInputStream);
        n3 += 4;
        analyzeHeader.readFloat(dataInputStream);
        n3 += 4;
        analyzeHeader.readFloat(dataInputStream);
        n3 += 4;
        analyzeHeader.readFloat(dataInputStream);
        n3 += 4;
        analyzeHeader.readInt(dataInputStream);
        n3 += 4;
        analyzeHeader.readInt(dataInputStream);
        n3 += 4;
        analyzeHeader.glmax = analyzeHeader.readInt(dataInputStream);
        n3 += 4;
        analyzeHeader.glmin = analyzeHeader.readInt(dataInputStream);
        n3 += 4;
        byte[] byArray = new byte[80];
        dataInputStream.read(byArray, 0, 80);
        n3 += 80;
        for (n = 0; n < 80 && byArray[n] != 0; ++n) {
        }
        byte[] byArray2 = new byte[n];
        for (n2 = 0; n2 < n; ++n2) {
            byArray2[n2] = byArray[n2];
        }
        analyzeHeader.description = new String(byArray2);
        for (n2 = 0; n2 < 24; ++n2) {
            dataInputStream.read();
        }
        n3 += 24;
        dataInputStream.read();
        ++n3;
        analyzeHeader.centre[0] = analyzeHeader.readShort(dataInputStream);
        n3 += 2;
        analyzeHeader.centre[1] = analyzeHeader.readShort(dataInputStream);
        n3 += 2;
        analyzeHeader.centre[2] = analyzeHeader.readShort(dataInputStream);
        n3 += 2;
        for (n2 = 0; n2 < 4; ++n2) {
            dataInputStream.read();
        }
        n3 += 4;
        for (n2 = 0; n2 < 10; ++n2) {
            dataInputStream.read();
        }
        n3 += 10;
        for (n2 = 0; n2 < 10; ++n2) {
            dataInputStream.read();
        }
        n3 += 10;
        for (n2 = 0; n2 < 10; ++n2) {
            dataInputStream.read();
        }
        n3 += 10;
        for (n2 = 0; n2 < 10; ++n2) {
            dataInputStream.read();
        }
        n3 += 10;
        for (n2 = 0; n2 < 10; ++n2) {
            dataInputStream.read();
        }
        n3 += 10;
        for (n2 = 0; n2 < 3; ++n2) {
            dataInputStream.read();
        }
        n3 += 3;
        analyzeHeader.readInt(dataInputStream);
        n3 += 4;
        analyzeHeader.readInt(dataInputStream);
        n3 += 4;
        analyzeHeader.readInt(dataInputStream);
        n3 += 4;
        analyzeHeader.readInt(dataInputStream);
        n3 += 4;
        analyzeHeader.readInt(dataInputStream);
        n3 += 4;
        analyzeHeader.readInt(dataInputStream);
        n3 += 4;
        analyzeHeader.readInt(dataInputStream);
        n3 += 4;
        analyzeHeader.readInt(dataInputStream);
        if ((n3 += 4) != 348) {
            logger.warning("Header is " + n3 + " bytes.\nAnalyze expects 348 bytes");
        }
        analyzeHeader.checkBitpix();
        dataInputStream.close();
        fileInputStream.close();
        analyzeHeader.hdrFile = string;
        analyzeHeader.dataFile = AnalyzeHeader.getIMG_File(string);
        return analyzeHeader;
    }

    private void checkBitpix() {
        short s = this.bitpix;
        switch (this.datatype) {
            case 1: {
                this.bitpix = 1;
                break;
            }
            case 2: 
            case 130: {
                this.bitpix = (short)8;
                break;
            }
            case 4: 
            case 132: {
                this.bitpix = (short)16;
                break;
            }
            case 8: 
            case 16: 
            case 136: {
                this.bitpix = (short)32;
                break;
            }
            case 128: {
                this.bitpix = (short)24;
                break;
            }
            case 32: 
            case 64: {
                this.bitpix = (short)64;
            }
        }
        if (s > 1 && this.bitpix != s) {
            logger.warning("Overriding bitpix value " + s + "\n. Java requires type " + this.caminoDataTypeString() + " to have size " + this.bitpix);
        }
    }

    public void writeHeader() throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(this.hdrFile);
        DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
        this.writeHeader(dataOutputStream);
        dataOutputStream.close();
    }

    private void writeHeader(DataOutputStream dataOutputStream) throws IOException {
        int n;
        this.checkBitpix();
        FilterOutputStream filterOutputStream = null;
        filterOutputStream = this.intelByteOrder ? new LEFilterOutputStream(dataOutputStream) : dataOutputStream;
        int n2 = 0;
        filterOutputStream.writeInt(348);
        n2 += 4;
        for (n = 0; n < 10; ++n) {
            filterOutputStream.write(0);
        }
        n2 += 10;
        for (n = 0; n < 18; ++n) {
            filterOutputStream.write(0);
        }
        n2 += 18;
        filterOutputStream.writeInt(16384);
        n2 += 4;
        filterOutputStream.writeShort(0);
        n2 += 2;
        filterOutputStream.writeByte(114);
        ++n2;
        filterOutputStream.writeByte(0);
        ++n2;
        filterOutputStream.writeShort(4);
        n2 += 2;
        filterOutputStream.writeShort(this.width);
        n2 += 2;
        filterOutputStream.writeShort(this.height);
        n2 += 2;
        filterOutputStream.writeShort(this.depth);
        n2 += 2;
        filterOutputStream.writeShort(this.nImages);
        n2 += 2;
        for (n = 0; n < 3; ++n) {
            filterOutputStream.writeShort(0);
        }
        n2 += 6;
        filterOutputStream.writeShort(this.picoSeed[0]);
        n2 += 2;
        filterOutputStream.writeShort(this.picoSeed[1]);
        n2 += 2;
        filterOutputStream.writeShort(this.picoSeed[2]);
        n2 += 2;
        filterOutputStream.writeShort(0);
        n2 += 2;
        filterOutputStream.writeShort(0);
        n2 += 2;
        filterOutputStream.writeShort(0);
        n2 += 2;
        filterOutputStream.writeShort(0);
        n2 += 2;
        filterOutputStream.writeShort(this.datatype);
        n2 += 2;
        filterOutputStream.writeShort(this.bitpix);
        n2 += 2;
        filterOutputStream.writeShort(0);
        n2 += 2;
        filterOutputStream.writeFloat(0.0f);
        n2 += 4;
        filterOutputStream.writeFloat(this.pixelWidth);
        n2 += 4;
        filterOutputStream.writeFloat(this.pixelHeight);
        n2 += 4;
        filterOutputStream.writeFloat(this.pixelDepth);
        n2 += 4;
        for (n = 0; n < 4; ++n) {
            filterOutputStream.writeFloat(0.0f);
        }
        n2 += 16;
        filterOutputStream.writeFloat(this.vox_offset);
        n2 += 4;
        filterOutputStream.writeFloat(this.scaleSlope);
        n2 += 4;
        filterOutputStream.writeFloat(this.scaleInter);
        n2 += 4;
        filterOutputStream.writeFloat(0.0f);
        n2 += 4;
        filterOutputStream.writeFloat(0.0f);
        n2 += 4;
        filterOutputStream.writeFloat(0.0f);
        n2 += 4;
        filterOutputStream.writeInt(0);
        n2 += 4;
        filterOutputStream.writeInt(0);
        n2 += 4;
        filterOutputStream.writeInt(this.glmax);
        n2 += 4;
        filterOutputStream.writeInt(this.glmin);
        n2 += 4;
        byte[] byArray = this.description.getBytes();
        boolean bl = false;
        if (byArray.length < 80) {
            for (n = 0; n < byArray.length; ++n) {
                ++n2;
                filterOutputStream.write(byArray[n]);
            }
            for (n = 0; n < 80 - byArray.length; ++n) {
                filterOutputStream.write(0);
                ++n2;
            }
        } else {
            for (n = 0; n < 79; ++n) {
                filterOutputStream.write(byArray[n]);
            }
            filterOutputStream.write(0);
            n2 += 80;
        }
        for (n = 0; n < 24; ++n) {
            filterOutputStream.write(0);
        }
        n2 += 24;
        filterOutputStream.write(0);
        ++n2;
        for (n = 0; n < 3; ++n) {
            filterOutputStream.writeShort(this.centre[n]);
        }
        n2 += 6;
        for (n = 0; n < 4; ++n) {
            filterOutputStream.write(0);
        }
        n2 += 4;
        for (n = 0; n < 10; ++n) {
            filterOutputStream.write(0);
        }
        n2 += 10;
        for (n = 0; n < 10; ++n) {
            filterOutputStream.write(0);
        }
        n2 += 10;
        for (n = 0; n < 10; ++n) {
            filterOutputStream.write(0);
        }
        n2 += 10;
        for (n = 0; n < 10; ++n) {
            filterOutputStream.write(0);
        }
        n2 += 10;
        for (n = 0; n < 10; ++n) {
            filterOutputStream.write(0);
        }
        n2 += 10;
        for (n = 0; n < 3; ++n) {
            filterOutputStream.write(0);
        }
        n2 += 3;
        filterOutputStream.writeInt(0);
        n2 += 4;
        filterOutputStream.writeInt(0);
        n2 += 4;
        filterOutputStream.writeInt(0);
        n2 += 4;
        filterOutputStream.writeInt(0);
        n2 += 4;
        filterOutputStream.writeInt(0);
        n2 += 4;
        filterOutputStream.writeInt(0);
        n2 += 4;
        filterOutputStream.writeInt(0);
        n2 += 4;
        filterOutputStream.writeInt(0);
        if ((n2 += 4) != 348) {
            System.err.println("WARNING: Header is " + n2 + " bytes");
            System.err.println("Analyze expects 348 bytes");
        }
    }

    public int readInt(DataInputStream dataInputStream) throws IOException {
        if (!this.intelByteOrder) {
            return dataInputStream.readInt();
        }
        byte by = dataInputStream.readByte();
        byte by2 = dataInputStream.readByte();
        byte by3 = dataInputStream.readByte();
        byte by4 = dataInputStream.readByte();
        return (by4 & 0xFF) << 24 | (by3 & 0xFF) << 16 | (by2 & 0xFF) << 8 | by & 0xFF;
    }

    public short readShort(DataInputStream dataInputStream) throws IOException {
        if (!this.intelByteOrder) {
            return dataInputStream.readShort();
        }
        byte by = dataInputStream.readByte();
        byte by2 = dataInputStream.readByte();
        return (short)((by2 & 0xFF) << 8 | by & 0xFF);
    }

    public float readFloat(DataInputStream dataInputStream) throws IOException {
        if (!this.intelByteOrder) {
            return dataInputStream.readFloat();
        }
        int n = this.readInt(dataInputStream);
        return Float.intBitsToFloat(n);
    }

    public static void main(String[] stringArray) {
        int n;
        AnalyzeHeader analyzeHeader = new AnalyzeHeader();
        if (stringArray.length == 0) {
            System.err.println("\nTo write a header: AnalyzeHeader\n\t-voxeldims [x y z] voxel dimensions\n\t-datadims [x y z] data dimensions\n\t-nimages [number] number of images in the img file. Default 1.\n\t-datatype [char | short | int | float | complex | double]\n data type of image\n\t-offset [value] a float value.\n\t-gl [min max] greylevel. Stored as int in the header\n\t-scaleslope [value] SPM scale factor. Default 1.0\n\t-scaleint [value] SPM scale intercept Default 0.0\n\t-description [String] no spaces, max length 79 bytes. Default blank.\n\t-centre [x y z] voxel specifying origin of Talairach coordinate system for SPM, default [0 0 0]\n\t-picoseed [x y z] voxel specifying the seed (for PICo maps), default [0 0 0].\n\t-outputfile [filename] output file name. Extension .hdr will be added if missing.\n\t-intelbyteorder output little-endian header. Default is big-endian\n\nTo read a header: AnalyzeHeader -readheader [filename]");
            System.exit(0);
        }
        String string = "";
        CL_Initializer.CL_init(stringArray);
        for (n = 0; n < stringArray.length; ++n) {
            if (!stringArray[n].equals("-initfromheader")) continue;
            try {
                analyzeHeader = AnalyzeHeader.readHeader(stringArray[n + 1]);
            }
            catch (IOException iOException) {
                throw new LoggedException(iOException);
            }
            CL_Initializer.markAsParsed(n, 2);
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equals("-readheader")) {
                try {
                    AnalyzeHeader analyzeHeader2 = AnalyzeHeader.readHeader(stringArray[n + 1]);
                    System.out.println(analyzeHeader2);
                    System.out.println(AnalyzeHeader.getArgs(analyzeHeader2, "all"));
                }
                catch (IOException iOException) {
                    throw new LoggedException(iOException);
                }
                System.exit(0);
                continue;
            }
            if (stringArray[n].equals("-printimagedims")) {
                try {
                    analyzeHeader = AnalyzeHeader.readHeader(stringArray[n + 1]);
                    String string2 = "-datadims " + analyzeHeader.width + " " + analyzeHeader.height + " " + analyzeHeader.depth + " -voxeldims " + analyzeHeader.pixelWidth + " " + analyzeHeader.pixelHeight + " " + analyzeHeader.pixelDepth;
                    System.out.print(string2);
                    System.exit(0);
                    continue;
                }
                catch (IOException iOException) {
                    throw new LoggedException(iOException);
                }
            }
            if (stringArray[n].equals("-printintelbyteorder")) {
                try {
                    analyzeHeader = AnalyzeHeader.readHeader(stringArray[n + 1]);
                    System.out.print(analyzeHeader.intelByteOrder ? 1 : 0);
                    System.exit(0);
                    continue;
                }
                catch (IOException iOException) {
                    throw new LoggedException(iOException);
                }
            }
            if (stringArray[n].equals("-printbigendian")) {
                try {
                    analyzeHeader = AnalyzeHeader.readHeader(stringArray[n + 1]);
                    System.out.print(analyzeHeader.intelByteOrder ? 0 : 1);
                    System.exit(0);
                    continue;
                }
                catch (IOException iOException) {
                    throw new LoggedException(iOException);
                }
            }
            if (stringArray[n].equals("-printprogargs")) {
                try {
                    analyzeHeader = AnalyzeHeader.readHeader(stringArray[n + 1]);
                    System.out.print(AnalyzeHeader.getArgs(analyzeHeader, stringArray[n + 2]));
                    System.exit(0);
                    continue;
                }
                catch (IOException iOException) {
                    throw new LoggedException(iOException);
                }
            }
            if (stringArray[n].equals("-initfromheader")) continue;
            if (stringArray[n].equals("-centre")) {
                analyzeHeader.centre[0] = Short.parseShort(stringArray[n + 1]);
                analyzeHeader.centre[1] = Short.parseShort(stringArray[n + 2]);
                analyzeHeader.centre[2] = Short.parseShort(stringArray[n + 3]);
                CL_Initializer.markAsParsed(n, 4);
                continue;
            }
            if (stringArray[n].equals("-picoseed")) {
                analyzeHeader.picoSeed[0] = Short.parseShort(stringArray[n + 1]);
                analyzeHeader.picoSeed[1] = Short.parseShort(stringArray[n + 2]);
                analyzeHeader.picoSeed[2] = Short.parseShort(stringArray[n + 3]);
                CL_Initializer.markAsParsed(n, 4);
                continue;
            }
            if (stringArray[n].equals("-intelbyteorder")) {
                analyzeHeader.intelByteOrder = true;
                CL_Initializer.markAsParsed(n);
                continue;
            }
            if (stringArray[n].equals("-networkbyteorder")) {
                analyzeHeader.intelByteOrder = false;
                CL_Initializer.markAsParsed(n);
                continue;
            }
            if (stringArray[n].equals("-datadims")) {
                analyzeHeader.width = Short.parseShort(stringArray[n + 1]);
                analyzeHeader.height = Short.parseShort(stringArray[n + 2]);
                analyzeHeader.depth = Short.parseShort(stringArray[n + 3]);
                CL_Initializer.markAsParsed(n, 4);
                continue;
            }
            if (stringArray[n].equals("-datatype")) {
                if (stringArray[n + 1].equals("binary")) {
                    analyzeHeader.datatype = 1;
                }
                if (stringArray[n + 1].equals("char")) {
                    analyzeHeader.datatype = (short)2;
                }
                if (stringArray[n + 1].equals("byte")) {
                    analyzeHeader.datatype = (short)130;
                }
                if (stringArray[n + 1].equals("short")) {
                    analyzeHeader.datatype = (short)4;
                }
                if (stringArray[n + 1].equals("int")) {
                    analyzeHeader.datatype = (short)8;
                }
                if (stringArray[n + 1].equals("ushort")) {
                    analyzeHeader.datatype = (short)132;
                }
                if (stringArray[n + 1].equals("uint")) {
                    analyzeHeader.datatype = (short)136;
                }
                if (stringArray[n + 1].equals("float")) {
                    analyzeHeader.datatype = (short)16;
                }
                if (stringArray[n + 1].equals("complex")) {
                    analyzeHeader.datatype = (short)32;
                }
                if (stringArray[n + 1].equals("double")) {
                    analyzeHeader.datatype = (short)64;
                }
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equals("-description")) {
                int n2 = 0;
                analyzeHeader.description = stringArray[n + 1];
                while (n + n2 + 2 < stringArray.length && !stringArray[n + n2 + 2].startsWith("-")) {
                    analyzeHeader.description = analyzeHeader.description + " " + stringArray[n + n2 + 2];
                    ++n2;
                }
                CL_Initializer.markAsParsed(n, n2 + 2);
                continue;
            }
            if (stringArray[n].equals("-gl")) {
                analyzeHeader.glmin = Short.parseShort(stringArray[n + 1]);
                analyzeHeader.glmax = Short.parseShort(stringArray[n + 2]);
                CL_Initializer.markAsParsed(n, 3);
                continue;
            }
            if (stringArray[n].equals("-nimages")) {
                analyzeHeader.nImages = Short.parseShort(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equals("-offset")) {
                analyzeHeader.vox_offset = Float.parseFloat(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equals("-scale")) {
                analyzeHeader.scaleSlope = Float.parseFloat(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equals("-scaleslope")) {
                analyzeHeader.scaleSlope = Float.parseFloat(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equals("-scaleinter")) {
                analyzeHeader.scaleInter = Float.parseFloat(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (!stringArray[n].equals("-voxeldims")) continue;
            analyzeHeader.pixelWidth = Float.parseFloat(stringArray[n + 1]);
            analyzeHeader.pixelHeight = Float.parseFloat(stringArray[n + 2]);
            analyzeHeader.pixelDepth = Float.parseFloat(stringArray[n + 3]);
            CL_Initializer.markAsParsed(n, 4);
        }
        CL_Initializer.checkParsing(stringArray);
        switch (analyzeHeader.datatype) {
            case 1: {
                logger.fine("Writing header data type as binary bit");
                analyzeHeader.bitpix = 1;
                break;
            }
            case 2: {
                logger.fine("Writing header data type as 8 bit char");
                analyzeHeader.bitpix = (short)8;
                break;
            }
            case 4: {
                logger.fine("Writing header data type as short");
                analyzeHeader.bitpix = (short)16;
                break;
            }
            case 8: {
                logger.fine("Writing header data type as int");
                analyzeHeader.bitpix = (short)32;
                break;
            }
            case 16: {
                logger.fine("Writing header data type as float");
                analyzeHeader.bitpix = (short)32;
                break;
            }
            case 128: {
                logger.fine("Writing header data type as RGB");
                analyzeHeader.bitpix = (short)24;
                break;
            }
            case 32: {
                logger.fine("Writing header data type as COMPLEX");
                analyzeHeader.bitpix = (short)64;
                break;
            }
            case 64: {
                logger.fine("Writing header data type as double");
                analyzeHeader.bitpix = (short)64;
                break;
            }
            case 130: {
                logger.fine("Writing header data type as byte");
                analyzeHeader.bitpix = (short)8;
                break;
            }
            case 132: {
                logger.fine("Writing header data type as ushort");
                analyzeHeader.bitpix = (short)16;
                break;
            }
            case 136: {
                logger.fine("Writing header data type as uint");
                analyzeHeader.bitpix = (short)32;
                break;
            }
            default: {
                throw new LoggedException("Unrecognized datatype " + analyzeHeader.datatype);
            }
        }
        try {
            if (OutputManager.outputFile != null) {
                if (OutputManager.outputFile.endsWith(".hdr")) {
                    analyzeHeader.setHeaderFile(OutputManager.outputFile);
                    analyzeHeader.writeHeader();
                } else {
                    analyzeHeader.setHeaderFile(OutputManager.outputFile + ".hdr");
                    analyzeHeader.writeHeader();
                }
            } else {
                OutputManager outputManager = new OutputManager();
                analyzeHeader.writeHeader(outputManager.getOutputStream());
                outputManager.close();
            }
        }
        catch (IOException iOException) {
            throw new LoggedException("Can't write header");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "Unknown";
        switch (this.datatype) {
            case 1: {
                string = "binary bit";
                break;
            }
            case 2: {
                string = "char (8-bit)";
                break;
            }
            case 4: {
                string = "short";
                break;
            }
            case 8: {
                string = "int";
                break;
            }
            case 16: {
                string = "float";
                break;
            }
            case 128: {
                string = "RGB";
                break;
            }
            case 32: {
                string = "Complex";
                break;
            }
            case 64: {
                string = "double";
                break;
            }
            case 130: {
                string = "byte (8-bit signed)";
                break;
            }
            case 132: {
                string = "ushort (16-bit unsigned)";
                break;
            }
            case 136: {
                string = "uint (32-bit unsigned)";
            }
        }
        stringBuffer.append("datatype\t: " + string + " (" + this.datatype + ")\n");
        stringBuffer.append("width\t\t: " + this.width + "\n");
        stringBuffer.append("height\t\t: " + this.height + "\n");
        stringBuffer.append("depth\t\t: " + this.depth + "\n");
        stringBuffer.append("pixelWidth\t: " + this.pixelWidth + "\n");
        stringBuffer.append("pixelHeight\t: " + this.pixelHeight + "\n");
        stringBuffer.append("pixelDepth\t: " + this.pixelDepth + "\n");
        stringBuffer.append("voxel_offset\t: " + this.vox_offset + "\n");
        stringBuffer.append("nImages\t\t: " + this.nImages + "\n");
        stringBuffer.append("intelByteOrder\t: " + this.intelByteOrder + "\n");
        stringBuffer.append("glmin\t\t: " + this.glmin + "\n");
        stringBuffer.append("glmax\t\t: " + this.glmax + "\n");
        stringBuffer.append("scale slope\t: " + this.scaleSlope + "\n");
        stringBuffer.append("scale inter\t: " + this.scaleInter + "\n");
        stringBuffer.append("bitpix\t\t: " + this.bitpix + "\n");
        stringBuffer.append("description\t: " + this.description + "\n");
        stringBuffer.append("origin\t\t: " + this.centre[0] + " " + this.centre[1] + " " + this.centre[2] + "\n");
        return stringBuffer.toString();
    }

    public static String getArgs(AnalyzeHeader analyzeHeader, String string) {
        String string2 = "Unknown";
        switch (analyzeHeader.datatype) {
            case 2: {
                string2 = "char";
                break;
            }
            case 130: {
                string2 = "byte";
                break;
            }
            case 4: {
                string2 = "short";
                break;
            }
            case 8: {
                string2 = "int";
                break;
            }
            case 132: {
                string2 = "ushort";
                break;
            }
            case 136: {
                string2 = "uint";
                break;
            }
            case 16: {
                string2 = "float";
                break;
            }
            case 64: {
                string2 = "double";
                break;
            }
            default: {
                return "Camino cannot read files of this data type";
            }
        }
        String string3 = "0 " + analyzeHeader.bitpix / 8 + " 0";
        if (analyzeHeader.intelByteOrder) {
            string3 = "0 -" + analyzeHeader.bitpix / 8 + " 0";
        }
        String string4 = "-voxels " + analyzeHeader.width * analyzeHeader.height * analyzeHeader.depth + " -inputdatatype " + string2;
        if (analyzeHeader.nImages > 1) {
            string4 = string4 + " -components " + analyzeHeader.nImages;
        }
        String string5 = "-datadims " + analyzeHeader.width + " " + analyzeHeader.height + " " + analyzeHeader.depth + " -voxeldims " + analyzeHeader.pixelWidth + " " + analyzeHeader.pixelHeight + " " + analyzeHeader.pixelDepth;
        String string6 = "-datadims " + analyzeHeader.width + " " + analyzeHeader.height + " " + analyzeHeader.depth;
        String string7 = "-datadims " + analyzeHeader.width + " " + analyzeHeader.height + " " + analyzeHeader.depth + " -voxeldims " + analyzeHeader.pixelWidth + " " + analyzeHeader.pixelHeight + " " + analyzeHeader.pixelDepth;
        if (string.equals("all")) {
            StringBuffer stringBuffer = new StringBuffer();
            if (analyzeHeader.intelByteOrder) {
                stringBuffer.append("This file is in little-endian byte order.\nConvert to network byte order with the following command:\n\tshredder " + string3 + " < [file] > [output].\n\n");
            }
            stringBuffer.append("\nCamino args computed from this header:\n");
            stringBuffer.append("Program\t\targs\n");
            stringBuffer.append("scanner2voxel\t");
            stringBuffer.append(string4);
            stringBuffer.append("\n\n");
            stringBuffer.append("pdview\t\t");
            stringBuffer.append(string5);
            stringBuffer.append("\n\n");
            stringBuffer.append("vcthreshselect\t");
            stringBuffer.append(string6);
            stringBuffer.append("\n\n");
            stringBuffer.append("track\t\t");
            stringBuffer.append(string7);
            stringBuffer.append("\n\n");
            return stringBuffer.toString();
        }
        if (string.equals("shredder")) {
            return string3;
        }
        if (string.equals("scanner2voxel")) {
            return string4;
        }
        if (string.equals("pdview")) {
            return string5;
        }
        if (string.equals("vcthreshselect")) {
            return string6;
        }
        if (string.equals("track")) {
            return string7;
        }
        return "";
    }

    public static AnalyzeHeader getHeader(int[] nArray, double[] dArray, short s) {
        AnalyzeHeader analyzeHeader = new AnalyzeHeader();
        analyzeHeader.datatype = s;
        analyzeHeader.checkBitpix();
        analyzeHeader.width = (short)nArray[0];
        analyzeHeader.height = (short)nArray[1];
        analyzeHeader.depth = (short)nArray[2];
        analyzeHeader.nImages = 1;
        analyzeHeader.pixelWidth = (float)dArray[0];
        analyzeHeader.pixelHeight = (float)dArray[1];
        analyzeHeader.pixelDepth = (float)dArray[2];
        return analyzeHeader;
    }

    public static AnalyzeHeader getHeader(double[][][] dArray, double[] dArray2, short s) {
        AnalyzeHeader analyzeHeader = AnalyzeHeader.getHeader(new int[]{dArray.length, dArray[0].length, dArray[0][0].length}, dArray2, s);
        double d = Double.MAX_VALUE;
        double d2 = -d;
        for (int i = 0; i < dArray[0][0].length; ++i) {
            for (int j = 0; j < dArray[0].length; ++j) {
                for (int k = 0; k < dArray.length; ++k) {
                    if (dArray[k][j][i] < d) {
                        d = dArray[k][j][i];
                    }
                    if (!(dArray[k][j][i] > d2)) continue;
                    d2 = dArray[k][j][i];
                }
            }
        }
        analyzeHeader.glmin = (int)d;
        analyzeHeader.glmax = (int)d2;
        return analyzeHeader;
    }

    public static AnalyzeHeader getHeader(float[][][] fArray, double[] dArray, short s) {
        AnalyzeHeader analyzeHeader = AnalyzeHeader.getHeader(new int[]{fArray.length, fArray[0].length, fArray[0][0].length}, dArray, s);
        float f = Float.MAX_VALUE;
        float f2 = -f;
        for (int i = 0; i < fArray[0][0].length; ++i) {
            for (int j = 0; j < fArray[0].length; ++j) {
                for (int k = 0; k < fArray.length; ++k) {
                    if (fArray[k][j][i] < f) {
                        f = fArray[k][j][i];
                    }
                    if (!(fArray[k][j][i] > f2)) continue;
                    f2 = fArray[k][j][i];
                }
            }
        }
        analyzeHeader.glmin = (int)f;
        analyzeHeader.glmax = (int)f2;
        return analyzeHeader;
    }

    public static void writeImage(int[][][] nArray, int[][][] nArray2, int[][][] nArray3, AnalyzeHeader analyzeHeader, String string, boolean bl) throws IOException {
        if (string.endsWith(".hdr") || string.endsWith(".img")) {
            string = string.substring(0, string.length() - 4);
        } else if (string.endsWith(".img.gz")) {
            string = string.substring(0, string.length() - 7);
        }
        FileOutputStream fileOutputStream = null;
        DataOutputStream dataOutputStream = null;
        if (bl) {
            fileOutputStream = new FileOutputStream(string + ".img.gz");
            dataOutputStream = new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(fileOutputStream), BUFFERSIZE));
        } else {
            fileOutputStream = new FileOutputStream(string + ".img");
            dataOutputStream = new DataOutputStream(new BufferedOutputStream(fileOutputStream, BUFFERSIZE));
        }
        AnalyzeHeader analyzeHeader2 = new AnalyzeHeader(analyzeHeader);
        analyzeHeader2.intelByteOrder = false;
        analyzeHeader2.datatype = (short)128;
        analyzeHeader2.bitpix = (short)24;
        analyzeHeader2.scaleSlope = 1.0f;
        analyzeHeader2.scaleInter = 0.0f;
        analyzeHeader2.setHeaderFile(string + ".hdr");
        analyzeHeader2.writeHeader();
        for (int i = 0; i < nArray[0][0].length; ++i) {
            for (int j = 0; j < nArray[0].length; ++j) {
                for (int k = 0; k < nArray.length; ++k) {
                    dataOutputStream.writeByte((byte)nArray[k][j][i]);
                    dataOutputStream.writeByte((byte)nArray2[k][j][i]);
                    dataOutputStream.writeByte((byte)nArray3[k][j][i]);
                }
            }
        }
        dataOutputStream.close();
    }

    public static void writeImage(short[][][] sArray, AnalyzeHeader analyzeHeader, String string, boolean bl) throws IOException {
        if (string.endsWith(".hdr") || string.endsWith(".img")) {
            string = string.substring(0, string.length() - 4);
        } else if (string.endsWith(".img.gz")) {
            string = string.substring(0, string.length() - 7);
        }
        FileOutputStream fileOutputStream = null;
        DataOutputStream dataOutputStream = null;
        if (bl) {
            fileOutputStream = new FileOutputStream(string + ".img.gz");
            dataOutputStream = new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(fileOutputStream), BUFFERSIZE));
        } else {
            fileOutputStream = new FileOutputStream(string + ".img");
            dataOutputStream = new DataOutputStream(new BufferedOutputStream(fileOutputStream, BUFFERSIZE));
        }
        AnalyzeHeader analyzeHeader2 = new AnalyzeHeader(analyzeHeader);
        analyzeHeader2.intelByteOrder = false;
        analyzeHeader2.setHeaderFile(string + ".hdr");
        analyzeHeader2.writeHeader();
        for (int i = 0; i < sArray[0][0].length; ++i) {
            for (int j = 0; j < sArray[0].length; ++j) {
                for (int k = 0; k < sArray.length; ++k) {
                    AnalyzeHeader.writeValue(sArray[k][j][i], dataOutputStream, analyzeHeader2);
                }
            }
        }
        dataOutputStream.close();
    }

    public static void writeImage(int[][][] nArray, AnalyzeHeader analyzeHeader, String string, boolean bl) throws IOException {
        if (string.endsWith(".hdr") || string.endsWith(".img")) {
            string = string.substring(0, string.length() - 4);
        } else if (string.endsWith(".img.gz")) {
            string = string.substring(0, string.length() - 7);
        }
        FileOutputStream fileOutputStream = null;
        DataOutputStream dataOutputStream = null;
        if (bl) {
            fileOutputStream = new FileOutputStream(string + ".img.gz");
            dataOutputStream = new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(fileOutputStream), BUFFERSIZE));
        } else {
            fileOutputStream = new FileOutputStream(string + ".img");
            dataOutputStream = new DataOutputStream(new BufferedOutputStream(fileOutputStream, BUFFERSIZE));
        }
        AnalyzeHeader analyzeHeader2 = new AnalyzeHeader(analyzeHeader);
        analyzeHeader2.intelByteOrder = false;
        analyzeHeader2.setHeaderFile(string + ".hdr");
        analyzeHeader2.writeHeader();
        for (int i = 0; i < nArray[0][0].length; ++i) {
            for (int j = 0; j < nArray[0].length; ++j) {
                for (int k = 0; k < nArray.length; ++k) {
                    AnalyzeHeader.writeValue(nArray[k][j][i], dataOutputStream, analyzeHeader2);
                }
            }
        }
        dataOutputStream.close();
    }

    public static void writeImage(float[][][] fArray, AnalyzeHeader analyzeHeader, String string, boolean bl) throws IOException {
        if (string.endsWith(".hdr") || string.endsWith(".img")) {
            string = string.substring(0, string.length() - 4);
        } else if (string.endsWith(".img.gz")) {
            string = string.substring(0, string.length() - 7);
        }
        FileOutputStream fileOutputStream = null;
        DataOutputStream dataOutputStream = null;
        if (bl) {
            fileOutputStream = new FileOutputStream(string + ".img.gz");
            dataOutputStream = new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(fileOutputStream), BUFFERSIZE));
        } else {
            fileOutputStream = new FileOutputStream(string + ".img");
            dataOutputStream = new DataOutputStream(new BufferedOutputStream(fileOutputStream, BUFFERSIZE));
        }
        AnalyzeHeader analyzeHeader2 = new AnalyzeHeader(analyzeHeader);
        analyzeHeader2.intelByteOrder = false;
        analyzeHeader2.setHeaderFile(string + ".hdr");
        analyzeHeader2.writeHeader();
        for (int i = 0; i < fArray[0][0].length; ++i) {
            for (int j = 0; j < fArray[0].length; ++j) {
                for (int k = 0; k < fArray.length; ++k) {
                    AnalyzeHeader.writeValue(fArray[k][j][i], dataOutputStream, analyzeHeader2);
                }
            }
        }
        dataOutputStream.close();
    }

    public static void writeImage(double[][][] dArray, AnalyzeHeader analyzeHeader, String string, boolean bl) throws IOException {
        if (string.endsWith(".hdr") || string.endsWith(".img")) {
            string = string.substring(0, string.length() - 4);
        } else if (string.endsWith(".img.gz")) {
            string = string.substring(0, string.length() - 7);
        }
        FileOutputStream fileOutputStream = null;
        DataOutputStream dataOutputStream = null;
        if (bl) {
            fileOutputStream = new FileOutputStream(string + ".img.gz");
            dataOutputStream = new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(fileOutputStream), BUFFERSIZE));
        } else {
            fileOutputStream = new FileOutputStream(string + ".img");
            dataOutputStream = new DataOutputStream(new BufferedOutputStream(fileOutputStream, BUFFERSIZE));
        }
        AnalyzeHeader analyzeHeader2 = new AnalyzeHeader(analyzeHeader);
        analyzeHeader2.intelByteOrder = false;
        analyzeHeader2.setHeaderFile(string + ".hdr");
        analyzeHeader2.writeHeader();
        for (int i = 0; i < dArray[0][0].length; ++i) {
            for (int j = 0; j < dArray[0].length; ++j) {
                for (int k = 0; k < dArray.length; ++k) {
                    AnalyzeHeader.writeValue(dArray[k][j][i], dataOutputStream, analyzeHeader2);
                }
            }
        }
        dataOutputStream.close();
    }

    private static final void writeValue(double d, DataOutputStream dataOutputStream, AnalyzeHeader analyzeHeader) throws IOException {
        double d2 = d;
        if ((double)analyzeHeader.scaleSlope != 0.0) {
            d2 = (d - (double)analyzeHeader.scaleInter) / (double)analyzeHeader.scaleSlope;
        }
        if (analyzeHeader.datatype == 64) {
            dataOutputStream.writeDouble(d2);
        } else if (analyzeHeader.datatype == 16) {
            dataOutputStream.writeFloat((float)d2);
        } else if (analyzeHeader.datatype == 8) {
            dataOutputStream.writeInt((int)d2);
        } else if (analyzeHeader.datatype == 136) {
            long l = (long)d2;
            long l2 = 0xFFFFFFFFL;
            if (l > l2) {
                l = l2;
            }
            if (l < 0L) {
                l = 0L;
            }
            dataOutputStream.writeInt((int)l);
        } else if (analyzeHeader.datatype == 4) {
            dataOutputStream.writeShort((short)d2);
        } else if (analyzeHeader.datatype == 132) {
            int n = (int)d2;
            int n2 = 65534;
            if (n > n2) {
                n = n2;
            }
            if (n < 0) {
                n = 0;
            }
            dataOutputStream.writeShort((short)n);
        } else if (analyzeHeader.datatype == 2) {
            int n = (int)d2;
            if (n < 0) {
                n = 0;
            } else if (n > 255) {
                n = 255;
            }
            dataOutputStream.writeByte((byte)(n & 0xFF));
        } else if (analyzeHeader.datatype == 130) {
            dataOutputStream.writeByte((byte)d2);
        }
    }

    public void setHeaderFile(String string) {
        String string2 = string;
        if (string2.endsWith(".hdr")) {
            string2 = string2.substring(0, string2.length() - 4);
        }
        this.hdrFile = string2 + ".hdr";
        this.dataFile = AnalyzeHeader.getIMG_File(this.hdrFile);
    }

    public String getHeaderFile(String string) {
        return this.hdrFile;
    }

    public String caminoDataTypeString() {
        if (this.datatype == 2) {
            return "char";
        }
        if (this.datatype == 130) {
            return "byte";
        }
        if (this.datatype == 4) {
            return "short";
        }
        if (this.datatype == 8) {
            return "int";
        }
        if (this.datatype == 132) {
            return "ushort";
        }
        if (this.datatype == 136) {
            return "uint";
        }
        if (this.datatype == 16) {
            return "float";
        }
        if (this.datatype == 64) {
            return "double";
        }
        throw new LoggedException("Header does not have a supported Camino data type");
    }

    public static String getIMG_File(String string) {
        String string2;
        String string3 = string;
        if (string3.endsWith(".hdr")) {
            string3 = string3.substring(0, string3.length() - 4);
        }
        if (!new File(string2 = string3 + ".img").exists() && !new File(string2 = string3 + ".img.gz").exists()) {
            return null;
        }
        return string2;
    }

    public static String getImageRoot(String string) {
        String string2 = null;
        string2 = string.endsWith(".hdr") ? string.substring(0, string.length() - 4) : (string.endsWith(".img") ? string.substring(0, string.length() - 4) : (string.endsWith(".img.gz") ? string.substring(0, string.length() - 7) : string));
        if (new File(string2 + ".hdr").exists()) {
            if (new File(string2 + ".img").exists() || new File(string2 + ".img.gz").exists()) {
                return string2;
            }
            return null;
        }
        return null;
    }

    @Override
    public int xDataDim() {
        return this.width;
    }

    @Override
    public int yDataDim() {
        return this.height;
    }

    @Override
    public int zDataDim() {
        return this.depth;
    }

    @Override
    public int[] getDataDims() {
        return new int[]{this.width, this.height, this.depth};
    }

    @Override
    public double xVoxelDim() {
        return this.pixelWidth;
    }

    @Override
    public double yVoxelDim() {
        return this.pixelHeight;
    }

    @Override
    public double zVoxelDim() {
        return this.pixelDepth;
    }

    @Override
    public double[] getVoxelDims() {
        return new double[]{this.pixelWidth, this.pixelHeight, this.pixelDepth};
    }

    @Override
    public double[] getOrigin() {
        return new double[]{this.centre[0], this.centre[1], this.centre[2]};
    }

    @Override
    public int components() {
        return this.nImages > 0 ? this.nImages : (short)1;
    }

    @Override
    public DataSource getImageDataSource() {
        double d;
        if (this.dataFile == null) {
            this.dataFile = AnalyzeHeader.getIMG_File(this.hdrFile);
            if (this.dataFile == null) {
                throw new DataSourceException("Can't find image data for " + this.hdrFile);
            }
        }
        double d2 = (double)this.scaleSlope == 0.0 ? 1.0 : (double)this.scaleSlope;
        double d3 = d = (double)this.scaleSlope == 0.0 ? 0.0 : (double)this.scaleInter;
        if (this.components() == 1) {
            if (d != 0.0 || d2 != 1.0) {
                return new VoxelOrderScaledDataSource(this.dataFile, 1, this.caminoDataTypeString(), this.intelByteOrder, (int)Math.abs(this.vox_offset), d2, d);
            }
            return new VoxelOrderDataSource(this.dataFile, 1, this.caminoDataTypeString(), this.intelByteOrder, (int)Math.abs(this.vox_offset));
        }
        int n = this.width * this.height * this.depth;
        double[][] dArray = new double[n][this.components()];
        VoxelOrderDataSource voxelOrderDataSource = new VoxelOrderDataSource(this.dataFile, 1, this.caminoDataTypeString(), this.intelByteOrder, (int)Math.abs(this.vox_offset));
        for (int i = 0; i < this.components(); ++i) {
            int n2;
            if (this.vox_offset < 0.0f) {
                n2 = this.bitpix / 8 * i * n + (i + 1) * (int)Math.abs(this.vox_offset);
                voxelOrderDataSource = new VoxelOrderDataSource(this.dataFile, 1, this.caminoDataTypeString(), this.intelByteOrder, n2);
            }
            for (n2 = 0; n2 < n; ++n2) {
                dArray[n2][i] = voxelOrderDataSource.nextVoxel()[0] * d2 + d;
            }
        }
        ScannerOrderDataSource scannerOrderDataSource = new ScannerOrderDataSource(dArray);
        return scannerOrderDataSource;
    }

    @Override
    public double[][][][] readVolumeData() {
        double d;
        if (this.dataFile == null) {
            this.dataFile = AnalyzeHeader.getIMG_File(this.hdrFile);
            if (this.dataFile == null) {
                throw new DataSourceException("Can't find image data for " + this.hdrFile);
            }
        }
        double d2 = (double)this.scaleSlope == 0.0 ? 1.0 : (double)this.scaleSlope;
        double d3 = d = (double)this.scaleSlope == 0.0 ? 0.0 : (double)this.scaleInter;
        if (this.dataFile == null) {
            throw new LoggedException("Can't find image data for " + this.hdrFile);
        }
        try {
            double[][][][] dArray = null;
            int n = this.width;
            int n2 = this.height;
            int n3 = this.depth;
            dArray = new double[n][n2][n3][this.components()];
            VoxelOrderDataSource voxelOrderDataSource = new VoxelOrderDataSource(this.dataFile, 1, this.caminoDataTypeString(), this.intelByteOrder, (int)Math.abs(this.vox_offset));
            for (int i = 0; i < this.components(); ++i) {
                int n4;
                if (this.vox_offset < 0.0f) {
                    n4 = this.bitpix / 8 * i * this.width * this.height * this.depth + (i + 1) * (int)Math.abs(this.vox_offset);
                    voxelOrderDataSource = new VoxelOrderDataSource(this.dataFile, 1, this.caminoDataTypeString(), this.intelByteOrder, n4);
                }
                for (n4 = 0; n4 < n3; ++n4) {
                    for (int j = 0; j < n2; ++j) {
                        for (int k = 0; k < n; ++k) {
                            dArray[k][j][n4][i] = voxelOrderDataSource.nextVoxel()[0] * d2 + d;
                        }
                    }
                }
            }
            return dArray;
        }
        catch (DataSourceException dataSourceException) {
            throw new LoggedException(dataSourceException);
        }
    }

    @Override
    public double[][][] readVolume(int n) {
        if (n < 0 || n >= this.components()) {
            throw new LoggedException("Attempted to read non-existent volume " + n);
        }
        double d = (double)this.scaleSlope == 0.0 ? 1.0 : (double)this.scaleSlope;
        double d2 = (double)this.scaleSlope == 0.0 ? 0.0 : (double)this.scaleInter;
        int n2 = 0;
        n2 = this.vox_offset < 0.0f ? this.bitpix / 8 * n * this.width * this.height * this.depth + (n + 1) * (int)Math.abs(this.vox_offset) : this.bitpix / 8 * n * this.width * this.height * this.depth + (int)Math.abs(this.vox_offset);
        VoxelOrderDataSource voxelOrderDataSource = new VoxelOrderDataSource(this.dataFile, 1, this.caminoDataTypeString(), this.intelByteOrder, n2);
        int n3 = this.width;
        int n4 = this.height;
        int n5 = this.depth;
        double[][][] dArray = new double[n3][n4][n5];
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n4; ++j) {
                for (int k = 0; k < n3; ++k) {
                    dArray[k][j][i] = voxelOrderDataSource.nextVoxel()[0] * d + d2;
                }
            }
        }
        return dArray;
    }
}

