/*
 * Decompiled with CFR 0.152.
 */
package apps;

import data.OutputManager;
import imaging.ImageHeader;
import java.io.DataOutputStream;
import java.io.IOException;
import misc.LoggedException;
import misc.ScalarImage;
import numerics.Point3D;
import numerics.Vector3D;
import tools.CL_Initializer;
import tractography.Tract;
import tractography.TractCollection;
import tractography.TractSource;
import tractography.Voxel;
import tractography.VoxelList;

public class VTK_Streamlines {
    private static OutputManager om;

    public static void main(String[] stringArray) {
        TractCollection tractCollection;
        Object object;
        int n;
        CL_Initializer.inputModel = "raw";
        CL_Initializer.CL_init(stringArray);
        om = new OutputManager();
        DataOutputStream dataOutputStream = om.getOutputStream();
        int n2 = CL_Initializer.dataDims[0];
        int n3 = CL_Initializer.dataDims[1];
        int n4 = CL_Initializer.dataDims[2];
        double d = Math.abs(CL_Initializer.voxelDims[0]);
        double d2 = Math.abs(CL_Initializer.voxelDims[1]);
        double d3 = Math.abs(CL_Initializer.voxelDims[2]);
        double[][][] dArray = null;
        ScalarImage scalarImage = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equals("-scalarfile")) {
                string2 = stringArray[n + 1];
                bl4 = true;
                CL_Initializer.markAsParsed(n, 2);
            } else if (stringArray[n].equals("-targetfile")) {
                string3 = stringArray[n + 1];
                bl2 = true;
                CL_Initializer.markAsParsed(n, 2);
            } else if (stringArray[n].equals("-seedfile")) {
                string = stringArray[n + 1];
                bl = true;
                CL_Initializer.markAsParsed(n, 2);
            } else if (stringArray[n].equals("-colourorient")) {
                bl3 = true;
                CL_Initializer.markAsParsed(n);
            }
            if (!stringArray[n].equals("-interpolatescalars") && !stringArray[n].equals("-interpolate")) continue;
            bl5 = true;
            CL_Initializer.markAsParsed(n);
        }
        CL_Initializer.checkParsing(stringArray);
        n = bl4 || bl2 || bl || bl3 ? 1 : 0;
        String string4 = null;
        if (bl4) {
            string4 = string2;
        }
        if (bl2) {
            string4 = string3;
        }
        if (bl) {
            string4 = string;
        }
        if (string4 != null) {
            object = null;
            tractCollection = null;
            try {
                object = ImageHeader.readHeader(string4);
            }
            catch (IOException iOException) {
                throw new LoggedException("Can't read file " + string4, iOException);
            }
            ImageHeader.checkDims(string4, CL_Initializer.dataDims, CL_Initializer.voxelDims);
            n2 = CL_Initializer.dataDims[0];
            n3 = CL_Initializer.dataDims[1];
            n4 = CL_Initializer.dataDims[2];
            d = Math.abs(CL_Initializer.voxelDims[0]);
            d2 = Math.abs(CL_Initializer.voxelDims[1]);
            d3 = Math.abs(CL_Initializer.voxelDims[2]);
            dArray = ((ImageHeader)object).readVolume(0);
            if (bl4) {
                scalarImage = new ScalarImage(dArray, new double[]{d, d2, d3});
                if (bl5) {
                    scalarImage.setInterpolation("linear");
                }
            }
        }
        if (CL_Initializer.inputModel.equals("voxels") && (d <= 0.0 || d2 <= 0.0 || d3 <= 0.0)) {
            throw new LoggedException("Input model is voxels, but voxel dimensions are not > 0.");
        }
        object = new TractSource(CL_Initializer.inputFile, CL_Initializer.inputModel, d, d2, d3);
        tractCollection = new TractCollection(1000, 100.0);
        while (((TractSource)object).more()) {
            tractCollection.addTract(((TractSource)object).nextTract());
        }
        try {
            int n5;
            Object object2;
            int n6;
            String string5 = "# vtk DataFile Version 3.0\nCamino tracts\nBINARY\nDATASET POLYDATA\n";
            string5 = string5 + "POINTS " + tractCollection.totalPoints() + " float\n";
            dataOutputStream.write(string5.getBytes("US-ASCII"));
            for (int i = 0; i < tractCollection.numberOfTracts(); ++i) {
                Tract tract = tractCollection.getTract(i);
                for (n6 = 0; n6 < tract.numberOfPoints(); ++n6) {
                    object2 = tract.getPoint(n6);
                    dataOutputStream.writeFloat((float)((Point3D)object2).x);
                    dataOutputStream.writeFloat((float)((Point3D)object2).y);
                    dataOutputStream.writeFloat((float)((Point3D)object2).z);
                }
            }
            String string6 = "\nLINES " + tractCollection.numberOfTracts() + " " + (tractCollection.numberOfTracts() + tractCollection.totalPoints()) + "\n";
            dataOutputStream.write(string6.getBytes("US-ASCII"));
            int n7 = 0;
            for (n6 = 0; n6 < tractCollection.numberOfTracts(); ++n6) {
                object2 = tractCollection.getTract(n6);
                dataOutputStream.writeInt(((Tract)object2).numberOfPoints());
                for (n5 = 0; n5 < ((Tract)object2).numberOfPoints(); ++n5) {
                    dataOutputStream.writeInt(n7);
                    ++n7;
                }
            }
            String string7 = "CELL_DATA " + tractCollection.numberOfTracts() + "\nPOINT_DATA " + tractCollection.totalPoints() + "\n";
            dataOutputStream.write(string7.getBytes("US-ASCII"));
            if (n != 0) {
                object2 = "";
                if (bl3) {
                    object2 = "COLOR_SCALARS RGB_scalars 3\n";
                } else if (bl2) {
                    object2 = "SCALARS target_scalars float 1\nLOOKUP_TABLE default\n";
                } else if (bl) {
                    object2 = "SCALARS seed_scalars float 1\nLOOKUP_TABLE default\n";
                } else if (bl4) {
                    object2 = "SCALARS custom_scalars float 1\nLOOKUP_TABLE default\n";
                }
                dataOutputStream.write(((String)object2).getBytes("US-ASCII"));
                for (n5 = 0; n5 < tractCollection.numberOfTracts(); ++n5) {
                    int n8;
                    int n9;
                    int n10;
                    Tract tract = tractCollection.getTract(n5);
                    if (bl3) {
                        Point3D point3D = null;
                        Point3D point3D2 = null;
                        Vector3D vector3D = new Vector3D(1.0, 0.0, 0.0);
                        for (n10 = 0; n10 < tract.numberOfPoints() - 1; ++n10) {
                            point3D = tract.getPoint(n10);
                            point3D2 = tract.getPoint(n10 + 1);
                            vector3D = new Vector3D(point3D, point3D2).normalized();
                            dataOutputStream.writeByte((byte)(255.0 * Math.abs(vector3D.x)));
                            dataOutputStream.writeByte((byte)(255.0 * Math.abs(vector3D.y)));
                            dataOutputStream.writeByte((byte)(255.0 * Math.abs(vector3D.z)));
                        }
                        dataOutputStream.writeByte((byte)(255.0 * Math.abs(vector3D.x)));
                        dataOutputStream.writeByte((byte)(255.0 * Math.abs(vector3D.y)));
                        dataOutputStream.writeByte((byte)(255.0 * Math.abs(vector3D.z)));
                        continue;
                    }
                    if (bl2) {
                        int n11;
                        VoxelList voxelList = tract.toVoxelList(d, d2, d3);
                        Voxel[] voxelArray = voxelList.getVoxels();
                        int n12 = voxelList.seedPointIndex();
                        n10 = 0;
                        n9 = 0;
                        for (n8 = n12; n8 < voxelArray.length; ++n8) {
                            n11 = (int)dArray[voxelArray[n8].x][voxelArray[n8].y][voxelArray[n8].z];
                            if (n11 <= 0) continue;
                            n10 = n11;
                            break;
                        }
                        for (n8 = n12; n8 >= 0; --n8) {
                            n11 = (int)dArray[voxelArray[n8].x][voxelArray[n8].y][voxelArray[n8].z];
                            if (n11 <= 0) continue;
                            n9 = n11;
                            break;
                        }
                        if (n10 > 0 && n9 == 0) {
                            n9 = n10;
                        } else if (n10 == 0 && n9 > 0) {
                            n10 = n9;
                        }
                        for (n8 = 0; n8 < tract.seedPointIndex(); ++n8) {
                            dataOutputStream.writeFloat(n9);
                        }
                        for (n8 = tract.seedPointIndex(); n8 < tract.numberOfPoints(); ++n8) {
                            dataOutputStream.writeFloat(n10);
                        }
                        continue;
                    }
                    if (bl) {
                        Point3D point3D = tract.getPoint(tract.seedPointIndex());
                        int n13 = (int)(point3D.x / d);
                        int n14 = (int)(point3D.y / d2);
                        n10 = (int)(point3D.z / d3);
                        n9 = (int)dArray[n13][n14][n10];
                        for (n8 = 0; n8 < tract.numberOfPoints(); ++n8) {
                            dataOutputStream.writeFloat(n9);
                        }
                        continue;
                    }
                    if (!bl4) continue;
                    for (int i = 0; i < tract.numberOfPoints(); ++i) {
                        Point3D point3D = tract.getPoint(i);
                        dataOutputStream.writeFloat((float)scalarImage.valueAt(point3D));
                    }
                }
            }
            om.close();
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
    }
}

