/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.StreamlineTractography;
import data.OutputManager;
import imaging.AnalyzeHeader;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Locale;
import misc.LoggedException;
import tools.CL_Initializer;
import tools.FileOutput;
import tractography.FreeFormROI;
import tractography.Voxel;

public class TargetProbsToASCII {
    private static int minTargetIndex = 0;
    private static int maxTargetIndex = 0;
    private static int[] targetIndices = null;
    private static boolean[] targetExists = null;

    public static void main(String[] stringArray) {
        Locale.setDefault(Locale.UK);
        String string = null;
        String string2 = null;
        String string3 = null;
        int n = 1;
        int n2 = 1;
        CL_Initializer.CL_init(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-inputroot")) {
                string = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-targetfile")) {
                string2 = stringArray[i + 1];
                if (string2.endsWith(".hdr")) {
                    string2 = string2.substring(0, string2.length() - 4);
                }
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-seedfile")) {
                string3 = stringArray[i + 1];
                if (string3.endsWith(".hdr")) {
                    string3 = string3.substring(0, string3.length() - 4);
                }
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-pd")) {
                n2 = Integer.parseInt(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (!stringArray[i].equals("-regionindex")) continue;
            n = Integer.parseInt(stringArray[i + 1]);
            CL_Initializer.markAsParsed(i, 2);
        }
        CL_Initializer.checkParsing(stringArray);
        AnalyzeHeader analyzeHeader = null;
        try {
            analyzeHeader = AnalyzeHeader.readHeader(string3);
        }
        catch (IOException iOException) {
            throw new LoggedException("Cannot read header of seed file");
        }
        int n3 = analyzeHeader.width;
        int n4 = analyzeHeader.height;
        int n5 = analyzeHeader.depth;
        double d = Math.abs(analyzeHeader.pixelWidth);
        double d2 = Math.abs(analyzeHeader.pixelHeight);
        double d3 = Math.abs(analyzeHeader.pixelDepth);
        short[][][] sArray = StreamlineTractography.readShortVolume(string3);
        string = string + Integer.toString(n) + "_";
        if (!new File(string + "1_" + n2 + "_0.hdr").exists()) {
            throw new LoggedException("Cannot find connection probability files matching input root");
        }
        double[][][] dArray = null;
        try {
            dArray = AnalyzeHeader.readHeader(string2).readVolume(0);
        }
        catch (IOException iOException) {
            throw new LoggedException("Cannot read header of target file");
        }
        TargetProbsToASCII.setTargetIndices(dArray);
        Voxel[] voxelArray = new FreeFormROI(sArray, (short)n, d, d2, d3).getVoxels();
        String string4 = "";
        int n6 = 6;
        for (int i = 0; i < n6; ++i) {
            string4 = string4 + "0";
        }
        DecimalFormat decimalFormat = new DecimalFormat("0." + string4 + "E00;-0." + string4 + "E00");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 2; ++i) {
            int n7 = 1;
            String string5 = string + n7 + "_" + n2 + "_" + i;
            while (new File(string5 + ".hdr").exists()) {
                int n8;
                double[] dArray2 = new double[maxTargetIndex - minTargetIndex + 1];
                double[][][] dArray3 = null;
                try {
                    dArray3 = AnalyzeHeader.readHeader(string5 + ".hdr").readVolume(0);
                }
                catch (IOException iOException) {
                    throw new LoggedException("Cannot read header " + string5 + ".hdr");
                }
                for (int j = 0; j < n5; ++j) {
                    for (n8 = 0; n8 < n4; ++n8) {
                        for (int k = 0; k < n3; ++k) {
                            if (!(dArray3[k][n8][j] > 0.0)) continue;
                            dArray2[TargetProbsToASCII.targetIndices[(int)dArray[k][n8][j]]] = dArray3[k][n8][j];
                        }
                    }
                }
                String string6 = "\t";
                stringBuffer.append(voxelArray[n7 - 1].x + string6 + voxelArray[n7 - 1].y + string6 + voxelArray[n7 - 1].z + string6);
                for (n8 = minTargetIndex; n8 <= maxTargetIndex; ++n8) {
                    if (!targetExists[n8]) continue;
                    stringBuffer.append(decimalFormat.format(dArray2[targetIndices[n8]]));
                    if (n8 >= maxTargetIndex) continue;
                    stringBuffer.append(string6);
                }
                stringBuffer.append("\n");
                string5 = string + ++n7 + "_" + n2 + "_" + i;
            }
        }
        if (OutputManager.outputFile != null) {
            FileOutput fileOutput = new FileOutput(OutputManager.outputFile);
            fileOutput.writeString(stringBuffer.toString());
            fileOutput.close();
        } else {
            System.out.print(stringBuffer.toString());
        }
    }

    private static void setTargetIndices(double[][][] dArray) {
        int n;
        int n2;
        int n3 = Short.MAX_VALUE;
        int n4 = 0;
        int n5 = dArray.length;
        int n6 = dArray[0].length;
        int n7 = dArray[0][0].length;
        targetExists = new boolean[Short.MAX_VALUE];
        for (n2 = 0; n2 < n7; ++n2) {
            for (n = 0; n < n6; ++n) {
                for (int i = 0; i < n5; ++i) {
                    if (dArray[i][n][n2] < (double)n3 && dArray[i][n][n2] > 0.0) {
                        n3 = (short)dArray[i][n][n2];
                    } else if (dArray[i][n][n2] > (double)n4) {
                        n4 = (short)dArray[i][n][n2];
                    }
                    if (!(dArray[i][n][n2] > 0.0)) continue;
                    TargetProbsToASCII.targetExists[(short)((int)dArray[i][n][n2])] = true;
                }
            }
        }
        minTargetIndex = n3;
        maxTargetIndex = n4;
        n2 = 0;
        targetIndices = new int[maxTargetIndex + 1];
        for (n = minTargetIndex; n <= maxTargetIndex; ++n) {
            if (!targetExists[n]) continue;
            TargetProbsToASCII.targetIndices[n] = n2++;
        }
    }
}

