/*
 * Decompiled with CFR 0.152.
 */
package apps;

import Jama.Matrix;
import data.DataSource;
import data.OutputManager;
import data.VoxelOrderDataSource;
import imaging.ImageHeader;
import imaging.MetaImageHeader;
import imaging.Nifti1Dataset;
import java.io.IOException;
import java.util.ArrayList;
import misc.LoggedException;
import numerics.ACG_Fitter;
import numerics.BinghamFitter;
import numerics.ConvergenceException;
import numerics.EigenSystem3D;
import numerics.RealMatrix;
import numerics.SphericalDistributionFitter;
import numerics.Vector3D;
import numerics.WatsonFitter;
import tools.CL_Initializer;

public class SphPDF_Fit {
    private static OutputManager om;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] stringArray) {
        int n;
        boolean bl = true;
        CL_Initializer.inputModel = "vector";
        boolean bl2 = true;
        String string = "bingham";
        Vector3D vector3D = null;
        Vector3D vector3D2 = null;
        Vector3D vector3D3 = null;
        int n2 = 0;
        String string2 = "raw";
        CL_Initializer.inputDataType = "double";
        CL_Initializer.CL_init(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-pdf")) {
                string = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-evecs")) {
                vector3D = Vector3D.vectorFromSPC(1.0, Double.parseDouble(stringArray[i + 1]), Double.parseDouble(stringArray[i + 2]));
                vector3D2 = Vector3D.vectorFromSPC(1.0, Double.parseDouble(stringArray[i + 3]), Double.parseDouble(stringArray[i + 4]));
                vector3D3 = Vector3D.vectorFromSPC(1.0, Double.parseDouble(stringArray[i + 5]), Double.parseDouble(stringArray[i + 6]));
                CL_Initializer.markAsParsed(i, 7);
            }
            if (stringArray[i].equals("-outputpicoformat")) {
                bl2 = false;
                CL_Initializer.markAsParsed(i);
            }
            if (!stringArray[i].equals("-vectorspervoxel")) continue;
            n2 = Integer.parseInt(stringArray[i + 1]);
            CL_Initializer.markAsParsed(i, 2);
        }
        CL_Initializer.checkParsing(stringArray);
        if (CL_Initializer.inputFile != null) {
            if (CL_Initializer.inputFile.endsWith(".mha") || CL_Initializer.inputFile.endsWith(".mhd")) {
                string2 = "meta";
            } else if (CL_Initializer.inputFile.endsWith(".nii") || CL_Initializer.inputFile.endsWith(".nii.gz")) {
                string2 = "nifti";
                bl = false;
            }
        }
        om = new OutputManager();
        DataSource dataSource = null;
        if (string.equals("acg") && !CL_Initializer.inputModel.equals("vector")) {
            throw new LoggedException("Need vectors to fit ACG");
        }
        if (string2.equals("meta") && CL_Initializer.inputFile == null) {
            throw new LoggedException("Meta files must be input with -inputfile");
        }
        DataSource dataSource2 = null;
        if (CL_Initializer.bgMaskFile != null) {
            CL_Initializer.initMaskSource();
            dataSource2 = CL_Initializer.bgMask;
        }
        Vector3D[] vector3DArray = null;
        EigenSystem3D eigenSystem3D = null;
        if (CL_Initializer.inputModel.equals("vector")) {
            Object object;
            if (string2.equals("raw")) {
                dataSource = new VoxelOrderDataSource(CL_Initializer.inputFile, 3, CL_Initializer.inputDataType);
            } else if (string2.equals("meta")) {
                try {
                    object = MetaImageHeader.readHeader(CL_Initializer.inputFile);
                    dataSource = ((MetaImageHeader)object).getImageDataSource();
                }
                catch (IOException iOException) {
                    throw new LoggedException(iOException);
                }
            }
            if (n2 == 0) {
                object = new ArrayList(2000);
                n = 0;
                while (dataSource.more()) {
                    ((ArrayList)object).add(new Vector3D(dataSource.nextVoxel()));
                    ++n;
                }
                n2 = n;
                vector3DArray = new Vector3D[n2];
                ((ArrayList)object).toArray(vector3DArray);
                eigenSystem3D = SphericalDistributionFitter.tBarEigenSystem(vector3DArray);
            } else {
                vector3DArray = new Vector3D[n2];
                for (int i = 0; i < n2; ++i) {
                    vector3DArray[i] = new Vector3D(dataSource.nextVoxel());
                }
                eigenSystem3D = SphericalDistributionFitter.tBarEigenSystem(vector3DArray);
            }
        } else if (CL_Initializer.inputModel.equals("dyad")) {
            ImageHeader imageHeader;
            if (string2.equals("raw")) {
                dataSource = new VoxelOrderDataSource(CL_Initializer.inputFile, 6, CL_Initializer.inputDataType);
            } else if (string2.equals("meta")) {
                try {
                    imageHeader = MetaImageHeader.readHeader(CL_Initializer.inputFile);
                    dataSource = ((MetaImageHeader)imageHeader).getImageDataSource();
                }
                catch (IOException iOException) {
                    throw new LoggedException(iOException);
                }
            } else if (string2.equals("nifti")) {
                imageHeader = new Nifti1Dataset(CL_Initializer.inputFile);
                dataSource = ((Nifti1Dataset)imageHeader).getImageDataSource();
            }
            eigenSystem3D = SphericalDistributionFitter.tBarEigenSystem(dataSource.nextVoxel(), bl);
        }
        int n3 = 0;
        n = 0;
        while (n == 0) {
            int n4;
            n = !dataSource.more() ? 1 : 0;
            double[] dArray = null;
            boolean bl3 = false;
            if (dataSource2 != null && dataSource2.nextVoxel()[0] == 0.0 || eigenSystem3D.eigenvalues[0] == 0.0) {
                bl3 = true;
                if (string.equals("bingham")) {
                    dArray = new double[2];
                } else if (string.equals("watson")) {
                    dArray = new double[1];
                } else {
                    if (!string.equals("acg")) throw new LoggedException("Unrecognized pdf: " + string);
                    dArray = new double[3];
                }
            } else {
                try {
                    if (string.equals("bingham")) {
                        dArray = SphPDF_Fit.getBinghamConcentrationParams(eigenSystem3D);
                    } else if (string.equals("watson")) {
                        dArray = SphPDF_Fit.getWatsonConcentrationParams(eigenSystem3D, vector3DArray);
                    } else {
                        if (!string.equals("acg")) throw new LoggedException("Unrecognized pdf: " + string);
                        dArray = SphPDF_Fit.getACGConcentrationParams(vector3DArray);
                    }
                }
                catch (LoggedException loggedException) {
                    for (n4 = 0; n4 < dArray.length; ++n4) {
                        dArray[n4] = 0.0;
                    }
                    System.err.println("Couldn't fit params in voxel " + n3 + ", scatter matrix eig\n" + eigenSystem3D);
                }
                if (!(Math.abs(dArray[0]) < 1000000.0)) {
                    for (int i = 0; i < dArray.length; ++i) {
                        dArray[i] = 0.0;
                    }
                    System.err.println("Couldn't fit params in voxel " + n3 + ", scatter matrix eig\n" + eigenSystem3D);
                }
            }
            if (bl2) {
                om.output(dArray);
            } else {
                double[] dArray2 = new double[9];
                if (vector3D != null) {
                    dArray2[0] = vector3D.x;
                    dArray2[1] = vector3D.y;
                    dArray2[2] = vector3D.z;
                    dArray2[3] = vector3D2.x;
                    dArray2[4] = vector3D2.y;
                    dArray2[5] = vector3D2.z;
                    dArray2[6] = vector3D3.x;
                    dArray2[7] = vector3D3.y;
                    dArray2[8] = vector3D3.z;
                } else {
                    for (n4 = 0; n4 < 3; ++n4) {
                        dArray2[3 * n4] = eigenSystem3D.eigenvectors[n4].x;
                        dArray2[3 * n4 + 1] = eigenSystem3D.eigenvectors[n4].y;
                        dArray2[3 * n4 + 2] = eigenSystem3D.eigenvectors[n4].z;
                    }
                }
                om.output(new double[]{bl3 ? 0.0 : 1.0, 1.0});
                om.output(dArray2);
                om.output(dArray);
            }
            ++n3;
            if (n != 0) continue;
            if (CL_Initializer.inputModel.equals("vector")) {
                vector3DArray = new Vector3D[n2];
                for (int i = 0; i < n2; ++i) {
                    vector3DArray[i] = new Vector3D(dataSource.nextVoxel());
                }
                eigenSystem3D = SphericalDistributionFitter.tBarEigenSystem(vector3DArray);
                continue;
            }
            if (!CL_Initializer.inputModel.equals("dyad")) continue;
            eigenSystem3D = SphericalDistributionFitter.tBarEigenSystem(dataSource.nextVoxel(), bl);
        }
        om.close();
    }

    protected static double[] getWatsonConcentrationParams(Vector3D[] vector3DArray) {
        EigenSystem3D eigenSystem3D = SphericalDistributionFitter.tBarEigenSystem(vector3DArray);
        if (vector3DArray != null) {
            return new double[]{WatsonFitter.fitKappa(eigenSystem3D, vector3DArray)};
        }
        return new double[]{WatsonFitter.fitKappa(eigenSystem3D)};
    }

    protected static double[] getWatsonConcentrationParams(EigenSystem3D eigenSystem3D, Vector3D[] vector3DArray) {
        if (vector3DArray != null) {
            return new double[]{WatsonFitter.fitKappa(eigenSystem3D, vector3DArray)};
        }
        return new double[]{WatsonFitter.fitKappa(eigenSystem3D)};
    }

    protected static double[] getBinghamConcentrationParams(EigenSystem3D eigenSystem3D) {
        try {
            double[] dArray = BinghamFitter.bngpar(eigenSystem3D.eigenvalues[1], eigenSystem3D.eigenvalues[2]);
            return new double[]{dArray[0], dArray[1]};
        }
        catch (ConvergenceException convergenceException) {
            return new double[]{0.0, 0.0};
        }
    }

    protected static double[] getBinghamConcentrationParams(Vector3D[] vector3DArray) {
        EigenSystem3D eigenSystem3D = SphericalDistributionFitter.tBarEigenSystem(vector3DArray);
        try {
            double[] dArray = BinghamFitter.bngpar(eigenSystem3D.eigenvalues[1], eigenSystem3D.eigenvalues[2]);
            return new double[]{dArray[0], dArray[1]};
        }
        catch (ConvergenceException convergenceException) {
            return new double[]{0.0, 0.0};
        }
    }

    protected static double[] getACGConcentrationParams(Vector3D[] vector3DArray) {
        RealMatrix realMatrix = ACG_Fitter.findA(vector3DArray);
        Matrix matrix = new Matrix(3, 3);
        matrix.set(0, 0, realMatrix.entries[0][0]);
        matrix.set(0, 1, realMatrix.entries[0][1]);
        matrix.set(0, 2, realMatrix.entries[0][2]);
        matrix.set(1, 0, realMatrix.entries[1][0]);
        matrix.set(1, 1, realMatrix.entries[1][1]);
        matrix.set(1, 2, realMatrix.entries[1][2]);
        matrix.set(2, 0, realMatrix.entries[2][0]);
        matrix.set(2, 1, realMatrix.entries[2][1]);
        matrix.set(2, 2, realMatrix.entries[2][2]);
        EigenSystem3D eigenSystem3D = EigenSystem3D.sort(matrix.eig());
        return new double[]{eigenSystem3D.eigenvalues[0], eigenSystem3D.eigenvalues[1], eigenSystem3D.eigenvalues[2]};
    }
}

