/*
 * Decompiled with CFR 0.152.
 */
package apps;

import data.OutputManager;
import java.util.logging.Logger;
import misc.LoggedException;
import misc.SphericalPoints;
import numerics.RealMatrix;
import numerics.Rotations;
import sphfunc.EvenSHS;
import sphfunc.ISCodes;
import sphfunc.MaxEntProfile;
import sphfunc.PDList;
import sphfunc.SphericalFunction;
import sphfunc.TuchRBF_Sum;
import tools.CL_Initializer;

public class SphFuncPD_Stats {
    private static Logger logger = Logger.getLogger("camino.apps.SphFuncPD_Stats");
    public static double pdThresh = 1.0;
    public static double stdsFromMeanF = 0.0;
    public static int density = 1000;
    public static final int GLOBALSTATS = 6;
    public static final int STATSPERPD = 8;
    public static boolean noOutput = false;
    public static boolean doConsistencyCheck = true;
    private static OutputManager om;

    public static void main(String[] stringArray) {
        Object object;
        CL_Initializer.inputDataType = "double";
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.initImagingScheme();
        CL_Initializer.initMaxEnt();
        CL_Initializer.initSphFuncDataSource();
        om = new OutputManager();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-noconsistencycheck")) {
                doConsistencyCheck = false;
                CL_Initializer.markAsParsed(i);
                continue;
            }
            if (stringArray[i].equals("-pdthresh")) {
                pdThresh = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (!stringArray[i].equals("-stdsfrommean")) continue;
            stdsFromMeanF = Double.parseDouble(stringArray[i + 1]);
            CL_Initializer.markAsParsed(i, 2);
        }
        CL_Initializer.checkParsing(stringArray);
        double[][] dArray = null;
        double[][] dArray2 = null;
        if (CL_Initializer.pointSetIndSet) {
            try {
                dArray = ISCodes.getPointSetForMaxEnt((int)CL_Initializer.pointSetInd).data;
                object = Rotations.randomRotMat(0);
                dArray2 = SphericalPoints.rotatePointSet(dArray, (RealMatrix)object);
            }
            catch (Exception exception) {
                throw new LoggedException(exception);
            }
        } else {
            dArray = SphericalPoints.getIcosahedralPointSet(density, 0);
            dArray2 = SphericalPoints.getIcosahedralPointSet(density, density);
        }
        while (CL_Initializer.data.more()) {
            try {
                Object object2;
                object = CL_Initializer.data.nextVoxel();
                if (object[0] >= 0.0 && Math.exp((double)object[1]) > CL_Initializer.BACKGROUNDTHRESHOLD) {
                    int n;
                    Object object3;
                    int n2;
                    object2 = null;
                    object2 = CL_Initializer.inputModel.equals("sh") ? (Object)new EvenSHS((double[])object, CL_Initializer.maxOrder) : (CL_Initializer.inputModel.equals("maxent") ? (Object)new MaxEntProfile((double[])object, CL_Initializer.kernelParams) : (Object)new TuchRBF_Sum((double[])object));
                    PDList pDList = new PDList(SphericalFunction.getSearchRadius());
                    double[] dArray3 = ((SphericalFunction)object2).getPDs(dArray, pDList);
                    boolean bl = true;
                    for (n2 = 0; n2 < dArray3.length; ++n2) {
                        if (dArray3[n2] > SphericalFunction.getSearchRadius()) {
                            bl = false;
                            continue;
                        }
                        if (!(dArray3[n2] < 0.0)) continue;
                        bl = false;
                    }
                    n2 = pDList.getNoPDs();
                    double[] dArray4 = ((SphericalFunction)object2).getStats();
                    double d = dArray4[0];
                    double d2 = dArray4[1];
                    pDList.pruneByValue(pdThresh * d + stdsFromMeanF * d2);
                    boolean bl2 = true;
                    if (doConsistencyCheck) {
                        object3 = ((SphericalFunction)object2).getPDsRS(dArray2);
                        n = pDList.getNoPDs();
                        ((PDList)object3).pruneByValue(pdThresh * d + stdsFromMeanF * d2);
                        bl2 = pDList.equivalent((PDList)object3, pdThresh);
                    }
                    object3 = new double[6 + CL_Initializer.numPDsIO * 8];
                    object3[0] = object[0];
                    object3[1] = object[1];
                    object3[2] = (double)pDList.getNoPDs();
                    object3[3] = bl ? 1.0 : 0.0;
                    object3[4] = d;
                    object3[5] = d2;
                    for (n = 0; n < CL_Initializer.numPDsIO; ++n) {
                        if (n < pDList.getNoPDs()) {
                            object3[6 + n * 8] = pDList.getPD(n).getPDX();
                            object3[6 + n * 8 + 1] = pDList.getPD(n).getPDY();
                            object3[6 + n * 8 + 2] = pDList.getPD(n).getPDZ();
                            object3[6 + n * 8 + 3] = pDList.getPD(n).getProp();
                            RealMatrix realMatrix = ((SphericalFunction)object2).getHessian(pDList.getPD(n));
                            object3[6 + n * 8 + 4] = realMatrix.entries[0][0];
                            object3[6 + n * 8 + 5] = realMatrix.entries[0][1];
                            object3[6 + n * 8 + 6] = realMatrix.entries[1][0];
                            object3[6 + n * 8 + 7] = realMatrix.entries[1][1];
                            continue;
                        }
                        for (int i = 0; i < 8; ++i) {
                            object3[6 + n * 8 + i] = 0.0;
                        }
                    }
                    om.output((double[])object3);
                    continue;
                }
                object2 = new double[6 + CL_Initializer.numPDsIO * 8];
                object2[0] = (double)object[0];
                object2[1] = (double)object[1];
                om.output((double[])object2);
            }
            catch (Exception exception) {
                throw new LoggedException(exception);
            }
        }
        om.close();
    }

    public static void setDensity(int n) {
        density = n;
    }

    public static void setNoOutput(boolean bl) {
        noOutput = bl;
    }

    public static void setPdThresh(double d) {
        pdThresh = d;
    }

    public static void setStdsFromMeanF(double d) {
        stdsFromMeanF = d;
    }
}

