/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.ModelFit;
import data.OutputManager;
import java.util.logging.Logger;
import misc.LoggedException;
import sphfunc.EvenSHS;
import sphfunc.MaxEntProfile;
import sphfunc.SphericalFunction;
import sphfunc.TuchRBF_Sum;
import tools.CL_Initializer;

public class SphFuncKurtosis {
    private static Logger logger = Logger.getLogger("camino.apps.SphFuncKurtosis");
    private static OutputManager om;

    public static void main(String[] stringArray) {
        CL_Initializer.inputDataType = "double";
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.checkParsing(stringArray);
        CL_Initializer.initImagingScheme();
        CL_Initializer.initMaxEnt();
        CL_Initializer.initSphFuncDataSource();
        om = new OutputManager();
        while (CL_Initializer.data.more()) {
            try {
                double[] dArray = CL_Initializer.data.nextVoxel();
                SphericalFunction sphericalFunction = null;
                sphericalFunction = CL_Initializer.inputModel.equals("sh") ? new EvenSHS(dArray, CL_Initializer.maxOrder) : (CL_Initializer.inputModel.equals("maxent") ? new MaxEntProfile(dArray, CL_Initializer.kernelParams) : new TuchRBF_Sum(dArray));
                double[] dArray2 = new double[]{1.0};
                if (dArray[0] >= 0.0 && !ModelFit.isBG(Math.exp(dArray[1]))) {
                    dArray2[0] = sphericalFunction.kurtosis();
                }
                om.output(dArray2);
            }
            catch (Exception exception) {
                LoggedException.logExceptionWarning(exception, Thread.currentThread().getName());
            }
        }
        om.close();
    }
}

