/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.InversionStats;
import data.ModelPDF;
import data.OutputManager;
import data.StandardTestFunctions;
import java.io.DataInputStream;
import java.util.Random;
import java.util.logging.Logger;
import misc.LoggedException;
import numerics.Rotations;
import tools.CL_Initializer;

public class SequenceStats {
    private static Logger logger = Logger.getLogger("camino.apps.SequenceStats");
    public static final int NUMSINGLEDTSTATS = 12;
    public static final int NUMTWOTENSORSTATS = 24;
    public static final int NUMTHREETENSORSTATS = 36;
    public static final int NUMMFRSTATS = 54;

    public static void main(String[] stringArray) {
        int n = 0;
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.checkParsing(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-rotations")) continue;
            n = Integer.parseInt(stringArray[i + 1]);
            CL_Initializer.markAsParsed(i);
            CL_Initializer.markAsParsed(i + 1);
        }
        DataInputStream dataInputStream = null;
        try {
            dataInputStream = new DataInputStream(System.in);
        }
        catch (Exception exception) {
            LoggedException.logExceptionWarning(exception, Thread.currentThread().getName());
        }
        OutputManager outputManager = new OutputManager();
        int n2 = 54;
        if (CL_Initializer.inversionIndices[0].numDTs == 1) {
            n2 = 12;
        }
        if (CL_Initializer.inversionIndices[0].numDTs == 2) {
            n2 = 24;
        }
        if (CL_Initializer.inversionIndices[0].numDTs == 3) {
            n2 = 36;
        }
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                try {
                    dArray[i][j] = dataInputStream.readDouble();
                    continue;
                }
                catch (Exception exception) {
                    StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
                    String string = new String();
                    logger.severe(exception.toString());
                    for (int k = 0; k < stackTraceElementArray.length; ++k) {
                        string = string + stackTraceElementArray[k] + "\n";
                    }
                    logger.severe(string);
                    throw new RuntimeException(exception);
                }
            }
        }
        double[] dArray2 = null;
        dArray2 = CL_Initializer.inversionIndices[0].numDTs == 1 ? SequenceStats.singleDT_Stats(dArray) : (CL_Initializer.inversionIndices[0].numDTs == 2 ? SequenceStats.twoTensorStats(dArray, CL_Initializer.dt2rotangle) : (CL_Initializer.inversionIndices[0].numDTs == 3 ? SequenceStats.threeTensorStats(dArray) : SequenceStats.mfrStats(dArray, CL_Initializer.testFunction, CL_Initializer.dt2rotangle)));
        outputManager.output(dArray2);
        outputManager.close();
    }

    public static double[] singleDT_Stats(double[][] dArray) {
        double[] dArray2 = InversionStats.meanSTDMaxAndMin(dArray, 1);
        double[] dArray3 = SequenceStats.dirStatsWithRotations(dArray, 2, 1, 0.0);
        double[] dArray4 = InversionStats.meanSTDMaxAndMin(dArray, 5);
        double[] dArray5 = InversionStats.meanSTDMaxAndMin(dArray, 8);
        double[] dArray6 = InversionStats.meanSTDMaxAndMin(dArray, 9);
        double[] dArray7 = InversionStats.meanSTDMaxAndMin(dArray, 10);
        double[] dArray8 = InversionStats.meanSTDMaxAndMin(dArray, 11);
        double[] dArray9 = new double[]{dArray2[0], dArray2[2], dArray2[3], dArray3[0], dArray3[2], dArray3[3], dArray4[0], dArray4[2], dArray4[3], dArray5[0], dArray5[2], dArray5[3], dArray6[0], dArray6[2], dArray6[3], dArray7[0], dArray7[2], dArray7[3], dArray8[0], dArray8[2], dArray8[3]};
        return dArray9;
    }

    public static double[] twoTensorStats(double[][] dArray, double d) {
        double[] dArray2 = InversionStats.meanSTDMaxAndMin(dArray, 1);
        double[] dArray3 = InversionStats.meanSTDMaxAndMin(dArray, 5);
        double[] dArray4 = SequenceStats.dirStatsWithRotations(dArray, 2, 3, d);
        double[] dArray5 = InversionStats.meanSTDMaxAndMin(dArray, 8);
        double[] dArray6 = InversionStats.meanSTDMaxAndMin(dArray, 9);
        double[] dArray7 = InversionStats.meanSTDMaxAndMin(dArray, 10);
        double[] dArray8 = InversionStats.meanSTDMaxAndMin(dArray, 11);
        double[] dArray9 = InversionStats.meanSTDMaxAndMin(dArray, 15);
        double[] dArray10 = SequenceStats.dirStatsWithRotations(dArray, 12, 3, d);
        double[] dArray11 = InversionStats.meanSTDMaxAndMin(dArray, 18);
        double[] dArray12 = InversionStats.meanSTDMaxAndMin(dArray, 19);
        double[] dArray13 = InversionStats.meanSTDMaxAndMin(dArray, 20);
        double[] dArray14 = InversionStats.meanSTDMaxAndMin(dArray, 21);
        double[] dArray15 = InversionStats.meanSTDMaxAndMin(dArray, 22);
        double[] dArray16 = InversionStats.meanSTDMaxAndMin(dArray, 23);
        double[] dArray17 = new double[]{dArray2[0], dArray2[2], dArray2[3], dArray4[0], dArray4[2], dArray4[3], dArray3[0], dArray3[2], dArray3[3], dArray5[0], dArray5[2], dArray5[3], dArray6[0], dArray6[2], dArray6[3], dArray7[0], dArray7[2], dArray7[3], dArray8[0], dArray8[2], dArray8[3], dArray10[0], dArray10[2], dArray10[3], dArray9[0], dArray9[2], dArray9[3], dArray11[0], dArray11[2], dArray11[3], dArray12[0], dArray12[2], dArray12[3], dArray13[0], dArray13[2], dArray13[3], dArray14[0], dArray14[2], dArray14[3], dArray15[0], dArray15[2], dArray15[3], dArray16[0], dArray16[2], dArray16[3]};
        return dArray17;
    }

    public static double[] threeTensorStats(double[][] dArray) {
        double[] dArray2 = InversionStats.meanSTDMaxAndMin(dArray, 1);
        double[] dArray3 = InversionStats.meanSTDMaxAndMin(dArray, 5);
        double[] dArray4 = SequenceStats.dirStatsWithRotations(dArray, 2, 3, 0.0);
        double[] dArray5 = InversionStats.meanSTDMaxAndMin(dArray, 8);
        double[] dArray6 = InversionStats.meanSTDMaxAndMin(dArray, 9);
        double[] dArray7 = InversionStats.meanSTDMaxAndMin(dArray, 10);
        double[] dArray8 = InversionStats.meanSTDMaxAndMin(dArray, 11);
        double[] dArray9 = InversionStats.meanSTDMaxAndMin(dArray, 15);
        double[] dArray10 = SequenceStats.dirStatsWithRotations(dArray, 12, 3, 0.0);
        double[] dArray11 = InversionStats.meanSTDMaxAndMin(dArray, 18);
        double[] dArray12 = InversionStats.meanSTDMaxAndMin(dArray, 19);
        double[] dArray13 = InversionStats.meanSTDMaxAndMin(dArray, 20);
        double[] dArray14 = InversionStats.meanSTDMaxAndMin(dArray, 21);
        double[] dArray15 = InversionStats.meanSTDMaxAndMin(dArray, 25);
        double[] dArray16 = SequenceStats.dirStatsWithRotations(dArray, 22, 3, 0.0);
        double[] dArray17 = InversionStats.meanSTDMaxAndMin(dArray, 28);
        double[] dArray18 = InversionStats.meanSTDMaxAndMin(dArray, 29);
        double[] dArray19 = InversionStats.meanSTDMaxAndMin(dArray, 30);
        double[] dArray20 = InversionStats.meanSTDMaxAndMin(dArray, 31);
        double[] dArray21 = InversionStats.meanSTDMaxAndMin(dArray, 32);
        double[] dArray22 = InversionStats.meanSTDMaxAndMin(dArray, 33);
        double[] dArray23 = InversionStats.meanSTDMaxAndMin(dArray, 34);
        double[] dArray24 = InversionStats.meanSTDMaxAndMin(dArray, 35);
        double[] dArray25 = new double[]{dArray2[0], dArray2[2], dArray2[3], dArray4[0], dArray4[2], dArray4[3], dArray3[0], dArray3[2], dArray3[3], dArray5[0], dArray5[2], dArray5[3], dArray6[0], dArray6[2], dArray6[3], dArray7[0], dArray7[2], dArray7[3], dArray8[0], dArray8[2], dArray8[3], dArray10[0], dArray10[2], dArray10[3], dArray9[0], dArray9[2], dArray9[3], dArray11[0], dArray11[2], dArray11[3], dArray12[0], dArray12[2], dArray12[3], dArray13[0], dArray13[2], dArray13[3], dArray14[0], dArray14[2], dArray14[3], dArray16[0], dArray16[2], dArray16[3], dArray15[0], dArray15[2], dArray15[3], dArray17[0], dArray17[2], dArray17[3], dArray18[0], dArray18[2], dArray18[3], dArray19[0], dArray19[2], dArray19[3], dArray20[0], dArray20[2], dArray20[3], dArray21[0], dArray21[2], dArray21[3], dArray22[0], dArray22[2], dArray22[3], dArray23[0], dArray23[2], dArray23[3], dArray24[0], dArray24[2], dArray24[3]};
        return dArray25;
    }

    public static double[] mfrStats(double[][] dArray, int n, double d) {
        double[] dArray2 = InversionStats.meanSTDMaxAndMin(dArray, 1);
        double[] dArray3 = InversionStats.meanSTDMaxAndMin(dArray, 2);
        double[] dArray4 = InversionStats.meanSTDMaxAndMin(dArray, 3);
        double[] dArray5 = InversionStats.meanSTDMaxAndMin(dArray, 4);
        double[] dArray6 = InversionStats.meanSTDMaxAndMin(dArray, 5);
        double[] dArray7 = SequenceStats.dirStatsWithRotations(dArray, 6, n, d);
        double[] dArray8 = InversionStats.meanSTDMaxAndMin(dArray, 9);
        double[] dArray9 = InversionStats.meanSTDMaxAndMin(dArray, 12);
        double[] dArray10 = InversionStats.meanSTDMaxAndMin(dArray, 13);
        double[] dArray11 = InversionStats.meanSTDMaxAndMin(dArray, 14);
        double[] dArray12 = InversionStats.meanSTDMaxAndMin(dArray, 16);
        double[] dArray13 = SequenceStats.dirStatsWithRotations(dArray, 18, n, d);
        double[] dArray14 = InversionStats.meanSTDMaxAndMin(dArray, 21);
        double[] dArray15 = InversionStats.meanSTDMaxAndMin(dArray, 24);
        double[] dArray16 = InversionStats.meanSTDMaxAndMin(dArray, 25);
        double[] dArray17 = InversionStats.meanSTDMaxAndMin(dArray, 26);
        double[] dArray18 = InversionStats.meanSTDMaxAndMin(dArray, 28);
        double[] dArray19 = SequenceStats.dirStatsWithRotations(dArray, 30, n, d);
        double[] dArray20 = InversionStats.meanSTDMaxAndMin(dArray, 33);
        double[] dArray21 = InversionStats.meanSTDMaxAndMin(dArray, 36);
        double[] dArray22 = InversionStats.meanSTDMaxAndMin(dArray, 37);
        double[] dArray23 = InversionStats.meanSTDMaxAndMin(dArray, 38);
        double[] dArray24 = InversionStats.meanSTDMaxAndMin(dArray, 40);
        double[] dArray25 = SequenceStats.dirStatsWithRotations(dArray, 42, n, d);
        double[] dArray26 = InversionStats.meanSTDMaxAndMin(dArray, 45);
        double[] dArray27 = InversionStats.meanSTDMaxAndMin(dArray, 48);
        double[] dArray28 = InversionStats.meanSTDMaxAndMin(dArray, 49);
        double[] dArray29 = InversionStats.meanSTDMaxAndMin(dArray, 50);
        double[] dArray30 = InversionStats.meanSTDMaxAndMin(dArray, 52);
        double[] dArray31 = new double[]{dArray2[0], dArray2[2], dArray2[3], dArray3[0], dArray3[2], dArray3[3], dArray4[0], dArray4[2], dArray4[3], dArray5[0], dArray5[2], dArray5[3], dArray6[0], dArray6[2], dArray6[3], dArray7[0], dArray7[2], dArray7[3], dArray8[0], dArray8[2], dArray8[3], dArray9[0], dArray9[2], dArray9[3], dArray10[0], dArray10[2], dArray10[3], dArray11[0], dArray11[2], dArray11[3], dArray12[0], dArray12[2], dArray12[3], dArray13[0], dArray13[2], dArray13[3], dArray14[0], dArray14[2], dArray14[3], dArray15[0], dArray15[2], dArray15[3], dArray16[0], dArray16[2], dArray16[3], dArray17[0], dArray17[2], dArray17[3], dArray18[0], dArray18[2], dArray18[3], dArray19[0], dArray19[2], dArray19[3], dArray20[0], dArray20[2], dArray20[3], dArray21[0], dArray21[2], dArray21[3], dArray22[0], dArray22[2], dArray22[3], dArray23[0], dArray23[2], dArray23[3], dArray24[0], dArray24[2], dArray24[3], dArray25[0], dArray25[2], dArray25[3], dArray26[0], dArray26[2], dArray26[3], dArray27[0], dArray27[2], dArray27[3], dArray28[0], dArray28[2], dArray28[3], dArray29[0], dArray29[2], dArray29[3], dArray30[0], dArray30[2], dArray30[3]};
        return dArray31;
    }

    public static double[] dirStatsWithRotations(double[][] dArray, int n, int n2, double d) {
        double[] dArray2;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = -12.0;
        double d5 = 12.0;
        for (int i = 0; i < dArray.length; ++i) {
            StandardTestFunctions.setTransformation(Rotations.randomRotMat(new Random(i + 1)));
            StandardTestFunctions.setDT2RotationAngle(d);
            ModelPDF modelPDF = StandardTestFunctions.getFunction(n2);
            double[][] dArray3 = modelPDF.getPDs();
            double d6 = -1.0;
            for (int j = 0; j < dArray3.length; ++j) {
                double d7 = Math.abs(dArray[i][n] * dArray3[j][0] + dArray[i][n + 1] * dArray3[j][1] + dArray[i][n + 2] * dArray3[j][2]);
                d6 = d7 > d6 ? d7 : d6;
            }
            double d8 = Math.acos(d6);
            d2 += d8;
            d3 += d8 * d8;
            d4 = d8 > d4 ? d8 : d4;
            d5 = d8 < d5 ? d8 : d5;
        }
        dArray2 = new double[]{d2 / (double)dArray.length, Math.sqrt(d3 / (double)dArray.length - dArray2[0] * dArray2[0]), d4, d5};
        return dArray2;
    }
}

