/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.StreamlineTractography;
import data.OutputManager;
import imaging.AnalyzeHeader;
import imaging.ImageHeader;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import misc.LoggedException;
import numerics.Point3D;
import numerics.Vector3D;
import tools.CL_Initializer;
import tractography.ConnectionProbabilityImage;
import tractography.ConnectivitySegmentedImage;
import tractography.FreeFormROI;
import tractography.StreamlineROI_Filter;
import tractography.TargetCP_Image;
import tractography.Tract;
import tractography.TractCollection;
import tractography.TractSource;
import tractography.Voxel;
import tractography.VoxelList;

public class ProcessStreamlines {
    private static Logger logger = Logger.getLogger("camino.apps.ProcessStreamlines");
    private static int MAX_PDS = 1000;
    private static OutputManager om;

    public static void main(String[] stringArray) {
        Object object;
        int n;
        if (stringArray.length == 0) {
            System.exit(0);
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        boolean bl8 = false;
        Vector3D vector3D = null;
        boolean bl9 = true;
        boolean bl10 = true;
        boolean bl11 = false;
        boolean bl12 = false;
        FreeFormROI freeFormROI = null;
        double d4 = -1.0;
        double d5 = -1.0;
        double d6 = -1.0;
        boolean bl13 = false;
        int n5 = -1;
        int n6 = -1;
        int n7 = 0;
        int n8 = 0;
        double d7 = 0.0;
        double d8 = 0.0;
        String string6 = null;
        double d9 = 0.0;
        CL_Initializer.inputModel = "raw";
        CL_Initializer.numPDsIO = 1;
        CL_Initializer.CL_init(stringArray);
        boolean bl14 = OutputManager.gzipOut;
        int n9 = 0;
        boolean bl15 = false;
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equals("-resamplestepsize")) {
                d9 = Double.parseDouble(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equals("-noresample")) {
                d9 = -1.0;
                CL_Initializer.markAsParsed(n);
                continue;
            }
            if (stringArray[n].equals("-seedpointmm")) {
                d4 = Double.parseDouble(stringArray[n + 1]);
                d5 = Double.parseDouble(stringArray[n + 2]);
                d6 = Double.parseDouble(stringArray[n + 3]);
                CL_Initializer.markAsParsed(n, 4);
                continue;
            }
            if (stringArray[n].equals("-seedpointvox")) {
                d4 = Double.parseDouble(stringArray[n + 1]);
                d5 = Double.parseDouble(stringArray[n + 2]);
                d6 = Double.parseDouble(stringArray[n + 3]);
                bl13 = true;
                CL_Initializer.markAsParsed(n, 4);
                continue;
            }
            if (stringArray[n].equals("-seedfile")) {
                string = stringArray[n + 1];
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equals("-regionindex")) {
                n5 = Integer.parseInt(stringArray[n + 1]) - 1;
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equals("-seedindex")) {
                int n10 = Integer.parseInt(stringArray[n + 1]);
                if (n10 <= 0) {
                    throw new LoggedException("Invalid seed index specified. Minimum index is 1");
                }
                n6 = n10 - 1;
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equals("-waypointfile")) {
                string3 = stringArray[n + 1];
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equals("-exclusionfile")) {
                string4 = stringArray[n + 1];
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equals("-targetfile")) {
                string2 = stringArray[n + 1];
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equals("-endpointfile")) {
                string5 = stringArray[n + 1];
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equals("-mintractpoints")) {
                n7 = Integer.parseInt(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equals("-mintractlength")) {
                d7 = Double.parseDouble(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equals("-maxtractpoints")) {
                n8 = Integer.parseInt(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equals("-maxtractlength")) {
                d8 = Double.parseDouble(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equals("-truncateinexclusion")) {
                bl10 = false;
                CL_Initializer.markAsParsed(n);
                continue;
            }
            if (stringArray[n].equals("-truncateloops")) {
                bl11 = true;
                CL_Initializer.markAsParsed(n);
                continue;
            }
            if (stringArray[n].equals("-discardloops")) {
                bl12 = true;
                CL_Initializer.markAsParsed(n);
                continue;
            }
            if (stringArray[n].equals("-allowmultitargets")) {
                bl9 = false;
                CL_Initializer.markAsParsed(n);
                continue;
            }
            if (stringArray[n].equals("-directional")) {
                bl8 = true;
                if (stringArray.length < n + 4) {
                    throw new LoggedException("-directionalcp requires a vector defining the forward direction");
                }
                vector3D = new Vector3D(Double.parseDouble(stringArray[n + 1]), Double.parseDouble(stringArray[n + 2]), Double.parseDouble(stringArray[n + 3]));
                CL_Initializer.markAsParsed(n, 4);
                continue;
            }
            if (stringArray[n].equals("-outputtracts")) {
                if (n < stringArray.length - 1) {
                    if (stringArray[n + 1].equals("oogl")) {
                        bl2 = true;
                        CL_Initializer.markAsParsed(n, 2);
                        continue;
                    }
                    if (stringArray[n + 1].equals("ooglbinary")) {
                        bl2 = true;
                        bl3 = true;
                        CL_Initializer.markAsParsed(n, 2);
                        continue;
                    }
                    if (stringArray[n + 1].equals("voxels")) {
                        bl = true;
                        CL_Initializer.markAsParsed(n, 2);
                        continue;
                    }
                    if (!stringArray[n + 1].equals("raw")) continue;
                    CL_Initializer.markAsParsed(n, 2);
                    continue;
                }
                CL_Initializer.markAsParsed(n, 1);
                continue;
            }
            if (stringArray[n].equals("-outputcp")) {
                bl4 = true;
                bl7 = true;
                CL_Initializer.markAsParsed(n);
                continue;
            }
            if (stringArray[n].equals("-outputcbs")) {
                bl5 = true;
                bl4 = true;
                CL_Initializer.markAsParsed(n);
                continue;
            }
            if (stringArray[n].equals("-outputsc")) {
                bl4 = true;
                bl7 = false;
                CL_Initializer.markAsParsed(n);
                continue;
            }
            if (stringArray[n].equals("-outputacm")) {
                bl4 = true;
                bl6 = true;
                CL_Initializer.markAsParsed(n);
                continue;
            }
            if (stringArray[n].equals("-iterations")) {
                n9 = Integer.parseInt(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equals("-outputroot")) {
                string6 = stringArray[n + 1];
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (!stringArray[n].equals("-silent")) continue;
            bl15 = true;
            CL_Initializer.markAsParsed(n);
        }
        CL_Initializer.checkParsing(stringArray);
        n2 = CL_Initializer.dataDims[0];
        n3 = CL_Initializer.dataDims[1];
        n4 = CL_Initializer.dataDims[2];
        d = CL_Initializer.voxelDims[0];
        d2 = CL_Initializer.voxelDims[1];
        d3 = CL_Initializer.voxelDims[2];
        if (bl11 && bl12) {
            logger.warning("Discard and truncate loops both selected. Program will truncate loops (run again witth discard option to remove them if desired)");
            bl12 = false;
        }
        if (n9 == 0) {
            n9 = bl4 ? StreamlineTractography.DEFAULT_PICO_ITERATIONS : 1;
        }
        if (bl5 && n6 > 0) {
            throw new LoggedException("Cannot specify -seedindex with -outputcbs. Concatenate all seeds from the ROI into a single file and use -regionIndex");
        }
        n = CL_Initializer.numPDsIO;
        int[] nArray = new int[]{n2, n3, n4};
        double[] dArray = new double[]{d, d2, d3};
        ImageHeader imageHeader = null;
        if (string != null) {
            try {
                imageHeader = ImageHeader.readHeader(string);
            }
            catch (IOException iOException) {
                throw new LoggedException(iOException);
            }
            if (!ImageHeader.checkDims(string, nArray, dArray)) {
                throw new LoggedException("Inconsistent data or voxel dimensions specified");
            }
        }
        short[][][] sArray = null;
        if (string3 != null) {
            if (imageHeader == null) {
                try {
                    imageHeader = ImageHeader.readHeader(string3);
                }
                catch (IOException iOException) {
                    throw new LoggedException(iOException);
                }
            }
            sArray = StreamlineTractography.readShortVolume(string3);
            if (!ImageHeader.checkDims(string3, nArray, dArray)) {
                throw new LoggedException("Inconsistent data or voxel dimensions specified");
            }
        }
        short[][][] sArray2 = null;
        if (string4 != null) {
            if (imageHeader == null) {
                try {
                    imageHeader = ImageHeader.readHeader(string4);
                }
                catch (IOException iOException) {
                    throw new LoggedException(iOException);
                }
            }
            sArray2 = StreamlineTractography.readShortVolume(string4);
            if (!ImageHeader.checkDims(string4, nArray, dArray)) {
                throw new LoggedException("Inconsistent data or voxel dimensions specified");
            }
        }
        short[][][] sArray3 = null;
        if (string2 != null) {
            if (imageHeader == null) {
                try {
                    imageHeader = ImageHeader.readHeader(string2);
                }
                catch (IOException iOException) {
                    throw new LoggedException(iOException);
                }
            }
            sArray3 = StreamlineTractography.readShortVolume(string2);
            if (!ImageHeader.checkDims(string2, nArray, dArray)) {
                throw new LoggedException("Inconsistent data or voxel dimensions specified");
            }
        }
        short[][][] sArray4 = null;
        if (string5 != null) {
            if (imageHeader == null) {
                try {
                    imageHeader = ImageHeader.readHeader(string5);
                }
                catch (IOException iOException) {
                    throw new LoggedException(iOException);
                }
            }
            sArray4 = StreamlineTractography.readShortVolume(string5);
            if (!ImageHeader.checkDims(string5, nArray, dArray)) {
                throw new LoggedException("Inconsistent data or voxel dimensions specified");
            }
        }
        n2 = nArray[0];
        n3 = nArray[1];
        n4 = nArray[2];
        d = Math.abs(dArray[0]);
        d2 = Math.abs(dArray[1]);
        d3 = Math.abs(dArray[2]);
        if (string == null) {
            if (d4 < 0.0 || d5 < 0.0 || d6 < 0.0) {
                if (bl4 && !bl6) {
                    throw new LoggedException("Seed points must be specified for connection probability images");
                }
            } else {
                object = new short[n2][n3][n4];
                if (bl13) {
                    object[(int)d4][(int)d5][(int)d6] = 1;
                } else {
                    object[(int)(d4 / d)][(int)(d5 / d2)][(int)(d6 / d3)] = 1;
                }
                freeFormROI = new FreeFormROI((short[][][])object, d, d2, d3);
            }
        } else {
            object = StreamlineTractography.readShortVolume(string);
            freeFormROI = new FreeFormROI((short[][][])object, d, d2, d3);
        }
        if (freeFormROI == null && !bl6) {
            if (string6 != null) {
                throw new LoggedException("Without ROI information, output is to a single stream (default stdout). Specify a file with -outputfile");
            }
        } else if (string6 == null) {
            string6 = "";
        }
        if (string6 == null) {
            om = new OutputManager();
        }
        object = new TractSource(CL_Initializer.inputFile, CL_Initializer.inputModel, d, d2, d3);
        if (bl5 && sArray3 == null) {
            throw new LoggedException("Cannot do connectivity segmentation without targets");
        }
        if ((bl || bl4) && ((double)n2 == 0.0 || (double)n3 == 0.0 || (double)n4 == 0.0 || d == 0.0 || d2 == 0.0 || d3 == 0.0)) {
            throw new LoggedException("Connection probability and voxel output requires  data and voxel dimensions to be specified.");
        }
        StreamlineROI_Filter streamlineROI_Filter = new StreamlineROI_Filter(n2, n3, n4, d, d2, d3);
        if (string3 != null) {
            streamlineROI_Filter.setWaypoints(sArray);
            streamlineROI_Filter.setTruncateLoops(bl11);
            streamlineROI_Filter.setDiscardLoops(bl12);
        }
        if (string4 != null) {
            streamlineROI_Filter.setExclusionROIs(sArray2);
            streamlineROI_Filter.setDiscardOnExclusionEntry(bl10);
        }
        if (string5 != null) {
            streamlineROI_Filter.setEndZones(sArray4);
        }
        if (d9 > 0.0) {
            streamlineROI_Filter.setResampleStepSize(d9);
        } else if (d9 < 0.0 || CL_Initializer.inputModel.equals("voxels") || d3 == 0.0) {
            streamlineROI_Filter.setResampleTracts(false);
        }
        if (n7 > 0) {
            streamlineROI_Filter.setMinTractPoints(n7);
        }
        if (d7 > 0.0) {
            streamlineROI_Filter.setMinTractLength(d7);
        }
        if (n8 > 0) {
            streamlineROI_Filter.setMaxTractPoints(n8);
            streamlineROI_Filter.setResampleTracts(false);
        }
        if (d8 > 0.0) {
            streamlineROI_Filter.setMaxTractLength(d8);
        }
        int n11 = n5 + 1;
        AnalyzeHeader analyzeHeader = null;
        AnalyzeHeader analyzeHeader2 = null;
        AnalyzeHeader analyzeHeader3 = null;
        analyzeHeader = new AnalyzeHeader();
        analyzeHeader.bitpix = (short)32;
        analyzeHeader.width = (short)n2;
        analyzeHeader.height = (short)n3;
        analyzeHeader.depth = (short)n4;
        analyzeHeader.pixelWidth = (float)dArray[0];
        analyzeHeader.pixelHeight = (float)dArray[1];
        analyzeHeader.pixelDepth = (float)dArray[2];
        if (imageHeader != null) {
            double[] dArray2 = imageHeader.getOrigin();
            analyzeHeader.centre = new short[]{(short)dArray2[0], (short)dArray2[1], (short)dArray2[2]};
            analyzeHeader.pixelWidth = (float)imageHeader.xVoxelDim();
            analyzeHeader.pixelHeight = (float)imageHeader.yVoxelDim();
            analyzeHeader.pixelDepth = (float)imageHeader.zVoxelDim();
        }
        analyzeHeader.datatype = (short)16;
        analyzeHeader.description = "Camino procstreamlines";
        analyzeHeader2 = new AnalyzeHeader(analyzeHeader);
        analyzeHeader2.datatype = (short)8;
        analyzeHeader3 = new AnalyzeHeader(analyzeHeader);
        analyzeHeader3.datatype = (short)4;
        analyzeHeader3.bitpix = (short)16;
        try {
            block171: {
                int n12;
                block170: {
                    int n13;
                    Object object2;
                    n12 = 1;
                    if (freeFormROI != null) {
                        n12 = freeFormROI.numberOfRegions();
                    }
                    if (!bl6) break block170;
                    int n14 = 0;
                    if (!bl15) {
                        System.err.println();
                    }
                    ConnectionProbabilityImage connectionProbabilityImage = new ConnectionProbabilityImage(n2, n3, n4, d, d2, d3);
                    while (((TractSource)object).more()) {
                        if (!bl15) {
                            System.err.print("\rProcessing streamline " + (n14 + 1));
                        }
                        object2 = new TractCollection(2, 100.0);
                        ((TractCollection)object2).addTract(((TractSource)object).nextTract());
                        object2 = streamlineROI_Filter.processTracts((TractCollection)object2);
                        connectionProbabilityImage.processTracts((TractCollection)object2);
                        ++n14;
                    }
                    if (bl7) {
                        object2 = connectionProbabilityImage.getConnectionProbabilities();
                        AnalyzeHeader.writeImage((double[][][])object2, analyzeHeader, string6 + "acm_cp", bl14);
                    } else {
                        object2 = connectionProbabilityImage.getStreamlineCounts();
                        AnalyzeHeader.writeImage((int[][][])object2, analyzeHeader2, string6 + "acm_sc", bl14);
                    }
                    if (!bl15) {
                        System.err.println();
                    }
                    if (freeFormROI == null) break block171;
                    int n15 = 0;
                    for (n13 = 0; n13 < n12; ++n13) {
                        FreeFormROI freeFormROI2 = (FreeFormROI)freeFormROI.getRegion(n13);
                        Voxel[] voxelArray = freeFormROI2.getVoxels();
                        n15 += voxelArray.length;
                    }
                    n13 = n15 * n9;
                    if (n13 <= n14) break block171;
                    logger.warning("Minimum expected number of tracts was " + n15 + " [seeds] * " + n9 + " [iterations] = " + n13 + ".\nActual number of tracts was " + n14);
                    break block171;
                }
                if (!bl4 && string6 == null) {
                    DataOutputStream dataOutputStream = om.getOutputStream();
                    int n16 = 0;
                    if (bl2) {
                        dataOutputStream.write(new String("LIST\n").getBytes());
                    }
                    if (!bl15) {
                        System.err.println();
                    }
                    while (((TractSource)object).more()) {
                        if (!bl15) {
                            System.err.print("\rProcessing streamline " + (n16 + 1));
                        }
                        TractCollection tractCollection = new TractCollection(2, 100.0);
                        tractCollection.addTract(((TractSource)object).nextTract());
                        tractCollection = streamlineROI_Filter.processTracts(tractCollection);
                        for (int i = 0; i < tractCollection.numberOfTracts(); ++i) {
                            Tract tract = tractCollection.getTract(i);
                            if (bl2) {
                                if (bl3) {
                                    tract.writeOOGL_BinaryVECT(dataOutputStream);
                                    continue;
                                }
                                dataOutputStream.write(tract.toOOGLVECT().getBytes());
                                continue;
                            }
                            if (bl) {
                                VoxelList voxelList = tract.toVoxelList(d, d2, d3);
                                voxelList.writeVoxelList(dataOutputStream);
                                continue;
                            }
                            tract.writeRaw(dataOutputStream);
                        }
                        ++n16;
                    }
                    dataOutputStream.close();
                } else {
                    int n17 = 0;
                    TractCollection tractCollection = new TractCollection(2, 100.0);
                    tractCollection.addTract(((TractSource)object).nextTract());
                    for (int i = 0; i < n12; ++i) {
                        Object object3;
                        Object object4;
                        Object object5;
                        Object object6;
                        FreeFormROI freeFormROI3 = (FreeFormROI)freeFormROI.getRegion(i);
                        Point3D[] point3DArray = freeFormROI3.getSeedPoints();
                        Voxel[] voxelArray = freeFormROI3.getVoxels();
                        n11 = i + 1;
                        if (n6 == -1) {
                            if (n5 > -1 && i != n5) continue;
                            if (!bl15) {
                                System.err.println("\nProcessing ROI " + n11 + " of " + n12);
                            }
                        } else {
                            if (point3DArray.length + n17 - 1 < n6) {
                                n17 += point3DArray.length;
                                continue;
                            }
                            if (n17 > n6) break;
                            if (!bl15) {
                                System.err.println("\nProcessing ROI " + n11 + " of " + n12);
                            }
                        }
                        if (bl5) {
                            int n18;
                            int n19;
                            int n20;
                            object6 = new ConnectivitySegmentedImage[MAX_PDS];
                            for (n20 = 0; n20 < point3DArray.length; ++n20) {
                                if (!bl15) {
                                    System.err.print("\rProcessing seed " + (n20 + 1) + " of " + point3DArray.length);
                                }
                                n19 = 0;
                                object5 = voxelArray[n20];
                                object4 = tractCollection.getTract(0).toVoxelList(d, d2, d3);
                                object3 = ((VoxelList)object4).getVoxel(((VoxelList)object4).seedPointIndex());
                                while (((Voxel)object5).equals(object3) && tractCollection != null) {
                                    if (object6[n19] == null) {
                                        object6[n19] = new ConnectivitySegmentedImage(freeFormROI3, sArray3, d, d2, d3);
                                        if (bl8) {
                                            object6[n19].setDirectional(vector3D);
                                        }
                                        object6[n19].setCountFirstEntry(bl9);
                                    }
                                    object6[n19].processTracts(n20, streamlineROI_Filter.processTracts(tractCollection));
                                    for (n18 = 1; n18 < n9; ++n18) {
                                        TractCollection tractCollection2 = streamlineROI_Filter.processTract(((TractSource)object).nextTract());
                                        object6[n19].processTracts(n20, tractCollection2);
                                    }
                                    if (((TractSource)object).more()) {
                                        ++n19;
                                        tractCollection = new TractCollection(2, 100.0);
                                        tractCollection.addTract(((TractSource)object).nextTract());
                                        object4 = tractCollection.getTract(0).toVoxelList(d, d2, d3);
                                        object3 = ((VoxelList)object4).getVoxel(((VoxelList)object4).seedPointIndex());
                                        continue;
                                    }
                                    tractCollection = null;
                                    object4 = null;
                                    object3 = null;
                                    if (n20 >= point3DArray.length - 1) continue;
                                    throw new LoggedException("No more tracts in input after processing seed " + (n20 + 1) + " of " + point3DArray.length);
                                }
                            }
                            for (n20 = 0; n20 < MAX_PDS; ++n20) {
                                if (object6[n20] == null) continue;
                                n19 = bl8 ? 2 : 1;
                                object5 = object6[n20].getSegmentedSeeds();
                                object4 = null;
                                object3 = null;
                                if (bl7) {
                                    object4 = object6[n20].getMaxTargetCP();
                                } else {
                                    object3 = object6[n20].getMaxTargetSC();
                                }
                                for (n18 = 0; n18 < n19; ++n18) {
                                    AnalyzeHeader.writeImage((short[][][])object5[n18], analyzeHeader3, string6 + "labels_" + (i + 1) + "_" + (n20 + 1) + "_" + n18, bl14);
                                    if (bl7) {
                                        AnalyzeHeader.writeImage((double[][][])object4[n18], analyzeHeader, string6 + "labelcp_" + (i + 1) + "_" + (n20 + 1) + "_" + n18, bl14);
                                        continue;
                                    }
                                    AnalyzeHeader.writeImage((int[][][])object3[n18], analyzeHeader2, string6 + "labelsc_" + (i + 1) + "_" + (n20 + 1) + "_" + n18, bl14);
                                }
                            }
                            continue;
                        }
                        if (bl4 && sArray3 != null) {
                            for (int j = 0; j < point3DArray.length; ++j) {
                                if (n6 > -1 && n17 != n6) {
                                    ++n17;
                                    continue;
                                }
                                ++n17;
                                if (!bl15) {
                                    System.err.print("\rProcessing seed " + (j + 1) + " of " + point3DArray.length);
                                }
                                int n21 = 0;
                                Voxel voxel = voxelArray[j];
                                object5 = tractCollection.getTract(0).toVoxelList(d, d2, d3);
                                object4 = ((VoxelList)object5).getVoxel(((VoxelList)object5).seedPointIndex());
                                while (voxel.equals(object4) && tractCollection != null) {
                                    Object object7;
                                    int n22;
                                    object3 = new TargetCP_Image(sArray3, d, d2, d3);
                                    if (bl8) {
                                        ((TargetCP_Image)object3).setDirectional(vector3D);
                                    }
                                    ((TargetCP_Image)object3).setCountFirstEntry(bl9);
                                    ((TargetCP_Image)object3).processTracts(streamlineROI_Filter.processTracts(tractCollection));
                                    for (n22 = 1; n22 < n9; ++n22) {
                                        object7 = streamlineROI_Filter.processTract(((TractSource)object).nextTract());
                                        ((TargetCP_Image)object3).processTracts((TractCollection)object7);
                                    }
                                    n22 = bl8 ? 2 : 1;
                                    object7 = null;
                                    int[][][][] nArray2 = null;
                                    if (bl7) {
                                        object7 = ((TargetCP_Image)object3).getConnectionProbabilities();
                                    } else {
                                        nArray2 = ((TargetCP_Image)object3).getStreamlineCounts();
                                    }
                                    for (int k = 0; k < n22; ++k) {
                                        if (bl7) {
                                            AnalyzeHeader.writeImage((double[][][])object7[k], analyzeHeader, string6 + (i + 1) + "_" + (j + 1) + "_" + (n21 + 1) + "_" + k, bl14);
                                            continue;
                                        }
                                        AnalyzeHeader.writeImage(nArray2[k], analyzeHeader2, string6 + (i + 1) + "_" + (j + 1) + "_" + (n21 + 1) + "_" + k, bl14);
                                    }
                                    ++n21;
                                    if (((TractSource)object).more()) {
                                        tractCollection = new TractCollection(2, 100.0);
                                        tractCollection.addTract(((TractSource)object).nextTract());
                                        object5 = tractCollection.getTract(0).toVoxelList(d, d2, d3);
                                        object4 = ((VoxelList)object5).getVoxel(((VoxelList)object5).seedPointIndex());
                                        continue;
                                    }
                                    tractCollection = null;
                                    object5 = null;
                                    object4 = null;
                                    if (j >= point3DArray.length - 1) continue;
                                    throw new LoggedException("No more tracts in input after processing seed " + (j + 1) + " of " + point3DArray.length);
                                }
                            }
                            continue;
                        }
                        if (bl4) {
                            for (int j = 0; j < point3DArray.length; ++j) {
                                if (n6 > -1 && n17 != n6) {
                                    ++n17;
                                    continue;
                                }
                                ++n17;
                                if (!bl15) {
                                    System.err.print("\rProcessing seed " + (j + 1) + " of " + point3DArray.length);
                                }
                                int n23 = 0;
                                Voxel voxel = voxelArray[j];
                                object5 = tractCollection.getTract(0).toVoxelList(d, d2, d3);
                                object4 = ((VoxelList)object5).getVoxel(((VoxelList)object5).seedPointIndex());
                                while (voxel.equals(object4) && tractCollection != null) {
                                    Object object8;
                                    object3 = new ConnectionProbabilityImage(n2, n3, n4, d, d2, d3);
                                    ((ConnectionProbabilityImage)object3).processTracts(streamlineROI_Filter.processTracts(tractCollection));
                                    for (int k = 1; k < n9; ++k) {
                                        TractCollection tractCollection3 = streamlineROI_Filter.processTract(((TractSource)object).nextTract());
                                        ((ConnectionProbabilityImage)object3).processTracts(tractCollection3);
                                    }
                                    if (bl7) {
                                        object8 = ((ConnectionProbabilityImage)object3).getConnectionProbabilities();
                                        AnalyzeHeader.writeImage(object8, analyzeHeader, string6 + (i + 1) + "_" + (j + 1) + "_" + (n23 + 1), bl14);
                                    } else {
                                        object8 = ((ConnectionProbabilityImage)object3).getStreamlineCounts();
                                        AnalyzeHeader.writeImage((int[][][])object8, analyzeHeader2, string6 + (i + 1) + "_" + (j + 1) + "_" + (n23 + 1), bl14);
                                    }
                                    if (((TractSource)object).more()) {
                                        tractCollection = new TractCollection(2, 100.0);
                                        tractCollection.addTract(((TractSource)object).nextTract());
                                        object5 = tractCollection.getTract(0).toVoxelList(d, d2, d3);
                                        object4 = ((VoxelList)object5).getVoxel(((VoxelList)object5).seedPointIndex());
                                    } else {
                                        tractCollection = null;
                                        object5 = null;
                                        object4 = null;
                                        if (j < point3DArray.length - 1) {
                                            throw new LoggedException("No more tracts in input after processing seed " + (j + 1) + " of " + point3DArray.length);
                                        }
                                    }
                                    ++n23;
                                }
                            }
                            continue;
                        }
                        object6 = null;
                        DataOutputStream dataOutputStream = null;
                        if (bl2) {
                            if (bl14) {
                                object6 = new FileOutputStream(string6 + n11 + ".oogl.gz");
                                dataOutputStream = new DataOutputStream(new GZIPOutputStream((OutputStream)object6, 0x1000000));
                            } else {
                                object6 = new FileOutputStream(string6 + n11 + ".oogl");
                                dataOutputStream = new DataOutputStream(new BufferedOutputStream((OutputStream)object6, 0x1000000));
                            }
                            dataOutputStream.write(new String("LIST\n").getBytes());
                        } else if (bl) {
                            if (bl14) {
                                object6 = new FileOutputStream(string6 + n11 + ".Bshort.gz");
                                dataOutputStream = new DataOutputStream(new GZIPOutputStream((OutputStream)object6, 0x1000000));
                            } else {
                                object6 = new FileOutputStream(string6 + n11 + ".Bshort");
                                dataOutputStream = new DataOutputStream(new BufferedOutputStream((OutputStream)object6, 0x1000000));
                            }
                        } else if (bl14) {
                            object6 = new FileOutputStream(string6 + n11 + ".Bfloat.gz");
                            dataOutputStream = new DataOutputStream(new GZIPOutputStream((OutputStream)object6, 0x1000000));
                        } else {
                            object6 = new FileOutputStream(string6 + n11 + ".Bfloat");
                            dataOutputStream = new DataOutputStream(new BufferedOutputStream((OutputStream)object6, 0x1000000));
                        }
                        if (!bl15) {
                            System.err.println();
                        }
                        for (int j = 0; j < point3DArray.length; ++j) {
                            if (n6 > -1 && n17 != n6) {
                                ++n17;
                                continue;
                            }
                            ++n17;
                            if (!bl15) {
                                System.err.print("\rProcessing seed " + (j + 1) + " of " + point3DArray.length);
                            }
                            object5 = voxelArray[j];
                            object4 = tractCollection.getTract(0).toVoxelList(d, d2, d3);
                            object3 = ((VoxelList)object4).getVoxel(((VoxelList)object4).seedPointIndex());
                            while (((Voxel)object5).equals(object3) && tractCollection != null) {
                                TractCollection tractCollection4 = streamlineROI_Filter.processTracts(tractCollection);
                                for (int k = 0; k < tractCollection4.numberOfTracts(); ++k) {
                                    if (bl2) {
                                        dataOutputStream.write(tractCollection4.getTract(k).toOOGLVECT().getBytes());
                                        continue;
                                    }
                                    if (bl) {
                                        tractCollection4.getTract(k).toVoxelList(d, d2, d3).writeVoxelList(dataOutputStream);
                                        continue;
                                    }
                                    tractCollection4.getTract(k).writeRaw(dataOutputStream);
                                }
                                if (((TractSource)object).more()) {
                                    tractCollection = new TractCollection(2, 100.0);
                                    tractCollection.addTract(((TractSource)object).nextTract());
                                    object4 = tractCollection.getTract(0).toVoxelList(d, d2, d3);
                                    object3 = ((VoxelList)object4).getVoxel(((VoxelList)object4).seedPointIndex());
                                    continue;
                                }
                                tractCollection = null;
                                object4 = null;
                                object3 = null;
                                if (j >= point3DArray.length - 1) continue;
                                throw new LoggedException("No more tracts in input after processing seed " + (j + 1) + " of " + point3DArray.length);
                            }
                        }
                        dataOutputStream.close();
                    }
                }
            }
            if (((TractSource)object).more()) {
                logger.warning("Tract processing finished but there are more Tracts in input. Check -seedfile and -iterations options.");
            }
            if (!bl15) {
                System.err.println("\n");
            }
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
    }
}

