/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.PointSetToScheme;
import data.OutputManager;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Locale;
import java.util.logging.Logger;
import misc.LoggedException;
import tools.CL_Initializer;
import tools.FileOutput;

public class PointSetToScheme2 {
    private static final Logger logger = Logger.getLogger("apps.PointSetToScheme2");

    public static void main(String[] stringArray) {
        CL_Initializer.CL_init(stringArray);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Locale.setDefault(Locale.UK);
        boolean bl4 = false;
        double d = 0.0;
        int n = 0;
        DecimalFormat decimalFormat = new DecimalFormat("   0.000000;  -0.000000");
        DecimalFormat decimalFormat2 = new DecimalFormat("   0.000E00");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-bvalue")) {
                d = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-usegradmod")) {
                bl4 = true;
                logger.info("Gradient direction magnitude will be incorporated into b-values");
                CL_Initializer.markAsParsed(i);
                continue;
            }
            if (stringArray[i].equals("-addzeromeas")) {
                n = Integer.parseInt(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-flipx")) {
                bl = true;
                CL_Initializer.markAsParsed(i);
                continue;
            }
            if (stringArray[i].equals("-flipy")) {
                bl2 = true;
                CL_Initializer.markAsParsed(i);
                continue;
            }
            if (!stringArray[i].equals("-flipz")) continue;
            bl3 = true;
            CL_Initializer.markAsParsed(i);
        }
        CL_Initializer.checkParsing(stringArray);
        try {
            int n2;
            int n3;
            double[][] dArray = PointSetToScheme.readPoints(CL_Initializer.inputFile, bl, bl2, bl3);
            double[] dArray2 = PointSetToScheme.getPointModulus(dArray);
            dArray = PointSetToScheme.normalizePoints(dArray);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("VERSION: 2\n");
            int n4 = dArray.length;
            for (n3 = 0; n3 < n; ++n3) {
                for (n2 = 0; n2 < 3; ++n2) {
                    stringBuffer.append(decimalFormat.format(0.0));
                }
                stringBuffer.append(decimalFormat2.format(0.0) + "\n");
            }
            n3 = 0;
            for (n2 = 0; n2 < n4; ++n2) {
                for (int i = 0; i < 3; ++i) {
                    stringBuffer.append(decimalFormat.format(dArray[n2][i]));
                }
                if (dArray[n2][0] == 0.0 && dArray[n2][1] == 0.0 && dArray[n2][2] == 0.0) {
                    stringBuffer.append(decimalFormat2.format(0.0) + "\n");
                    continue;
                }
                if (bl4) {
                    stringBuffer.append(decimalFormat2.format(d * dArray2[n2] * dArray2[n2]) + "\n");
                    continue;
                }
                if (dArray2[n2] != 0.0 && !(Math.abs(1.0 - dArray2[n2]) < 1.0E-5)) {
                    n3 = 1;
                }
                stringBuffer.append(decimalFormat2.format(d) + "\n");
            }
            if (OutputManager.outputFile == null) {
                System.out.print(stringBuffer.toString());
            } else {
                FileOutput fileOutput = new FileOutput(OutputManager.outputFile);
                fileOutput.writeString(stringBuffer.toString());
                fileOutput.close();
            }
            if (n3 != 0) {
                logger.warning("Some measurements have non-unit gradient directions. Directions have been normalized to unit length");
            }
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
    }
}

