/*
 * Decompiled with CFR 0.152.
 */
package apps;

import data.DataSourceException;
import data.OutputManager;
import imaging.Scheme;
import inverters.BallStickInversion;
import inverters.DT_Inversion;
import inverters.DiffusionInversion;
import inverters.LinearADC_Inversion;
import inverters.ModelIndex;
import inverters.RestoreDT_Inversion;
import inverters.ThreeTensorInversion;
import inverters.TwoTensorInversion;
import java.util.logging.Logger;
import misc.LoggedException;
import tools.CL_Initializer;

public class ModelFit {
    private static Logger logger = Logger.getLogger("camino.apps.ModelFit");
    private static OutputManager om;

    public static void main(String[] stringArray) {
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.checkParsing(stringArray);
        CL_Initializer.initImagingScheme();
        CL_Initializer.initDataSynthesizer();
        om = new OutputManager();
        DiffusionInversion diffusionInversion = ModelFit.getIndexedInversion(CL_Initializer.inversionIndices, CL_Initializer.imPars);
        ModelFit.processVoxels(diffusionInversion, om);
    }

    public static void processVoxels(DiffusionInversion diffusionInversion, OutputManager outputManager) {
        int n = 0;
        while (CL_Initializer.data.more()) {
            try {
                double[] dArray;
                double[] dArray2 = CL_Initializer.data.nextVoxel();
                double d = CL_Initializer.imPars.geoMeanZeroMeas(dArray2);
                if (ModelFit.isBG(d)) {
                    dArray = new double[diffusionInversion.itemsPerVoxel()];
                    dArray[0] = -1.0;
                    dArray[1] = d > 0.0 ? Math.log(d) : 0.0;
                    outputManager.output(dArray);
                    diffusionInversion.background();
                } else {
                    dArray = diffusionInversion.invert(dArray2);
                    outputManager.output(dArray);
                }
                logger.fine("Completed voxel: " + ++n);
            }
            catch (DataSourceException dataSourceException) {
                throw new LoggedException("The data file does not contain a whole number of voxels.Check the scheme file. Got Exception " + dataSourceException);
            }
        }
        diffusionInversion.close();
        outputManager.close();
    }

    public static DiffusionInversion getIndexedInversion(ModelIndex[] modelIndexArray, Scheme scheme) {
        if (modelIndexArray[0] == ModelIndex.BALL_STICK) {
            return new BallStickInversion(scheme);
        }
        if (modelIndexArray[0] == ModelIndex.RESTORE) {
            if (CL_Initializer.sigma == -1.0) {
                logger.severe("Noise level must be specified (-sigma <std>) for RESTORE.");
                System.exit(1);
            }
            return new RestoreDT_Inversion(scheme, CL_Initializer.sigma);
        }
        if (modelIndexArray[0] == ModelIndex.ADC) {
            return new LinearADC_Inversion(scheme);
        }
        if (modelIndexArray[0].numDTs == 1) {
            return DT_Inversion.getIndexedDT_Inversion(modelIndexArray[0], scheme);
        }
        if (modelIndexArray[0].numDTs == 2) {
            if (modelIndexArray.length == 1) {
                return new TwoTensorInversion(scheme, modelIndexArray[0], ModelIndex.LDT);
            }
            return new TwoTensorInversion(scheme, modelIndexArray[0], modelIndexArray[1]);
        }
        if (modelIndexArray[0].numDTs == 3) {
            if (modelIndexArray.length == 1) {
                return new ThreeTensorInversion(scheme, modelIndexArray[0], ModelIndex.LDT);
            }
            return new ThreeTensorInversion(scheme, modelIndexArray[0], modelIndexArray[1]);
        }
        return null;
    }

    public static boolean isBG(double d) {
        boolean bl = false;
        if (CL_Initializer.BACKGROUNDTHRESHOLD > 0.0) {
            boolean bl2 = bl = d < CL_Initializer.BACKGROUNDTHRESHOLD;
        }
        if (CL_Initializer.bgMask != null) {
            try {
                bl = CL_Initializer.bgMask.nextVoxel()[0] == 0.0;
            }
            catch (DataSourceException dataSourceException) {
                throw new LoggedException("Error reading background mask." + dataSourceException);
            }
        }
        return bl;
    }
}

