/*
 * Decompiled with CFR 0.152.
 */
package apps;

import data.VoxelOrderDataSource;
import imaging.Scheme;
import java.util.logging.Logger;
import simulation.SimulationParams;
import tools.CL_Initializer;

public class GatherStats {
    private static final Logger logger = Logger.getLogger("apps.GatherStats");
    private static double[] xaxis = new double[]{0.4924, 0.6327, 0.69, 0.8355, 0.8869, 0.9489, 0.9791, 0.99, 0.9999, 1.0};

    public static void main(String[] stringArray) {
        int n;
        int n2;
        int n3;
        int n4;
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.checkParsing(stringArray);
        int n5 = 1;
        if (CL_Initializer.brownianSimulation) {
            CL_Initializer.brownianSimulation = false;
            n5 = SimulationParams.sim_inflamm_increments;
        }
        CL_Initializer.initImagingScheme();
        Scheme scheme = CL_Initializer.imPars;
        VoxelOrderDataSource voxelOrderDataSource = new VoxelOrderDataSource(CL_Initializer.inputFile, scheme.numMeasurements(), CL_Initializer.inputDataType);
        int n6 = scheme.numMeasurements();
        double[][] dArray = new double[n6][n5];
        double[][] dArray2 = new double[n6][n5];
        for (n4 = 0; n4 < n6; ++n4) {
            for (n3 = 0; n3 < n5; ++n3) {
                dArray[n4][n3] = 0.0;
                dArray2[n4][n3] = 0.0;
            }
        }
        n4 = 0;
        while (voxelOrderDataSource.more()) {
            for (n3 = 0; n3 < n5; ++n3) {
                double[] dArray3 = voxelOrderDataSource.nextVoxel();
                double d = dArray3[0];
                for (int i = 1; i < n6; ++i) {
                    double[] dArray4 = dArray[i];
                    int n7 = n3;
                    dArray4[n7] = dArray4[n7] + dArray3[i] / d;
                    double[] dArray5 = dArray2[i];
                    int n8 = n3;
                    dArray5[n8] = dArray5[n8] + dArray3[i] / d * (dArray3[i] / d);
                }
            }
            ++n4;
        }
        double[][] dArray6 = new double[n6][n5];
        double d = 0.0;
        double d2 = Double.MAX_VALUE;
        double d3 = 0.0;
        for (n2 = 1; n2 < n6; ++n2) {
            for (n = 0; n < n5; ++n) {
                double[] dArray7 = dArray[n2];
                int n9 = n;
                dArray7[n9] = dArray7[n9] / (double)n4;
                double[] dArray8 = dArray2[n2];
                int n10 = n;
                dArray8[n10] = dArray8[n10] / (double)n4;
                dArray6[n2][n] = Math.sqrt(dArray2[n2][n] - dArray[n2][n] * dArray[n2][n]);
                d += dArray6[n2][n];
                if (dArray6[n2][n] < d2) {
                    d2 = dArray6[n2][n];
                }
                if (!(dArray6[n2][n] > d3)) continue;
                d3 = dArray6[n2][n];
            }
        }
        d /= (double)n6;
        logger.info("std devs of each signal:");
        for (n2 = 1; n2 < n6; ++n2) {
            for (n = 0; n < n5; ++n) {
                System.err.println(xaxis[n] + "," + dArray[n2][n] + "," + dArray6[n2][n]);
            }
            System.err.println();
        }
        logger.info("mean std dev is " + d);
        logger.info("min  std dev is " + d2);
        logger.info("max  std dev is " + d3);
    }
}

