/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.ModelFit;
import data.DataSourceException;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.logging.Logger;
import misc.LoggedException;
import tools.CL_Initializer;

public class DataStats {
    private static Logger logger = Logger.getLogger("camino.apps.ModelFit");

    public static void main(String[] stringArray) {
        Object object;
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.checkParsing(stringArray);
        CL_Initializer.initImagingScheme();
        CL_Initializer.initDataSynthesizer();
        int n = 0;
        double[] dArray = new double[CL_Initializer.imPars.numMeasurements()];
        double[] dArray2 = new double[CL_Initializer.imPars.numMeasurements()];
        while (CL_Initializer.data.more()) {
            try {
                object = CL_Initializer.data.nextVoxel();
                double d = CL_Initializer.imPars.geoMeanZeroMeas((double[])object);
                if (ModelFit.isBG(d)) continue;
                ++n;
                for (int i = 0; i < ((double[])object).length; ++i) {
                    int n2 = i;
                    dArray[n2] = dArray[n2] + object[i];
                    int n3 = i;
                    dArray2[n3] = dArray2[n3] + object[i] * object[i];
                }
            }
            catch (DataSourceException dataSourceException) {
                throw new LoggedException("The data file does not contain a whole number of voxels.Check the scheme file. Got Exception " + dataSourceException);
            }
        }
        object = new DecimalFormat("0.000000E00;-0.000000E00");
        System.out.println("Foreground voxel count: " + n);
        System.out.println("Component   E(S)           E(S^2)         Var(S)         Std(S)");
        Object[] objectArray = new Object[1];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = dArray[i] / (double)n;
            dArray2[i] = dArray2[i] / (double)n;
            objectArray[0] = new Integer(i + 1);
            System.out.print(MessageFormat.format("{0,number, 0;-0}", objectArray));
            objectArray[0] = new Double(dArray[i]);
            System.out.print("          " + object.format(((Number)objectArray[0]).doubleValue()));
            objectArray[0] = new Double(dArray2[i]);
            System.out.print("    " + object.format(((Number)objectArray[0]).doubleValue()));
            objectArray[0] = new Double(dArray2[i] - dArray[i] * dArray[i]);
            System.out.print("    " + object.format(((Number)objectArray[0]).doubleValue()));
            objectArray[0] = new Double(Math.sqrt(dArray2[i] - dArray[i] * dArray[i]));
            System.out.println("    " + object.format(((Number)objectArray[0]).doubleValue()));
        }
    }
}

