/*
 * Decompiled with CFR 0.152.
 */
package apps;

import data.DataSynthesizer;
import data.OutputManager;
import data.VoxelOrderDataSource;
import java.util.logging.Logger;
import numerics.MTRandom;
import tools.CL_Initializer;

public class AddNoise {
    private static final Logger logger = Logger.getLogger("apps.AddNoise");
    private static OutputManager om;

    public static void main(String[] stringArray) {
        CL_Initializer.inputDataType = "float";
        OutputManager.outputDataType = "float";
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.checkParsing(stringArray);
        MTRandom mTRandom = new MTRandom(CL_Initializer.seed);
        om = new OutputManager();
        VoxelOrderDataSource voxelOrderDataSource = new VoxelOrderDataSource(CL_Initializer.inputFile, 1, CL_Initializer.inputDataType);
        if (CL_Initializer.sigma <= 0.0) {
            String string = new String("Must set the noise level.  Include -sigma <sigma>.");
            logger.severe(string);
            throw new RuntimeException(string);
        }
        boolean bl = false;
        if (CL_Initializer.noiseType.toLowerCase().equals("gaussian")) {
            bl = true;
        }
        int n = Math.max(CL_Initializer.numVoxels, 1);
        while (voxelOrderDataSource.more()) {
            double[] dArray = voxelOrderDataSource.nextVoxel();
            for (int i = 0; i < n; ++i) {
                double[] dArray2 = bl ? DataSynthesizer.addGaussianNoise(dArray, CL_Initializer.sigma, mTRandom) : DataSynthesizer.addNoise(dArray, CL_Initializer.sigma, mTRandom);
                om.output(dArray2);
            }
        }
        om.close();
    }
}

