/*
 * Decompiled with CFR 0.152.
 */
package JSci.instruments;

import JSci.instruments.ROIAdapter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;

public class RectangularROI
extends ROIAdapter {
    private static final int LW = 3;
    private int minx;
    private int maxx;
    private int miny;
    private int maxy;
    private Component comp = null;
    private int state;
    private int iX;
    private int iY;
    private int vminx;
    private int vmaxx;
    private int vminy;
    private int vmaxy;

    public RectangularROI(int n, int n2, int n3, int n4) {
        this.minx = n;
        this.maxx = n3;
        this.miny = n2;
        this.maxy = n4;
    }

    public Shape getShape() {
        return new Rectangle(this.minx, this.miny, this.maxx - this.minx + 1, this.maxy - this.miny + 1);
    }

    public void setComponent(Component component) {
        if (this.comp != null) {
            this.comp.removeMouseListener(this);
            this.comp.removeMouseMotionListener(this);
        }
        this.comp = component;
        if (this.comp != null) {
            this.comp.addMouseListener(this);
            this.comp.addMouseMotionListener(this);
        }
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.GREEN);
        ((Graphics2D)graphics).draw(this.getShape());
    }

    private int region(Point point) {
        if (point.x < this.minx || point.x > this.maxx || point.y < this.miny || point.y > this.maxy) {
            return 0;
        }
        if (point.y <= this.miny + 3) {
            if (point.x <= this.minx + 3) {
                return 1;
            }
            if (point.x < this.maxx - 3) {
                return 2;
            }
            return 3;
        }
        if (point.y < this.maxy - 3) {
            if (point.x <= this.minx + 3) {
                return 4;
            }
            if (point.x < this.maxx - 3) {
                return 5;
            }
            return 6;
        }
        if (point.x <= this.minx + 3) {
            return 7;
        }
        if (point.x < this.maxx - 3) {
            return 8;
        }
        return 9;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.state = this.region(mouseEvent.getPoint());
        this.iX = mouseEvent.getX();
        this.iY = mouseEvent.getY();
        this.vminx = this.minx;
        this.vmaxx = this.maxx;
        this.vminy = this.miny;
        this.vmaxy = this.maxy;
        this.comp.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.state = 0;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        switch (this.region(mouseEvent.getPoint())) {
            case 0: {
                this.comp.setCursor(Cursor.getDefaultCursor());
                break;
            }
            case 1: {
                this.comp.setCursor(Cursor.getPredefinedCursor(6));
                break;
            }
            case 2: {
                this.comp.setCursor(Cursor.getPredefinedCursor(8));
                break;
            }
            case 3: {
                this.comp.setCursor(Cursor.getPredefinedCursor(7));
                break;
            }
            case 4: {
                this.comp.setCursor(Cursor.getPredefinedCursor(10));
                break;
            }
            case 5: {
                this.comp.setCursor(Cursor.getPredefinedCursor(13));
                break;
            }
            case 6: {
                this.comp.setCursor(Cursor.getPredefinedCursor(11));
                break;
            }
            case 7: {
                this.comp.setCursor(Cursor.getPredefinedCursor(4));
                break;
            }
            case 8: {
                this.comp.setCursor(Cursor.getPredefinedCursor(9));
                break;
            }
            case 9: {
                this.comp.setCursor(Cursor.getPredefinedCursor(5));
            }
        }
    }

    private int clip(int n, int n2, int n3) {
        if (n2 < n) {
            return n;
        }
        if (n2 > n3) {
            return n3;
        }
        return n2;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = n - this.iX;
        int n4 = n2 - this.iY;
        switch (this.state) {
            case 0: {
                this.minx = Math.min(n, this.iX);
                this.maxx = Math.max(n, this.iX);
                this.miny = Math.min(n2, this.iY);
                this.maxy = Math.max(n2, this.iY);
                break;
            }
            case 1: {
                this.minx = this.clip(0, this.vminx + n3, this.maxx);
                this.miny = this.clip(0, this.vminy + n4, this.maxy);
                break;
            }
            case 2: {
                this.miny = this.clip(0, this.vminy + n4, this.maxy);
                break;
            }
            case 3: {
                this.maxx = this.clip(this.minx, this.vmaxx + n3, this.comp.getWidth() - 1);
                this.miny = this.clip(0, this.vminy + n4, this.maxy);
                break;
            }
            case 4: {
                this.minx = this.clip(0, this.vminx + n3, this.maxx);
                break;
            }
            case 5: {
                if (this.vminx + n3 < 0) {
                    n3 = -this.vminx;
                }
                if (this.vmaxx + n3 >= this.comp.getWidth()) {
                    n3 = this.comp.getWidth() - this.vmaxx - 1;
                }
                if (this.vminy + n4 < 0) {
                    n4 = -this.vminy;
                }
                if (this.vmaxy + n4 >= this.comp.getHeight()) {
                    n4 = this.comp.getHeight() - this.vmaxy - 1;
                }
                this.minx = this.vminx + n3;
                this.maxx = this.vmaxx + n3;
                this.miny = this.vminy + n4;
                this.maxy = this.vmaxy + n4;
                break;
            }
            case 6: {
                this.maxx = this.clip(this.minx, this.vmaxx + n3, this.comp.getWidth() - 1);
                break;
            }
            case 7: {
                this.minx = this.clip(0, this.vminx + n3, this.maxx);
                this.maxy = this.clip(this.miny, this.vmaxy + n4, this.comp.getHeight() - 1);
                break;
            }
            case 8: {
                this.maxy = this.clip(this.miny, this.vmaxy + n4, this.comp.getHeight() - 1);
                break;
            }
            case 9: {
                this.maxx = this.clip(this.minx, this.vmaxx + n3, this.comp.getWidth() - 1);
                this.maxy = this.clip(this.miny, this.vmaxy + n4, this.comp.getHeight() - 1);
            }
        }
        this.comp.repaint();
    }
}

