/*
 * Decompiled with CFR 0.152.
 */
package JSci.instruments;

import JSci.instruments.Image;
import JSci.instruments.ImageSink;
import JSci.instruments.ImageSource;
import JSci.instruments.Player;
import com.inzyme.jmds.DSCaptureDeviceInfo;
import com.inzyme.jmds.DSCaptureDeviceManager;
import com.inzyme.jmds.DSCapturePin;
import com.inzyme.jmds.DSDataSource;
import java.awt.Component;
import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.PushBufferStream;

public class Marlin
implements ImageSource,
BufferTransferHandler {
    private Dimension dim = new Dimension(640, 480);
    private ImageSink sink;

    public Marlin() {
        DSCaptureDeviceInfo[] dSCaptureDeviceInfoArray = DSCaptureDeviceManager.getCaptureDevices();
        DSCapturePin[] dSCapturePinArray = dSCaptureDeviceInfoArray[0].getPins();
        DSDataSource dSDataSource = new DSDataSource(dSCapturePinArray[0]);
        try {
            dSDataSource.connect();
            dSDataSource.start();
        }
        catch (Exception exception) {
            System.out.println("Unable to connect to camera: " + exception);
            System.exit(2);
        }
        PushBufferStream[] pushBufferStreamArray = dSDataSource.getStreams();
        pushBufferStreamArray[0].setTransferHandler((BufferTransferHandler)this);
    }

    public void transferData(PushBufferStream pushBufferStream) {
        if (this.sink == null) {
            return;
        }
        final byte[] byArray = new byte[this.getSize().width * this.getSize().height];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 0;
        }
        Buffer buffer = new Buffer();
        buffer.setData((Object)byArray);
        buffer.setLength(this.getSize().width * this.getSize().height);
        buffer.setFormat(pushBufferStream.getFormat());
        try {
            pushBufferStream.read(buffer);
        }
        catch (Exception exception) {
            System.out.println("Frame lost " + exception);
            throw new Error();
        }
        final long l = System.currentTimeMillis();
        final Dimension dimension = new Dimension(this.getWidth(), this.getHeight());
        Image image = new Image(){

            public byte[] getData() {
                return byArray;
            }

            public Dimension getSize() {
                return dimension;
            }

            public long getTimeStamp() {
                return l;
            }
        };
        this.sink.receive(image);
    }

    public void setSink(ImageSink imageSink) {
        if (this.sink != imageSink) {
            this.sink = imageSink;
            this.sink.setSource(this);
        }
    }

    public int getWidth() {
        return this.dim.width;
    }

    public int getHeight() {
        return this.dim.height;
    }

    public Dimension getSize() {
        return this.dim;
    }

    public Component getControlComponent() {
        return null;
    }

    public static void main(String[] stringArray) {
        Marlin marlin = new Marlin();
        Player player = new Player();
        marlin.setSink(player);
        player.start();
    }
}

