/*
 * Decompiled with CFR 0.152.
 */
package JSci.instruments;

import JSci.instruments.Dimensions;
import JSci.instruments.Overlay;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.util.ArrayList;

public abstract class Image
implements Dimensions {
    private static ColorModel cm;
    private ArrayList ovrl = new ArrayList();

    public int getWidth() {
        return this.getSize().width;
    }

    public int getHeight() {
        return this.getSize().height;
    }

    public abstract Dimension getSize();

    public int getScansize() {
        return this.getSize().width;
    }

    public int getOffset() {
        return 0;
    }

    public ColorModel getColorModel() {
        return cm;
    }

    public abstract byte[] getData();

    public long getTimeStamp() {
        return 0L;
    }

    public void doOverlay(Graphics graphics) {
        for (int i = 0; i < this.ovrl.size(); ++i) {
            ((Overlay)this.ovrl.get(i)).paint(graphics);
        }
    }

    public void addOverlay(Overlay overlay) {
        this.ovrl.add(overlay);
    }

    public Image getSubImage(Rectangle rectangle) {
        final int n = rectangle.width;
        final int n2 = rectangle.height;
        final byte[] byArray = new byte[n * n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                byArray[i + j * n] = this.getData()[this.getOffset() + (rectangle.x + i) + (rectangle.y + j) * this.getScansize()];
            }
        }
        return new Image(){

            public int getWidth() {
                return n;
            }

            public int getHeight() {
                return n2;
            }

            public Dimension getSize() {
                return new Dimension(n, n2);
            }

            public int getScansize() {
                return n;
            }

            public int getOffset() {
                return 0;
            }

            public byte[] getData() {
                return byArray;
            }
        };
    }

    static {
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        for (int i = 0; i < 256; ++i) {
            byArray2[i] = byArray3[i] = (byte)i;
            byArray[i] = byArray3[i];
        }
        cm = new IndexColorModel(8, 256, byArray, byArray2, byArray3);
    }
}

