/*
 * Decompiled with CFR 0.152.
 */
package JSci.instruments;

import JSci.instruments.PositionControlAdapter;
import JSci.swing.JPointer;
import JSci.swing.JSliderPlus;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DummyPositionControl
extends PositionControlAdapter {
    private double position = Double.NaN;
    private JComponent ccomp = null;

    public void setPosition(double d) {
        if (d < this.getMinimum() || d > this.getMaximum() || this.position == d) {
            return;
        }
        this.position = d;
        this.doSetPosition(d);
        this.fireStateChanged();
    }

    protected void doSetPosition(double d) {
    }

    public double getPosition() {
        if (Double.isNaN(this.position)) {
            this.position = this.getActualPosition();
        }
        return this.position;
    }

    public double getActualPosition() {
        if (Double.isNaN(this.position)) {
            this.position = 50.0;
        }
        return this.position;
    }

    public double getMinimum() {
        return 0.0;
    }

    public double getMaximum() {
        return 100.0;
    }

    public double getMinorStep() {
        return 10.0;
    }

    public double getMajorStep() {
        return 20.0;
    }

    public void sleep() {
    }

    private JComponent createControlPanel() {
        JSliderPlus jSliderPlus = new JSliderPlus(1, this.getMinimum(), this.getMaximum());
        final JPointer jPointer = new JPointer(3);
        jPointer.setValue(this.getPosition());
        jPointer.setColor(Color.MAGENTA);
        jSliderPlus.setMinorTickSpacing(this.getMinorStep());
        jSliderPlus.setMajorTickSpacing(this.getMajorStep());
        jSliderPlus.setPaintMinorTicks(true);
        jSliderPlus.setPaintMajorTicks(true);
        jSliderPlus.setPaintLabels(true);
        jSliderPlus.addJPointer(jPointer);
        final JSpinner jSpinner = new JSpinner(new SpinnerNumberModel(this.getPosition(), this.getMinimum(), this.getMaximum(), this.getMinorStep()));
        JPanel jPanel = new JPanel(){

            public void setEnabled(boolean bl) {
                super.setEnabled(bl);
                jPointer.setEnabled(bl);
                jSpinner.setEnabled(bl);
            }
        };
        jPanel.setLayout(new BorderLayout());
        jPanel.add("West", (Component)jSliderPlus);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jSpinner);
        jPanel.add("East", jPanel2);
        jSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                double d = (Double)jSpinner.getValue();
                DummyPositionControl.this.setPosition(d);
            }
        });
        jPointer.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                double d = jPointer.getValue();
                DummyPositionControl.this.setPosition(d);
            }
        });
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                double d = DummyPositionControl.this.getPosition();
                jSpinner.setValue(new Double(d));
                jPointer.setValue(d);
            }
        });
        return jPanel;
    }

    public Component getControlComponent() {
        if (this.ccomp == null) {
            this.ccomp = this.createControlPanel();
        }
        return this.ccomp;
    }

    public String getUnit() {
        return "unknown";
    }

    public static void main(String[] stringArray) {
        DummyPositionControl dummyPositionControl = new DummyPositionControl(){};
        JFrame jFrame = new JFrame("Testing the DummyPositionControl");
        jFrame.getContentPane().add(dummyPositionControl.getControlComponent());
        jFrame.pack();
        jFrame.setDefaultCloseOperation(3);
        jFrame.show();
    }
}

