/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.util;

import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import ptolemy.util.ClassUtilities;

public class XSLTUtilities {
    private static boolean _exportDTD = false;

    private XSLTUtilities() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String lastArg;
        String outputFileName = lastArg = args[args.length - 1];
        int numberOfTransformers = args.length - 2;
        if (lastArg.compareTo("exportMoMLDTD") == 0) {
            _exportDTD = true;
            outputFileName = args[args.length - 2];
            numberOfTransformers = args.length - 3;
        } else {
            _exportDTD = false;
        }
        if (_exportDTD && args.length < 4 || !_exportDTD && args.length < 3) {
            System.err.println("Usage: java -classpath $PTII ptolemy.util.XSLTUtilities inputFile xslFile1 [xslFile2 . . .] outputFile [exportMoMLDTD]");
            System.exit(2);
        }
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(outputFileName);
            Document inputDocument = XSLTUtilities.parse(args[0]);
            LinkedList<String> transforms = new LinkedList<String>();
            for (int i = 1; i < numberOfTransformers + 1; ++i) {
                transforms.add(args[i]);
            }
            Document outputDocument = XSLTUtilities.transform(inputDocument, transforms);
            XSLTUtilities._writeOutput(XSLTUtilities.toString(outputDocument), fileWriter);
        }
        finally {
            if (fileWriter != null) {
                fileWriter.close();
            }
        }
    }

    public static Document parse(String filename) throws ParserConfigurationException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        try {
            return builder.parse(new InputSource(filename));
        }
        catch (SAXException ex) {
            IOException exception = new IOException("Failed to parse '" + filename + "'");
            exception.initCause(ex);
            throw exception;
        }
    }

    public static void setExportDTD(boolean exportDTD) {
        _exportDTD = exportDTD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Document document) throws TransformerException, IOException {
        ByteArrayOutputStream outputStream = null;
        try {
            outputStream = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(outputStream);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer serializer = transformerFactory.newTransformer();
            serializer.transform(new DOMSource(document), result);
            String string = ((Object)outputStream).toString();
            return string;
        }
        finally {
            if (outputStream != null) {
                ((OutputStream)outputStream).close();
            }
        }
    }

    public static Document transform(Document inputDocument, String xslFileName) throws TransformerException, IOException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setErrorListener(new ErrorListener(){

            @Override
            public void error(TransformerException exception) throws TransformerException {
                throw exception;
            }

            @Override
            public void fatalError(TransformerException exception) throws TransformerException {
                throw exception;
            }

            @Override
            public void warning(TransformerException exception) {
                System.err.println("ptolemy.util.XSLTUtilities.transform(): Warning: " + exception);
            }
        });
        Transformer transformer = null;
        try {
            transformer = transformerFactory.newTransformer(new StreamSource(xslFileName));
        }
        catch (TransformerConfigurationException ex) {
            try {
                Class<?> refClass = Class.forName("ptolemy.util.XSLTUtilities");
                URL entryURL = refClass.getClassLoader().getResource(xslFileName);
                if (entryURL == null) {
                    IOException exception = new IOException("Failed to open '" + xslFileName + "'");
                    exception.initCause(ex);
                    throw exception;
                }
                transformer = transformerFactory.newTransformer(new StreamSource(entryURL.toString()));
            }
            catch (Exception ex2) {
                IOException exception = new IOException("Failed to open \"" + xslFileName + "\".\n" + "Searching the classpath threw:\n" + ex2);
                exception.initCause(ex);
                throw exception;
            }
        }
        DOMResult result = new DOMResult();
        transformer.transform(new DOMSource(inputDocument), result);
        return (Document)result.getNode();
    }

    public static Document transform(Document inputDocument, List xslFileNames) throws TransformerException, IOException {
        for (String fileName : xslFileNames) {
            inputDocument = XSLTUtilities.transform(inputDocument, fileName);
        }
        return inputDocument;
    }

    public static void transform(String input, FileWriter fileWriter, List xslFileNames) throws ParserConfigurationException, TransformerException, IOException {
        Document inputDocument = null;
        try {
            inputDocument = XSLTUtilities.parse(input);
        }
        catch (IOException ex) {
            try {
                URL jarURL = ClassUtilities.jarURLEntryResource(input);
                if (jarURL == null) {
                    throw new IOException("'" + input + "' was not a jar " + "URL, or was not found");
                }
                inputDocument = XSLTUtilities.parse(jarURL.toString());
            }
            catch (IOException ex2) {
                throw ex;
            }
        }
        Document outputDocument = XSLTUtilities.transform(inputDocument, xslFileNames);
        XSLTUtilities._writeOutput(XSLTUtilities.toString(outputDocument), fileWriter);
    }

    private static void _writeOutput(String outputString, FileWriter fileWriter) throws IOException {
        if (_exportDTD) {
            int positionToInsertDTD = outputString.indexOf("<!--");
            fileWriter.write(outputString, 0, positionToInsertDTD);
            fileWriter.write("\r\n<!DOCTYPE entity PUBLIC \"-//UC Berkeley//DTD MoML 1//EN\" \r\n\"http://ptolemy.eecs.berkeley.edu/xml/dtd/MoML_1.dtd\">");
            fileWriter.write(outputString.substring(positionToInsertDTD));
        } else {
            fileWriter.write(outputString);
        }
    }
}

