/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.moml.filter;

import java.util.HashMap;
import java.util.Iterator;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.MoMLFilter;
import ptolemy.moml.MoMLParser;

public class AddIcon
implements MoMLFilter {
    private static HashMap _actorsThatShouldHaveIcons = new HashMap();
    private String _currentActorFullName;
    private boolean _currentlyProcessingActorThatMayNeedAnIcon = false;
    private String _iconMoML;
    private String _lastNameSeen;
    private static MoMLParser _parser;

    @Override
    public String filterAttributeValue(NamedObj container, String element, String attributeName, String attributeValue) {
        if (attributeValue == null) {
            return null;
        }
        if (attributeName.equals("name")) {
            this._lastNameSeen = attributeValue;
            if (this._currentlyProcessingActorThatMayNeedAnIcon && attributeValue.equals("_icon")) {
                this._currentlyProcessingActorThatMayNeedAnIcon = false;
            }
        }
        if (attributeName.equals("class")) {
            if (_actorsThatShouldHaveIcons.containsKey(attributeValue)) {
                this._currentlyProcessingActorThatMayNeedAnIcon = true;
                this._currentActorFullName = container != null ? container.getFullName() + "." + this._lastNameSeen : "." + this._lastNameSeen;
                this._iconMoML = (String)_actorsThatShouldHaveIcons.get(attributeValue);
            } else if (this._currentlyProcessingActorThatMayNeedAnIcon && container != null && !container.getFullName().equals(this._currentActorFullName) && !container.getFullName().startsWith(this._currentActorFullName)) {
                this._currentlyProcessingActorThatMayNeedAnIcon = false;
            }
        }
        return attributeValue;
    }

    @Override
    public void filterEndElement(NamedObj container, String elementName) throws Exception {
        if (this._currentlyProcessingActorThatMayNeedAnIcon && elementName.equals("entity") && container != null && container.getFullName().equals(this._currentActorFullName)) {
            this._currentlyProcessingActorThatMayNeedAnIcon = false;
            if (_parser == null) {
                _parser = new MoMLParser();
            }
            _parser.setContext(container);
            try {
                _parser.parse(null, this._iconMoML);
                MoMLParser.setModified(true);
            }
            catch (Exception ex) {
                throw new IllegalActionException(null, ex, "Failed to parse\n" + this._iconMoML);
            }
        }
    }

    @Override
    public String toString() {
        StringBuffer results = new StringBuffer(this.getClass().getName() + ": Add specialized icons that display the value\n" + "of one of the parameters.\n" + "The affected actors are:\n");
        Iterator actors = _actorsThatShouldHaveIcons.keySet().iterator();
        while (actors.hasNext()) {
            results.append("\t" + (String)actors.next() + "\n");
        }
        return results.toString();
    }

    static {
        _actorsThatShouldHaveIcons.put("ptolemy.actor.lib.Const", "<property name=\"_icon\" class=\"ptolemy.vergil.icon.BoxedValueIcon\">\n<property name=\"attributeName\" value=\"value\"/>\n<property name=\"displayWidth\" value=\"40\"/>\n</property>\n");
        _actorsThatShouldHaveIcons.put("ptolemy.actor.lib.Expression", "<property name=\"_icon\" class=\"ptolemy.vergil.icon.BoxedValueIcon\">\n<property name=\"attributeName\" value=\"expression\"/>\n<property name=\"displayWidth\" value=\"60\"/>\n</property>\n");
        String functionIcon = "<property name=\"_icon\" class=\"ptolemy.vergil.icon.AttributeValueIcon\">\n<property name=\"attributeName\" value=\"function\"/>\n</property>\n";
        _actorsThatShouldHaveIcons.put("ptolemy.actor.lib.MathFunction", functionIcon);
        _actorsThatShouldHaveIcons.put("ptolemy.actor.lib.Scale", "<property name=\"_icon\" class=\"ptolemy.vergil.icon.AttributeValueIcon\">\n<property name=\"attributeName\" value=\"factor\"/>\n</property>\n");
        _actorsThatShouldHaveIcons.put("ptolemy.actor.lib.TrigFunction", functionIcon);
    }
}

