/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.moml;

import java.util.Stack;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NamedObj;

public class UndoContext {
    private boolean _childrenUndoable;
    private boolean _undoable;
    private StringBuffer _undoMoML;
    private StringBuffer _closingUndoMoML;
    private Stack _undoChildEntries;

    public UndoContext(boolean undoableContext) {
        this._undoable = undoableContext;
        this._undoChildEntries = new Stack();
        this._undoMoML = new StringBuffer();
        this._closingUndoMoML = new StringBuffer();
    }

    public void appendClosingUndoMoML(String undoMoML) {
        this._closingUndoMoML.insert(0, undoMoML);
    }

    public void appendUndoMoML(String undoMoML) {
        this._undoMoML.append(undoMoML);
    }

    public void applyRename(String newName) throws IllegalActionException {
        if (this._undoMoML.length() == 0) {
            throw new IllegalActionException("Failed to create undo entry:\nCannot rename an element whose parent undo context does not have any undo MoML. Requested new name: " + newName);
        }
        String undo = this._undoMoML.toString();
        String marker = "name=\"";
        int startIndex = undo.indexOf("name=\"");
        if (startIndex == -1) {
            throw new IllegalActionException("Failed to create undo entry:\nCannot rename an element whose parent undo context does not have a name attribute in its undo MoML. Requested new name: " + newName);
        }
        int endIndex = undo.indexOf("\"", startIndex += marker.length());
        if (endIndex == -1) {
            throw new IllegalActionException("Failed to create undo entry:\nCannot rename an element whose parent undo context does not have a valid name attribute in its undo MoML. Requested new name: " + newName);
        }
        this._undoMoML.replace(startIndex, endIndex, newName);
    }

    public String generateUndoEntry() {
        while (!this._undoChildEntries.isEmpty()) {
            this._undoMoML.append((String)this._undoChildEntries.pop());
        }
        this._undoMoML.append(this._closingUndoMoML.toString());
        return this._undoMoML.toString();
    }

    public String getUndoMoML() {
        return this._undoMoML.toString();
    }

    public boolean hasUndoMoML() {
        return this._undoMoML.length() > 0;
    }

    public boolean hasUndoableChildren() {
        return this._childrenUndoable;
    }

    public boolean isUndoable() {
        return this._undoable;
    }

    public static String moveContextEnd(NamedObj context, NamedObj containee) {
        if (UndoContext.moveContextStart(context, containee).equals("")) {
            return "";
        }
        NamedObj container = containee.getContainer();
        return "</" + container.getElementName() + ">\n";
    }

    public static String moveContextStart(NamedObj context, NamedObj containee) {
        if (context == null || containee == null) {
            return "";
        }
        NamedObj container = containee.getContainer();
        if (container == null || container == context) {
            return "";
        }
        String entityContext = container.getName(context);
        String elemName = container.getElementName();
        return "<" + elemName + " name=\"" + entityContext + "\" >\n";
    }

    public void pushUndoEntry(String entry) {
        this._undoChildEntries.push(entry);
    }

    public void setChildrenUndoable(boolean isUndoable) {
        this._childrenUndoable = isUndoable;
    }

    public void setUndoable(boolean isUndoable) {
        this._undoable = isUndoable;
    }

    public String toString() {
        return "UndoContext: " + (this.isUndoable() ? "are" : "are not") + " undoable and " + (this.hasUndoableChildren() ? "has" : "does not have") + " undoable children\n" + "undoMoML: " + this.getUndoMoML() + "\n" + "closingUndoMoML: " + this._closingUndoMoML.toString() + "\n";
    }
}

