/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.media;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import javax.swing.JPanel;

public class Picture
extends JPanel {
    private int _width;
    private int _height;
    private int[] _pixels;
    private Image _image;
    private MemoryImageSource _imageSource;

    public Picture(int width, int height) {
        this._width = width;
        this._height = height;
        this._pixels = new int[this._width * this._height];
        this.setSize(width, height);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this._width, this._height);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this._width, this._height);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(this._width, this._height);
    }

    public void displayImage() {
        if (this._imageSource == null && this._image == null) {
            this._imageSource = new MemoryImageSource(this._width, this._height, ColorModel.getRGBdefault(), this._pixels, 0, this._width);
            this._imageSource.setAnimated(true);
            this._image = this.createImage(this._imageSource);
        }
        if (this._imageSource != null) {
            this._imageSource.newPixels();
        }
    }

    @Override
    public synchronized void paint(Graphics graphics) {
        if (this._image != null) {
            graphics.drawImage(this._image, 0, 0, this);
        }
    }

    public void setImage(Image image) throws IllegalArgumentException {
        this._image = image;
    }

    public void setImage(int[] pixels) throws IllegalArgumentException {
        if (pixels.length != this._width * this._height) {
            throw new IllegalArgumentException("setImage: Specified image size does notmatch that of the component.");
        }
        this._pixels = pixels;
        if (this._imageSource != null) {
            this._imageSource.newPixels(pixels, ColorModel.getRGBdefault(), 0, this._width);
        }
    }

    public void setPixel(int row, int col, int intensity) {
        if (row < 0 || row >= this._height || col < 0 || col >= this._width) {
            return;
        }
        if (intensity < 0) {
            intensity = 0;
        } else if (intensity > 255) {
            intensity = 255;
        }
        this._pixels[row * this._width + col] = 0xFF000000 | intensity << 16 | intensity << 8 | intensity;
    }

    public void setPixel(int row, int col, int red, int green, int blue) {
        if (row < 0 || row >= this._height || col < 0 || col >= this._width) {
            return;
        }
        if (red < 0) {
            red = 0;
        } else if (red > 255) {
            red = 255;
        }
        if (green < 0) {
            green = 0;
        } else if (green > 255) {
            green = 255;
        }
        if (blue < 0) {
            blue = 0;
        } else if (blue > 255) {
            blue = 255;
        }
        this._pixels[row * this._width + col] = 0xFF000000 | red << 16 | green << 8 | blue;
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

