/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.math;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Precision
implements Cloneable,
Serializable {
    public static final PrecisionFormat INTEGER_FRACTION = new IntegerFractionPrecisionFormat();
    public static final PrecisionFormat LENGTH_EXPONENT = new LengthExponentPrecisionFormat();
    public static final PrecisionFormat LENGTH_INTEGER = new LengthIntegerPrecisionFormat();
    public static final PrecisionFormat EXPRESSION_LANGUAGE = new ExpressionLanguagePrecisionFormat();
    public static final PrecisionFormat VHDL = new VHDLPrecisionFormat();
    private int _length = 0;
    private int _exponent = 0;
    private int _sign = 0;
    private PrecisionFormat _format = INTEGER_FRACTION;
    private static final int TWORAISEDTOSIZE = 65;
    private static BigDecimal[] _twoRaisedTo = new BigDecimal[65];

    public Precision(String str) throws IllegalArgumentException {
        Precision p = null;
        p = INTEGER_FRACTION.parseString(str);
        if (p != null) {
            this._format = INTEGER_FRACTION;
        } else {
            p = LENGTH_INTEGER.parseString(str);
            if (p != null) {
                this._format = LENGTH_INTEGER;
            } else {
                p = LENGTH_EXPONENT.parseString(str);
                if (p != null) {
                    this._format = LENGTH_EXPONENT;
                } else {
                    p = VHDL.parseString(str);
                    if (p != null) {
                        this._format = VHDL;
                    }
                }
            }
        }
        if (p != null) {
            this._length = p._length;
            this._exponent = p._exponent;
            this._sign = p._sign;
            return;
        }
        throw new IllegalArgumentException("Unrecognized Precision String:" + str);
    }

    public Precision(int length, int integerBits) throws IllegalArgumentException {
        this(1, length, integerBits - length);
    }

    public Precision(int sign, int length, int exponent) throws IllegalArgumentException {
        if (sign != 0 && sign != 1) {
            throw new IllegalArgumentException("Incorrect definition of Precision. Sign must be 0 or 1");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Incorrect definition of Precision. Do not use negative total length ");
        }
        this._sign = sign;
        this._length = length;
        this._exponent = exponent;
    }

    public Object clone() {
        return this;
    }

    public boolean equals(Object object) {
        if (object instanceof Precision) {
            Precision other = (Precision)object;
            if (other._length == this._length && other._exponent == this._exponent && other._sign == this._sign) {
                return true;
            }
        }
        return false;
    }

    public BigDecimal findMaximum() {
        BigDecimal bd = new BigDecimal(this.getMaximumUnscaledValue());
        return Precision.shiftBigDecimal(bd, this._exponent);
    }

    public BigDecimal findMinimum() {
        if (!this.isSigned()) {
            return new BigDecimal(0);
        }
        BigDecimal bd = new BigDecimal(this.getMinimumUnscaledValue());
        return Precision.shiftBigDecimal(bd, this._exponent);
    }

    public BigDecimal getEpsilon() {
        return new BigDecimal(Math.pow(2.0, this._exponent));
    }

    public int getExponent() {
        return this._exponent;
    }

    public int getFractionBitLength() {
        return -this._exponent;
    }

    public int getIntegerBitLength() {
        return this._length + this._exponent;
    }

    public int getLeastSignificantBitPosition() {
        return this._exponent;
    }

    public BigInteger getMaximumUnscaledValue() {
        BigInteger val = BigInteger.ZERO.setBit(this._length - this._sign);
        val = val.subtract(BigInteger.ONE);
        return val;
    }

    public BigInteger getMinimumUnscaledValue() {
        if (this.isSigned()) {
            return BigInteger.ZERO.setBit(this._length - 1).negate();
        }
        return BigInteger.ZERO;
    }

    public int getMostSignificantBitPosition() {
        return this._exponent + this._length - 1;
    }

    public int getMostSignificantDataBitPosition() {
        return this._exponent + this._length - 1 - this._sign;
    }

    public int getNumberOfBits() {
        return this._length;
    }

    public BigInteger getNumberOfLevels() {
        int numBits = this.getNumberOfBits();
        return BigInteger.ZERO.setBit(numBits);
    }

    public int getSign() {
        return this._sign;
    }

    public int hashCode() {
        return Integer.valueOf(this._length).hashCode() >>> Integer.valueOf(this._exponent).hashCode() >>> Integer.valueOf(this._sign).hashCode();
    }

    public boolean isSigned() {
        return this._sign == 1;
    }

    public static Precision union(Precision precisionA, Precision precisionB) {
        int minExponent = precisionA._exponent < precisionB._exponent ? precisionA._exponent : precisionB._exponent;
        int aDataMSB = precisionA.getMostSignificantDataBitPosition();
        int bDataMSB = precisionB.getMostSignificantDataBitPosition();
        int maxDataMSB = aDataMSB > bDataMSB ? aDataMSB : bDataMSB;
        int newLength = maxDataMSB - minExponent + 1;
        int newSign = precisionA._sign == 1 || precisionB._sign == 1 ? 1 : 0;
        return new Precision(newSign, newLength += newSign, minExponent);
    }

    public static BigDecimal shiftBigDecimal(BigDecimal val, int shiftval) {
        if (shiftval == 0) {
            return val;
        }
        if (shiftval > 0) {
            return val.multiply(Precision._getTwoRaisedTo(shiftval));
        }
        int scaleShift = -shiftval + val.scale();
        BigDecimal result = val.divide(Precision._getTwoRaisedTo(-shiftval), scaleShift, 6);
        return result;
    }

    public String toString() {
        return this._format.printPrecisionFormat(this);
    }

    public String toString(PrecisionFormat format) {
        return format.printPrecisionFormat(this);
    }

    private static BigDecimal _getTwoRaisedTo(int number) {
        if (number < _twoRaisedTo.length) {
            return _twoRaisedTo[number];
        }
        return new BigDecimal(BigInteger.ZERO.setBit(number));
    }

    static {
        BigDecimal powerOf2 = BigDecimal.valueOf(1L);
        for (int i = 0; i < _twoRaisedTo.length; ++i) {
            Precision._twoRaisedTo[i] = powerOf2;
            powerOf2 = powerOf2.add(powerOf2);
        }
    }

    public static class VHDLPrecisionFormat
    extends PrecisionFormat {
        protected final String _regex = "\\s*\\(?\\s*([USus])?\\s*(-?\\d+)\\s*:\\s*(-?\\d+)\\s*\\)?\\s*";

        @Override
        public Precision parseString(String str) {
            int sign = 1;
            int msb = 0;
            int lsb = 0;
            Matcher matcher = Pattern.compile("\\s*\\(?\\s*([USus])?\\s*(-?\\d+)\\s*:\\s*(-?\\d+)\\s*\\)?\\s*").matcher(str);
            if (matcher.matches()) {
                String signString = matcher.group(1);
                if (signString != null) {
                    sign = VHDLPrecisionFormat.parseSignString(signString);
                }
                if ((msb = VHDLPrecisionFormat.parseInteger(matcher.group(2))) <= (lsb = VHDLPrecisionFormat.parseInteger(matcher.group(3)))) {
                    throw new IllegalArgumentException("MSb of VHDL format must be greater than LSb:" + str);
                }
                int length = msb - lsb + 1;
                int exponent = lsb;
                return new Precision(sign, length, exponent);
            }
            return null;
        }

        @Override
        public String printPrecisionFormat(Precision p) {
            String sign = p.isSigned() ? "" : "U";
            return "(" + sign + p.getMostSignificantBitPosition() + ":" + p.getLeastSignificantBitPosition() + ")";
        }
    }

    public static class LengthExponentPrecisionFormat
    extends PrecisionFormat {
        protected final String _regex = "\\s*[\\(\\[]?\\s*([USus])?\\s*(\\d+)e(-?\\d+)\\s*[\\)\\]]?\\s*";

        @Override
        public Precision parseString(String str) throws IllegalArgumentException {
            int sign = 1;
            int exponent = 0;
            int length = 0;
            Matcher matcher = Pattern.compile("\\s*[\\(\\[]?\\s*([USus])?\\s*(\\d+)e(-?\\d+)\\s*[\\)\\]]?\\s*").matcher(str);
            if (matcher.matches()) {
                String signString = matcher.group(1);
                if (signString != null) {
                    sign = LengthExponentPrecisionFormat.parseSignString(signString);
                }
                length = LengthExponentPrecisionFormat.parseInteger(matcher.group(2));
                exponent = LengthExponentPrecisionFormat.parseInteger(matcher.group(3));
                if (length < 1) {
                    throw new IllegalArgumentException("Precision format must be at least 1 bit:" + str);
                }
                return new Precision(sign, length, exponent);
            }
            return null;
        }

        @Override
        public String printPrecisionFormat(Precision p) {
            String sign = p.isSigned() ? "" : "U";
            return "(" + sign + p.getNumberOfBits() + "e" + p.getExponent() + ")";
        }
    }

    public static class ExpressionLanguagePrecisionFormat
    extends LengthIntegerPrecisionFormat {
        @Override
        public String printPrecisionFormat(Precision p) {
            return "(" + p.getNumberOfBits() + "," + p.getIntegerBitLength() + ")";
        }
    }

    public static class LengthIntegerPrecisionFormat
    extends PrecisionFormat {
        protected static final String _regex = "\\s*[\\(\\[]?\\s*([USus])?\\s*(\\d+)[,/]\\s*(-?\\d+)\\s*[\\)\\]]?\\s*";

        @Override
        public Precision parseString(String str) throws IllegalArgumentException {
            int sign = 1;
            int intLength = 0;
            int length = 0;
            Matcher matcher = Pattern.compile(_regex).matcher(str);
            if (matcher.matches()) {
                String signString = matcher.group(1);
                if (signString != null) {
                    sign = LengthIntegerPrecisionFormat.parseSignString(signString);
                }
                length = LengthIntegerPrecisionFormat.parseInteger(matcher.group(2));
                intLength = LengthIntegerPrecisionFormat.parseInteger(matcher.group(3));
                int exponent = -(length - intLength);
                if (length < 1) {
                    throw new IllegalArgumentException("Precision format must be at least 1 bit:" + str);
                }
                return new Precision(sign, length, exponent);
            }
            return null;
        }

        @Override
        public String printPrecisionFormat(Precision p) {
            String sign = p.isSigned() ? "" : "U";
            return "(" + sign + p.getNumberOfBits() + "/" + p.getIntegerBitLength() + ")";
        }
    }

    public static class IntegerFractionPrecisionFormat
    extends PrecisionFormat {
        protected static final String _regex = "\\s*[\\(\\[]?\\s*([USus])?\\s*(-?\\d+)\\.(-?\\d+)\\s*[\\)\\]]?\\s*";

        @Override
        public Precision parseString(String str) throws IllegalArgumentException {
            int sign = 1;
            int intLength = 0;
            int fracLength = 0;
            Matcher matcher = Pattern.compile(_regex).matcher(str);
            if (matcher.matches()) {
                String signString = matcher.group(1);
                if (signString != null) {
                    sign = IntegerFractionPrecisionFormat.parseSignString(signString);
                }
                intLength = IntegerFractionPrecisionFormat.parseInteger(matcher.group(2));
                fracLength = IntegerFractionPrecisionFormat.parseInteger(matcher.group(3));
                int length = fracLength + intLength;
                int exponent = -fracLength;
                if (length < 1) {
                    throw new IllegalArgumentException("Precision format  must be at least 1 bit:" + str);
                }
                return new Precision(sign, length, exponent);
            }
            return null;
        }

        @Override
        public String printPrecisionFormat(Precision p) {
            String sign = p.isSigned() ? "" : "U";
            return "(" + sign + p.getIntegerBitLength() + "." + p.getFractionBitLength() + ")";
        }
    }

    public static abstract class PrecisionFormat {
        public static final String COMMA_OR_FORWARDSLASH = "[,/]";
        public static final String OPTIONAL_L_PARAN = "\\(?";
        public static final String OPTIONAL_L_PARANBRACKET = "[\\(\\[]?";
        public static final String OPTIONAL_R_PARAN = "\\)?";
        public static final String OPTIONAL_R_PARANBRACKET = "[\\)\\]]?";
        public static final String PERIOD = "\\.";
        public static final String SIGNED_INTEGER_GROUP = "(-?\\d+)";
        public static final String OPTIONAL_U_OR_S_GROUP = "([USus])?";
        public static final String UNSIGNED_INTEGER_GROUP = "(\\d+)";
        public static final String OPTIONAL_WHITE_SPACE = "\\s*";

        public abstract Precision parseString(String var1) throws IllegalArgumentException;

        public abstract String printPrecisionFormat(Precision var1);

        public static int parseInteger(String str) throws IllegalArgumentException {
            int value = 0;
            try {
                value = Integer.parseInt(str);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid integer number:" + str + " " + e);
            }
            return value;
        }

        public static int parseSignString(String str) throws IllegalArgumentException {
            if (str.equalsIgnoreCase("U")) {
                return 0;
            }
            if (str.equalsIgnoreCase("S")) {
                return 1;
            }
            throw new IllegalArgumentException("Invalid signed format string:'" + str + "'. Expecting 'U' or 'S'");
        }
    }
}

