/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.math;

import ptolemy.math.Fraction;

public class FractionMatrixMath {
    private FractionMatrixMath() {
    }

    public static final Fraction[][] add(Fraction[][] matrix, Fraction z) {
        Fraction[][] returnValue = new Fraction[FractionMatrixMath._rows(matrix)][FractionMatrixMath._columns(matrix)];
        for (int i = 0; i < FractionMatrixMath._rows(matrix); ++i) {
            for (int j = 0; j < FractionMatrixMath._columns(matrix); ++j) {
                returnValue[i][j] = matrix[i][j].add(z);
            }
        }
        return returnValue;
    }

    public static final Fraction[][] add(Fraction[][] matrix1, Fraction[][] matrix2) {
        FractionMatrixMath._checkSameDimension("add", matrix1, matrix2);
        Fraction[][] returnValue = new Fraction[FractionMatrixMath._rows(matrix1)][FractionMatrixMath._columns(matrix1)];
        for (int i = 0; i < FractionMatrixMath._rows(matrix1); ++i) {
            for (int j = 0; j < FractionMatrixMath._columns(matrix1); ++j) {
                returnValue[i][j] = matrix1[i][j].add(matrix2[i][j]);
            }
        }
        return returnValue;
    }

    public static final Fraction[][] allocCopy(Fraction[][] matrix) {
        return FractionMatrixMath.crop(matrix, 0, 0, FractionMatrixMath._rows(matrix), FractionMatrixMath._columns(matrix));
    }

    public static final Fraction[][] crop(Fraction[][] matrix, int rowStart, int colStart, int rowSpan, int colSpan) {
        Fraction[][] returnValue = new Fraction[rowSpan][colSpan];
        for (int i = 0; i < rowSpan; ++i) {
            System.arraycopy(matrix[rowStart + i], colStart, returnValue[i], 0, colSpan);
        }
        return returnValue;
    }

    public static final Fraction[][] diag(Fraction[] array) {
        int n = array.length;
        Fraction[][] returnValue = new Fraction[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                returnValue[i][j] = i == j ? array[i] : new Fraction(0, 1);
            }
        }
        return returnValue;
    }

    public static final Fraction[][] divide(Fraction[][] matrix, Fraction z) {
        Fraction[][] returnValue = new Fraction[FractionMatrixMath._rows(matrix)][FractionMatrixMath._columns(matrix)];
        for (int i = 0; i < FractionMatrixMath._rows(matrix); ++i) {
            for (int j = 0; j < FractionMatrixMath._columns(matrix); ++j) {
                returnValue[i][j] = matrix[i][j].divide(z);
            }
        }
        return returnValue;
    }

    public static final Fraction[][] divideElements(Fraction[][] matrix1, Fraction[][] matrix2) {
        int rows = FractionMatrixMath._rows(matrix1);
        int columns = FractionMatrixMath._columns(matrix1);
        FractionMatrixMath._checkSameDimension("divideElements", matrix1, matrix2);
        Fraction[][] returnValue = new Fraction[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix1[i][j].divide(matrix2[i][j]);
            }
        }
        return returnValue;
    }

    public static final Fraction[] fromMatrixToArray(Fraction[][] matrix) {
        return FractionMatrixMath.fromMatrixToArray(matrix, FractionMatrixMath._rows(matrix), FractionMatrixMath._columns(matrix));
    }

    public static final Fraction[] fromMatrixToArray(Fraction[][] matrix, int maxRow, int maxCol) {
        Fraction[] returnValue = new Fraction[maxRow * maxCol];
        for (int i = 0; i < maxRow; ++i) {
            System.arraycopy(matrix[i], 0, returnValue, i * maxCol, maxCol);
        }
        return returnValue;
    }

    public static final Fraction[][] identity(int dim) {
        Fraction[][] returnValue = new Fraction[dim][dim];
        for (int i = 0; i < dim; ++i) {
            for (int j = 0; j < dim; ++j) {
                if (i == j) {
                    returnValue[i][i] = new Fraction(1, 1);
                    continue;
                }
                returnValue[i][j] = new Fraction(0, 1);
            }
        }
        return returnValue;
    }

    public static final Fraction[][] multiply(Fraction[][] matrix, Fraction scaleFactor) {
        int rows = FractionMatrixMath._rows(matrix);
        int columns = FractionMatrixMath._columns(matrix);
        Fraction[][] returnValue = new Fraction[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix[i][j].multiply(scaleFactor);
            }
        }
        return returnValue;
    }

    public static final Fraction[] multiply(Fraction[] array, Fraction[][] matrix) {
        int rows = FractionMatrixMath._rows(matrix);
        int columns = FractionMatrixMath._columns(matrix);
        if (rows != array.length) {
            throw new IllegalArgumentException("preMultiply : array does not have the same number of elements (" + array.length + ") as the number of rows " + "of the matrix (" + rows + ")");
        }
        Fraction[] returnValue = new Fraction[columns];
        for (int i = 0; i < columns; ++i) {
            Fraction sum = new Fraction(0, 1);
            for (int j = 0; j < rows; ++j) {
                sum = sum.add(matrix[j][i].multiply(array[j]));
            }
            returnValue[i] = sum;
        }
        return returnValue;
    }

    public static final Fraction[] multiply(Fraction[][] matrix, Fraction[] array) {
        int rows = FractionMatrixMath._rows(matrix);
        int columns = FractionMatrixMath._columns(matrix);
        if (columns != array.length) {
            throw new IllegalArgumentException("postMultiply() : array does not have the same number of elements (" + array.length + ") as the number of " + "columns of the matrix (" + columns + ")");
        }
        Fraction[] returnValue = new Fraction[rows];
        for (int i = 0; i < rows; ++i) {
            Fraction sum = new Fraction(0, 1);
            for (int j = 0; j < columns; ++j) {
                sum = sum.add(matrix[i][j].multiply(array[j]));
            }
            returnValue[i] = sum;
        }
        return returnValue;
    }

    public static final Fraction[][] multiply(Fraction[][] matrix1, Fraction[][] matrix2) throws ArithmeticException {
        if (FractionMatrixMath._columns(matrix1) != FractionMatrixMath._rows(matrix2)) {
            throw new ArithmeticException("Number of columns (" + FractionMatrixMath._columns(matrix1) + ") of matrix1 does note equal number of rows (" + FractionMatrixMath._rows(matrix2) + ") of matrix2.");
        }
        Fraction[][] returnValue = new Fraction[FractionMatrixMath._rows(matrix1)][FractionMatrixMath._columns(matrix2)];
        for (int i = 0; i < FractionMatrixMath._rows(matrix1); ++i) {
            for (int j = 0; j < FractionMatrixMath._columns(matrix2); ++j) {
                Fraction sum = new Fraction(0, 1);
                for (int k = 0; k < FractionMatrixMath._columns(matrix1); ++k) {
                    sum = sum.add(matrix1[i][k].multiply(matrix2[k][j]));
                }
                returnValue[i][j] = sum;
            }
        }
        return returnValue;
    }

    public static final Fraction[][] multiplyElements(Fraction[][] matrix1, Fraction[][] matrix2) {
        int rows = FractionMatrixMath._rows(matrix1);
        int columns = FractionMatrixMath._columns(matrix1);
        FractionMatrixMath._checkSameDimension("multiplyElements", matrix1, matrix2);
        Fraction[][] returnValue = new Fraction[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix1[i][j].multiply(matrix2[i][j]);
            }
        }
        return returnValue;
    }

    public static final Fraction[][] negative(Fraction[][] matrix) {
        int rows = FractionMatrixMath._rows(matrix);
        int columns = FractionMatrixMath._columns(matrix);
        Fraction[][] returnValue = new Fraction[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix[i][j].negate();
            }
        }
        return returnValue;
    }

    public static final Fraction[][] subtract(Fraction[][] matrix1, Fraction[][] matrix2) {
        FractionMatrixMath._checkSameDimension("subtract", matrix1, matrix2);
        int rows = FractionMatrixMath._rows(matrix1);
        int columns = FractionMatrixMath._columns(matrix1);
        Fraction[][] returnValue = new Fraction[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix1[i][j].subtract(matrix2[i][j]);
            }
        }
        return returnValue;
    }

    public static final Fraction sum(Fraction[][] matrix) {
        Fraction sum = new Fraction(0, 1);
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[i].length; ++j) {
                sum = sum.add(matrix[i][j]);
            }
        }
        return sum;
    }

    public static final double[][] toDoubleMatrix(Fraction[][] matrix) {
        int rows = FractionMatrixMath._rows(matrix);
        int columns = FractionMatrixMath._columns(matrix);
        double[][] returnValue = new double[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix[i][j].toDouble();
            }
        }
        return returnValue;
    }

    public static final Fraction[][] toMatrixFromArray(Fraction[] array, int rows, int cols) {
        Fraction[][] returnValue = new Fraction[rows][cols];
        for (int i = 0; i < rows; ++i) {
            System.arraycopy(array, i * cols, returnValue[i], 0, cols);
        }
        return returnValue;
    }

    public static final String toString(Fraction[][] matrix) {
        return FractionMatrixMath.toString(matrix, ", ", "{", "}", "{", ", ", "}");
    }

    public static final String toString(Fraction[][] matrix, String elementDelimiter, String matrixBegin, String matrixEnd, String vectorBegin, String vectorDelimiter, String vectorEnd) {
        StringBuffer sb = new StringBuffer();
        sb.append(matrixBegin);
        for (int i = 0; i < FractionMatrixMath._rows(matrix); ++i) {
            sb.append(vectorBegin);
            for (int j = 0; j < FractionMatrixMath._columns(matrix); ++j) {
                sb.append(matrix[i][j].toString());
                if (j >= FractionMatrixMath._columns(matrix) - 1) continue;
                sb.append(elementDelimiter);
            }
            sb.append(vectorEnd);
            if (i >= FractionMatrixMath._rows(matrix) - 1) continue;
            sb.append(vectorDelimiter);
        }
        sb.append(matrixEnd);
        return new String(sb);
    }

    public static final Fraction trace(Fraction[][] matrix) {
        int dim = FractionMatrixMath._checkSquare("trace", matrix);
        Fraction sum = new Fraction(0, 1);
        for (int i = 0; i < dim; ++i) {
            sum = sum.add(matrix[i][i]);
        }
        return sum;
    }

    public static final Fraction[][] transpose(Fraction[][] matrix) {
        int rows = FractionMatrixMath._rows(matrix);
        int columns = FractionMatrixMath._columns(matrix);
        Fraction[][] returnValue = new Fraction[columns][rows];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[j][i] = matrix[i][j];
            }
        }
        return returnValue;
    }

    protected static final void _checkSameDimension(String caller, Fraction[][] matrix1, Fraction[][] matrix2) {
        int rows = FractionMatrixMath._rows(matrix1);
        int columns = FractionMatrixMath._columns(matrix1);
        if (rows != FractionMatrixMath._rows(matrix2) || columns != FractionMatrixMath._columns(matrix2)) {
            throw new IllegalArgumentException("ptolemy.math.FractionMatrixMath." + caller + "() : one matrix " + FractionMatrixMath._dimensionString(matrix1) + " is not the same size as another matrix " + FractionMatrixMath._dimensionString(matrix2) + ".");
        }
    }

    protected static final int _checkSquare(String caller, Fraction[][] matrix) {
        if (FractionMatrixMath._rows(matrix) != FractionMatrixMath._columns(matrix)) {
            throw new IllegalArgumentException("ptolemy.math.FractionMatrixMath." + caller + "() : matrix argument " + FractionMatrixMath._dimensionString(matrix) + " is not a square matrix.");
        }
        return FractionMatrixMath._rows(matrix);
    }

    protected static final int _columns(Fraction[][] matrix) {
        return matrix[0].length;
    }

    protected static final String _dimensionString(Fraction[][] matrix) {
        return "[" + FractionMatrixMath._rows(matrix) + " x " + FractionMatrixMath._columns(matrix) + "]";
    }

    protected static final int _rows(Fraction[][] matrix) {
        return matrix.length;
    }
}

