/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.math;

import ptolemy.math.Complex;
import ptolemy.math.DoubleArrayMath;
import ptolemy.math.DoubleBinaryOperation;
import ptolemy.math.DoubleUnaryOperation;

public class DoubleMatrixMath {
    private DoubleMatrixMath() {
    }

    public static final double[][] add(double[][] matrix, double z) {
        double[][] returnValue = new double[DoubleMatrixMath._rows(matrix)][DoubleMatrixMath._columns(matrix)];
        for (int i = 0; i < DoubleMatrixMath._rows(matrix); ++i) {
            for (int j = 0; j < DoubleMatrixMath._columns(matrix); ++j) {
                returnValue[i][j] = matrix[i][j] + z;
            }
        }
        return returnValue;
    }

    public static final double[][] add(double[][] matrix1, double[][] matrix2) {
        DoubleMatrixMath._checkSameDimension("add", matrix1, matrix2);
        double[][] returnValue = new double[DoubleMatrixMath._rows(matrix1)][DoubleMatrixMath._columns(matrix1)];
        for (int i = 0; i < DoubleMatrixMath._rows(matrix1); ++i) {
            for (int j = 0; j < DoubleMatrixMath._columns(matrix1); ++j) {
                returnValue[i][j] = matrix1[i][j] + matrix2[i][j];
            }
        }
        return returnValue;
    }

    public static final double[][] allocCopy(double[][] matrix) {
        return DoubleMatrixMath.crop(matrix, 0, 0, DoubleMatrixMath._rows(matrix), DoubleMatrixMath._columns(matrix));
    }

    public static final double[][] applyBinaryOperation(DoubleBinaryOperation op, double z, double[][] matrix) {
        int rows = DoubleMatrixMath._rows(matrix);
        int columns = DoubleMatrixMath._columns(matrix);
        double[][] returnValue = new double[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = op.operate(z, matrix[i][j]);
            }
        }
        return returnValue;
    }

    public static final double[][] applyBinaryOperation(DoubleBinaryOperation op, double[][] matrix, double z) {
        int rows = DoubleMatrixMath._rows(matrix);
        int columns = DoubleMatrixMath._columns(matrix);
        double[][] returnValue = new double[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = op.operate(matrix[i][j], z);
            }
        }
        return returnValue;
    }

    public static final double[][] applyBinaryOperation(DoubleBinaryOperation op, double[][] matrix1, double[][] matrix2) {
        int rows = DoubleMatrixMath._rows(matrix1);
        int columns = DoubleMatrixMath._columns(matrix1);
        DoubleMatrixMath._checkSameDimension("applyBinaryOperation", matrix1, matrix2);
        double[][] returnValue = new double[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = op.operate(matrix1[i][j], matrix2[i][j]);
            }
        }
        return returnValue;
    }

    public static final double[][] applyUnaryOperation(DoubleUnaryOperation op, double[][] matrix) {
        int rows = DoubleMatrixMath._rows(matrix);
        int columns = DoubleMatrixMath._columns(matrix);
        double[][] returnValue = new double[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = op.operate(matrix[i][j]);
            }
        }
        return returnValue;
    }

    public static final double[][] crop(double[][] matrix, int rowStart, int colStart, int rowSpan, int colSpan) {
        double[][] returnValue = new double[rowSpan][colSpan];
        for (int i = 0; i < rowSpan; ++i) {
            System.arraycopy(matrix[rowStart + i], colStart, returnValue[i], 0, colSpan);
        }
        return returnValue;
    }

    public static final double determinant(double[][] matrix) {
        DoubleMatrixMath._checkSquare("determinant", matrix);
        double det = 1.0;
        int n = DoubleMatrixMath._rows(matrix);
        double[][] a = DoubleMatrixMath.allocCopy(matrix);
        for (int pivot = 0; pivot < n - 1; ++pivot) {
            double big = Math.abs(a[pivot][pivot]);
            int swapRow = 0;
            for (int row = pivot + 1; row < n; ++row) {
                double absElement = Math.abs(a[row][pivot]);
                if (!(absElement > big)) continue;
                swapRow = row;
                big = absElement;
            }
            if (swapRow != 0) {
                double[] aPtr = a[pivot];
                a[pivot] = a[swapRow];
                a[swapRow] = aPtr;
                det *= -a[pivot][pivot];
            } else {
                det *= a[pivot][pivot];
            }
            if (Math.abs(det) <= Complex.EPSILON) {
                return det;
            }
            double pivotInverse = 1.0 / a[pivot][pivot];
            int col = pivot + 1;
            while (col < n) {
                double[] dArray = a[pivot];
                int n2 = col++;
                dArray[n2] = dArray[n2] * pivotInverse;
            }
            for (int row = pivot + 1; row < n; ++row) {
                double temp = a[row][pivot];
                for (int col2 = pivot + 1; col2 < n; ++col2) {
                    double[] dArray = a[row];
                    int n3 = col2;
                    dArray[n3] = dArray[n3] - a[pivot][col2] * temp;
                }
            }
        }
        return det *= a[n - 1][n - 1];
    }

    public static final double[][] diag(double[] array) {
        int n = array.length;
        double[][] returnValue = new double[n][n];
        for (int i = 0; i < n; ++i) {
            returnValue[i][i] = array[i];
        }
        return returnValue;
    }

    public static final double[][] divide(double[][] matrix, double z) {
        double[][] returnValue = new double[DoubleMatrixMath._rows(matrix)][DoubleMatrixMath._columns(matrix)];
        for (int i = 0; i < DoubleMatrixMath._rows(matrix); ++i) {
            for (int j = 0; j < DoubleMatrixMath._columns(matrix); ++j) {
                returnValue[i][j] = matrix[i][j] / z;
            }
        }
        return returnValue;
    }

    public static final double[][] divideElements(double[][] matrix1, double[][] matrix2) {
        int rows = DoubleMatrixMath._rows(matrix1);
        int columns = DoubleMatrixMath._columns(matrix1);
        DoubleMatrixMath._checkSameDimension("divideElements", matrix1, matrix2);
        double[][] returnValue = new double[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix1[i][j] / matrix2[i][j];
            }
        }
        return returnValue;
    }

    public static final double[] fromMatrixToArray(double[][] matrix) {
        return DoubleMatrixMath.fromMatrixToArray(matrix, DoubleMatrixMath._rows(matrix), DoubleMatrixMath._columns(matrix));
    }

    public static final double[] fromMatrixToArray(double[][] matrix, int maxRow, int maxCol) {
        double[] returnValue = new double[maxRow * maxCol];
        for (int i = 0; i < maxRow; ++i) {
            System.arraycopy(matrix[i], 0, returnValue, i * maxCol, maxCol);
        }
        return returnValue;
    }

    public static final double[][] hilbert(int dim) {
        double[][] returnValue = new double[dim][dim];
        for (int i = 0; i < dim; ++i) {
            for (int j = 0; j < dim; ++j) {
                returnValue[i][j] = 1.0 / (double)(i + j + 1);
            }
        }
        return returnValue;
    }

    public static final double[][] identity(int dim) {
        double[][] returnValue = new double[dim][dim];
        for (int i = 0; i < dim; ++i) {
            returnValue[i][i] = 1.0;
        }
        return returnValue;
    }

    public static final double[][] identityMatrixDouble(int dim) {
        return DoubleMatrixMath.identity(dim);
    }

    public static final double[][] inverse(double[][] A) {
        DoubleMatrixMath._checkSquare("inverse", A);
        int n = DoubleMatrixMath._rows(A);
        double[][] Ai = DoubleMatrixMath.allocCopy(A);
        int[] pivotFlag = new int[n];
        int[] swapCol = new int[n];
        int[] swapRow = new int[n];
        int irow = 0;
        int icol = 0;
        for (int i = 0; i < n; ++i) {
            double big = 0.0;
            for (int row = 0; row < n; ++row) {
                if (pivotFlag[row] != 0) continue;
                for (int col = 0; col < n; ++col) {
                    double absElement;
                    if (pivotFlag[col] != 0 || !((absElement = Math.abs(Ai[row][col])) >= big)) continue;
                    big = absElement;
                    irow = row;
                    icol = col;
                }
            }
            int n2 = icol;
            pivotFlag[n2] = pivotFlag[n2] + 1;
            if (irow != icol) {
                for (int col = 0; col < n; ++col) {
                    double temp = Ai[irow][col];
                    Ai[irow][col] = Ai[icol][col];
                    Ai[icol][col] = temp;
                }
            }
            swapRow[i] = irow;
            swapCol[i] = icol;
            if (Ai[icol][icol] == 0.0) {
                throw new IllegalArgumentException("Attempt to invert a singular matrix.");
            }
            double pivotInverse = 1.0 / Ai[icol][icol];
            Ai[icol][icol] = 1.0;
            int col = 0;
            while (col < n) {
                double[] dArray = Ai[icol];
                int n3 = col++;
                dArray[n3] = dArray[n3] * pivotInverse;
            }
            for (int row = 0; row < n; ++row) {
                if (row == icol) continue;
                double temp = Ai[row][icol];
                Ai[row][icol] = 0.0;
                for (int col2 = 0; col2 < n; ++col2) {
                    double[] dArray = Ai[row];
                    int n4 = col2;
                    dArray[n4] = dArray[n4] - Ai[icol][col2] * temp;
                }
            }
        }
        for (int swap = n - 1; swap >= 0; --swap) {
            if (swapRow[swap] == swapCol[swap]) continue;
            for (int row = 0; row < n; ++row) {
                double temp = Ai[row][swapRow[swap]];
                Ai[row][swapRow[swap]] = Ai[row][swapCol[swap]];
                Ai[row][swapCol[swap]] = temp;
            }
        }
        return Ai;
    }

    public static final void matrixCopy(double[][] sourceMatrix, double[][] destinationMatrix) {
        DoubleMatrixMath.matrixCopy(sourceMatrix, 0, 0, destinationMatrix, 0, 0, DoubleMatrixMath._rows(sourceMatrix), DoubleMatrixMath._columns(sourceMatrix));
    }

    public static final void matrixCopy(double[][] sourceMatrix, int sourceRowStart, int sourceColStart, double[][] destinationMatrix, int destinationRowStart, int destinationColumnStart, int rowSpan, int columnSpan) {
        for (int i = 0; i < rowSpan; ++i) {
            System.arraycopy(sourceMatrix[sourceRowStart + i], sourceColStart, destinationMatrix[destinationRowStart + i], destinationColumnStart, columnSpan);
        }
    }

    public static final double[][] modulo(double[][] matrix, double z) {
        double[][] returnValue = new double[DoubleMatrixMath._rows(matrix)][DoubleMatrixMath._columns(matrix)];
        for (int i = 0; i < DoubleMatrixMath._rows(matrix); ++i) {
            for (int j = 0; j < DoubleMatrixMath._columns(matrix); ++j) {
                returnValue[i][j] = matrix[i][j] % z;
            }
        }
        return returnValue;
    }

    public static final double[][] multiply(double[][] matrix, double scaleFactor) {
        int rows = DoubleMatrixMath._rows(matrix);
        int columns = DoubleMatrixMath._columns(matrix);
        double[][] returnValue = new double[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix[i][j] * scaleFactor;
            }
        }
        return returnValue;
    }

    public static final double[] multiply(double[][] matrix, double[] array) {
        int rows = DoubleMatrixMath._rows(matrix);
        int columns = DoubleMatrixMath._columns(matrix);
        if (rows != array.length) {
            throw new IllegalArgumentException("preMultiply : array does not have the same number of elements (" + array.length + ") as the number of rows " + "of the matrix (" + rows + ")");
        }
        double[] returnValue = new double[columns];
        for (int i = 0; i < columns; ++i) {
            double sum = 0.0;
            for (int j = 0; j < rows; ++j) {
                sum += matrix[j][i] * array[j];
            }
            returnValue[i] = sum;
        }
        return returnValue;
    }

    public static final double[] multiply(double[] array, double[][] matrix) {
        int rows = DoubleMatrixMath._rows(matrix);
        int columns = DoubleMatrixMath._columns(matrix);
        if (columns != array.length) {
            throw new IllegalArgumentException("postMultiply() : array does not have the same number of elements (" + array.length + ") as the number of " + "columns of the matrix (" + columns + ")");
        }
        double[] returnValue = new double[rows];
        for (int i = 0; i < rows; ++i) {
            double sum = 0.0;
            for (int j = 0; j < columns; ++j) {
                sum += matrix[i][j] * array[j];
            }
            returnValue[i] = sum;
        }
        return returnValue;
    }

    public static final double[][] multiply(double[][] matrix1, double[][] matrix2) {
        double[][] returnValue = new double[DoubleMatrixMath._rows(matrix1)][matrix2[0].length];
        for (int i = 0; i < DoubleMatrixMath._rows(matrix1); ++i) {
            for (int j = 0; j < matrix2[0].length; ++j) {
                double sum = 0.0;
                for (int k = 0; k < matrix2.length; ++k) {
                    sum += matrix1[i][k] * matrix2[k][j];
                }
                returnValue[i][j] = sum;
            }
        }
        return returnValue;
    }

    public static final double[][] multiplyElements(double[][] matrix1, double[][] matrix2) {
        int rows = DoubleMatrixMath._rows(matrix1);
        int columns = DoubleMatrixMath._columns(matrix1);
        DoubleMatrixMath._checkSameDimension("multiplyElements", matrix1, matrix2);
        double[][] returnValue = new double[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix1[i][j] * matrix2[i][j];
            }
        }
        return returnValue;
    }

    public static final double[][] negative(double[][] matrix) {
        int rows = DoubleMatrixMath._rows(matrix);
        int columns = DoubleMatrixMath._columns(matrix);
        double[][] returnValue = new double[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = -matrix[i][j];
            }
        }
        return returnValue;
    }

    public static final double[][] orthogonalizeColumns(double[][] matrix) {
        Object[] orthoInfo = DoubleMatrixMath._orthogonalizeRows(DoubleMatrixMath.transpose(matrix));
        return DoubleMatrixMath.transpose((double[][])orthoInfo[0]);
    }

    public static final double[][] orthogonalizeRows(double[][] matrix) {
        Object[] orthoInfo = DoubleMatrixMath._orthogonalizeRows(matrix);
        return (double[][])orthoInfo[0];
    }

    public static final double[][] orthonormalizeColumns(double[][] matrix) {
        return DoubleMatrixMath.transpose(DoubleMatrixMath.orthogonalizeRows(DoubleMatrixMath.transpose(matrix)));
    }

    public static final double[][] orthonormalizeRows(double[][] matrix) {
        int rows = DoubleMatrixMath._rows(matrix);
        Object[] orthoInfo = DoubleMatrixMath._orthogonalizeRows(matrix);
        double[][] orthogonalMatrix = (double[][])orthoInfo[0];
        double[] oneOverNormSquaredArray = (double[])orthoInfo[2];
        for (int i = 0; i < rows; ++i) {
            orthogonalMatrix[i] = DoubleArrayMath.scale(orthogonalMatrix[i], Math.sqrt(oneOverNormSquaredArray[i]));
        }
        return orthogonalMatrix;
    }

    public static final double[][][] qr(double[][] matrix) {
        int columns = DoubleMatrixMath._columns(matrix);
        Object[] orthoRowInfo = DoubleMatrixMath._orthogonalizeRows(DoubleMatrixMath.transpose(matrix));
        double[][] qT = (double[][])orthoRowInfo[0];
        double[][] dotProducts = (double[][])orthoRowInfo[1];
        double[] oneOverNormSquaredArray = (double[])orthoRowInfo[2];
        Integer nullity = (Integer)orthoRowInfo[3];
        if (nullity > 0) {
            throw new IllegalArgumentException("qr() : not all column vectors are linearly independent.");
        }
        for (int i = 0; i < columns; ++i) {
            double oneOverNorm = Math.sqrt(oneOverNormSquaredArray[i]);
            qT[i] = DoubleArrayMath.scale(qT[i], oneOverNorm);
            int j = i;
            while (j < columns) {
                double[] dArray = dotProducts[i];
                int n = j++;
                dArray[n] = dArray[n] * oneOverNorm;
            }
        }
        return new double[][][]{DoubleMatrixMath.transpose(qT), dotProducts};
    }

    public static final double[][] subtract(double[][] matrix1, double[][] matrix2) {
        DoubleMatrixMath._checkSameDimension("subtract", matrix1, matrix2);
        int rows = DoubleMatrixMath._rows(matrix1);
        int columns = DoubleMatrixMath._columns(matrix1);
        double[][] returnValue = new double[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix1[i][j] - matrix2[i][j];
            }
        }
        return returnValue;
    }

    public static final double sum(double[][] matrix) {
        double sum = 0.0;
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[i].length; ++j) {
                sum += matrix[i][j];
            }
        }
        return sum;
    }

    public static final Complex[][] toComplexMatrix(double[][] matrix) {
        int rows = DoubleMatrixMath._rows(matrix);
        int columns = DoubleMatrixMath._columns(matrix);
        Complex[][] returnValue = new Complex[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = new Complex(matrix[i][j], 0.0);
            }
        }
        return returnValue;
    }

    public static final float[][] toFloatMatrix(double[][] matrix) {
        int rows = DoubleMatrixMath._rows(matrix);
        int columns = DoubleMatrixMath._columns(matrix);
        float[][] returnValue = new float[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = (float)matrix[i][j];
            }
        }
        return returnValue;
    }

    public static final int[][] toIntegerMatrix(double[][] matrix) {
        int rows = DoubleMatrixMath._rows(matrix);
        int columns = DoubleMatrixMath._columns(matrix);
        int[][] returnValue = new int[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = (int)matrix[i][j];
            }
        }
        return returnValue;
    }

    public static final long[][] toLongMatrix(double[][] matrix) {
        int rows = DoubleMatrixMath._rows(matrix);
        int columns = DoubleMatrixMath._columns(matrix);
        long[][] returnValue = new long[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = (long)matrix[i][j];
            }
        }
        return returnValue;
    }

    public static final double[][] toMatrixFromArray(double[] array, int rows, int cols) {
        double[][] returnValue = new double[rows][cols];
        for (int i = 0; i < rows; ++i) {
            System.arraycopy(array, i * cols, returnValue[i], 0, cols);
        }
        return returnValue;
    }

    public static final String toString(double[][] matrix) {
        return DoubleMatrixMath.toString(matrix, ", ", "{", "}", "{", ", ", "}");
    }

    public static final String toString(double[][] matrix, String elementDelimiter, String matrixBegin, String matrixEnd, String vectorBegin, String vectorDelimiter, String vectorEnd) {
        StringBuffer sb = new StringBuffer();
        sb.append(matrixBegin);
        for (int i = 0; i < DoubleMatrixMath._rows(matrix); ++i) {
            sb.append(vectorBegin);
            for (int j = 0; j < DoubleMatrixMath._columns(matrix); ++j) {
                sb.append(Double.toString(matrix[i][j]));
                if (j >= DoubleMatrixMath._columns(matrix) - 1) continue;
                sb.append(elementDelimiter);
            }
            sb.append(vectorEnd);
            if (i >= DoubleMatrixMath._rows(matrix) - 1) continue;
            sb.append(vectorDelimiter);
        }
        sb.append(matrixEnd);
        return new String(sb);
    }

    public static final double trace(double[][] matrix) {
        int dim = DoubleMatrixMath._checkSquare("trace", matrix);
        double sum = 0.0;
        for (int i = 0; i < dim; ++i) {
            sum += matrix[i][i];
        }
        return sum;
    }

    public static final double[][] transpose(double[][] matrix) {
        int rows = DoubleMatrixMath._rows(matrix);
        int columns = DoubleMatrixMath._columns(matrix);
        double[][] returnValue = new double[columns][rows];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[j][i] = matrix[i][j];
            }
        }
        return returnValue;
    }

    public static final boolean within(double[][] matrix1, double[][] matrix2, double distance) {
        int rows = DoubleMatrixMath._rows(matrix1);
        int columns = DoubleMatrixMath._columns(matrix1);
        DoubleMatrixMath._checkSameDimension("within", matrix1, matrix2);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                if (!(matrix1[i][j] > matrix2[i][j] + distance) && !(matrix1[i][j] < matrix2[i][j] - distance)) continue;
                return false;
            }
        }
        return true;
    }

    public static final boolean within(double[][] matrix1, double[][] matrix2, double[][] errorMatrix) {
        int rows = DoubleMatrixMath._rows(matrix1);
        int columns = DoubleMatrixMath._columns(matrix1);
        DoubleMatrixMath._checkSameDimension("within", matrix1, matrix2);
        DoubleMatrixMath._checkSameDimension("within", matrix1, errorMatrix);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                if (!(matrix1[i][j] > matrix2[i][j] + errorMatrix[i][j]) && !(matrix1[i][j] < matrix2[i][j] - errorMatrix[i][j])) continue;
                return false;
            }
        }
        return true;
    }

    protected static final void _checkSameDimension(String caller, double[][] matrix1, double[][] matrix2) throws IllegalArgumentException {
        int rows = DoubleMatrixMath._rows(matrix1);
        int columns = DoubleMatrixMath._columns(matrix1);
        if (rows != DoubleMatrixMath._rows(matrix2) || columns != DoubleMatrixMath._columns(matrix2)) {
            throw new IllegalArgumentException("ptolemy.math.DoubleMatrixMath." + caller + "() : one matrix " + DoubleMatrixMath._dimensionString(matrix1) + " is not the same size as another matrix " + DoubleMatrixMath._dimensionString(matrix2) + ".");
        }
    }

    protected static final int _checkSquare(String caller, double[][] matrix) throws IllegalArgumentException {
        if (DoubleMatrixMath._rows(matrix) != DoubleMatrixMath._columns(matrix)) {
            throw new IllegalArgumentException("ptolemy.math.DoubleMatrixMath." + caller + "() : matrix argument " + DoubleMatrixMath._dimensionString(matrix) + " is not a square matrix.");
        }
        return DoubleMatrixMath._rows(matrix);
    }

    protected static final int _columns(double[][] matrix) {
        return matrix[0].length;
    }

    protected static final String _dimensionString(double[][] matrix) {
        return "[" + DoubleMatrixMath._rows(matrix) + " x " + DoubleMatrixMath._columns(matrix) + "]";
    }

    protected static final Object[] _orthogonalizeRows(double[][] rowArrays) {
        int rows = rowArrays.length;
        int columns = rowArrays[0].length;
        int nullity = 0;
        double[][] orthogonalMatrix = new double[rows][];
        double[] oneOverNormSquaredArray = new double[rows];
        double[][] dotProductMatrix = new double[rows][rows];
        for (int i = 0; i < rows; ++i) {
            double[] refArray;
            double[] rowArray = refArray = rowArrays[i];
            for (int j = 0; j < i; ++j) {
                double dotProduct;
                dotProductMatrix[j][i] = dotProduct = DoubleArrayMath.dotProduct(refArray, orthogonalMatrix[j]);
                rowArray = DoubleArrayMath.subtract(rowArray, DoubleArrayMath.scale(orthogonalMatrix[j], dotProduct * oneOverNormSquaredArray[j]));
            }
            dotProductMatrix[i][i] = DoubleArrayMath.dotProduct(refArray, rowArray);
            double normSquared = DoubleArrayMath.sumOfSquares(rowArray);
            if (normSquared == 0.0) {
                orthogonalMatrix[i] = i == 0 ? new double[columns] : rowArray;
                oneOverNormSquaredArray[i] = 0.0;
                ++nullity;
                continue;
            }
            orthogonalMatrix[i] = rowArray;
            oneOverNormSquaredArray[i] = 1.0 / normSquared;
        }
        return new Object[]{orthogonalMatrix, dotProductMatrix, oneOverNormSquaredArray, nullity};
    }

    protected static final int _rows(double[][] matrix) {
        return matrix.length;
    }
}

