/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.kernel.util;

import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.List;
import ptolemy.kernel.util.ChangeListener;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public abstract class ChangeRequest {
    private String _description;
    private boolean _errorReported;
    private Exception _exception;
    private List _listeners;
    private List _localListeners;
    private boolean _pending = true;
    private boolean _persistent = true;
    private Object _source;

    public ChangeRequest(Object source, String description) {
        this._source = source;
        this._description = description;
        this._errorReported = false;
    }

    public void addChangeListener(ChangeListener listener) {
        if (this._localListeners == null) {
            this._localListeners = new LinkedList();
        }
        if (!this._localListeners.contains(listener)) {
            this._localListeners.add(0, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void execute() {
        if (!this._pending) {
            throw new InternalErrorException("Attempted to execute a change request that had already been executed.");
        }
        this._exception = null;
        boolean needToReport = false;
        try {
            this._execute();
        }
        catch (Exception ex) {
            needToReport = true;
            this._exception = ex;
        }
        if (this._localListeners != null) {
            for (ChangeListener listener : this._localListeners) {
                if (this._exception == null) {
                    listener.changeExecuted(this);
                    continue;
                }
                listener.changeFailed(this, this._exception);
            }
        }
        if (this._listeners != null) {
            for (ChangeListener listener : this._listeners) {
                if (listener instanceof WeakReference) {
                    listener = ((WeakReference)((Object)listener)).get();
                }
                if (!(listener instanceof ChangeListener)) continue;
                if (this._exception == null) {
                    listener.changeExecuted(this);
                    continue;
                }
                needToReport = false;
                listener.changeFailed(this, this._exception);
            }
        }
        try {
            if (needToReport && this._exception != null) {
                Nameable object = null;
                if (this._source instanceof Nameable) {
                    object = (Nameable)this._source;
                }
                throw new InternalErrorException(object, (Throwable)this._exception, "ChangeRequest failed (NOTE: there is no ChangeListener):\n" + this._description);
            }
        }
        finally {
            this._pending = false;
            this.notifyAll();
        }
    }

    public String getDescription() {
        return this._description;
    }

    public NamedObj getLocality() {
        return null;
    }

    public Object getSource() {
        return this._source;
    }

    public boolean isErrorReported() {
        return this._errorReported;
    }

    public boolean isPersistent() {
        return this._persistent;
    }

    public void removeChangeListener(ChangeListener listener) {
        if (this._localListeners != null) {
            this._localListeners.remove(listener);
        }
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setErrorReported(boolean reported) {
        this._errorReported = reported;
    }

    public void setListeners(List listeners) {
        if (listeners != null) {
            this._listeners = new LinkedList(listeners);
        }
    }

    public void setPersistent(boolean persistent) {
        this._persistent = persistent;
    }

    public final synchronized void waitForCompletion() throws Exception {
        while (this._pending) {
            this.wait();
        }
        if (this._exception != null) {
            throw (Exception)this._exception.fillInStackTrace();
        }
    }

    protected abstract void _execute() throws Exception;
}

