/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.kernel;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import ptolemy.kernel.ComponentRelation;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.CrossRefList;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class Relation
extends NamedObj {
    protected CrossRefList _linkList = new CrossRefList(this);

    public Relation() {
        this._elementName = "relation";
    }

    public Relation(String name) throws IllegalActionException {
        super(name);
        this._elementName = "relation";
    }

    public Relation(Workspace workspace) {
        super(workspace);
        this._elementName = "relation";
    }

    public Relation(Workspace workspace, String name) throws IllegalActionException {
        super(workspace, name);
        this._elementName = "relation";
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        Relation newObject = (Relation)super.clone(workspace);
        newObject._linkList = new CrossRefList(newObject);
        return newObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void link(Relation relation) throws IllegalActionException {
        if (relation != null && this._workspace != relation.workspace()) {
            throw new IllegalActionException((Nameable)this, relation, "Cannot link because workspaces are different.");
        }
        try {
            this._workspace.getWriteAccess();
            if (relation != null) {
                this._checkRelation(relation, true);
                if (!this._linkList.isLinked(relation)) {
                    this._linkList.link(relation._linkList);
                }
            } else {
                this._linkList.link(null);
            }
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List linkedObjectsList() {
        try {
            this._workspace.getReadAccess();
            LinkedList result = new LinkedList();
            Enumeration links = this._linkList.getContainers();
            while (links.hasMoreElements()) {
                Object next = links.nextElement();
                result.add(next);
            }
            LinkedList linkedList = result;
            return linkedList;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List linkedPortList() {
        try {
            this._workspace.getReadAccess();
            LinkedList result = new LinkedList();
            Enumeration links = this._linkList.getContainers();
            HashSet<Relation> exceptRelations = new HashSet<Relation>();
            exceptRelations.add(this);
            while (links.hasMoreElements()) {
                Object next = links.nextElement();
                if (next instanceof Port) {
                    result.add(next);
                    continue;
                }
                result.addAll(((Relation)next)._linkedPortList(null, exceptRelations));
            }
            LinkedList linkedList = result;
            return linkedList;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List linkedPortList(Port except) {
        try {
            this._workspace.getReadAccess();
            LinkedList result = new LinkedList();
            Enumeration links = this._linkList.getContainers();
            HashSet<Relation> exceptRelations = new HashSet<Relation>();
            exceptRelations.add(this);
            while (links.hasMoreElements()) {
                Object link = links.nextElement();
                if (link instanceof Port) {
                    if (link == except) continue;
                    result.add(link);
                    continue;
                }
                result.addAll(((Relation)link)._linkedPortList(except, exceptRelations));
            }
            LinkedList linkedList = result;
            return linkedList;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public Enumeration linkedPorts() {
        return Collections.enumeration(this.linkedPortList());
    }

    public Enumeration linkedPorts(Port except) {
        return Collections.enumeration(this.linkedPortList(except));
    }

    public int numLinks() {
        return this.linkedPortList().size();
    }

    public List relationGroupList() {
        LinkedList result = new LinkedList();
        this._relationGroup(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlink(Relation relation) {
        try {
            this._workspace.getWriteAccess();
            this._linkList.unlink(relation);
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlinkAll() {
        try {
            this._workspace.getWriteAccess();
            int size = this._linkList.size();
            Object[] linkedObjectsArray = new Object[size];
            int i = 0;
            Enumeration links = this._linkList.getContainers();
            while (links.hasMoreElements()) {
                Object linkedObject = links.nextElement();
                linkedObjectsArray[i++] = linkedObject;
            }
            for (i = 0; i < size; ++i) {
                if (linkedObjectsArray[i] instanceof Port) {
                    ((Port)linkedObjectsArray[i]).unlink(this);
                    continue;
                }
                ((Relation)linkedObjectsArray[i]).unlink(this);
            }
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    protected void _checkPort(Port port) throws IllegalActionException {
    }

    protected void _checkRelation(Relation relation, boolean symmetric) throws IllegalActionException {
        if (relation != null && symmetric) {
            relation._checkRelation(this, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String _description(int detail, int indent, int bracket) {
        try {
            this._workspace.getReadAccess();
            StringBuffer result = new StringBuffer();
            if (bracket == 1 || bracket == 2) {
                result.append(super._description(detail, indent, 1));
            } else {
                result.append(super._description(detail, indent, 0));
            }
            if ((detail & 4) != 0) {
                if (result.toString().trim().length() > 0) {
                    result.append(" ");
                }
                detail &= 0xFFFFFFFB;
                result.append("links {\n");
                Enumeration links = this._linkList.getContainers();
                while (links.hasMoreElements()) {
                    Object object = links.nextElement();
                    if (object instanceof Port) {
                        result.append(((Port)object)._description(detail, indent + 1, 2) + "\n");
                        continue;
                    }
                    result.append(((Relation)object)._description(detail, indent + 1, 2) + "\n");
                }
                result.append(Relation._getIndentPrefix(indent) + "}");
            }
            if (bracket == 2) {
                result.append("}");
            }
            String string = result.toString();
            return string;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    @Override
    protected NamedObj _getContainedObject(NamedObj container, String relativeName) throws IllegalActionException {
        if (!(container instanceof CompositeEntity)) {
            throw new InternalErrorException("Expected " + container.getFullName() + " to be an instance of ptolemy.kernel.CompositeEntity, " + "but it is " + container.getClass().getName());
        }
        ComponentRelation candidate = ((CompositeEntity)container).getRelation(relativeName);
        if (candidate != null && !this.getClass().isInstance(candidate)) {
            throw new IllegalActionException((Nameable)this, "Expected " + candidate.getFullName() + " to be an instance of " + this.getClass().getName() + ", but it is " + candidate.getClass().getName());
        }
        return candidate;
    }

    private List _linkedPortList(Port exceptPort, Set exceptRelations) {
        LinkedList result = new LinkedList();
        if (exceptRelations.contains(this)) {
            return result;
        }
        exceptRelations.add(this);
        Enumeration links = this._linkList.getContainers();
        while (links.hasMoreElements()) {
            Object link = links.nextElement();
            if (link instanceof Port) {
                if (link == exceptPort) continue;
                result.add(link);
                continue;
            }
            Relation relation = (Relation)link;
            if (exceptRelations.contains(relation)) continue;
            result.addAll(relation._linkedPortList(exceptPort, exceptRelations));
        }
        return result;
    }

    private void _relationGroup(List list) {
        if (!list.contains(this)) {
            list.add(this);
            Enumeration links = this._linkList.getContainers();
            while (links.hasMoreElements()) {
                Object link = links.nextElement();
                if (!(link instanceof Relation)) continue;
                ((Relation)link)._relationGroup(list);
            }
        }
    }
}

