/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.kernel;

import java.lang.ref.WeakReference;
import java.util.List;
import ptolemy.kernel.ComponentPort;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.InstantiableNamedObj;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.Instantiable;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class ComponentEntity
extends Entity {
    private CompositeEntity _container;
    private static String _defaultIcon = "<svg>\n<rect x=\"-30\" y=\"-20\" width=\"60\" height=\"40\" style=\"fill:white\"/>\n<polygon points=\"-20,-10 20,0 -20,10\" style=\"fill:blue\"/>\n</svg>\n";

    public ComponentEntity() {
        this._addIcon();
    }

    public ComponentEntity(Workspace workspace) {
        super(workspace);
        this._addIcon();
    }

    public ComponentEntity(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container.workspace(), name);
        this.setContainer(container);
        this._addIcon();
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        ComponentEntity newObject = (ComponentEntity)super.clone(workspace);
        newObject._container = null;
        return newObject;
    }

    @Override
    public NamedObj getContainer() {
        return this._container;
    }

    @Override
    public Instantiable instantiate(NamedObj container, String name) throws CloneNotSupportedException, IllegalActionException, NameDuplicationException {
        if (container != null && !(container instanceof CompositeEntity)) {
            throw new IllegalActionException((Nameable)this, "Cannot instantiate into a container that is not an instance of CompositeEntity: " + container.getFullName());
        }
        ComponentEntity clone = (ComponentEntity)super.instantiate(container, name);
        clone.setContainer((CompositeEntity)container);
        clone._adjustDeferrals();
        clone._adjustOverride(0);
        return clone;
    }

    public boolean isAtomic() {
        return true;
    }

    public boolean isOpaque() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int moveDown() throws IllegalActionException {
        CompositeEntity container = (CompositeEntity)this.getContainer();
        if (container == null) {
            throw new IllegalActionException((Nameable)this, "Has no container.");
        }
        try {
            this._workspace.getWriteAccess();
            int result = container._containedEntities.moveDown(this);
            for (NamedObj derived : this.getDerivedList()) {
                container = (CompositeEntity)derived.getContainer();
                container._containedEntities.moveDown(derived);
            }
            int n = result;
            return n;
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int moveToFirst() throws IllegalActionException {
        CompositeEntity container = (CompositeEntity)this.getContainer();
        if (container == null) {
            throw new IllegalActionException((Nameable)this, "Has no container.");
        }
        try {
            this._workspace.getWriteAccess();
            int result = container._containedEntities.moveToFirst(this);
            for (NamedObj derived : this.getDerivedList()) {
                container = (CompositeEntity)derived.getContainer();
                container._containedEntities.moveToFirst(derived);
            }
            int n = result;
            return n;
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int moveToIndex(int index) throws IllegalActionException {
        CompositeEntity container = (CompositeEntity)this.getContainer();
        if (container == null) {
            throw new IllegalActionException((Nameable)this, "Has no container.");
        }
        try {
            this._workspace.getWriteAccess();
            int result = container._containedEntities.moveToIndex(this, index);
            for (NamedObj derived : this.getDerivedList()) {
                container = (CompositeEntity)derived.getContainer();
                container._containedEntities.moveToIndex(derived, index);
            }
            int n = result;
            return n;
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int moveToLast() throws IllegalActionException {
        CompositeEntity container = (CompositeEntity)this.getContainer();
        if (container == null) {
            throw new IllegalActionException((Nameable)this, "Has no container.");
        }
        try {
            this._workspace.getWriteAccess();
            int result = container._containedEntities.moveToLast(this);
            for (NamedObj derived : this.getDerivedList()) {
                container = (CompositeEntity)derived.getContainer();
                container._containedEntities.moveToLast(derived);
            }
            int n = result;
            return n;
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int moveUp() throws IllegalActionException {
        CompositeEntity container = (CompositeEntity)this.getContainer();
        if (container == null) {
            throw new IllegalActionException((Nameable)this, "Has no container.");
        }
        try {
            this._workspace.getWriteAccess();
            int result = container._containedEntities.moveUp(this);
            for (NamedObj derived : this.getDerivedList()) {
                container = (CompositeEntity)derived.getContainer();
                container._containedEntities.moveUp(derived);
            }
            int n = result;
            return n;
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Port newPort(String name) throws IllegalActionException, NameDuplicationException {
        try {
            ComponentPort port;
            this._workspace.getWriteAccess();
            ComponentPort componentPort = port = new ComponentPort(this, name);
            return componentPort;
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    @Override
    public List propagateExistence() throws IllegalActionException {
        List result = super.propagateExistence();
        for (ComponentEntity clone : result) {
            clone._adjustDeferrals();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContainer(CompositeEntity container) throws IllegalActionException, NameDuplicationException {
        if (container != null && this._workspace != container.workspace()) {
            throw new IllegalActionException((Nameable)this, container, "Cannot set container because workspaces are different.");
        }
        try {
            this._workspace.getWriteAccess();
            this._checkContainer(container);
            CompositeEntity previousContainer = (CompositeEntity)this.getContainer();
            if (previousContainer == container) {
                return;
            }
            if (container != null) {
                container._addEntity(this);
                if (previousContainer == null) {
                    this._workspace.remove(this);
                }
            }
            this._container = container;
            if (previousContainer != null) {
                previousContainer._removeEntity(this);
            }
            if (container == null) {
                for (Port port : this.portList()) {
                    port.unlinkAll();
                }
                this._setParent(null);
            } else {
                container._finishedAddEntity(this);
                if (this._changeRequests != null) {
                    for (ChangeRequest request : this._changeRequests) {
                        container.requestChange(request);
                    }
                    this._changeRequests = null;
                }
            }
            if (previousContainer != null && container != null) {
                this.validateSettables();
            }
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    @Override
    public void setName(String name) throws IllegalActionException, NameDuplicationException {
        ComponentEntity another;
        CompositeEntity container;
        if (name == null) {
            name = "";
        }
        if ((container = (CompositeEntity)this.getContainer()) != null && (another = container.getEntity(name)) != null && another != this) {
            throw new NameDuplicationException((Nameable)container, "Name duplication: " + name);
        }
        super.setName(name);
    }

    @Override
    protected void _addPort(Port port) throws IllegalActionException, NameDuplicationException {
        if (!(port instanceof ComponentPort)) {
            throw new IllegalActionException((Nameable)this, port, "Incompatible port class for this entity.");
        }
        super._addPort(port);
    }

    protected void _adjustDeferrals() throws IllegalActionException {
        String className = this.getClassName();
        NamedObj context = this;
        int levelsToSearch = this.getDerivedLevel();
        InstantiableNamedObj candidate = null;
        for (int aboveLevel = 0; !(aboveLevel >= levelsToSearch || candidate != null && candidate.isClassDefinition() || context == null); ++aboveLevel) {
            if (!((context = ((NamedObj)context).getContainer()) instanceof CompositeEntity)) continue;
            candidate = ((CompositeEntity)context).getEntity(className);
        }
        if (candidate != null) {
            this._setParent(candidate);
            this._markContentsDerived(0);
            candidate.propagateValues();
        }
    }

    protected void _checkContainer(InstantiableNamedObj container) throws IllegalActionException {
        if (container != null && !(container instanceof CompositeEntity)) {
            throw new IllegalActionException((Nameable)this, container, "Component entity can only be contained by a CompositeEntity");
        }
        if (container == null) {
            boolean hasDeferrals = false;
            List deferred = this.getChildren();
            StringBuffer names = new StringBuffer();
            if (deferred != null) {
                for (WeakReference deferrer : deferred) {
                    NamedObj deferrerObject = (NamedObj)deferrer.get();
                    if (deferrerObject == null) continue;
                    hasDeferrals = true;
                    if (names.length() > 0) {
                        names.append(", ");
                    }
                    names.append(deferrerObject.getFullName());
                }
            }
            if (hasDeferrals) {
                throw new IllegalActionException((Nameable)this, "Cannot delete because there are instances and/or subclasses:\n" + names.toString());
            }
        }
    }

    @Override
    protected NamedObj _getContainedObject(NamedObj container, String relativeName) throws IllegalActionException {
        if (!(container instanceof CompositeEntity)) {
            throw new IllegalActionException((Nameable)this, "Expected " + container.getFullName() + " to be an instance of ptolemy.kernel.CompositeEntity," + " but it is " + container.getClass().getName());
        }
        ComponentEntity candidate = ((CompositeEntity)container).getEntity(relativeName);
        if (candidate != null && !this.getClass().isInstance(candidate)) {
            throw new IllegalActionException((Nameable)this, "Expected " + candidate.getFullName() + " to be an instance of " + this.getClass().getName() + ", but it is " + candidate.getClass().getName());
        }
        return candidate;
    }

    @Override
    protected NamedObj _propagateExistence(NamedObj container) throws IllegalActionException {
        try {
            ComponentEntity newObject = (ComponentEntity)super._propagateExistence(container);
            newObject.setContainer((CompositeEntity)container);
            return newObject;
        }
        catch (NameDuplicationException e) {
            throw new InternalErrorException(e);
        }
    }

    private void _addIcon() {
        this._attachText("_iconDescription", _defaultIcon);
    }
}

