/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.graph.analysis.strategy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ptolemy.graph.DirectedGraph;
import ptolemy.graph.Graph;
import ptolemy.graph.Node;
import ptolemy.graph.analysis.analyzer.SinkNodeAnalyzer;
import ptolemy.graph.analysis.strategy.CachedStrategy;

public class SinkNodeStrategy
extends CachedStrategy
implements SinkNodeAnalyzer {
    public SinkNodeStrategy(Graph graph) {
        super(graph);
    }

    @Override
    public List nodes() {
        return (List)this._result();
    }

    @Override
    public String toString() {
        String result = "Sink node analysis for the following graph.\n" + this.graph().toString();
        result = result + "The sink nodes are:\n" + this._result();
        return result;
    }

    @Override
    public boolean valid() {
        return this.graph() instanceof DirectedGraph;
    }

    @Override
    protected Object _compute() {
        ArrayList<Node> sinkNodes = new ArrayList<Node>();
        for (Node node : this.graph().nodes()) {
            if (((DirectedGraph)this.graph()).outputEdgeCount(node) != 0) continue;
            sinkNodes.add(node);
        }
        return sinkNodes;
    }

    protected Object _convertResult() {
        return Collections.unmodifiableList((List)this._result());
    }
}

