/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.graph.analysis.strategy;

import java.lang.reflect.Method;
import java.util.HashMap;
import ptolemy.graph.Edge;
import ptolemy.graph.Graph;
import ptolemy.graph.Node;
import ptolemy.graph.analysis.AnalysisException;
import ptolemy.graph.analysis.analyzer.MirrorTransformer;
import ptolemy.graph.analysis.strategy.CachedStrategy;

public class MirrorTransformerStrategy
extends CachedStrategy
implements MirrorTransformer {
    private Graph _graph;
    private boolean _cloneWeights = false;
    private HashMap _originalVersion = new HashMap();
    private HashMap _transformedVersion = new HashMap();

    public MirrorTransformerStrategy(Graph graph) {
        super(graph);
    }

    @Override
    public void cloneWeight(boolean status) {
        this._cloneWeights = status;
    }

    @Override
    public boolean hasBackwardMapping() {
        return true;
    }

    @Override
    public boolean hasForwardMapping() {
        return true;
    }

    @Override
    public Graph mirror() {
        return this.mirror(this.graph(), this._cloneWeights);
    }

    @Override
    public Graph mirror(Graph graph, boolean cloneWeights) {
        if (graph.getClass() != this.graph().getClass() || cloneWeights != this._cloneWeights) {
            this.reset();
        }
        this._graph = graph;
        boolean tempCloneWeights = this._cloneWeights;
        this._cloneWeights = cloneWeights;
        Graph result = (Graph)this._result();
        this._cloneWeights = tempCloneWeights;
        return result;
    }

    @Override
    public Object originalVersionOf(Object transformedObject) {
        return this._originalVersion.get(transformedObject);
    }

    @Override
    public Object transformedVersionOf(Object originalObject) {
        return this._transformedVersion.get(originalObject);
    }

    @Override
    public boolean valid() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Object _compute() {
        String nameClone = "clone";
        Graph mirrorGraph = null;
        try {
            mirrorGraph = (Graph)this._graph.getClass().newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not create an empty graph from this one.\n" + exception + "\n");
        }
        for (Node node : this.graph().nodes()) {
            Node mirrorNode = null;
            if (!node.hasWeight()) {
                mirrorNode = new Node();
            } else {
                Object mirrorWeight = null;
                try {
                    if (this._cloneWeights) {
                        Object oldWeight = node.getWeight();
                        if (!(oldWeight instanceof Cloneable)) throw new RuntimeException();
                        Class[] argumentTypes = new Class[]{};
                        Method method = oldWeight.getClass().getMethod(nameClone, argumentTypes);
                        mirrorWeight = method.invoke(oldWeight, (Object[])null);
                    } else {
                        mirrorWeight = node.getWeight();
                    }
                }
                catch (Throwable throwable) {
                    throw new AnalysisException("Can not clone the node weight.\n", throwable);
                }
                mirrorNode = new Node(mirrorWeight);
            }
            mirrorGraph.addNode(mirrorNode);
            this._originalVersion.put(mirrorNode, node);
            this._transformedVersion.put(node, mirrorNode);
        }
        for (Edge edge : this.graph().edges()) {
            Edge mirrorEdge = null;
            Node mirrorSource = (Node)this._transformedVersion.get(edge.source());
            Node mirrorSink = (Node)this._transformedVersion.get(edge.sink());
            if (!edge.hasWeight()) {
                mirrorEdge = new Edge(mirrorSource, mirrorSink);
            } else {
                Object mirrorWeight = null;
                try {
                    if (this._cloneWeights) {
                        Object oldWeight = edge.getWeight();
                        if (!(oldWeight instanceof Cloneable)) throw new RuntimeException();
                        Class[] argumentTypes = new Class[]{};
                        Method method = oldWeight.getClass().getMethod(nameClone, argumentTypes);
                        mirrorWeight = method.invoke(oldWeight, (Object[])null);
                    } else {
                        mirrorWeight = edge.getWeight();
                    }
                }
                catch (Throwable throwable) {
                    throw new RuntimeException("Can not clone the edge weight.\n", throwable);
                }
                mirrorEdge = new Edge(mirrorSource, mirrorSink, mirrorWeight);
            }
            mirrorGraph.addEdge(mirrorEdge);
            this._originalVersion.put(mirrorEdge, edge);
            this._transformedVersion.put(edge, mirrorEdge);
        }
        return mirrorGraph;
    }
}

