/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.sr.lib;

import ptolemy.actor.lib.logic.LogicFunction;
import ptolemy.data.BooleanToken;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;

public class NonStrictLogicFunction
extends LogicFunction {
    public NonStrictLogicFunction(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
    }

    @Override
    public void fire() throws IllegalActionException {
        BooleanToken value = null;
        BooleanToken in = null;
        for (int i = 0; i < this.input.getWidth(); ++i) {
            if (!this.input.isKnown(i) || !this.input.hasToken(i) || (in = (BooleanToken)this.input.get(i)) == null) continue;
            value = this._updateFunction(in, value);
        }
        if (value == null) {
            if (this.input.isKnown()) {
                this.output.sendClear(0);
            }
        } else {
            value = this._nullifyIncompleteResults(value);
        }
        if (value != null) {
            if (this._negate) {
                value = value.not();
            }
            this.output.send(0, value);
        }
    }

    @Override
    public boolean isStrict() {
        return false;
    }

    @Override
    public void pruneDependencies() {
        super.pruneDependencies();
        this.removeDependency(this.input, this.output);
    }

    private BooleanToken _nullifyIncompleteResults(BooleanToken inValue) throws IllegalActionException {
        BooleanToken outValue = inValue;
        if (!this.input.isKnown()) {
            switch (this._function) {
                case 0: {
                    if (!inValue.booleanValue()) break;
                    outValue = null;
                    break;
                }
                case 1: {
                    if (inValue.booleanValue()) break;
                    outValue = null;
                    break;
                }
                case 2: {
                    outValue = null;
                    break;
                }
                default: {
                    throw new InternalErrorException("Invalid value for _function private variable. LogicFunction actor (" + this.getFullName() + ")" + " on function type " + this._function);
                }
            }
        }
        return outValue;
    }
}

