/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.sdf.lib.vq;

import java.awt.Container;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.util.LinkedList;
import javax.swing.JFrame;
import ptolemy.data.AWTImageToken;
import ptolemy.data.IntMatrixToken;
import ptolemy.data.Token;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.media.Picture;

public class ImageDisplay
extends ptolemy.actor.lib.image.ImageDisplay {
    public ImageDisplay(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.input.setTypeEquals(BaseType.INT_MATRIX);
    }

    private int[] _convertBWImageToPackedRGBImage(IntMatrixToken token) {
        int[][] frame = token.intMatrix();
        int xSize = token.getColumnCount();
        int ySize = token.getRowCount();
        int[] RGBbuffer = new int[xSize * ySize];
        int index = 0;
        for (int j = ySize - 1; j >= 0; --j) {
            int i = 0;
            while (i < xSize) {
                RGBbuffer[index] = 0xFF000000 | (frame[j][i] & 0xFF) << 16 | (frame[j][i] & 0xFF) << 8 | frame[j][i] & 0xFF;
                ++i;
                ++index;
            }
        }
        return RGBbuffer;
    }

    @Override
    protected void _display(Token in) {
        int xSize = ((IntMatrixToken)in).getColumnCount();
        int ySize = ((IntMatrixToken)in).getRowCount();
        if (this._frame != null) {
            MemoryImageSource imageSource = new MemoryImageSource(xSize, ySize, ColorModel.getRGBdefault(), this._convertBWImageToPackedRGBImage((IntMatrixToken)in), 0, xSize);
            imageSource.setAnimated(true);
            Image image = this._frame.getContentPane().createImage(imageSource);
            AWTImageToken token = new AWTImageToken(image);
            LinkedList<AWTImageToken> tokens = new LinkedList<AWTImageToken>();
            tokens.add(token);
            try {
                this._effigy.setTokens(tokens);
            }
            catch (IllegalActionException e) {
                throw new InternalErrorException(e);
            }
        } else if (this._picture != null) {
            if (this._oldXSize != xSize || this._oldYSize != ySize) {
                if (this._debugging) {
                    this._debug("Image size has changed.");
                }
                this._oldXSize = xSize;
                this._oldYSize = ySize;
                Container container = this._picture.getParent();
                container.remove(this._picture);
                this._picture = new Picture(xSize, ySize);
                this._picture.setImage(this._convertBWImageToPackedRGBImage((IntMatrixToken)in));
                this._picture.setBackground(null);
                container.add("Center", this._picture);
                container.validate();
                container.invalidate();
                container.repaint();
                container.doLayout();
                Container c = container.getParent();
                while (c.getParent() != null) {
                    c.invalidate();
                    c.validate();
                    if (!((c = c.getParent()) instanceof JFrame)) continue;
                    ((JFrame)c).pack();
                }
            } else {
                this._picture.setImage(this._convertBWImageToPackedRGBImage((IntMatrixToken)in));
                this._picture.displayImage();
                this._picture.repaint();
            }
        }
    }
}

