/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.sdf.lib.vq;

import ptolemy.actor.lib.Transformer;
import ptolemy.data.IntMatrixToken;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public class ImageContrast
extends Transformer {
    private int[] colorHistogram = new int[256];

    public ImageContrast(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.output.setTypeEquals(BaseType.INT_MATRIX);
        this.input.setTypeEquals(BaseType.INT_MATRIX);
    }

    @Override
    public void fire() throws IllegalActionException {
        int frameElement;
        int j;
        int i;
        super.fire();
        IntMatrixToken message = (IntMatrixToken)this.input.get(0);
        int[][] frame = message.intMatrix();
        for (i = 0; i < 256; ++i) {
            this.colorHistogram[i] = 0;
        }
        int pixels = frame.length * frame[0].length;
        for (i = 0; i < frame.length; ++i) {
            for (j = 0; j < frame[i].length; ++j) {
                frameElement = frame[i][j];
                if (frameElement < 0 || frameElement > 255) {
                    throw new IllegalActionException("ImageContrast:input image pixel contains at" + j + "," + i + "with value" + frameElement + "that is out of bounds." + " Not between 0 and 255.");
                }
                int n = frameElement;
                this.colorHistogram[n] = this.colorHistogram[n] + 1;
            }
        }
        for (i = 1; i < 256; ++i) {
            this.colorHistogram[i] = this.colorHistogram[i - 1] + this.colorHistogram[i];
        }
        int distributionConstant = pixels / 255;
        for (i = 0; i < frame.length; ++i) {
            for (j = 0; j < frame[i].length; ++j) {
                frameElement = frame[i][j];
                frame[i][j] = this.colorHistogram[frameElement] / distributionConstant;
            }
        }
        message = new IntMatrixToken(frame);
        this.output.send(0, message);
    }
}

