/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.sdf.lib;

import ptolemy.actor.TypedIOPort;
import ptolemy.data.ArrayToken;
import ptolemy.data.IntToken;
import ptolemy.data.expr.Parameter;
import ptolemy.domains.sdf.lib.FIR;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.Workspace;

public class VariableFIR
extends FIR {
    public Parameter blockSize = new Parameter(this, "blockSize");
    public TypedIOPort newTaps;

    public VariableFIR(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.blockSize.setExpression("1");
        this.newTaps = new TypedIOPort(this, "newTaps");
        this.newTaps.setInput(true);
        this.newTaps.setTypeSameAs(this.taps);
        this.taps.setVisibility(Settable.NONE);
        this.output.setTypeSameAs(this.input);
        this.output_tokenProductionRate.setExpression("interpolation * blockSize");
        this.input_tokenConsumptionRate.setExpression("decimation * blockSize");
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        super.attributeChanged(attribute);
        if (attribute == this.interpolation || attribute == this.decimation || attribute == this.blockSize) {
            this._reinitializeNeeded = true;
        }
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        VariableFIR newObject = (VariableFIR)super.clone(workspace);
        newObject.newTaps.setTypeSameAs(newObject.taps);
        newObject.output.setTypeSameAs(newObject.input);
        return newObject;
    }

    @Override
    public void fire() throws IllegalActionException {
        if (this.newTaps.hasToken(0)) {
            ArrayToken tapsToken = (ArrayToken)this.newTaps.get(0);
            this._taps = tapsToken.arrayValue();
            this._zero = this._taps[0].zero();
            this._reinitialize();
        }
        int blockSizeValue = ((IntToken)this.blockSize.getToken()).intValue();
        for (int i = 0; i < blockSizeValue; ++i) {
            super.fire();
        }
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        if (this._reinitializeNeeded) {
            this._reinitialize();
        }
        if (this.newTaps.hasToken(0)) {
            return super.prefire();
        }
        if (this._debugging) {
            this._debug("Called prefire(), which returns false.");
        }
        return false;
    }
}

