/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.sdf.lib;

import ptolemy.actor.TypedIOPort;
import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.MatrixToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.MatrixType;
import ptolemy.data.type.MonotonicFunction;
import ptolemy.data.type.Type;
import ptolemy.domains.sdf.lib.SDFTransformer;
import ptolemy.graph.InequalityTerm;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.Workspace;

public class MatrixToSequence
extends SDFTransformer {
    public Parameter rows;
    public Parameter columns;
    public Parameter enforceMatrixSize;

    public MatrixToSequence(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.input.setTypeAtMost(BaseType.MATRIX);
        this.output.setTypeAtLeast(new FunctionTerm(this.input));
        this.rows = new Parameter(this, "rows");
        this.rows.setExpression("1");
        this.columns = new Parameter(this, "columns");
        this.columns.setExpression("1");
        this.enforceMatrixSize = new Parameter(this, "enforceMatrixSize");
        this.enforceMatrixSize.setExpression("true");
        this.enforceMatrixSize.setTypeEquals(BaseType.BOOLEAN);
        this.output_tokenProductionRate.setExpression("rows * columns");
        this._attachText("_iconDescription", "<svg>\n<polygon points=\"-15,-15 15,15 15,-15 -15,15\" style=\"fill:white\"/>\n</svg>\n");
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        int columnsValue;
        if (attribute == this.rows) {
            int rowsValue = ((IntToken)this.rows.getToken()).intValue();
            if (rowsValue <= 0) {
                throw new IllegalActionException((Nameable)this, "Invalid number of rows: " + rowsValue);
            }
        } else if (attribute == this.columns && (columnsValue = ((IntToken)this.columns.getToken()).intValue()) <= 0) {
            throw new IllegalActionException((Nameable)this, "Invalid number of columns: " + columnsValue);
        }
        super.attributeChanged(attribute);
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        MatrixToSequence newObject = (MatrixToSequence)super.clone(workspace);
        newObject.input.setTypeAtMost(BaseType.MATRIX);
        newObject.output.setTypeAtLeast(new FunctionTerm(newObject.input));
        return newObject;
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        if (!this.input.hasToken(0)) {
            return;
        }
        MatrixToken token = (MatrixToken)this.input.get(0);
        int actualRowCount = token.getRowCount();
        int actualColumnCount = token.getColumnCount();
        boolean enforce = ((BooleanToken)this.enforceMatrixSize.getToken()).booleanValue();
        if (enforce) {
            int rowsValue = ((IntToken)this.rows.getToken()).intValue();
            int columnsValue = ((IntToken)this.columns.getToken()).intValue();
            if (actualRowCount != rowsValue || actualColumnCount != columnsValue) {
                throw new IllegalActionException((Nameable)this, "The input matrix size " + actualRowCount + "x" + actualColumnCount + " does not match what the actor requires, " + rowsValue + "x" + columnsValue);
            }
        }
        for (int i = 0; i < actualRowCount; ++i) {
            for (int j = 0; j < actualColumnCount; ++j) {
                this.output.send(0, token.getElementAsToken(i, j));
            }
        }
    }

    private static class FunctionTerm
    extends MonotonicFunction {
        private TypedIOPort _port;

        private FunctionTerm(TypedIOPort port) {
            this._port = port;
        }

        @Override
        public Object getValue() {
            Type inputType = this._port.getType();
            if (!(inputType instanceof MatrixType)) {
                return BaseType.UNKNOWN;
            }
            return ((MatrixType)inputType).getElementType();
        }

        @Override
        public InequalityTerm[] getVariables() {
            if (this._port.getTypeTerm().isSettable()) {
                InequalityTerm[] variable = new InequalityTerm[]{this._port.getTypeTerm()};
                return variable;
            }
            return new InequalityTerm[0];
        }
    }
}

