/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.sdf.lib;

import ptolemy.actor.TypedIOPort;
import ptolemy.actor.util.ConstVariableModelAnalysis;
import ptolemy.data.ArrayToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.ComplexToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.MonotonicFunction;
import ptolemy.data.type.Type;
import ptolemy.domains.sdf.lib.SDFTransformer;
import ptolemy.graph.InequalityTerm;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class Autocorrelation
extends SDFTransformer {
    public Parameter biased;
    public Parameter numberOfInputs;
    public Parameter numberOfLags;
    public Parameter symmetricOutput;
    private int _numberOfInputs;
    private int _numberOfLags;
    private int _lengthOfOutput;
    private boolean _symmetricOutput;
    private Token[] _outputs;

    public Autocorrelation(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.input_tokenConsumptionRate.setExpression("numberOfInputs");
        this.numberOfInputs = new Parameter((NamedObj)this, "numberOfInputs", new IntToken(256));
        this.numberOfInputs.setTypeEquals(BaseType.INT);
        this.numberOfLags = new Parameter((NamedObj)this, "numberOfLags", new IntToken(64));
        this.numberOfLags.setTypeEquals(BaseType.INT);
        this.biased = new Parameter((NamedObj)this, "biased", new BooleanToken(false));
        this.biased.setTypeEquals(BaseType.BOOLEAN);
        this.symmetricOutput = new Parameter((NamedObj)this, "symmetricOutput", new BooleanToken(false));
        this.symmetricOutput.setTypeEquals(BaseType.BOOLEAN);
        this.input.setTypeAtLeast(new FunctionTerm(this.input));
        this.output.setTypeAtLeast(new OutputTypeTerm());
        this.attributeChanged(this.numberOfInputs);
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.numberOfInputs || attribute == this.numberOfLags || attribute == this.symmetricOutput) {
            this._numberOfInputs = ((IntToken)this.numberOfInputs.getToken()).intValue();
            this._numberOfLags = ((IntToken)this.numberOfLags.getToken()).intValue();
            this._symmetricOutput = ((BooleanToken)this.symmetricOutput.getToken()).booleanValue();
            if (this._numberOfInputs <= 0) {
                throw new IllegalActionException((Nameable)this, "Invalid numberOfInputs: " + this._numberOfInputs);
            }
            if (this._numberOfLags <= 0) {
                throw new IllegalActionException((Nameable)this, "Invalid numberOfLags: " + this._numberOfLags);
            }
            this._lengthOfOutput = this._symmetricOutput ? 2 * this._numberOfLags + 1 : 2 * this._numberOfLags;
            if (this._outputs == null || this._lengthOfOutput != this._outputs.length) {
                this._outputs = new Token[this._lengthOfOutput];
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        Autocorrelation newObject = (Autocorrelation)super.clone(workspace);
        newObject.input.setTypeAtLeast(new FunctionTerm(newObject.input));
        TypedIOPort typedIOPort = newObject.output;
        Autocorrelation autocorrelation = newObject;
        autocorrelation.getClass();
        typedIOPort.setTypeAtLeast(autocorrelation.new OutputTypeTerm());
        return newObject;
    }

    @Override
    public void fire() throws IllegalActionException {
        int i;
        super.fire();
        boolean biasedValue = ((BooleanToken)this.biased.getToken()).booleanValue();
        Token[] inputValues = this.input.get(0, this._numberOfInputs);
        int notSymmetric = this._symmetricOutput ? 0 : 1;
        boolean complex = inputValues[0] instanceof ComplexToken;
        for (i = this._numberOfLags; i >= 0; --i) {
            Token sum = inputValues[0].zero();
            for (int j = 0; j < this._numberOfInputs - i; ++j) {
                if (complex) {
                    ComplexToken conjugate = new ComplexToken(((ComplexToken)inputValues[j]).complexValue().conjugate());
                    sum = sum.add(conjugate.multiply(inputValues[j + i]));
                    continue;
                }
                sum = sum.add(inputValues[j].multiply(inputValues[j + i]));
            }
            this._outputs[i + this._numberOfLags - notSymmetric] = biasedValue ? sum.divide(this.numberOfInputs.getToken()) : sum.divide(new IntToken(this._numberOfInputs - i));
        }
        for (i = this._numberOfLags - 1 - notSymmetric; i >= 0; --i) {
            if (complex) {
                ComplexToken candidate = (ComplexToken)this._outputs[2 * (this._numberOfLags - notSymmetric) - i];
                this._outputs[i] = new ComplexToken(candidate.complexValue().conjugate());
                continue;
            }
            this._outputs[i] = this._outputs[2 * (this._numberOfLags - notSymmetric) - i];
        }
        this.output.broadcast(new ArrayToken(this._outputs));
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        if (!this.input.hasToken(0, this._numberOfInputs)) {
            if (this._debugging) {
                this._debug("Called prefire(), which returns false.");
            }
            return false;
        }
        return super.prefire();
    }

    private class OutputTypeTerm
    extends MonotonicFunction {
        private ArrayType _arrayType;

        private OutputTypeTerm() {
        }

        @Override
        public Object getValue() throws IllegalActionException {
            ConstVariableModelAnalysis analysis = ConstVariableModelAnalysis.getAnalysis(Autocorrelation.this.symmetricOutput);
            if (analysis.isConstant(Autocorrelation.this.symmetricOutput) && analysis.isConstant(Autocorrelation.this.numberOfLags)) {
                Token symmetricOutputToken = analysis.getConstantValue(Autocorrelation.this.symmetricOutput);
                Token numberOfLagsToken = analysis.getConstantValue(Autocorrelation.this.numberOfLags);
                int lags = ((IntToken)numberOfLagsToken).intValue();
                if (((BooleanToken)symmetricOutputToken).booleanValue()) {
                    return this._getArrayTypeRaw(2 * lags + 1);
                }
                return this._getArrayTypeRaw(2 * lags);
            }
            return this._getArrayTypeRaw();
        }

        @Override
        public InequalityTerm[] getVariables() {
            InequalityTerm[] array = new InequalityTerm[]{Autocorrelation.this.input.getTypeTerm()};
            return array;
        }

        private ArrayType _getArrayTypeRaw() throws IllegalActionException {
            Type type = Autocorrelation.this.input.getType();
            if (this._arrayType == null || !((Object)this._arrayType.getElementType()).equals(type)) {
                this._arrayType = new ArrayType(type);
            }
            return this._arrayType;
        }

        private ArrayType _getArrayTypeRaw(int length) throws IllegalActionException {
            Type type = Autocorrelation.this.input.getType();
            if (this._arrayType == null || !((Object)this._arrayType.getElementType()).equals(type)) {
                this._arrayType = new ArrayType(type, length);
            }
            return this._arrayType;
        }
    }

    private static class FunctionTerm
    extends MonotonicFunction {
        private TypedIOPort _port;

        private FunctionTerm(TypedIOPort port) {
            this._port = port;
        }

        @Override
        public Object getValue() {
            Type inputType = this._port.getType();
            if (inputType == BaseType.INT) {
                return BaseType.DOUBLE;
            }
            if (inputType == BaseType.INT_MATRIX) {
                return BaseType.DOUBLE_MATRIX;
            }
            return inputType;
        }

        @Override
        public InequalityTerm[] getVariables() {
            InequalityTerm[] variable = new InequalityTerm[]{this._port.getTypeTerm()};
            return variable;
        }
    }
}

