/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.sdf.kernel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import ptolemy.actor.Actor;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Director;
import ptolemy.actor.IOPort;
import ptolemy.actor.sched.NotSchedulableException;
import ptolemy.actor.sched.Schedule;
import ptolemy.actor.util.DFUtilities;
import ptolemy.domains.sdf.kernel.SDFScheduler;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Workspace;

public class CachedSDFScheduler
extends SDFScheduler {
    private int _cacheSize;
    private Map _scheduleCache;
    private List _scheduleKeyList;
    private Map _externalRatesCache;
    private String _mostRecentRates;
    private List _inputPortList;
    private List _outputPortList;
    private long _workspaceVersion = 0L;

    public CachedSDFScheduler() {
        this.constructCaches(0);
    }

    public CachedSDFScheduler(Workspace workspace) {
        super(workspace);
        this.constructCaches(0);
    }

    public CachedSDFScheduler(Director container, String name, int cacheSize) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.constructCaches(cacheSize);
    }

    public void clearCaches() {
        if (this._cacheSize > 0) {
            this._scheduleKeyList.clear();
        }
        this._scheduleCache.clear();
        this._externalRatesCache.clear();
        this._mostRecentRates = "";
    }

    public void constructCaches(int cacheSize) {
        this._scheduleCache = new HashMap();
        if (cacheSize > 0) {
            this._scheduleKeyList = new ArrayList(cacheSize);
        }
        this._externalRatesCache = new TreeMap();
        this._cacheSize = cacheSize;
    }

    @Override
    protected Schedule _getSchedule() throws NotSchedulableException, IllegalActionException {
        Schedule schedule;
        if (this._inputPortList == null || this._workspaceVersion != this.workspace().getVersion()) {
            this._inputPortList = this._getInputPortList();
        }
        if (this._outputPortList == null || this._workspaceVersion != this.workspace().getVersion()) {
            this._outputPortList = this._getOutputPortList();
        }
        this._workspaceVersion = this.workspace().getVersion();
        StringBuffer rates = new StringBuffer();
        for (IOPort inputPort : this._inputPortList) {
            int rate = DFUtilities.getTokenConsumptionRate(inputPort);
            rates.append(rate);
        }
        for (IOPort outputPort : this._outputPortList) {
            int rate = DFUtilities.getTokenProductionRate(outputPort);
            rates.append(rate);
            DFUtilities.getTokenInitProduction(outputPort);
            rates.append(rate);
        }
        String rateKey = rates.toString();
        if (this._scheduleCache.containsKey(rateKey)) {
            schedule = (Schedule)this._scheduleCache.get(rateKey);
            if (!rateKey.equals(this._mostRecentRates)) {
                this._mostRecentRates = rateKey;
                if (this._cacheSize > 0) {
                    this._scheduleKeyList.remove(rateKey);
                    this._scheduleKeyList.add(0, rateKey);
                }
                Map externalRates = (Map)this._externalRatesCache.get(rateKey);
                this._saveContainerRates(externalRates);
            }
        } else {
            this._mostRecentRates = rateKey;
            if (this._cacheSize > 0) {
                while (this._scheduleKeyList.size() >= this._cacheSize) {
                    Object key = this._scheduleKeyList.get(this._cacheSize - 1);
                    this._scheduleKeyList.remove(this._cacheSize - 1);
                    this._scheduleCache.remove(key);
                    this._externalRatesCache.remove(key);
                }
                this._scheduleKeyList.add(0, rateKey);
            }
            schedule = super._getSchedule();
            this._scheduleCache.put(rateKey, schedule);
            Map externalRates = this.getExternalRates();
            this._externalRatesCache.put(rateKey, externalRates);
        }
        this.setValid(true);
        return schedule;
    }

    private List _getInputPortList() {
        CompositeActor container = (CompositeActor)this.getContainer().getContainer();
        List actors = container.deepEntityList();
        Iterator actorIterator = actors.iterator();
        LinkedList<IOPort> inputPortList = new LinkedList<IOPort>();
        while (actorIterator.hasNext()) {
            Actor containedActor = (Actor)actorIterator.next();
            List temporaryInputPortList = containedActor.inputPortList();
            for (IOPort inputPort : temporaryInputPortList) {
                inputPortList.add(inputPort);
            }
        }
        return inputPortList;
    }

    private List _getOutputPortList() {
        CompositeActor container = (CompositeActor)this.getContainer().getContainer();
        List actors = container.deepEntityList();
        Iterator actorIterator2 = actors.iterator();
        LinkedList<IOPort> outputPortList = new LinkedList<IOPort>();
        while (actorIterator2.hasNext()) {
            Actor containedActor = (Actor)actorIterator2.next();
            List temporaryOutputPortList = containedActor.outputPortList();
            for (IOPort outputPort : temporaryOutputPortList) {
                outputPortList.add(outputPort);
            }
        }
        return outputPortList;
    }
}

