/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.rendezvous.lib;

import java.util.LinkedList;
import java.util.List;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.process.TerminateProcessException;
import ptolemy.data.ArrayToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.ArrayType;
import ptolemy.domains.rendezvous.kernel.RendezvousDirector;
import ptolemy.domains.rendezvous.kernel.RendezvousReceiver;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.Workspace;

public class ResourcePool
extends TypedAtomicActor {
    public TypedIOPort grant;
    public TypedIOPort release;
    public Parameter initialPool;
    private List _pool = new LinkedList();
    private boolean _postfireReturns = true;
    private Thread _readThread = null;

    public ResourcePool(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.grant = new TypedIOPort(this, "grant", false, true);
        this.grant.setMultiport(true);
        this.release = new TypedIOPort(this, "release", true, false);
        this.release.setMultiport(true);
        this.initialPool = new Parameter(this, "initialPool");
        this.initialPool.setExpression("{1}");
        this.grant.setTypeAtLeast(ArrayType.elementType(this.initialPool));
        this.grant.setTypeAtLeast(this.release);
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.initialPool) {
            ArrayToken pool = (ArrayToken)this.initialPool.getToken();
            this._pool.clear();
            for (int i = 0; i < pool.length(); ++i) {
                this._pool.add(pool.getElement(i));
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        ResourcePool newObject = (ResourcePool)super.clone(workspace);
        try {
            newObject.grant.setTypeAtLeast(ArrayType.elementType(newObject.initialPool));
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException(e);
        }
        newObject.grant.setTypeAtLeast(newObject.release);
        return newObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        final RendezvousDirector director = (RendezvousDirector)this.getDirector();
        final Thread writeThread = Thread.currentThread();
        if (!(this.getDirector() instanceof RendezvousDirector)) {
            throw new IllegalActionException((Nameable)this, "ResourcePool actor can only be used with RendezvousDirector.");
        }
        this._postfireReturns = true;
        if (this.release.getWidth() > 0 && this._readThread == null) {
            this._readThread = new Thread(this.getFullName() + "_readThread"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    try {
                        while (!ResourcePool.this._stopRequested) {
                            RendezvousDirector rendezvousDirector = director;
                            synchronized (rendezvousDirector) {
                                if (ResourcePool.this._debugging) {
                                    ResourcePool.this._debug("Resources available: " + ResourcePool.this._pool);
                                }
                                Token resource = RendezvousReceiver.getFromAny(ResourcePool.this.release.getReceivers(), director);
                                ResourcePool.this._pool.add(resource);
                                director.threadUnblocked(writeThread, null);
                                director.notifyAll();
                            }
                        }
                        return;
                    }
                    catch (TerminateProcessException ex) {
                        ResourcePool.this._postfireReturns = false;
                        return;
                    }
                    finally {
                        director.removeThread(ResourcePool.this._readThread);
                    }
                }
            };
            director.addThread(this._readThread);
            this._readThread.start();
        } else if (this.release.getWidth() == 0 && this._readThread != null) {
            this._readThread.interrupt();
        }
        RendezvousDirector rendezvousDirector = director;
        synchronized (rendezvousDirector) {
            while (this._pool.size() == 0) {
                if (this._stopRequested || !this._postfireReturns) {
                    this._postfireReturns = false;
                    return;
                }
                try {
                    director.threadBlocked(writeThread, null);
                    RendezvousReceiver.waitForChange(director);
                }
                catch (TerminateProcessException ex) {
                    this._postfireReturns = false;
                    return;
                }
                finally {
                    director.threadUnblocked(writeThread, null);
                }
            }
            Token token = (Token)this._pool.get(0);
            try {
                RendezvousReceiver.putToAny(token, this.grant.getRemoteReceivers(), director);
            }
            catch (TerminateProcessException e) {
                this._postfireReturns = false;
                return;
            }
            this._pool.remove(0);
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._readThread = null;
        this._postfireReturns = true;
        this.attributeChanged(this.initialPool);
    }

    @Override
    public boolean postfire() {
        return this._postfireReturns;
    }
}

