/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.rendezvous.kernel;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import ptolemy.actor.AbstractReceiver;
import ptolemy.actor.Actor;
import ptolemy.actor.IOPort;
import ptolemy.actor.NoRoomException;
import ptolemy.actor.Receiver;
import ptolemy.actor.process.BoundaryDetector;
import ptolemy.actor.process.ProcessReceiver;
import ptolemy.actor.process.TerminateProcessException;
import ptolemy.data.Token;
import ptolemy.domains.rendezvous.kernel.RendezvousDirector;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.Nameable;

public class RendezvousReceiver
extends AbstractReceiver
implements ProcessReceiver {
    private static final int GET = 4;
    private static final int PUT = 8;
    private static final int GET_CONDITIONAL = 1;
    private static final int PUT_CONDITIONAL = 2;
    private static final int GET_FROM_ALL = 4;
    private static final int GET_FROM_ANY = 5;
    private static final int PUT_TO_ALL = 8;
    private static final int PUT_TO_ANY = 10;
    private static final int GET_FROM_ANY_PUT_TO_ALL = 13;
    private BoundaryDetector _boundaryDetector;
    private int _channelIndex = -1;
    private boolean _getConditional = false;
    private Receiver[][] _getReceivers = null;
    private Thread _getWaiting = null;
    private boolean _putConditional = false;
    private Receiver[][] _putReceivers = null;
    private Thread _putWaiting = null;
    private Receiver[][] _symmetricGetReceivers;
    private Receiver[][] _symmetricPutReceivers;
    private Receiver[][] _thisReceiver = new Receiver[1][1];
    private Token _token;

    public RendezvousReceiver() {
        this._boundaryDetector = new BoundaryDetector(this);
        this._thisReceiver[0][0] = this;
    }

    public RendezvousReceiver(IOPort container) throws IllegalActionException {
        super(container);
        this._boundaryDetector = new BoundaryDetector(this);
        this._thisReceiver[0][0] = this;
    }

    @Override
    public void clear() {
        this.reset();
    }

    @Override
    public Token get() throws TerminateProcessException {
        return RendezvousReceiver.getFromAll(this._thisReceiver, this._getDirector())[0][0];
    }

    public static Token[][] getFromAll(Receiver[][] receivers, RendezvousDirector director) throws TerminateProcessException {
        Map result = null;
        try {
            result = RendezvousReceiver._getOrPutTokens(receivers, null, director, null, null, 4);
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException(ex);
        }
        Token[][] tokens = new Token[receivers.length][];
        for (int i = 0; i < receivers.length; ++i) {
            if (receivers[i] == null) continue;
            tokens[i] = new Token[receivers[i].length];
            for (int j = 0; j < receivers[i].length; ++j) {
                if (receivers[i][j] == null) continue;
                tokens[i][j] = (Token)result.get(receivers[i][j]);
            }
        }
        return tokens;
    }

    public static Token getFromAny(Receiver[][] receivers, RendezvousDirector director) throws TerminateProcessException {
        Map result = null;
        try {
            result = RendezvousReceiver._getOrPutTokens(receivers, null, director, null, null, 5);
        }
        catch (IllegalActionException ex) {
            // empty catch block
        }
        for (int i = 0; i < receivers.length; ++i) {
            if (receivers[i] == null) continue;
            for (int j = 0; j < receivers[i].length; ++j) {
                if (receivers[i][j] == null || !result.containsKey(receivers[i][j])) continue;
                return (Token)result.get(receivers[i][j]);
            }
        }
        throw new InternalErrorException("No token is received.");
    }

    public static void getFromAnyPutToAll(Receiver[][] getReceivers, Receiver[][] putReceivers, RendezvousDirector director) throws IllegalActionException, TerminateProcessException {
        RendezvousReceiver._getOrPutTokens(getReceivers, putReceivers, director, null, null, 13);
    }

    @Override
    public boolean hasRoom() {
        return true;
    }

    @Override
    public boolean hasRoom(int tokens) {
        return true;
    }

    @Override
    public boolean hasToken() {
        return true;
    }

    @Override
    public boolean hasToken(int tokens) {
        return true;
    }

    @Override
    public boolean isConnectedToBoundary() {
        return this._boundaryDetector.isConnectedToBoundary();
    }

    @Override
    public boolean isConnectedToBoundaryInside() {
        return this._boundaryDetector.isConnectedToBoundaryInside();
    }

    @Override
    public boolean isConnectedToBoundaryOutside() {
        return this._boundaryDetector.isConnectedToBoundaryOutside();
    }

    @Override
    public boolean isConsumerReceiver() {
        return this.isConnectedToBoundary();
    }

    @Override
    public boolean isInsideBoundary() {
        return this._boundaryDetector.isInsideBoundary();
    }

    @Override
    public boolean isOutsideBoundary() {
        return this._boundaryDetector.isOutsideBoundary();
    }

    @Override
    public boolean isProducerReceiver() {
        return this.isOutsideBoundary() || this.isInsideBoundary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReadBlocked() {
        RendezvousDirector rendezvousDirector = this._getDirector();
        synchronized (rendezvousDirector) {
            return this._getWaiting != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isWriteBlocked() {
        RendezvousDirector rendezvousDirector = this._getDirector();
        synchronized (rendezvousDirector) {
            return this._putWaiting != null;
        }
    }

    @Override
    public void put(Token token) throws IllegalActionException, TerminateProcessException {
        RendezvousReceiver.putToAll(new Token[][]{{token}}, this._thisReceiver, this._getDirector());
    }

    @Override
    public void putArrayToAll(Token[] tokens, int numberOfTokens, Receiver[] receivers) throws NoRoomException, IllegalActionException, TerminateProcessException {
        if (numberOfTokens > tokens.length) {
            IOPort container = this.getContainer();
            throw new IllegalActionException((Nameable)container, "Not enough tokens supplied.");
        }
        for (int i = 0; i < numberOfTokens; ++i) {
            this.putToAll(tokens[i], receivers);
        }
    }

    @Override
    public void putToAll(Token token, Receiver[] receivers) throws NoRoomException, IllegalActionException {
        this.putToAll(token, receivers, this._getDirector());
    }

    public void putToAll(Token token, Receiver[] receivers, RendezvousDirector director) throws IllegalActionException, TerminateProcessException {
        if (receivers == null || receivers.length == 0) {
            return;
        }
        RendezvousReceiver.putToAll(new Token[][]{{token}}, new Receiver[][]{receivers}, director);
    }

    public static void putToAll(Token[][] tokens, Receiver[][] receivers, RendezvousDirector director) throws IllegalActionException, TerminateProcessException {
        RendezvousReceiver._getOrPutTokens(null, receivers, director, null, tokens, 8);
    }

    public static void putToAny(Token token, Receiver[][] receivers, RendezvousDirector director) throws IllegalActionException, TerminateProcessException {
        RendezvousReceiver._getOrPutTokens(null, receivers, director, token, null, 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestFinish() {
        RendezvousDirector lock;
        RendezvousDirector rendezvousDirector = lock = this._getDirector();
        synchronized (rendezvousDirector) {
            this.reset();
            lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        RendezvousDirector rendezvousDirector = this._getDirector();
        synchronized (rendezvousDirector) {
            this._resetFlags(true, true);
        }
    }

    public static void waitForChange(RendezvousDirector director) throws TerminateProcessException {
        if (director.isStopRequested() || director._inWrapup) {
            throw new TerminateProcessException("Thread terminated.");
        }
        try {
            director.wait();
        }
        catch (InterruptedException e) {
            throw new TerminateProcessException("Thread interrupted.");
        }
        if (director.isStopRequested() || director._inWrapup) {
            throw new TerminateProcessException("Thread terminated.");
        }
    }

    protected static void _commitRendezvous(Set receivers, RendezvousDirector director) {
        HashMap<RendezvousReceiver, Token> result = new HashMap<RendezvousReceiver, Token>();
        TopologicalSort sort = new TopologicalSort(receivers);
        while (sort.hasNext()) {
            RendezvousReceiver castReceiver = (RendezvousReceiver)sort.next();
            result.put(castReceiver, castReceiver._token);
            if (director._getResultMap(castReceiver._getWaiting) == null) {
                director.threadUnblocked(castReceiver._getWaiting, null);
                director._setResultMap(castReceiver._getWaiting, result);
            }
            if (director._getResultMap(castReceiver._putWaiting) != null) continue;
            director.threadUnblocked(castReceiver._putWaiting, null);
            director._setResultMap(castReceiver._putWaiting, result);
        }
        for (RendezvousReceiver castReceiver : receivers) {
            if (castReceiver._getReceivers != null && castReceiver._getConditional) {
                RendezvousReceiver._resetReceiversFlags(castReceiver._getReceivers, true, false);
            }
            if (castReceiver._putReceivers != null && castReceiver._putConditional) {
                RendezvousReceiver._resetReceiversFlags(castReceiver._putReceivers, false, true);
            }
            castReceiver._resetFlags(true, true);
        }
    }

    protected RendezvousDirector _getDirector() {
        try {
            Actor container = (Actor)((Object)this.getContainer().getContainer());
            if (this.isInsideBoundary()) {
                return (RendezvousDirector)container.getDirector();
            }
            return (RendezvousDirector)container.getExecutiveDirector();
        }
        catch (NullPointerException ex) {
            throw new TerminateProcessException("RendezvousReceiver: trying to rendezvous with a receiver with no director => terminate.");
        }
    }

    protected static Set _receiversReadyToCommit(Receiver[][] receivers, boolean isPut) {
        HashSet ready = new HashSet();
        if (RendezvousReceiver._checkRendezvous(receivers, isPut, new HashSet(), ready, new HashSet(), new HashSet(), false, false, null)) {
            return ready;
        }
        return null;
    }

    private static boolean _checkRendezvous(Receiver[][] receivers, boolean isPut, Set beingChecked, Set ready, Set notReady, Set symmetricReceivers, boolean isSymmetricGet, boolean isSymmetricPut, Receiver farSideReceiver) {
        if (receivers.length == 0) {
            return isPut;
        }
        boolean isConditional = RendezvousReceiver._isConditional(receivers, isPut);
        boolean branchReady = false;
        int selectedBranch = RendezvousReceiver._getSelectedBranch(receivers, beingChecked, ready);
        for (int i = 0; i < receivers.length; ++i) {
            if (receivers[i] == null) continue;
            if (isConditional && farSideReceiver != null) {
                boolean found = false;
                for (int j = 0; j < receivers[i].length; ++j) {
                    if (receivers[i][j] != farSideReceiver) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            if (isConditional && selectedBranch >= 0 && selectedBranch != i) continue;
            branchReady = true;
            for (int j = 0; j < receivers[i].length; ++j) {
                RendezvousReceiver receiver = (RendezvousReceiver)receivers[i][j];
                if (receiver == null) continue;
                if (symmetricReceivers.contains(receiver)) {
                    return false;
                }
                if (beingChecked.contains(receiver) || ready.contains(receiver)) continue;
                if (notReady.contains(receiver)) {
                    branchReady = false;
                    break;
                }
                if (receiver._putWaiting == null || receiver._getWaiting == null) {
                    branchReady = false;
                    notReady.add(receiver);
                    break;
                }
                Receiver[][] farSideReceivers = isPut ? receiver._getReceivers : receiver._putReceivers;
                beingChecked.add(receiver);
                symmetricReceivers.add(receiver);
                Receiver[][] symmetric = receiver._symmetricGetReceivers;
                if (branchReady && !isSymmetricPut && symmetric != null && !RendezvousReceiver._checkRendezvous(symmetric, false, beingChecked, ready, notReady, symmetricReceivers, true, false, null)) {
                    branchReady = false;
                }
                symmetric = receiver._symmetricPutReceivers;
                if (branchReady && !isSymmetricGet && symmetric != null && !RendezvousReceiver._checkRendezvous(symmetric, true, beingChecked, ready, notReady, symmetricReceivers, false, true, null)) {
                    branchReady = false;
                }
                if (branchReady && !RendezvousReceiver._checkRendezvous(farSideReceivers, !isPut, beingChecked, ready, notReady, new HashSet(), false, false, receiver)) {
                    branchReady = false;
                }
                beingChecked.remove(receiver);
                symmetricReceivers.remove(receiver);
                if (branchReady) {
                    ready.add(receiver);
                    continue;
                }
                notReady.add(receiver);
                break;
            }
            if (isConditional && branchReady || !isConditional && !branchReady) break;
        }
        return branchReady;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map _getOrPutTokens(Receiver[][] getReceivers, Receiver[][] putReceivers, RendezvousDirector director, Token token, Token[][] tokenArray, int flag) throws IllegalActionException, TerminateProcessException {
        boolean isGet = (flag & 4) == 4;
        boolean isPut = (flag & 8) == 8;
        boolean isGetConditional = (flag & 1) == 1;
        boolean isPutConditional = (flag & 2) == 2;
        boolean isSymmetric = isPut && isGet;
        Map result = null;
        RendezvousDirector rendezvousDirector = director;
        synchronized (rendezvousDirector) {
            RendezvousReceiver receiver;
            int j;
            int i;
            Thread theThread = Thread.currentThread();
            boolean cardinalityTest = true;
            if (!isGetConditional && !isPutConditional && getReceivers != null && putReceivers != null && getReceivers.length < putReceivers.length) {
                cardinalityTest = false;
            }
            if (cardinalityTest && isGet) {
                for (i = 0; i < getReceivers.length; ++i) {
                    if (getReceivers[i] == null) continue;
                    for (j = 0; j < getReceivers[i].length; ++j) {
                        receiver = (RendezvousReceiver)getReceivers[i][j];
                        if (receiver == null) continue;
                        receiver._getWaiting = theThread;
                        receiver._getReceivers = getReceivers;
                        receiver._getConditional = isGetConditional;
                        if (!isSymmetric) continue;
                        receiver._channelIndex = i;
                        receiver._symmetricPutReceivers = putReceivers;
                    }
                }
            }
            if (cardinalityTest && isPut) {
                for (i = 0; i < putReceivers.length; ++i) {
                    if (putReceivers[i] == null) continue;
                    for (j = 0; j < putReceivers[i].length; ++j) {
                        receiver = (RendezvousReceiver)putReceivers[i][j];
                        if (receiver == null) continue;
                        receiver._putWaiting = theThread;
                        receiver._putReceivers = putReceivers;
                        IOPort port = receiver.getContainer();
                        if (isPutConditional) {
                            receiver._putConditional = true;
                            receiver._token = token == null ? null : port.convert(token);
                        } else {
                            receiver._putConditional = false;
                            try {
                                token = tokenArray[i][j];
                            }
                            catch (Throwable e) {
                                // empty catch block
                            }
                            Token token2 = receiver._token = token == null ? null : port.convert(token);
                        }
                        if (!isSymmetric) continue;
                        receiver._symmetricGetReceivers = getReceivers;
                    }
                }
            }
            Set rendezvousReceivers = null;
            if (cardinalityTest && getReceivers != null) {
                rendezvousReceivers = RendezvousReceiver._receiversReadyToCommit(getReceivers, false);
            } else if (cardinalityTest) {
                rendezvousReceivers = RendezvousReceiver._receiversReadyToCommit(putReceivers, true);
            }
            if (rendezvousReceivers == null) {
                director.threadBlocked(theThread, null);
                while (result == null) {
                    RendezvousReceiver.waitForChange(director);
                    result = director._getResultMap(theThread);
                }
                director._setResultMap(theThread, null);
            } else {
                RendezvousReceiver._commitRendezvous(rendezvousReceivers, director);
                result = director._setResultMap(theThread, null);
            }
        }
        return result;
    }

    private static int _getSelectedBranch(Receiver[][] receivers, Set beingChecked, Set ready) {
        for (int i = 0; i < receivers.length; ++i) {
            if (receivers[i] == null) continue;
            for (int j = 0; j < receivers[i].length; ++j) {
                Receiver receiver = receivers[i][j];
                if (receiver == null || !beingChecked.contains(receiver) && !ready.contains(receiver)) continue;
                return i;
            }
        }
        return -1;
    }

    private static boolean _isConditional(Receiver[][] receivers, boolean isPut) {
        for (int i = 0; i < receivers.length; ++i) {
            if (receivers[i] == null) continue;
            for (int j = 0; j < receivers[i].length; ++j) {
                RendezvousReceiver receiver = (RendezvousReceiver)receivers[i][j];
                if (receiver == null) continue;
                if (isPut) {
                    return receiver._putConditional;
                }
                return receiver._getConditional;
            }
        }
        return false;
    }

    private void _resetFlags(boolean clearGet, boolean clearPut) {
        if (clearGet) {
            this._channelIndex = -1;
            this._getReceivers = null;
            this._getWaiting = null;
            this._symmetricPutReceivers = null;
        }
        if (clearPut) {
            this._putReceivers = null;
            this._putWaiting = null;
            this._symmetricGetReceivers = null;
        }
    }

    private static void _resetReceiversFlags(Receiver[][] receivers, boolean clearGet, boolean clearPut) {
        for (int i = 0; i < receivers.length; ++i) {
            if (receivers[i] == null) continue;
            for (int j = 0; j < receivers[i].length; ++j) {
                if (receivers[i][j] == null) continue;
                ((RendezvousReceiver)receivers[i][j])._resetFlags(clearGet, clearPut);
            }
        }
    }

    private static class TopologicalSort {
        private Set _receivers;
        private Set _zeroInDegree;

        TopologicalSort(Set receivers) {
            this._receivers = receivers;
            this._initialize();
        }

        public boolean hasNext() {
            return !this._zeroInDegree.isEmpty();
        }

        public Receiver next() {
            RendezvousReceiver next;
            block4: {
                Receiver[][] putReceivers;
                Token token;
                block5: {
                    Iterator zeroInDegreeIterator = this._zeroInDegree.iterator();
                    if (!zeroInDegreeIterator.hasNext()) {
                        return null;
                    }
                    next = (RendezvousReceiver)zeroInDegreeIterator.next();
                    zeroInDegreeIterator.remove();
                    if (next._symmetricPutReceivers == null) break block4;
                    token = next._token;
                    putReceivers = next._symmetricPutReceivers;
                    if (!next._getConditional) break block5;
                    for (int i = 0; i < putReceivers.length; ++i) {
                        if (putReceivers[i] == null) continue;
                        for (int j = 0; j < putReceivers[i].length; ++j) {
                            RendezvousReceiver receiver = (RendezvousReceiver)putReceivers[i][j];
                            if (receiver == null || !this._receivers.contains(receiver)) continue;
                            receiver._token = token;
                            this._zeroInDegree.add(receiver);
                        }
                    }
                    break block4;
                }
                int i = next._channelIndex;
                if (i >= putReceivers.length || putReceivers[i] == null) break block4;
                for (int j = 0; j < putReceivers[i].length; ++j) {
                    RendezvousReceiver receiver = (RendezvousReceiver)putReceivers[i][j];
                    if (receiver == null || !this._receivers.contains(receiver)) continue;
                    receiver._token = token;
                    this._zeroInDegree.add(receiver);
                }
            }
            return next;
        }

        private void _initialize() {
            this._zeroInDegree = new HashSet();
            for (RendezvousReceiver receiver : this._receivers) {
                if (receiver._symmetricGetReceivers != null) continue;
                this._zeroInDegree.add(receiver);
            }
            if (this._zeroInDegree.isEmpty()) {
                throw new InternalErrorException("No entry point.");
            }
        }
    }
}

